from .brokers_export import BrokerExport
from flask_restful import Resource, request
from flask_jwt_extended import jwt_required
from dateutil.parser import parse
from ..security_service import verify_role
from ..responses import ErrorResponses, SuccessResponses
from ..user.users_params import *
import itertools
from ..import_params import ImportParams
from ..trade.trades_regroups import *
from ..server_info import ServerInfo
from ..event.events import UserEventList as EventUser
import hmac
import hashlib
import requests
import time as tt
from json.decoder import JSONDecodeError
from datetime import datetime as dt

class WooxExport(BrokerExport,ServerInfo, Resource):

    @verify_role('broker export')
    def post(self):        
        try:
            """
            self.data = {"portfolio":"","broker":"tda","auto_login":true,"partial":true}
            """
            version = {}
            self.data = {}
            self.orders_execid = []
            self.data = request.json
            
            # ini syncronization
            new_event_id=self.init_sync()
            if not isinstance(new_event_id,UserEvents) and not self.is_lambda():
                return Response.response(new_event_id['status'], out=new_event_id['export'], message=new_event_id['message'], title=new_event_id['title'])
            
            self.pusher_title =  'Checking Credentials'
            self.pusher_message = '5%'
            self.pusher_complete = False
            self.send_pusher()
            
            for credential in self.credentials:
                
                self.credential = None
                self.credential = credential
                self.not_error = self.validate()
                
                if self.not_error != True:
                    _end = self.end_sync()
                    if _end != True:
                        return _end

                self.symbols = []
                self.credential = None
                self.credential = credential
                
                self.pusher_title =  'Connecting to the WOO Network serve'
                self.pusher_message = '15%'
                self.pusher_complete = False
                self.send_pusher() 
                
                self.not_error = self.login()
                if self.not_error != True:
                    _end = self.end_sync(code=1)
                    if _end != True:
                        return _end
                
                if self.credential:
                    self.symbols =  self.symbols +self.credential.symbols_list

                if self.data['symbols']!=[] and self.symbols == [] and ('add' in self.data or self.data['add'] == True):
                    self.symbols =self.data['symbols']
                self.account_pusher = 'Account #'+str(self.get_api_key_information())
                self.time_out_lambda=False
                if self.condition_lambda() and not self.aws_autosync:
                    try:
                        self.not_error = self.call_lambda()
                    except Exception as err:
                        #print(err)
                        #print(traceback.print_exc())
                        self.not_error = err
                        self.executed_lambda = False
                
                if not self.executed_lambda:
                    if self.symbols == [] and (not 'add' in self.data or self.data['add'] == False):                       
                                               
                        self._update_progress('Getting symbols', '15%')
                        self.not_error = self.get_symbols()
                        if self.not_error != True:
                            _end = self.end_sync(code=6)
                            if _end != True:
                                return _end
                    
                    self.symbols = list(set(self.symbols))
                    
                    self._update_progress('Saving data', '16%')
                    self.save_configs()                                

                    self._update_progress('Retrieving orders', '18%')
                    
                    self.not_error = self.get_woox_orders_all_history()
                    if self.not_error != True:
                        _end = self.end_sync(code=7)
                        if _end != True:
                            return _end
                                                            
                    if self.orders!=[]:                   
                        self.orders=list(itertools.chain.from_iterable(self.orders))                  
                
                        for order in self.orders:                      
                            order['created_at'] = int(order['executed_timestamp'])/1000
                            order['created_at_formated'] = datetime.utcfromtimestamp(int(order['executed_timestamp'])/1000).strftime('%Y-%m-%d %H:%M:%S')
                    
                        self.all_orders = self.orders       
                            
                                        
                    self.save_account(self.api_key_information)
                    
                    self.save_files(file_type='json')
                        
                    self._update_progress('Reading orders', '19%') 
                    
                    self.interpret_orders() 
                    
                    self._update_progress('Preparing all to save orders', '20%') 
                    
                    self.save_orders()
                            
                    self.not_error  = self.save_params()
                    #getattr(self.out, 'mgs', 'successfully')
                    self.sync_status(healthy=True, message=self.out['mgs'] if 'mgs' in self.out else 'Sync Success', status_code=200)
                    
            #TERMINA LA ITERACION
            return self.end_sync(event_id=new_event_id)

        except Exception as err:
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(tt.time())-self.star_timestamp), 500, 'Fail')
            self.unlock_portfolios()
            self._update_progress('warning', 'Imported fail',True)
            return ErrorResponses.error_500(self.data, err, version)

    def validate(self):
        try:

            self.data = request.json
            self.user.users_configs.not_warning_import = self.data.get('not_warning_import',True)
            self.user.users_configs.save()
            self.symbols = self.data.get('symbols',self.symbols)
            self.auto_import = self.data['auto_import'] if 'auto_import' in self.data else False
            self.api_key_information=''
            self.new_sync = True
            
            if self.credential and (not 'add' in self.data or self.data['add'] == False):
                self.api_key = self.credential.api_key
                self.secret_key = self.credential.secret_key
                self.test_account =  self.credential.test_account
                self.host  = "https://api.staging.woo.org" if  self.credential.test_account else "https://api.woo.org"
                self.new_sync = False
            else:
                if self.data['api_key'] =='' or self.data['secret_key'] == '' or self.data['test_account']=='':
                    return "Wrong credentials"

                self.api_key = self.data['api_key'].strip()
                self.secret_key = self.data['secret_key'].strip()
                self.host  = "https://api.staging.woo.org" if  self.data['test_account']  else "https://api.woo.org"
                self.test_account =  self.data['test_account']
                self.add = self.data.get('add',False)
                self.new_sync = True
            return True

        except Exception as err:
            if not self.credential:
                return "Wrong credentials"
            self.api_key = self.credential.api_key
            self.secret_key = self.credential.secret_key
            self.test_account =  self.credential.test_account
            self.api_key_information=''
            self.host  = "https://api.staging.woo.org" if  self.credential.test_account else "https://api.woo.org"
            self.user.users_configs.not_warning_import = True
            self.user.users_configs.save()
            self.data = None

    def genSignature(self, timestamp, uri_path, payload):       
        if 'v3' in uri_path:
            if len(payload)>0:
                query_string = timestamp + 'GET' + uri_path + json.dumps(payload)
            else:
                query_string = timestamp + 'GET' + uri_path
        else:
            if len(payload)>0:
                query_string = '&'.join(["{}={}".format(k, v) for k, v in payload.items()]) + f"|{timestamp}"
            else:
                query_string = f"|{timestamp}"
                    
        signature = hmac.new(
            self.secret_key.encode('utf-8'),
            query_string.encode('utf-8'),
            hashlib.sha256
        ).hexdigest()
        return signature
                
    def request_woox(self, uri_path, payload):
        tt.sleep(0.4)
        timestamp = str(int(time.time() * 1000))
        payload = OrderedDict(sorted(payload.items()))
        
        if 'v3' in uri_path:
            ContentType = "application/json"
        else:
            ContentType = "application/x-www-form-urlencoded"
            
        headers = {
            'Content-Type': ContentType,
            'x-api-key': self.api_key,
            'x-api-signature': self.genSignature(timestamp,uri_path,payload),
            'x-api-timestamp': timestamp,
            'cache-control': 'no-cache'
        } 
                
        try: 
            response = requests.get(url=self.host + uri_path, params=payload,  headers=headers)
            #print(response.text)
        except (
            requests.exceptions.ReadTimeout,
            requests.exceptions.SSLError,
            requests.exceptions.ConnectionError,
        ) as e:
            return e
                                
        # Convert response to dictionary, or raise if requests error.
        try:
            s_json = response.json()

        # If we have trouble converting, handle the error and retry.
        except JSONDecodeError as e:
                return "Conflict. Could not decode JSON."
                            
        return s_json 
    
    def get_api_key_information(self):
        url= '/v3/accountinfo'
        payload={}
        response = self.request_woox(url, payload)
        if  response['success'] == True:
            try:
                applicationId=response["data"]["applicationId"]
                self.api_key_information=applicationId.split("-")[0]
                return self.api_key_information
            except:
                return None
        else:
            return None
        
    def login(self):               
        
        self.session_v3=requests.Session() #requests V3
        try:
            url= '/v3/accountinfo'
            payload={}
            response = self.request_woox(url, payload)
            if  response['success'] == False:
                return  response['message'] 
            else:
                applicationId=response["data"]["applicationId"]
                self.api_key_information=applicationId.split("-")[0]
                return True
        except:
                self.api_key_information=''
                return 'Invalid Api-Key ID.' 
        
    def get_symbols(self):
        try:
            self.symbols = []
            url='/v1/public/info'
            payload={}        
            response = self.request_woox(url, payload)        
            if  response['success'] == True and response["rows"]!= []:
                for symbol in response["rows"]:
                    SymbolList=symbol['symbol'].split("_") 
                    self.symbols.append(SymbolList[-2]+SymbolList[-1])
            return True
        except Exception as e:
            return str(e)
        
    def get_woox_orders(self):
        url= '/v1/client/trades' 
        msg_order_len = 0            
        order_len = 500
        symbols=self.data['symbols']        
        start_time =  1000000000001 # int((time.time()-2629743))*1000                 
        if self.data['partial']== True:
            start_time = int(self.get_last_date_a()*1000)-86400
            if start_time==0:                        
                start_time =  1000000000001 # int((time.time()-2629743))*1000
        i = 1     
        end_time = int(time.time() * 1000)           
        while order_len > 0 and start_time < end_time:
            self._update_progress('Retrieving orders Page {}'.format(i), '16%')              
            start_time, endTime = self.validate_date_range(start_time, end_time)
            payload={
                    "size":500,
                    "start_t":start_time,
                    #"end_t":end_time,
                    }                
            try: 
                tt.sleep(0.5)            
                order = self.request_woox(url, payload)
                #print(order)
                #print('start_time',start_time)
                #print('end_time  ',end_time)
                if  order['success'] == True:
                    if 'data' in order and len(order['data'])>0:                                       
                        order_len = len(order['data'])                      
                        
                        for row_order in order['data']:
                            SymbolList=row_order['symbol'].split("_") 
                            row_order['symbol']=SymbolList[-2]+SymbolList[-1]
                            row_order['executed_timestamp']=str(row_order['executed_timestamp']).replace('.', '')
                            try:
                                start_time=int(row_order['executed_timestamp'])+1
                            except:
                                start_time=int((time.time()-2629743))*1000
                            if row_order['symbol'] in symbols or not symbols:
                                self.used_symbols.append(row_order['symbol'])
                                self.orders.append([row_order])
                    else:
                        order_len = 0                   
                else:
                    order_len = 0
                    return  order['message']
            except Exception as e:
                print(traceback.print_exc())
                order_len = 0
                return 'Error Extracting orders'                      
            
            i = i+1
            msg_order_len = order_len + msg_order_len
        return True
  
    def get_woox_orders_all_history(self):
        url='/v1/client/hist_trades'
        msg_order_len = 0    
        self.orders=[]             
        order_len = 5000
        symbols=self.data['symbols']        
        start_time =  1000000000001 # int((time.time()-2629743))*1000                 
        if self.data['partial']== True:
            start_time = int(self.get_last_date_a()*1000)
            if start_time<=0:
                start_time =  1000000000001 # int((time.time()-2629743))*1000
        i = 1     
        end_time = int(time.time() * 1000)           
        while order_len > 0 and start_time < end_time:
            self._update_progress('Retrieving orders Page {}'.format(i), '16%')              
            start_time, endTime = self.validate_date_range(start_time, end_time)
            payload={
                    "size":5000,
                    "start_t":start_time,
                    "end_t":end_time,
                    }                
            try: 
                tt.sleep(1)            
                order = self.request_woox(url, payload)
                #print(order)
                #print('start_time',start_time)
                #print('end_time  ',end_time)
                if  order['success'] == True:
                    if 'data' in order and len(order['data'])>0:                                       
                        order_len = len(order['data'])                      
                        
                        for row_order in order['data']:
                            SymbolList=row_order['symbol'].split("_") 
                            row_order['symbol']=SymbolList[-2]+SymbolList[-1]
                            row_order['executed_timestamp']=str(row_order['executed_timestamp']).replace('.', '')
                            try:
                                start_time=int(row_order['executed_timestamp'])+1
                            except:
                                start_time=int((time.time()-2629743))*1000
                            if row_order['symbol'] in symbols or not symbols:
                                self.used_symbols.append(row_order['symbol'])
                                self.orders.append([row_order])
                    else:
                        order_len = 0                   
                else:
                    order_len = 0
                    return  order['message']
            except Exception as e:
                print(traceback.print_exc())
                order_len = 0
                return 'Error Extracting orders'                      
            
            i = i+1
            msg_order_len = order_len + msg_order_len
        return True
                           
    def interpret_orders(self):
        try:
            interpreter_orders_event = EventUser.post_user_evenpiYLRvUbnUDWlxZvOvGjM0IyfkjLAMZynTsYts(101)
        except:
            pass
        result_b = []
        b=len(self.orders)
        new_date_time = []
        pip_value_order = dict()
        pip_value_order_btc = dict()
        verify_njson_len = 0
        orders_filerow = []
        i = 0
        
        self.orders = list(sorted(self.orders, key=lambda i: i['created_at'], reverse=True))
                    
        if self.orders:
            orders_filerow = ImportParams.filerow_orders(self.params['get_session_userid'],
                                                         var_sync='id', 
                                                         var_file='order_id',
                                                         broker='woox'
                                                     )
      
        new_list = []
        
        for order in self.orders:
             
            check_json = json.dumps(order)
            check_json = hashlib.md5(check_json.encode('utf-8')).hexdigest()
            if check_json in new_list:
                continue
                
            i = i +1
            original_file_row = json.loads(json.dumps(order))
            njson = json.dumps(order)
            njson = hashlib.md5(njson.encode('utf-8')).hexdigest()                 
                
            if 'side'in order:
                action = order['buy/sell'].upper() if 'buy/sell' in order else order['side'].upper() if 'side' in order else order['transaction category'].upper() if 'transaction category' in order else ''
            else:
                action = 'BUY' if order['isBuyer']== True else 'SELL'
            action = 'BUY' if action == 'BUY' or action=='COVER' else 'SELL' if action == 'SELL' or action == 'SHORT' else ''
            order['symbol']  = order['contracts'] if 'contracts' in order else order['contract'] if 'contract' in order else order['symbol'] if 'symbol' in order else ''
            order['date'] = order['created_at_formated']            
            order['type'] = order['filled type'].upper() if 'filled type' in order else order['types'].upper() if 'types' in order else 'TRADE'

            # continue 
            order['price'] = order['executed_price']                
            if float(order['executed_price']) != 0:
                order['quantity'] = float(order['executed_quantity']) /  float(order['executed_price'])
            else:
                continue 
            if not order['symbol'] or not order['date'] or not order['price'] or not action or order['type'] != "TRADE":
                continue

            pip_value = 1
            date_time = order['date']
            original_file_row['date_tz'] = date_time
            self.any_error, date, time = ImportParams.get_param_datetime(date_time,b)
            new_date_time = ImportParams.convert_date(date, time, self.date_format,True,'UTC')

            order['date'] = new_date_time[0]
            order['time'] = new_date_time[1]
            fp = str(order['price']).replace(',', '').replace('$','')
            decimal = fp[::-1].find('.')
            decimal = decimal if decimal > 1 else 2
            price = round(float(fp),decimal)
            #price = round(float(order['price'].replace(',', '')),6)

            sm = len(order['symbol'])
            type = 'crypto'
            option = 'CRYPTO'
            strike = ''
            expire = ''

            user_portfolio = self.params['user_portfolio']           

            #################### VERIFY FILE ROW ######################
                        
            if njson in orders_filerow:
                verify_njson_len = verify_njson_len + 1
                continue
            if 'id' in original_file_row and original_file_row['id']:
                order_id = '{}'.format(original_file_row['id'])
                if order_id in orders_filerow:
                    verify_njson_len = verify_njson_len + 1
                    continue
            try:
                var_date = original_file_row['date_tz']
                var_date = ImportParams.parse_date(var_date).strftime('%Y-%m-%d %H:%M:%S')
                njson3 = '{}{}{}{}{}{}{}'.format(float(fp) if fp else 0.00,
                                                 var_date,
                                                 option,
                                                 1 if action == 'BUY' else 2,
                                                 float(str(order['executed_quantity']).replace(',', '')) if 'executed_quantity' in order \
                                                      else '',
                                                 float(strike) if ImportParams.isfloat(strike) else 0.0,
                                                 expire
                                                )
                if njson3 in orders_filerow:
                    verify_njson_len = verify_njson_len + 1
                    continue
            except:
                pass
            ###########################################################
            sym = order['symbol'][-3:]
            if not 'execValue' in order:
                pip_value = self.convert_usdt(order, pip_value_order, date )
            elif sym in ['USD']:
                value_order = float(order['executed_quantity']) * float(order['executed_price'])
                exec_value = float(order['execValue']) if ImportParams.isfloat(order['execValue']) else ''
                pip_value_exec = (exec_value / value_order)
                pip_value = pip_value_exec * price
            elif 'USDT' in order['symbol']:
                pip_value = 1
            else:
                value_order = float(order['executed_quantity']) * float(order['executed_price'])
                exec_value = float(order['execValue']) if ImportParams.isfloat(order['execValue']) else ''
                if exec_value and order['symbol']:                    
                    if value_order != 0:
                        pip_value = (exec_value / value_order)
                    else:
                        pip_value = exec_value
                        
                    pip_value = pip_value * float(order['price'])
                     
                    #pip_value_btc = ImportParams.pip_value_crypto_(order['date'], base='usdt', currency='btc')"""
            
            pip_value_btc = 1
            if order['symbol'] == 'BTCUSD':
                row_btc = '{}{}'.format(date,sym)
                if not row_btc in pip_value_order_btc:
                    pip_value_btc = ImportParams.pip_value_crypto_(order['date'], base='usdt', currency='btc')
                    pip_value_order_btc[row_btc] = pip_value_btc
                else:
                    pip_value_btc = pip_value_order_btc[row_btc]
                
            if len(order['symbol']) > 8 and len(order['symbol'].split('-')) == 4:
                split_symbol = order['symbol'].split('-')
                type = 'crypto option'
                option = 'CALL' if split_symbol[3].upper() == 'C' else 'PUT' if split_symbol[3].upper() == 'P' else 'OPTION'
                strike = split_symbol[2]
                expire = str(parse(split_symbol[1]).strftime("%d %b %y")).upper()
                order['symbol'] = '#{}{}'.format(split_symbol[0],'USDT')

            order['orderby'] = b
            order['trade_notes'] = order['trade_notes'] if 'trade_notes' in order else ''
            order['type_stock'] = type
            order['type_option'] = option
            order['action'] = action
            order['price'] = price
            order['shares'] = str(order['executed_quantity']).replace(',', '') if 'executed_quantity' in order else str(order['qty']).replace(',', '')
            # if not 'app' in self.domain_name():
            #order['swap'] = order['execFee'] if 'execFee' in order else '0.00'
            if 'execFee' in order:
                order['fees'] = (float(order['execFee']) * float(pip_value_btc)) if 'execFee' in order else '0.00'
            elif 'cumExecFee' in order:
                order['fees'] = order['cumExecFee'] if 'cumExecFee' in order else '0.00'
            else:
                order['fees'] = (float(order['feeAmount']) * float(pip_value_btc)) if 'feeAmount' in order else '0.00'

            if ImportParams.isfloat(order['fees']) and 'USD' in order['symbol'] \
                  and not 'USDT' in order['symbol'] and not 'BTCUSD' in order['symbol']:
                order['fees'] = float(order['fees']) * float(price)
            order['njson'] = njson
            order['decimal'] = decimal
            order['expire'] = expire
            order['strike'] = strike
            order['pip_value'] = pip_value
            order['original_file_row'] = original_file_row
            order['broker'] = self.params['broker']
            order['userid'] = self.params['get_session_userid']
            order['portfolio'] = user_portfolio
            order['app_broker'] = 1
            order['size'] = 1
            data_item = ImportParams.get_result_append(order)
            self.out_result.append(data_item)
            b = b - 1 
        try:
            event_success = EventUser.update_user_events(interpreter_orders_event)
        except:
            pass

    def save_orders(self):
        try:
            regroup_orders_event = EventUser.post_user_events(102, new_user=self.user_id)
        except:
            pass
        if self.user.id == 666:
            print('save orders',len(self.out_result))
        import_broker = 'woox'
        regroup_value = [group['code'] for group in self.user.users_configs.trade_grouping if group['active'] == True][0]
        error_mgs = "There was an error. Our support team will review the issue and get back to you"
        # print('antes del regroup', len(self.out_result))
        spread = False
        if regroup_value == 'split':
            output_group = TradeRegroups.regroup_trades_closed(self.out_result,import_broker,self.user.id)

        else:
            if regroup_value=='spread':
                spread = True
            output_group = TradeRegroups.regroup_trades(self.out_result, import_broker, self.user.id, spread=spread, user=self.user)
        if 'error' in output_group:
            self.out['mgs'] = error_mgs
            return self.out
        any_error, rows, return_total, error_issue, executions, self.upload_id = TradeRegroups.save_to_database(output_group,import_broker, self.user.id, archive = self.filename_csv, upload_id = self.upload_id)
        self.out_result = output_group
        """
            rows : total trades imported
            executions: total executions imported
        """
        # print('despues del regroup', executions)
        self.rows = self.rows+rows
        self.executions = self.executions + executions
        self.out = {'any_error': any_error, 'rows': self.rows, 'ordens': self.executions,
                'return_total': return_total, 'error_issue': error_issue,
                'broker': import_broker, 'error_code': any_error}
        if any_error and any_error != 21:
            self.out['mgs'] = error_mgs
            return self.out
        else:
            if rows > 0:
                try:
                    self.user.fk_user_status_id = 1
                    self.user.save()
                except:
                    pass
                mgs = f'{str(self.rows)} Trades, {str(self.executions)} Executions'
            else:
                if self.last_date == 0 or self.last_date == None:
                    mgs = "No new trades found."
                else:
                    mgs = "No new trades to import"
        self.out['mgs'] = mgs
        self.save_file(tmp_route = self.tmp_route_csv, archive = self.filename_csv ,data = self.all_orders, to = self.to_csv, f_type= 'transactions_csv', content_type = 'text/csv',  portfolio =self.portfolio,  executions=executions , trades=rows, fk_broker_id = self.broker.broker_id, broker = self.broker.broker_key)
        #UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,replace=True)
        try:
            event_success = EventUser.update_user_events(regroup_orders_event)
        except:
            pass