import traceback
import sys
from flask_restful import Resource, request
from ..models import BrokersConnections, Portfolios, PortfolioReferences, PortfolioAdjustment, \
                      PortfolioAdjustmentType, BrokersApis, TradesHistories, \
                      TempOrders, TradesHistories, Trades, HandlingErrorsLog
from ..portfolio.adjustment import PortfolioAdjustmentDefinition as pad
from ..responses import ErrorResponses, SuccessResponses
from ..user.users_params import *
import itertools
from ..import_params import ImportParams
from ..trade.trades_regroups import *
import time
from datetime import timedelta
from .brokers_export import BrokerExport
from ..event.events import UserEventList as EventUser
#from requests.exceptions import ConnectionError
import requests
import json
import boto3
from datetime import datetime


class TradeLockerExport(BrokerExport, ServerInfo, Resource):

    @verify_role('broker export')
    def post(self):
        try:           
            new_event_id=self.init_sync()
            self._update_progress('Saving Pre-Data', '1%')
            if not isinstance(new_event_id,UserEvents) and not self.is_lambda():
                return new_event_id

            for credential in self.credentials:
                self.credential = credential
                self._update_progress('Checking Credentials', '5%')
                self.not_error = self.validate()
                if self.not_error is not True:
                    _end = self.end_sync(code=1)
                    if _end is not True:
                        return _end

                self.symbols = []
                
                self._update_progress('Login to TradeLocker', '5%')                
                self.not_error = self.login()
                if self.not_error is not True:                    
                    self.test_account = not self.test_account
                    self.host = "https://demo.tradelocker.com" if self.test_account is True else "https://live.tradelocker.com"
                    not_error = self.login()
                    if not_error is not True:
                        self.not_error = "{}|{}".format(self.not_error, not_error)
                        _end = self.end_sync(code=10)
                        if _end is not True:
                            return _end
                # self.sessions.append(self.session)
                #if self.credential:
                    #self.symbols = self.symbols + self.credential.symbols_list

                #if self.data['symbols'] != [] and self.symbols == [] and (
                #        'add' in self.data or self.data['add'] == True):
                #    self.symbols = self.data['symbols']
                self.orders = []
                self.all_orders = []
                self.account_pusher = "Not Account Found"
                msg = "Not Account Found"
                for account in self.api_key_information:
                    self.account_pusher = 'Account #' + str(account['id'])
                    self.time_out_lambda=False
                    if self.condition_lambda() and not self.aws_autosync:
                        try:
                            self.not_error = self.call_lambda(account=account)
                        except Exception as err:
                            #print(err)
                            #print(traceback.print_exc())
                            self.not_error = err
                            self.executed_lambda = False
                    
                    if not self.executed_lambda:
                        self._update_progress('Saving account', '10%')
                        self.not_error = self.save_account(account['id'])
                        if self.not_error is not True:
                            _end = self.end_sync(code=6)
                            if _end is not True:
                                return _end
                        
                        self._update_progress('Getting pairs', '11%')
                        self.not_error = self.get_symbols(account)
                        if self.not_error is not True:
                            _end = self.end_sync(code=6)
                            if _end is not True:
                                return _end
                        #lambda_event = request.environ.get('lambda.event')
                        #lambda_context = request.environ.get('lambda.context')
                        #log_stream_name  = request.environ.get("AWS_LAMBDA_LOG_STREAM_NAME", "UNKNOWN_LOG_STREAM")

                        self._update_progress('Saving data', '15%')

                        self.save_configs()
                        self._update_progress('Get orders from TradeLocker', '18%')
                        self.not_error = self.get_orders(account)
                        if self.not_error is not True:
                            _end = self.end_sync(code=7)
                            if _end is not True:
                                return _end
                        #self.all_orders = self.all_orders + self.orders
                        self.all_orders = self.orders
                            
                        self.check_status_connection_db()
                        if len(self.all_orders) > 0:
                            self._update_progress('Saving deposits', '18%')
                            self.save_deposits(account, self.orders)
                            self.save_files(file_type='json')
                            self._update_progress('Reading orders', '19%')
                            #self.interpret_orders()
                            self.interpret_save_orders()
                            #UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, True)
                            #self.pusher_title = self.account_pusher + ' - Preparing all to save orders'
                            #self.pusher_message = '20%'
                            #self.pusher_complete = False
                            #self.send_pusher()
                            #self.save_orders()
                    self.not_error  = self.save_params()

                    if len(self.api_key_information) > 0:
                        
                        self.user.users_configs.tda_import = True
                        self.user.users_configs.save()
                        #self._update_progress('Import completed', '100%')
                        msg = self.out['mgs'] if 'mgs' in self.out else 'Sync Success'
                    else:
                        if not self.is_lambda() or not self.can_call_lambda():
                            #UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, True)
                            self.unlock_portfolios()
                        self._update_progress('warning', 'Not accounts founds')
                        self.errors.append(
                            str(self.not_error) + ' for Account #' + account['id'])
                        #self.sync_status(healthy=True, message=str(self.not_error))
                        if len(self.credentials) <= 1:
                            return ErrorResponses.error_500(self.data, 'Not accounts founds', version)
                        else:
                            continue
                self.sync_status(healthy=True, message=msg, status_code=200)
                    
            # TERMINA LA ITERACION
            self.out["user_id"] = self.user.id
            self.out["status_response_login"] = self.response.status_code if self.response else 0
            self.out["status_response_symbol"] = self.symbol_response.status_code if self.symbol_response else 0
            self.out["status_response_orders"] = self.order_response.status_code if self.order_response else 0
            self.out["deposits_response"] = self.deposits_response.status_code if self.deposits_response else 0
            self.out["len_orders"] = len(self.orders)
            self.out["start_time"] = self.start_time
            self.out["end_time"] = time.strftime("%Y-%m-%d %H:%M:%S")
            self.out["params"] = self.params
            self.out["out_result"] = len(self.out_result)
            self.out["msg"] = msg
            #print(self.out)
            # Save orders data to S3

            # try:
            #     # Initialize S3 client
            #     ACCESS_KEY = "AKIAVF7U2LM63DF43XFH"
            #     SECRET_KEY = "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"

            #     # Inicializar cliente S3 con credenciales hardcodeadas
            #     s3 = boto3.client(
            #         's3',
            #         aws_access_key_id=ACCESS_KEY,
            #         aws_secret_access_key=SECRET_KEY,
            #     )

            #     # Configuration
            #     BUCKET_NAME = 'time-test'
            #     FILE_NAME = 'logs.txt'

            #     try:
            #         # Try to retrieve existing content
            #         response = s3.get_object(Bucket=BUCKET_NAME, Key=FILE_NAME)
            #         existing_content = response['Body'].read().decode('utf-8')
            #         print(f"File {FILE_NAME} found, appending content.")
            #     except s3.exceptions.NoSuchKey:
            #         print(f"The file {FILE_NAME} does not exist in bucket {BUCKET_NAME}. Creating a new file.")
            #         existing_content = ""  # No existing content, so we start fresh

            #     # Add new content
            #     content_to_upload = f"{existing_content}\n{self.out}"

            #     # Upload updated content
            #     s3.put_object(
            #         Bucket=BUCKET_NAME,
            #         Key=FILE_NAME,
            #         Body=content_to_upload.encode('utf-8'),
            #         ContentType='text/plain'
            #     )
            #     print(f"File {FILE_NAME} updated successfully in bucket {BUCKET_NAME}.")
            # except s3.exceptions.ClientError as e:
            #     error_code = e.response['Error']['Code']
            #     print(f"ClientError: {error_code}")
            #     if error_code == 'InvalidToken':
            #         print("The provided token is invalid. Check your credentials.")
            # except Exception as e:
            #     print(f"An unexpected error occurred: {str(e)}")

            # msg = f''
            # return SuccessResponses.success_200(data='export', message=msg, out=self.out)
            return self.end_sync(event_id=new_event_id)

        except Exception as err:
            #UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, True)
            self.unlock_portfolios()
            self._update_progress('warning', 'Import Fail', True)
            if self.is_lambda() and self.can_call_lambda():
                self.save_params_lambda((int(time.time()) - self.star_timestamp), 500, 'Fail')
            return ErrorResponses.error_500(self.data, err, version)

    def validate(self):
        try:
            self.data = request.json
            self.user.users_configs.not_warning_import = self.data.get('not_warning_import', True)
            self.symbols = self.data.get('symbols', self.symbols)
            self.user.users_configs.save()
            self.auto_import = self.data['auto_import'] if 'auto_import' in self.data else False
            if self.credential and self.add == False:
                #self.credential = BrokersConnections.find_by(**{'user_id':self.user.id, "broker_id":self.broker.broker_id, 'active': True})
                self.api_key = self.credential.api_key
                self.secret_key = self.credential.secret_key
                self.username = self.credential.username
                self.password = self.credential.password
                self.test_account = self.credential.test_account
                self.passphrase = self.credential.passphrase
                self.new_sync = self.credential.new_sync
                # self.content_type = 'application/x-www-form-urlencoded'
            else:
                # self.symbols = self.data['symbols']
                self.api_key = self.data['api_key'] if 'api_key' in self.data else None
                self.username = self.data['username'] if 'username' in self.data else None
                self.password = self.data['password'] if 'password' in self.data else None
                self.secret_key = self.data['secret_key'] if 'secret_key' in self.data else None
                self.passphrase = self.data['passphrase'].strip()
                self.test_account = self.data['test_account'] if 'test_account' in self.data and self.data['test_account'] != "" else False
                self.new_sync = True
                self.add = self.data.get('add', False)
                
                

            self.host = "https://demo.tradelocker.com" if self.test_account == True else "https://live.tradelocker.com"

            if self.passphrase == '' or self.passphrase == None:
                return "Not server found"
            return True

        except Exception as err:
            if not self.credential:
                return "Wrong credentials"

            # self.symbols = self.credential.symbols
            self.api_key = self.credential.api_key
            self.secret_key = self.credential.secret_key
            self.passphrase = self.credential.passphrase
            self.test_account = self.credential.test_account
            self.host = "https://demo.tradelocker.com" if self.test_account == True else "https://live.tradelocker.com"
            
            # self.content_type = 'application/x-www-form-urlencoded'
            self.user.users_configs.not_warning_import = True
            self.user.users_configs.save()
            self.data = None

    def login(self):
        try:
            #self.api_key_information = []
            endpoint_login = '/backend-api/auth/jwt/token'
            endpoint_accounts = '/backend-api/auth/jwt/all-accounts'
            data = {
                'email': self.api_key or self.username,
                'password': self.secret_key or self.password,
                'server': self.passphrase
            }
            self.headers =  {
                'contentType': 'application/json'
            }
            response = requests.request('post', self.host + endpoint_login, headers=self.headers, json=data)
            self.response = response
            response = response.json()
            if 'accessToken' in response:
                self.headers['Authorization'] = 'Bearer ' + response['accessToken']
                accounts = requests.request('get', self.host+endpoint_accounts, headers=self.headers).json()
                if 'sync_all_v2' in self.data and self.data['sync_all_v2'] == True:
                    for account in accounts['accounts']:
                        if (isinstance(self.api_key_information[0], str) and self.api_key_information[0].startswith( str(account['id']) )) or (isinstance(self.api_key_information[0], dict) and self.api_key_information[0]['id'].startswith( str(account['id']) )):
                            self.api_key_information = [account]
                            return True
                    
                self.api_key_information = accounts['accounts']
                return True
            else:
                return json.dumps(response)
        except Exception as e:
            #print(e)
            #print(traceback.print_exc())
            return str(e)

    def get_symbols(self,account):
        try: 
            endpoint = f"/backend-api/trade/accounts/{account['id']}/instruments"
            self.headers['accNum'] = account['accNum']
            while True:
                response = requests.request('get', self.host+endpoint, headers=self.headers, timeout=10)
                self.symbol_response = response
                if response.status_code == 429:
                    # Get retry-after from response if available, otherwise wait 1 second
                    retry_after = int(response.headers.get('Retry-After', 1))
                    time.sleep(retry_after)
                    continue
                elif response.status_code == 200:
                    break
                else:
                    #print(f"Unexpected status code: {self.user.id} - {response.status_code}")
                    raise Exception(f"Unexpected status code: {response.status_code} - {response.text}")
            response = response.json()
            if response['s'] == 'ok':
                self.symbols = response['d']['instruments']
            endpoint = f"/backend-api/trade/config"
            response = requests.request('get', self.host+endpoint, headers=self.headers).json()
            self.keys = response['d']
            return True
        except Exception as ex:
            return str(ex)

    def convert_orders_to_json(self, data, data_key='ordersHistoryConfig', multilevel=True):
        # Claves correspondientes al array proporcionado
        keys = [item["id"] for item in self.keys[data_key]['columns']]
        # Convertir cada orden en un diccionario
        if multilevel:
            return [dict(zip(keys, d)) for d in data]
        return dict(zip(keys, data))

    def find_instrument_by_id(self, instrument_id):
        endpoint = '/backend-api/trade/instruments/'
        try:
            for instrument in self.symbols:
                if instrument['tradableInstrumentId'] == int(instrument_id):
                    symbol = instrument['name'].split('.')
                    routes = instrument['routes'] 
                    route_id = None
                    for route in routes:
                        if route['type'] == "INFO":
                            route_id = route['id']
                    if route_id != None:
                        if instrument_id in self.routes:
                            instrument['route'] = self.routes[instrument_id]
                            tick_size = self.routes[instrument_id]['tickSize'][0]['tickSize']
                        else:
                            while True:
                                response = requests.request('get', f"{self.host}{endpoint}{instrument['tradableInstrumentId']}?routeId={route_id}" , headers=self.headers, timeout=10).json()
                                if 'error' in response:
                                    date_object = datetime.strptime(response['timestamp'], "%Y-%m-%dT%H:%M:%S.%fZ")
                                    current_timestamp = datetime.utcnow().timestamp()
                                    seconds_remaining = date_object.timestamp() - current_timestamp
                                    if seconds_remaining <= 0:
                                        seconds_remaining = .5
                                    time.sleep(seconds_remaining)
                                else:
                                    instrument['route'] = response['d']
                                    self.routes[instrument_id] = response['d']
                                    tick_size = response['d']['tickSize'][0]['tickSize']
                                    break
                    return symbol[0], instrument['route']['lotSize'],instrument
            return None,None,None
        except Exception as ex:
            return None,None,None
            

    def get_orders(self, account):
        try:
            last_date = self.get_last_date_a(user_account=account['id'])
            if 'partial' in self.data and self.data['partial'] == True:
                last_time = last_date
            else:
                last_time = 0
            
            startTime = int(last_time * 1000)
            timestampt = int(time.time()) * 1000
            orders = []
            orders_filled = []
            endpoint = f"/backend-api/trade/accounts/{account['id']}/ordersHistory"
            if last_time > 0:
                endpoint = f"{endpoint}?from={startTime}&to={timestampt}"
            self.headers['accNum'] = account['accNum']
            while True:
                    response = requests.request('get', self.host+endpoint, headers=self.headers, timeout=10)
                    self.order_response = response
                    if response.status_code == 429:
                        # Get retry-after from response if available, otherwise wait 1 second
                        retry_after = int(response.headers.get('Retry-After', 1))
                        time.sleep(retry_after)
                        continue
                    elif response.status_code == 200:
                        break
                    else:
                        #print(f"Unexpected status code: {self.user.id} - {response.status_code}")
                        raise Exception(f"Unexpected status code: {response.status_code}")
            response = response.json()
            if response['s'] == 'ok':
                self.routes = {}
                
                orders = self.convert_orders_to_json(response['d']['ordersHistory'], 'ordersHistoryConfig')
                i = 0
                for order in orders:
                    if order['status'] == "Filled":
                        orders_filled.append(order)
                for order in orders_filled:
                    i+=1
                    order['symbol'], order['size'], order['instruments']  = self.find_instrument_by_id(order['tradableInstrumentId'])
                    if i % 100 == 0 or i == 1 or i == len(self.all_orders):
                        self._update_progress(f"Get Contracts orders from TradeLocker: {i}/{len(orders_filled)}", '19%')
            self.orders = orders_filled
            
            return True
        except Exception as ex:
            return str(ex)
    
    def save_deposits(self, account, orders):
        try:
            endpoint = f"/backend-api/trade/accounts/{account['id']}/state"
            self.headers['accNum'] = account['accNum']
            response = requests.request('get', self.host+endpoint, headers=self.headers)
            self.deposits_response = response
            response = response.json()
            if response['s'] == 'ok':
                account_info = self.convert_orders_to_json(response['d']['accountDetailsData'], 'accountDetailsConfig', False)
                deposit_adjustment=1
                deposits=account_info['balance']
                reference_code = account['id']
                get_portfolio = PortfolioReferences.query.\
                        filter_by(
                            reference_code = reference_code,
                            fk_broker_id = self.broker.broker_id,
                            fk_user_id = self.user.id,
                            )
                get_portfolio = get_portfolio.first()
                fk_portfolio_id = get_portfolio.fk_portfolio_id
                dates = [datetime.utcfromtimestamp(int(order["createdDate"]) / 1000) for order in orders]
                if len(dates) > 0:
                    created_at = min(dates)  - timedelta(days=1)
                else:
                    created_at = datetime.now()  - timedelta(days=1)
                    
                format_date=str(created_at)
                created_at=str(created_at)[0:10]
                instance = pad()       
                portfolio = Portfolios.query.filter_by(
                                                        fk_user_id=self.user.id,
                                                        portfolio_id=fk_portfolio_id).first()
                if portfolio:
                    if self.new_sync == True and not PortfolioAdjustment.validate_duplicated(deposits, created_at, deposit_adjustment, fk_portfolio_id):
                        #se guarda en la tabla portfolio_adjustments con el tipo de adjustment en la tabla portfolio_adjustment_type
                            add_adjustment = instance.create(
                                                    portfolio,
                                                    deposits, 
                                                    deposit_adjustment,
                                                    str(created_at), 
                                                    '%Y-%m-%d'
                                                    )
        except Exception as ex:
            pass
    def interpret_orders(self):
        pip_value_order = dict()
        b = 0
        new_date_time = []
        verify_njson_len = 0
        i = 0
        for order in self.all_orders:
            i += 1
            if i % 100 == 0 or i == 1 or i == len(self.all_orders):
                self._update_progress("Reading orders: {}/{}".format(i, len( self.all_orders)), '19%') 
            original_file_row = json.loads(json.dumps(order))
            njson = json.dumps(order)
            njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
            try:
                action = order['side'].upper()
                order['price'] = float(order['avgPrice'] if order['avgPrice'] is not None else order['price'] )
                quantity = float(order['filledQty']) if 'filledQty' in order else order['qty']
                order['side'] = action
                order_time = int(order['lastModified'])
                order['date'] = datetime.utcfromtimestamp(order_time / 1000).isoformat()
                order['quantity'] = quantity
                pair = order["instruments"]['name'].split('.')
                multiplier = 0
                if self.passphrase == 'OSP-LIVE' or self.passphrase == 'OSP-DEMO':
                    comm = {'':0, 'MINI':1, 'PRO':8, 'STN':7, 'VAR':0}
                    if any(pair[0].startswith(currency) for currency in ["USD","EUR","GBP","CAD","AUD"]) and (1711497600*1000)<=float(order['lastModified']):
                        if len(pair) > 1:
                            multiplier = comm[ pair[1] ]
                        else:
                            multiplier = 0
                        
                order['commission'] = (quantity * multiplier) if action == 'SELL' else 0
                #pip_value = order['size']* order['tick_size']
                if order['symbol'] == None:
                    continue
                order['fees'] = 0
                if order['status'] != 'Filled':
                    continue
                #else:
                #    order['symbol'] = order['symbol'].split('.')[0]
            except Exception as err:
                continue
            if not action:
                continue
            #pip_value = 1
            if 'instruments' in order and 'route' in order['instruments'] \
                and 'lotSize' in order['instruments']['route']:
                order['size'] = order['instruments']['route']['lotSize']
            date_time = order['date']
            original_file_row['date_tz'] = date_time
            self.any_error, date, time = ImportParams.get_param_datetime(date_time, b)
            new_date_time = ImportParams.convert_date(date, time, self.date_format, True, 'UTC')

            order['date'] = new_date_time[0]
            order['time'] = new_date_time[1]
            
            sym = order['symbol'][-3:]
            pip_row = "{}{}".format(sym,order['date'])
            if not pip_row in pip_value_order:
                pip_value = float(ImportParams.value_pip_forex(order['date'],sym))
                pip_value_order[pip_row] = pip_value
            else:
                pip_value = pip_value_order[pip_row]
                
            fp = str(order['price']).replace(',', '').replace('$', '')
            decimal = fp[::-1].find('.')
            decimal = decimal if decimal > 1 else 2
            price = round(float(fp), decimal)
            # price = round(float(order['price'].replace(',', '')),6)

            sm = len(order['symbol'])
            type = 'forex'
            option = 'FOREX'
            strike = ''
            expire = ''
            try:
                if order['instruments']['type'] == 'CRYPTO':
                    type = 'crypto'
                    option = 'CRYPTO'
                else:
                    order['symbol'] = "${}|{}".format(order['symbol'], order['positionId'])
            except:
                order['symbol'] = "${}|{}".format(order['symbol'], order['positionId'])
                
            #order['size'] = 1

            #if order['category'] in self.params['user_portfolios']:
            #    user_portfolio = self.params['user_portfolios'][order['category']]
            #else:
            #    user_portfolio = self.params['user_portfolio']

            user_portfolio = self.params['user_portfolio']

            #################### VERIFY FILE ROW ######################
            if ImportParams.verify_njson(njson, self.params['get_session_userid'], user_portfolio):
                verify_njson_len = verify_njson_len + 1
                continue
            else:
                if 'id' in original_file_row and original_file_row['id']:
                    n2 = original_file_row['id']
                    njson2 = json.dumps(n2)
                    njson2 = hashlib.md5(njson2.encode('utf-8')).hexdigest()
                    if ImportParams.verify_njson(njson2, self.params['get_session_userid'], user_portfolio):
                        verify_njson_len = verify_njson_len + 1
                        continue
                    else:
                        if ImportParams.verify_date_file_row(self.params['get_session_userid'],
                                                             self.params['broker'],
                                                             original_file_row,
                                                             argv2='id' if 'id' in original_file_row
                                                             else '',
                                                             portfolio=user_portfolio
                                                             ):
                            verify_njson_len = verify_njson_len + 1
                            continue
                        else:
                            njson3 = {
                                'price': float(fp) if fp else 0.00,
                                'date': order['date'] + ' ' + order['time'],
                                'option_type': option,
                                'action': 1 if action == 'BUY' else 2,
                                'shares': order['quantity'],
                                'strike': float(strike) if ImportParams.isfloat(strike) else '',
                                'expire': expire,

                            }
                            if ImportParams.verify_njson_webull(njson3, self.params['get_session_userid']):
                                verify_njson_len = verify_njson_len + 1
                                continue
                            else:
                                njson = njson2
            #order['symbol'] = f"${order['symbol']}"
            order['trade_notes'] = order['text'] if 'text' in order else ''
            order['type_stock'] = type
            order['type_option'] = option
            order['action'] = action
            order['price'] = price
            order['shares'] = str(order['quantity']).replace(',', '')
            order['comm'] = str(order['commission']).replace(',', '').replace('$','')
            order['njson'] = njson
            order['decimal'] = decimal
            order['expire'] = expire
            order['strike'] = strike
            order['pip_value'] = pip_value
            order['original_file_row'] = original_file_row
            order['broker'] = self.params['broker']
            order['userid'] = self.params['get_session_userid']
            order['portfolio'] = user_portfolio
            data_item = ImportParams.get_result_append(order)
            
            self.out_result.append(data_item)
            b = b + 1