"""
TradeLocker format detector.

Detects TradeLocker API JSON format and returns appropriate interpreter.
"""

import polars as pl

from pipeline.p01_normalize.brokers.tradelocker.tradelocker import TradeLockerInterpreter
from pipeline.p01_normalize.exceptions import UnknownFormatError


def detect(df: pl.DataFrame) -> TradeLockerInterpreter:
    """
    Detect if the DataFrame is TradeLocker format.

    Args:
        df: Input DataFrame to check

    Returns:
        TradeLockerInterpreter if format matches

    Raises:
        UnknownFormatError: If format doesn't match TradeLocker
    """
    if TradeLockerInterpreter.can_handle(df, {}):
        return TradeLockerInterpreter()

    raise UnknownFormatError("Data does not match TradeLocker format")
