import traceback
import requests
from .brokers_export import BrokerExport
from flask_restful import Resource, request
from .. import pusher_client
from ..security_service import verify_role
from ..models import BrokersConnections
from ..responses import ErrorResponses, SuccessResponses
from ..user.users_params import *
from ..import_params import ImportParams
from ..trade.trades_regroups import *
from ..server_info import ServerInfo
from ..event.events import UserEventList as EventUser
import itertools
import datetime
import time as tt
from dateutil.parser import parse

class TastyworksExport(BrokerExport,ServerInfo, Resource):

    @verify_role('broker export')
    def post(self):
        #print('TastyworksExport post')
        version = {}
        self.data = {}
        try:
            """
            self.data = {"portfolio":"","broker":"tda","auto_login":true,"partial":true}
            """
            self.data = request.json
            
            new_event_id=self.init_sync()
            if not isinstance(new_event_id,UserEvents) and not self.is_lambda():
                return new_event_id
            rows = 0
            executions = 0
            return_total = 0
            ordens = 0
            self.orders_filerow = []
            self.orders_filerow = ImportParams.filerow_orders(self.params['get_session_userid'],
                                                            var_sync='id', 
                                                            var_file='order #',
                                                            broker='tastyworks'
                                                        )
            for credential in self.credentials:
                self._update_progress('Checking Credentials', '5%')
                self.credential = credential
                self.not_error = self.validate()
                self.send_pusher()
                if self.not_error != True:
                    _end = self.end_sync(code=4)
                    if _end != True:
                        return _end

                self._update_progress('Connecting to the server', '6%')  
                self.not_error = self.login()
                if self.not_error != True:
                    if 'Two Factor Authentication required' in self.not_error:
                        self.extra_params_pusher['2fa'] = True
                        self._update_progress('Two Factor Authentication required', '6%')
                        _end = self.end_sync(code=-1)
                        if _end != True:
                            return _end
                        
                    _end = self.end_sync(code=1)
                    if _end != True:
                        return _end
                     
                self.time_out_lambda = False
                if self.condition_lambda() and not self.aws_autosync:
                    try:
                        self.not_error = self.call_lambda()
                    except Exception as err:
                        #print(err)
                        #print(traceback.print_exc())
                        self.not_error = err
                        self.executed_lambda = False 
                    
                if not self.executed_lambda:
                    self._update_progress('Get accounts', '16%') 
                    self.not_error = self.get_accounts()
                    self.save_configs()
                    if self.not_error != True:
                        _end = self.end_sync()
                        if _end != True:
                            return _end
                    self._update_progress('Retrieving orders', '17%') 
                    self.not_error = self.get_tastyworks_orders()
                    self.save_configs()                    
                     
                    if self.not_error != True:
                        _end = self.end_sync(code=7)
                        if _end != True:
                            return _end
                        
                    self._update_progress('Saving data', '18%')
                    self.save_accounts(self.accounts)
                    self.account = self.account_list[0] if isinstance(self.account_list, list) and len(self.account_list) > 0 else ''                     
                    self.not_error  = self.save_params()
                    if len(self.all_orders) > 0:
                        self.save_files(file_type='json')
                    self._update_progress('Reading orders', '19%')
                    #start_time_t = tt.time() 
                    self.interpreter_orders()
                    #end_time_t = tt.time()
                    #print(f"Tiempo de ejecución usando interpret_orders: {end_time_t - start_time_t:.6f} segundos")  
                    self._update_progress('Save orders', '20%')
                    self.save_orders()
                     
                    if self.out['rows'] > 0:
                        rows = rows+self.out['rows']
                    if 'return_total' in self.out and self.out['return_total'] > 0:
                        return_total = return_total+self.out['return_total']
                    if 'ordens' in self.out and self.out['ordens'] > 0:
                        ordens = ordens+self.out['ordens']
                        
                    self.not_error  = self.save_params() 
           
            #TERMINA LA ITERACION
            return self.end_sync(event_id=new_event_id)

        except Exception as err:
            #UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
            self.unlock_portfolios()
            self._update_progress('warning', 'Imported Fail', True)
            return ErrorResponses.error_500(self.data, err, version)

    def validate(self):
        try: 
            self.new_sync = True
            self.data = request.json
            self.user.users_configs.not_warning_import = self.data.get('not_warning_import', True)
            self.user.users_configs.save()
            self.symbols = self.data.get('symbols', self.symbols)
            self.auto_import = self.data['auto_import'] if 'auto_import' in self.data else False
            if self.credential and (not 'add' in self.data or self.data['add'] == False):
                self.username = self.credential.username
                #self.account = self.credential.username
                self.password = self.credential.password
                self.test_account = self.credential.test_account
                self.passphrase = self.credential.passphrase
                self.access_token = self.credential.access_token
                self.new_sync = False
            else:
                #print('username', self.data['username'])    
                #print('password', self.data['password'])
                if self.data['username'] == '' or self.data['password'] == '':
                    return "Wrong credentials"
                account_check = BrokersConnections.find_by(**{'user_id':self.user.id, "username":self.data['username'].strip(), "password":self.data['password'].strip(), 
                                                         "active": True})
                
                self.username = self.data['username'].strip()
                self._2fa = self.data['2fa'].strip()
                self.password = self.data['password'].strip()
                self.test_account = self.data['test_account'] if 'test_account' in self.data and self.data['test_account']!=None else False
                self.passphrase = self.data.get('passphrase', None)
                
                if account_check:
                    return "account_is_already_connected"
            
            return True
        except Exception as err:
            #print('error validate')
            #print(traceback.print_exc())
            if not self.credential:
                #print(err)
                return "Wrong credentials"
            self.new_sync = False
            self.username = self.credential.username
            #self.account = self.credential.username
            self.password = self.credential.password
            self.test_account = self.credential.test_account
            self.passphrase = self.credential.passphrase
            self.access_token = self.credential.access_token
            self.user.users_configs.not_warning_import = True
            self.user.users_configs.save()
            self.data = None

    def login(self):
        try:
            #print('login',self.data)
            if self.access_token and self.new_sync == False and self.get_accounts()==True:
                return True
            else: 
                headers_login = {
                                    'Content-Type': 'application/json'
                                }
                if self._2fa:
                    headers_login  = {
                                        'Content-Type': 'application/json',
                                        'x-tastyworks-otp': self._2fa
                                    } 
                     
                tastyworks_login = {"login": self.username, "password": self.password}
                # The Login request to login and get the json response from tastyworks
                tasty_login = requests.post("https://api.tastyworks.com/sessions", headers=headers_login, params=tastyworks_login)
                json_response = tasty_login.json()
                #print('json_response', json_response)
                self.orders = json_response
                if 'error' in json_response:
                    if 'valid two factor code' in json_response['error']['message']:
                        self.extra_params_pusher['2fa'] = True
                        return 'Two Factor Authentication required. Please generate the code with your authenticator app and try again'
                    return json_response['error']['message']
                self.access_token = json_response['data']['session-token']
                self.headers = {'Authorization': f'{self.access_token}'}

                return True
        except Exception as err:
            return str(err)

    def get_accounts(self):
        self.headers = {'Authorization': f'{self.access_token}'}
        self.accounts = []
        try:
            tasty_url = f'https://api.tastyworks.com/customers/me/accounts'
            get_accounts = requests.get(tasty_url, headers=self.headers)
            json_response = get_accounts.json()
            #print('get_accounts', json_response)
            if 'error' in json_response:
                return json_response['error']['message']
            for account in  json_response['data']['items']:
                self.accounts.append(account['account']['account-number'])

            self.orders =  json_response
            self.all_orders =[self.orders]

            #self.save_files(file_type='json')

        except Exception:
            #print('error get accounts')
            #print(str(traceback.format_exc()))
            pass
        return True

    def get_tastyworks_orders(self):
        try:   
            #print('get_tastyworks_orders')
            self.orders = []
            self.all_orders = []
            today = date.today().strftime("%Y-%m-%d")
            tomorrow =  date.today() + timedelta(days=1)
            tomorrow_string = tomorrow.strftime("%Y-%m-%d")
             
            cash = 'ACCOUNT_Number'
            margin = 'Account_number'
            if 'account' in self.data and self.new_sync == False:
                #print('self.data["account"]', self.data['account'])
                accounts = [self.data['account']]
            else:
                accounts= self.accounts
                # accounts= ['5WW44652']
            length = len(accounts)
            i = 0
            while i < length:
                start_date = '2010-08-02'
                paginated = False
                if self.data['partial']: 
                    last_date = self.get_last_date_a(user_account = accounts[i],format='%Y-%m-%d')
                    if last_date != 0:
                        start_date = last_date
                        paginated = True
                    else:
                        start_date = '2010-08-02'
                        paginated = False
                                                     
                
                order_len = 2000
                # i = 0
                j = 0
                while order_len == 2000:
                    self._update_progress('Retrieving orders from '+start_date, '18%')
                    if paginated: # types[]={value1}&types[]={value2} type=Trade& type=Trade&
                        tasty_url= f"https://api.tastyworks.com/accounts/"+accounts[i]+"/transactions?start-date="+start_date+"&per-page=2000&page-offset="+str(j)
                    else:
                        tasty_url= f"https://api.tastyworks.com/accounts/"+accounts[i]+"/transactions?per-page=2000&page-offset="+str(j)
                    get_history = requests.get(tasty_url, headers=self.headers)
                    if get_history.status_code == 200:
                        history_in_json = get_history.json()
                        # print('get_tastyworks_orders', history_in_json)
                        self.orders.append(history_in_json['data']['items'])
                        self.pagination_info.append(history_in_json['pagination'])
                        # print(history_in_json['pagination'])
                        order_len = len(history_in_json['data']['items'])
                        j +=1
                    else:
                        order_len = 0
                i += 1
            self.orders=list(itertools.chain.from_iterable(self.orders))
            self.all_orders = self.orders

        except Exception:
            #print('error get orders')
            #print(str(traceback.format_exc()))
            pass
        return True

    def interpreter_orders(self):
        #print('interpreter_orders')
        i = 0
        b = 0
        new_date_time = []
        pip_value_order = dict()
        pip_value_order_btc = dict()
        verify_njson_len = 0
        date_format='mdy'
        expire = ''
        strike = ''
        option = 'SHARE'
        file_row_dict = []
        type = 'share'
        new_list = []     
        
        if self.orders and isinstance(self.orders[0], list):
            self.orders = [order for sublist in self.orders for order in sublist]    

        self.orders = list(sorted(self.orders, key=lambda i: (i['executed-at']), reverse=True))
        verify_njson_len = 0
                 
        for order in self.orders: 
            if i % 500 == 0 or i == 1 or i == len( self.orders):
                self._update_progress("Reading orders: {}/{}".format(i, len( self.orders)), '19%')
                
            check_json = json.dumps(order)
            check_json = hashlib.md5(check_json.encode('utf-8')).hexdigest()
            if check_json in new_list:
                continue
            new_list.append(check_json)
            updated_file_row = False
            if not 'symbol' in order or not 'price' in order:
                continue                                                                         
            if not 'TRADE' in order['transaction-type'].upper() and not 'RECEIVE_DELIVER' in order['transaction-type'].strip().replace(' ','_').upper() and not 'RECEIVE DELIVER' in order['transaction-type'].strip().replace(' ','_').upper():
                continue        
            i += 1
            original_file_row = json.loads(json.dumps(order))
            order['date'] = order['executed-at']
            date_tz = order['date']
            original_file_row['date_tz'] = order['date']
            if 'date' in order and order['date'] and self.params['timezone'] != 'do-not-convert':
                any_error, date_tz = ImportParams.convert_date_with_timezone(order['date'])
                if any_error:
                    return self.out_result, any_error
                if self.params['timezone'] != 'do-not-convert':
                    order['date'] = date_tz
                    self.params['timezone'] = 'America/New_York'


            n2 = json.loads(json.dumps(order))

            order['type'] = 'Equity Option'


            vn = json.dumps(order)
            if 'type' in order and 'transaction-sub-type' in order:
                vn = date_tz.strip() + order['type'].strip() + order['transaction-sub-type'].strip() + order['symbol'].strip() + order['description'].strip()
            njson = vn.upper()
            njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
            if file_row_dict and njson == file_row_dict[-1] and \
                self.params['get_session_userid'] in ['47132','242106','49127', '137705']:
                if date_tz:
                    try:
                        dt = parse(date_tz)
                        dt += datetime.timedelta(seconds=1)
                        date_tz = dt.strftime("%Y-%m-%dT%H:%M:%S.%f")[:-3] + "Z"
                        # dt = datetime.datetime.strptime(date_tz, "%Y-%m-%dT%H:%M:%S%z")
                        # dt += datetime.timedelta(seconds=1)
                        # date_tz = dt.strftime("%Y-%m-%dT%H:%M:%S%z")
                        original_file_row['date_tz'] = date_tz
                        order['date'] = date_tz
                    except Exception:
                        #print(traceback.format_exc())
                        pass
                    vn = json.dumps(order)
                    if 'type' in order and 'transaction-sub-type' in order:
                        vn = date_tz.strip() + order['type'].strip() + order['transaction-sub-type'].strip() + order['symbol'].strip() + order['description'].strip()
                    njson = vn.upper().replace(' ', '')
                    njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                    updated_file_row = True
            # guardar siempre al final
            file_row_dict.append(njson)
            order['orderby'] = b
            size_param = 1

            action = order['action'].strip().replace(' ','_').upper() if 'action' in order else \
                order['transaction-sub-type'].strip().replace(' ','_').upper() if 'transaction-sub-type' in order else ''
           
            order['action'] = 'BUY' if action == 'BUY_TO_OPEN' or action == 'BUY_TO_CLOSE' or action == 'BUY' else 'SELL' if action == 'SELL_TO_OPEN' \
                            or action  == 'SELL_TO_CLOSE' or action == 'SELL' else 'EXP' if 'description' in order and 'EXPIRATION' in order['description'].upper() \
                            else 'BUY' if 'description' in order and 'ASSIGNMENT' in order['description'].upper() else 'SELL' \
                            if 'description' in order and 'EXERCISE' in order['description'].upper() else ''
                        
            order['type'] = order['transaction code'].strip().replace('_',' ').upper() if 'transaction code' in order else order['instrument type'].strip().replace('_',' ').upper() if 'instrument type' in order else ''
            order['symbol'] = " ".join(order['symbol'].split())
            
            #order['symbol'] = order['symbol'].replace('.','').strip()
            
            if 'instrument-type' in order and 'Equity Option' in order['instrument-type'].title():
                type = 'option'
                extract = ' '.join(order['symbol'].split()).split(' ')
                order['symbol'] = extract[0]
                option = 'CALL' if 'C' in extract[1].upper() else 'PUT' if 'P' in extract[1].upper() else 'OPTION'
                extract = extract[1].replace('C','P').split('P')
                expire = extract[0]
                de = datetime.datetime.strptime(expire,"%y%m%d")
                expire = de.strftime('%d %b %y').upper()
                strike = extract[1]
                strike = float(strike)/ 1000
                strike = str(strike)
            elif 'instrument-type' in order and 'Future Option' in order['instrument-type'].title():
                type = 'option'
                extract = ' '.join(order['symbol'].split()).split(' ')
                
                #order['symbol'] = extract[0]
                order['symbol'] = order['underlying-symbol'] if 'underlying-symbol' in order else extract[0]
                if 'underlying-symbol' in order:
                    last_char = order['symbol'][-1]
                    if ImportParams.isfloat(last_char):
                        order['symbol'] = order['symbol'][:-2]
                
                params_future = ImportParams.getFutureSymbol(order['symbol'].replace('.','').replace('/',''))
                order['symbol'] = params_future['symbol'] if 'symbol' in params_future and params_future['symbol'] else order['symbol']
                size_param = params_future['size'] if 'size' in params_future else 100
                try:
                    if len(extract)==2:
                        option = 'CALL' if 'C' in extract[1].upper() else 'PUT' if 'P' in extract[1].upper() else 'OPTION'
                        extract = extract[1].replace('C','P').split('P')
                    else:  
                        option = 'CALL' if 'C' in extract[2].upper() else 'PUT' if 'P' in extract[2].upper() else 'OPTION'
                        extract = extract[2].replace('C','P').split('P')
                except:
                    continue
                expire = extract[0]
                de = datetime.datetime.strptime(expire,"%y%m%d")
                expire = de.strftime('%d %b %y').upper()
                strike = extract[1]
                strike = str(strike)

            elif 'instrument-type' in order and 'Future' in order['instrument-type'].title():
                type = 'future'
                option = 'FUTURE'
                params_future = ImportParams.getFutureSymbol(order['symbol'].replace('/',''))
                order['symbol'] = params_future['symbol'] if 'symbol' in params_future and params_future['symbol'] else order['symbol']
                expire = params_future['expire'] if 'expire' in params_future and params_future['expire'] else ''
                size_param = params_future['size'] if 'size' in params_future and params_future['size'] else ''
                strike = ''
            elif 'instrument-type' in order and 'Equity' in order['instrument-type'].title():
                type = 'share'
                option = 'SHARE'
                extract = ' '.join(order['symbol'].split()).split(' ')
                order['symbol'] = extract[0]
                expire = ''
                strike = ''
            elif 'instrument-type' in order and 'Cryptocurrency' in order['instrument-type'].title():
                type = 'crypto'
                option = 'CRYPTO'
                order['symbol'] = order['symbol'].replace('/', '')
                expire = ''
                strike = ''
                
            
            if ImportParams.isfloat(order['symbol']) or ImportParams.isfloat(order['symbol'][:4]) or order['action'] not in ['BUY', 'SELL','EXP','ASG']:
                continue
            if order['symbol'] == "SPXW":
                order['symbol'] = "SPX"
            any_error, date, time = ImportParams.get_param_datetime(order['date'],b)
            new_date_time = ImportParams.convert_date(date, time, date_format,_zone=self.params['timezone'])

            order['date'] = new_date_time[0]
            order['time'] = new_date_time[1]

            description = order['description']
            # des_p = description.split('@ ') if '@' in description else ''
            size = 100 if ('Put' in description or 'Call' in description) or ('call or put'in order and ('PUT' in order['call or put'].upper() or 'CALL' in order['call or put'].upper())) else 1
            quantity = float(order['quantity'].replace(',', ''))
            # order['price'] = des_p[1] if 'average price' in order and len(des_p) > 1 else str(value / quantity / size) if 'average price' in order else order['price'] if 'price' in order else '0'
            order['price'] = order['price'] if 'price' in order else '0'

            fp = str(order['price'].replace('-', '').replace(',', ''))
            decimal = fp[::-1].find('.')
            decimal = decimal if decimal > 1 else 2
            vfp = ImportParams.isfloat(fp)
            price = round(float(fp),decimal)
            #price = round(float(fp),6) if vfp else 0.00

            commission = order['commission'].replace(',', '').replace('-', '').replace('$', '') if 'commission' in order else ''
            commission = float(commission) if ImportParams.isfloat(commission) and commission else 0.00
            try:
                fees = float(order['regulatory-fees']) + float(order['clearing-fees']) + float(order['proprietary-index-option-fees'])
            except:
                fees = 0
                pass
            fees = float(fees) if ImportParams.isfloat(fees) and fees else 0.00
            #################### VERIFY FILE ROW ######################
            
            try:
                if njson in self.orders_filerow:
                    verify_njson_len = verify_njson_len + 1
                    continue
                
                if 'id' in original_file_row and original_file_row['id']:
                    order_id = original_file_row['id']
                    if order_id in self.orders_filerow:
                        #print('entro id',order_id)
                        verify_njson_len = verify_njson_len + 1
                        continue

                order_id = ''
                portfolio_ = self.params['user_portfolios'][order['account-number']]
                if 'id' in order and order['id']:
                    order_id = order['id']  
                              
                valid_file_row = ImportParams.validate_filerow(self.orders_filerow, 
                                                               njson=njson, 
                                                               order_id=order_id,
                                                               date_tz=original_file_row['date_tz'],
                                                               price=fp,
                                                               option=option,
                                                               action=order['action'],
                                                               quantity=quantity,
                                                               strike=strike,
                                                               expire=expire,
                                                               portfolio=portfolio_,
                                                               updated_file_row = updated_file_row
                                                              )
                if valid_file_row:
                    verify_njson_len = verify_njson_len + 1
                    continue
            except:
                pass
            
            ##########################################################            
            order['symbol'] = order['symbol'].replace('.','').strip()
            order['type_stock'] = type
            order['type_option'] = option
            order['price'] = price#fp
            order['shares'] = quantity
            order['comm'] = commission
            order['njson'] = njson
            order['decimal'] = decimal
            order['expire'] = expire
            order['strike'] = strike
            order['fees'] = fees
            order['size'] = size_param
            order['broker'] = self.params['broker']
            order['userid'] = self.params['get_session_userid']
            order['portfolio'] = self.params['user_portfolios'][order['account-number']]
            order['original_file_row'] = original_file_row
                          
            data_item = ImportParams.get_result_append(order)
            self.out_result.append(data_item)
            b = b - 1
        return True


    def save_orders(self):
        self.check_status_connection_db()
        import_broker = self.params['broker']
        try:
            regroup_value = [group['code'] for group in self.user.users_configs.trade_grouping if group['active'] == True][0]
        except:
            regroup_value = 'split'
        ################## AUTO SPREAD ####################
        try:
            self._update_progress('Auto Expires', '20%')
            get_spread = False
            if regroup_value == 'spread':
                get_spread = True
            if get_spread and current_user.users_configs.spread_detection:
                TempOrders.delete_all()
                self.out_result = TradeRegroups.insertTempOrders(self.out_result,user_id = self.user.id,is_sync=True)
        except:
            #print(traceback.format_exc())
            pass
        ###################################################

        error_mgs = "There was an error. Our support team will review the issue and get back to you"
        self._update_progress('Regrouping orders', '20%')
        self.user.users_configs.save()
        spread = False
        if regroup_value == 'split':
            output_group = TradeRegroups.regroup_trades_closed(self.out_result,import_broker,self.user.id)
        else:
            if regroup_value=='spread':
                spread = True
            output_group = TradeRegroups.regroup_trades(self.out_result, import_broker, self.user.id, spread=spread, user=self.user)
        if 'error' in output_group:
            self.out['mgs'] = error_mgs
            return self.out
        self.check_status_connection_db()
        self._update_progress('Save orders', '20%')
        any_error, rows, return_total, error_issue, executions, self.upload_id = TradeRegroups.save_to_database(output_group,import_broker, self.user.id, archive = self.filename_csv, upload_id = self.upload_id)
        #self.out_result = output_group
        """
            rows : total trades imported
            executions: total executions imported
        """ 
        self.rows = self.rows+rows
        self.executions = self.executions + executions
        self.out = {'any_error': any_error, 'rows': self.rows, 'ordens': self.executions,
                'return_total': return_total, 'error_issue': error_issue,
                'broker': import_broker, 'error_code': any_error}
        if any_error and any_error != 21:
            self.out['mgs'] = error_mgs
            return self.out
        else:
            if rows > 0:
                try:
                    self.user.fk_user_status_id = 1
                    self.user.save()
                except:
                    pass
                mgs = f'{str(self.rows)} Trades, {str(self.executions)} Executions'
            else:
                if self.last_date == 0 or self.last_date == None:
                    mgs = "No new trades found."
                else:
                    mgs = "No new trades to import"
        self.out['mgs'] = mgs
        self._update_progress('Save File', '20%')
        if len(self.all_orders) > 0:
            self.save_file(tmp_route = self.tmp_route_csv, archive = self.filename_csv ,data = self.all_orders, to = self.to_csv, f_type= 'transactions_csv', content_type = 'text/csv',  portfolio =self.portfolio,  executions=executions , trades=rows, fk_broker_id = self.broker.broker_id, broker = self.broker.broker_key)
        self._update_progress('Update Expires', '20%')
        UpdateTrade.update_subprocess_import(self.user.id, 'expired')
