import re
import hashlib
import json
import traceback

from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required
from dateutil.parser import parse

from .. import_params import ImportParams
from .. security_service import *
from .. logs import create_log
from .. responses import ErrorResponses, SuccessResponses
from .. portfolio.portfolios import *
from .. trade.trades_regroups import UpdateTrade

# Test trades
class BrokerTastyworks(Resource):
    ORDERS_FILEROW = []
    def getcsv(params, content, date_format='mdy'):
        data = "BrokerTastyworks 1"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0
        cont = False
        row_upload = False
        file_row_dict = list()
        try:
            if content:
                if 'Entry Price' in content:
                    return out_result, 9
                cont = True
            if '\t' in content:
                content = content.replace(',', '')
            if 'Trade Action' in content:
                return BrokerTastyworks.getcsv5(params, content, date_format='mdy')
            #content = re.sub(r'(?!(([^"]*"){2})*[^"]*$),', '', content)
            #content = content.replace(';', '').replace("\t",',').replace('\r\n\r\n','\r\n').replace('"2','2').replace(',"',',').replace('",',',')
            if 'P/L YTD' in content.upper():
                return out_result, 1203

            #content_b = content.split(",\n")
            if '""' in content:
                content = content.replace('""', '|').replace('"','').replace('|','"')
            content_b = content.splitlines()
            content_b = "\n".join(content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""

            if len(content_b) == 0 and cont:
                return out_result, 1202

            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                row = re.sub(r'(?!(([^"]*"){2})*[^"]*$),', '', row)
                row = row.replace('"','')

                rl = rl + 1
                if not 'TRADE' in row.upper() and not 'RECEIVE_DELIVER' in row.upper() and not 'RECEIVE DELIVER' in row.upper()  and rl > 1:
                    continue
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)

            if len(result_b) <= 1:
                return BrokerTastyworks.getcsv2(params,content)

            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            result_c = []
            b = len(result)
            r = 0

            account_code = ''
            code_not_found = True
            filename_csv =  params['filename_orig'] if 'filename_orig' in params else params['filename'] if 'filename' in params else ''
            if filename_csv and 'tastyworks_transactions_x' in filename_csv:
                extract_account = filename_csv.strip().split('tastyworks_transactions_x')
                account_code = extract_account[1].strip().split('_')[0]
                if extract_account[0] or not ImportParams.isfloat(account_code):
                    return out_result, 1204
                if account_code:
                    error, error_code, portfolio_id = ReferenceVerify.verify_code(
                                                    account_code,
                                                    params['get_session_userid'],
                                                    params['broker'],
                                                    params['user_portfolio'])
                    if error:
                        any_error = error_code
                        out_result = account_code
                        if error_code in [1011, 1014]:
                            out_result = portfolio_id
                        return out_result, any_error
                    if portfolio_id:
                        params['user_portfolio'] = portfolio_id
                code_not_found = False

                if code_not_found:
                    result_out, any_error = ReferenceVerify.validate_reference_code_format(
                        portfolio_id=params['user_portfolio']
                    )
                    if any_error:
                        return result_out, any_error
            verify_njson_len = 0
            orders_filerow = []
            try:
                orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                              var_sync='order-id',
                                                              var_file='order #',
                                                              broker=params['broker'])
                BrokerTastyworks.ORDERS_FILEROW = orders_filerow

            except:
                pass

            for a, n in enumerate(result):
                updated_file_row = False
                original_file_row = json.loads(json.dumps(n))
                n['date'] = n['date'] if 'date' in n else n['entered'] if 'entered' in n else ''
                date_tz = n['date']
                char_valid = False
                if 'T' in date_tz:
                    dh = date_tz.split('T')
                    char_valid = ImportParams.isChar(dh[1])
                original_file_row['date_tz'] = n['date']
                if ('date' in n and n['date'] and char_valid and params['timezone'] != 'do-not-convert'):
                    any_error, date_tz = ImportParams.convert_date_with_timezone(n['date'])
                    if any_error:
                        return out_result, any_error
                    if params['timezone'] != 'do-not-convert':
                        n['date'] = date_tz
                        params['timezone'] = 'America/New_York'

                n2 = json.loads(json.dumps(n))
                n['type'] = n['type'].strip().replace('_', ' ') if 'type' in n else ''
                if not n['type']:
                    continue

                action = n['action'].strip().upper() if 'action' in n else n['type'].upper()
                value = n['value'] if 'value' in n and ImportParams.isfloat(n['value']) else 0
                n['type'] = n['type'].strip().replace('_',' ').upper() if not 'contract exp date' in n else ''

                #####################
                n['action'] = 'BUY' if action == 'BUY_TO_OPEN' or action == 'BUY_TO_CLOSE' or action=='BUY' else 'SELL' \
                if action == 'SELL_TO_OPEN' or action  == 'SELL_TO_CLOSE' or action == 'SELL' else 'EXP' if 'description' in n and \
                'EXPIRATION' in n['description'].upper() else 'BUY' if 'description' in n and \
                'ASSIGNMENT' in n['description'].upper()  else 'SELL' if 'description' in n and \
                'EXERCISE' in n['description'].upper() else 'BUY' if 'description' in n and float(value) < 0 and \
                'CASH SETTLEMENT OF' in n['description'].upper() else 'SELL' if 'description' in n and float(value) > 0 and \
                'CASH SETTLEMENT OF' in n['description'].upper() else ''
                #####################

                n['instrument type'] = n['instrument type'] if 'instrument type' in n else ''
                n['symbol'] = n['symbol'].strip() if 'symbol' in n else n['underlying symbol'] if 'underlying symbol' in n else ''
                n['commissions'] = n['commissions'] if 'commissions' in n else n['commission'] if 'commission' in n else ''
                n['fees'] = n['fees'] if 'fees' in n else ''

                if ImportParams.isfloat(n['symbol']) or n['action'] not in ['BUY', 'SELL','EXP']:
                    continue

                vn = date_tz.strip() + n['type'].strip() + n['action'].strip() + n['symbol'].strip() + (n['description'].strip() if 'description' in n else n['price'])
                njson = vn.upper().replace(' ', '')
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                if file_row_dict and njson == file_row_dict[-1] and str(params['get_session_userid']) in ['47132','242106','49127', '137705']:
                    # sumar 1 segundo al date_tz / n['date']
                    if date_tz:
                        try:
                            # OJO: ajusta el formato al que realmente tengas
                            # Ejemplos: "%Y-%m-%d %H:%M:%S" o "%m/%d/%y %H:%M:%S"
                            # dt = parse(date_tz)
                            dt = datetime.strptime(date_tz, "%Y-%m-%dT%H:%M:%S%z")
                            dt += timedelta(seconds=1)
                            date_tz = dt.strftime("%Y-%m-%dT%H:%M:%S%z")
                            original_file_row['date_tz'] = date_tz
                            n['date'] = date_tz
                        except Exception:
                            print(traceback.format_exc())
                            pass

                        # recalcular hash con el nuevo date_tz
                        vn = date_tz.strip() + n['type'].strip() + n['action'].strip() + n['symbol'].strip() + (n['description'].strip() if 'description' in n else n['price'])
                        njson = vn.upper().replace(' ', '')
                        njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                        updated_file_row = True
                # guardar siempre al final
                file_row_dict.append(njson)
                ### issue 8136 ###
                #########################################################

                n['orderby'] = b

                if 'T' in n['date']:
                    d = n['date'].strip().split('T')
                    dd = d[0]
                    dt = d[1]

                    date = dd.split('-')
                    n['date'] = date[1]+'/'+date[2]+'/'+date[0]
                    time = dt.split('Z')[0].split('.')
                    n['time'] = time[0]
                    n['date'] = n['date']+' '+n['time']

                if 'time' in n:
                    if n['time'] and not ':' in n['date']:
                        n['date'] = n['date']+' '+n['time']
                    if not n['time']:
                        any_error = 21
                any_error, date, time = ImportParams.get_param_datetime(n['date'],b)
                new_date_time = ImportParams.convert_date(date, time, date_format,_zone=params['timezone'])

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                description = n['description'] if 'description' in n else ''
                # issue 11947
                if 'ASSIGNMENT' in description.upper() or 'EXERCISE' in description.upper():
                    row_index_a = next((index for (index, d) in enumerate(result) if d['symbol'].replace(' ','') == n['symbol'].replace(' ','') and 'Cash settlement' in d['description']), -1)
                    if row_index_a >= 0:
                        continue
                if 'Cash settlement' in n['description']:
                    cash_settlement = ImportParams.Tastyworks_cash_settlement(params['get_session_userid'],
                                                                              original_file_row,
                                                                              portfolio=params['user_portfolio']
                                                                              )
                    if cash_settlement:
                        update_trade = UpdateTrade.getTrade(cash_settlement)
                des_a = description.split(' ')
                des_p = description.split('@ ') if '@' in description else []

                size = 100 if n['instrument type'] in ['Equity Option', 'Future Option'] else 1

                quantity = float(n['quantity'].replace(',', ''))

                if 'value' in n:
                    value = float(n['value'].replace('-', '').replace(',', ''))
                    n['price'] = des_p[1].strip().split(' ')[0].replace('-', '').replace(',', '') if len(des_p) > 1 else (value / quantity / size) if 'OPTION' in n['instrument type'].upper() else n['average price']

                    if n['instrument type'].lower() == 'equity':
                        n['price'] = (value / quantity / size) if 'OPTION' in n['instrument type'].upper() \
                                  else n['average price']
                    try:
                        size = value / (float(n['price'])*quantity)
                    except:
                        pass

                fp = str(n['price']).replace('-','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00
                if price == 0 and n['action']=='RMV':
                    n['action'] = 'SELL'
                if price < 0 and n['action']=='RMV':
                    n['action'] = 'BUY'

                symbol_code = n['symbol'].replace(' ','')
                s = n['symbol'].split(' ')
                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                expire = ''
                n_spread = 'SINGLE'
                quantity = n['quantity'].replace('-', '').replace(',', '')
                if 'contract exp date' in n and n['contract exp date']:
                    de = n['contract exp date'].replace('-',' ')
                    expire = de.upper()
                    if not 'call or put' in n:
                        type = 'future'
                        option = 'FUTURE'

                strike = ''
                if sm > 4 and sm <= 8 and n['symbol'][:1]=='/':
                    type = 'future'
                    option = 'FUTURE'

                    future_params = ImportParams.getFutureSymbol(s[0].replace('/',''))
                    if future_params:
                        s[0] = future_params['symbol']
                        expire = future_params['expire']
                        expire = expire.upper().replace('-',' ')
                        n['size'] = future_params['size']

                elif sm > 8 or ('instrument type' in n and 'OPTION' in n['instrument type'].upper()):
                    n['size'] = size
                    try:
                        if n['instrument type'].upper() == 'FUTURE OPTION':
                            if 'amount' in n and ImportParams.isfloat(n['amount']):
                                if ImportParams.isfloat(quantity):
                                    amount = float(n['amount'])
                                    value = float(price) * quantity
                                    n['size'] = abs(round(amount / value, 2))
                            else:
                                future_params_symbol = ImportParams.getFutureSymbolOption(s[0].replace('/','')) if not 'underlying symbol' in n else ImportParams.getFutureSymbolOption(n['underlying symbol'].replace('/',''))
                                if 'size' in future_params_symbol and ImportParams.isfloat(future_params_symbol['size']):
                                    n['size'] = future_params_symbol['size']
                    except:
                        pass

                    multiplier = 0
                    if 'multiplier' in n and ImportParams.isfloat(n['multiplier']) and float(n['multiplier']) != n['size']:
                        if 'value' in n and ImportParams.isfloat(n['value']):
                            multiplier = abs(float(n['value']) / (float(fp) * float(quantity))) if (float(fp) * float(quantity)) > 0 else int(n['multiplier'])
                        if multiplier > 0:
                            n['multiplier'] = multiplier
                            n['size'] = multiplier
                    type = 'option'
                    option = 'CALL' if 'CALL' in n['call or put'] else 'PUT' if 'PUT' in n['call or put'] else 'OPTION'
                    expire = n['expiration date']
                    strike = n['strike price']
                    if expire:
                        ep = expire.split('/')
                        if len(ep[2])==2:
                            de = ImportParams.get_trade_datetime(expire,"%m/%d/%y")
                        else:
                            de = ImportParams.get_trade_datetime(expire,"%m/%d/%Y")

                        expire = de.strftime('%d %b %y').upper()

                        if result_c:
                            ##########################################
                            if n['type'].upper() == 'RECEIVE DELIVER':
                                row_index = next((index for (index, d) in enumerate(result_c) if d['symbol'].replace(' ','') == symbol_code and '@' in d['description']), -1)
                                if row_index >= 0:
                                    n['spread'] = result_c[row_index]['spread'] if 'spread' in result_c[row_index] else 'SINGLE'
                            ##########################################

                    if 'instrument type' in n and 'FUTURE' in n['instrument type'].upper():
                        symbol = n['underlying symbol'].replace('.','').replace('/','').strip() if 'underlying symbol' in n else s[0].replace('*','').replace('.','').replace('/','').strip()
                        future_params = ImportParams.getFutureSymbol(symbol)
                        s[0] = future_params['symbol']

                        if n['type'].upper() == 'RECEIVE DELIVER' and future_params['size'] != n['size'] and not '@' in n['description']:
                            fp = abs(float(n['value']) / (float(future_params['size']) * float(quantity)))
                            n['size'] = future_params['size']

                        #fp = str(float(fp)/float(future_params['size'])) if ImportParams.isfloat(future_params['size']) else fp


                elif '.' in n['symbol'] and sm > 6:
                    type = 'forex'
                    option = 'FOREX'

                if 'instrument type' in n and n['instrument type'].lower() == "cryptocurrency":
                    type = 'crypto'
                    option = 'CRYPTO'
                n['symbol'] = s[0].replace('*','').strip()

                commission = n['commissions'].replace(',', '').replace('-', '').replace('$', '')
                commission = float(commission) if ImportParams.isfloat(commission) and commission else 0.00
                fees = n['fees'].replace(',', '').replace('-', '').replace('$', '')
                fees = float(fees) if ImportParams.isfloat(fees) and fees else 0.00
                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = params['user_portfolio']
                    if 'order #' in n and n['order #'] and not updated_file_row:
                        order_id = n['order #']
                    valid_file_row = ImportParams.validate_filerow(orders_filerow,
                                                                   njson=njson,
                                                                   order_id=order_id,
                                                                   date_tz=original_file_row['date_tz'],
                                                                   price=fp,
                                                                   option=option,
                                                                   action=n['action'],
                                                                   quantity=quantity,
                                                                   strike=strike,
                                                                   expire=expire,
                                                                   portfolio=portfolio_,
                                                                   updated_file_row=updated_file_row
                                                                  )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################
                n['symbol'] = n['symbol'].replace('RUTW','RUT')
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['fees'] = fees

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                n['original_file_row'] = original_file_row

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b - 1

                # out_result.append(n)
        except Exception as err:
            print(traceback.format_exc())
            any_error = 9

        if len(out_result) > 0:
            return out_result, any_error
        else:
            if not any_error and not out_result and verify_njson_len:
                return out_result, any_error
            else:
                return BrokerTastyworks.getcsv2(params,content)

    def getcsv2(params, content, date_format='mdy'):
        data = "BrokerTastyworks2"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            content = content.replace(';', '').replace("\t",',').replace('\r\n\r\n','\r\n')
            content_b = content.splitlines()
            content_b = "\n".join(content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""

            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                row = re.sub(r'(?!(([^"]*"){2})*[^"]*$),', '', row)
                row = row.replace('"','')
                rl = rl + 1
                if not 'TRADE' in row.upper() and not 'RECEIVE_DELIVER' in row.upper() and not 'RECEIVE DELIVER' in row.upper() and rl > 1:
                    continue

                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)

                result_b.append(row)
            if len(result_b) <= 1:
                return BrokerTastyworks.getcsv3(params,content)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)

            verify_njson_len = 0
            if not BrokerTastyworks.ORDERS_FILEROW:
                orders_filerow = []
                try:
                    orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                                  var_sync='order-id',
                                                                  var_file='order #',
                                                                  broker=params['broker'])
                    BrokerTastyworks.ORDERS_FILEROW = orders_filerow

                except:
                    pass
            else:
                orders_filerow = BrokerTastyworks.ORDERS_FILEROW

            b = len(result)
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                n['date'] = n['date/time'] if 'date/time' in n else n['date'] if 'date' in n else ''
                date_tz = n['date']
                original_file_row['date_tz'] = n['date']
                if 'date' in n and n['date'] and params['timezone'] != 'do-not-convert':
                    any_error, date_tz = ImportParams.convert_date_with_timezone(n['date'])
                    if any_error:
                        return out_result, any_error
                    if params['timezone'] != 'do-not-convert':
                        n['date'] = date_tz
                        params['timezone'] = 'America/New_York'


                n2 = json.loads(json.dumps(n))

                n['type'] = 'Equity Option'


                vn = json.dumps(n)
                if 'type' in n and 'transaction subcode' in n:
                    vn = date_tz.strip() + n['type'].strip() + n['transaction subcode'].strip() + n['symbol'].strip() + n['description'].strip()
                njson = vn.upper()
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()


                n['orderby'] = b

                action = n['transaction subcode'].strip().replace(' ','_').upper() if 'transaction subcode' in n else n['action'] if 'action' in n else ''
                n['type'] = n['transaction code'].strip().replace('_',' ').upper() if 'transaction code' in n else n['instrument type'].strip().replace('_',' ').upper() if 'instrument type' in n else ''
                n['action'] = 'BUY' if action == 'BUY_TO_OPEN' or action == 'BUY_TO_CLOSE' or action == 'BUY' else 'SELL' if action == 'SELL_TO_OPEN' \
                              or action  == 'SELL_TO_CLOSE' or action == 'SELL' else 'EXP' if 'description' in n and 'EXPIRATION' in n['description'].upper() \
                              else 'BUY' if 'description' in n and 'ASSIGNMENT' in n['description'].upper() else 'SELL' \
                              if 'description' in n and 'EXERCISE' in n['description'].upper() else ''
                n['symbol'] = " ".join(n['symbol'].split())
                n['symbol'] = n['symbol'].replace('.','').strip()

                if ImportParams.isfloat(n['symbol']) or ImportParams.isfloat(n['symbol'][:4]) or n['action'] not in ['BUY', 'SELL','EXP','ASG']:
                    continue

                any_error, date, time = ImportParams.get_param_datetime(n['date'],b)
                new_date_time = ImportParams.convert_date(date, time, date_format,_zone=params['timezone'])

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                description = n['description']
                des_a = description.split(' ')
                des_p = description.split('@ ') if '@' in description else ''
                des_s = description.split(n['symbol']+' ') if n['symbol'] in description else ''
                size = 100 if ('Put' in description or 'Call' in description) or ('call or put'in n and ('PUT' in n['call or put'].upper() or 'CALL' in n['call or put'].upper())) else 1
                #Value	Quantity	Average Price
                quantity = float(n['quantity'].replace(',', ''))
                value = float(n['value'].replace('-', '').replace(',', '')) if 'value' in n else 0
                n['price'] = des_p[1] if 'average price' in n and len(des_p) > 1 else str(value / quantity / size) if 'average price' in n else n['price'] if 'price' in n else '0'

                ds = des_s[1].split(' ') if des_s else ''

                symbol = n['symbol']+' '+ds[0]+ds[1]+ds[2] if 'call/put' in n and n['call/put']  and len(ds) > 2 else n['symbol']
                #value = float(n['value'].replace('-', '').replace(',', ''))
                #n['price'] = (value / quantity / size)

                fp = str(n['price'].replace('-', '').replace(',', ''))
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00

                s = n['symbol'].split(' ')
                sm = len(symbol)
                type = 'share'
                option = 'SHARE'
                expire = ''
                strike = ''
                symb_fut = ''
                quantity = int(float(n['quantity'].replace('-', '').replace(',', '')))
                if sm > 4 and sm < 8 and n['symbol'][:1]=='/':
                    type = 'future'
                    option = 'FUTURE'
                    params_future = ImportParams.getFutureSymbol(n['symbol'].replace('/',''))
                    symb_fut = params_future['symbol'] if 'symbol' in params_future and params_future['symbol'] else n['symbol']
                    expire = params_future['expire'] if 'expire' in params_future and params_future['expire'] else ''
                    n['size'] = params_future['size'] if 'size' in params_future and params_future['size'] else ''

                elif sm >= 8 or n['symbol'][:1]=='/':
                    #TSLA  181116C00290000
                    type = 'option'
                    #n['size'] = 100
                    n['size'] = 100
                    if 'amount' in n and ImportParams.isfloat(n['amount']) and float(n['amount']) > 0:
                        amount = float(n['amount'])
                        value = float(price) * quantity
                        n['size'] = abs(round(amount / value, 2))

                    else:
                        future_params_symbol = ImportParams.getFutureSymbolOption(s[0].replace('/',''))
                        if 'size' in future_params_symbol and ImportParams.isfloat(future_params_symbol['size']):
                            n['size'] = future_params_symbol['size']
                    multiplier = 0
                    if 'multiplier' in n and ImportParams.isfloat(n['multiplier']) and float(n['multiplier']) != n['size']:
                        if 'value' in n and ImportParams.isfloat(n['value']):
                            multiplier = abs(float(n['value']) / float(fp) / float(quantity))
                        if multiplier > 0:
                            n['multiplier'] = multiplier
                            n['size'] = multiplier

                    if 'call/put' in n:
                        option = 'CALL' if 'C' in n['call/put'] else 'PUT' if 'P' in n['call/put'] else 'OPTION'
                    elif 'call or put' in n:
                        option = 'CALL' if 'CALL' in n['call or put'].upper() else 'PUT' if 'PUT' in n['call or put'].upper() else 'OPTION'
                    elif 'description' in n:
                        option = 'CALL' if 'CALL' in n['description'].upper() else 'PUT' if 'PUT' in n['description'].upper() else 'OPTION'
                    else:
                        if ' ' in symbol:
                            option = 'CALL' if 'C' in symbol.split(' ')[1] else 'PUT' if 'P' in symbol.split(' ')[1] else 'OPTION'
                        else:
                            option = 'OPTION'

                    if 'underlying symbol' in n:
                        #Underlying Symbol	Expiration Date	Strike Price	Call or Put
                        ds = n['description'].split(' ')

                        desc = des_p[0] if len(des_p) > 1 else n['description']
                        match_exp = re.search(r'\d{2}/\d{2}/\d{2}',desc)
                        expire = match_exp.group() if match_exp else n['expiration date'] if 'expiration date' in n else ''

                        match_str = re.search(r'\d+\.\d{2}', desc.replace('$','').replace(',',''))
                        strike = match_str.group() if match_str else n['strike price'] if 'strike price' in n else n['strike'] if 'strike' in n else ''

                        n['symbol'] = n['underlying symbol'] if 'underlying symbol' in n else n['symbol']

                    if '/' in n['symbol']:
                        getfurure = ImportParams.getFutureSymbolOption(n['symbol'].replace('/',''))
                        symb_fut = getfurure['symbol']
                        expire = getfurure['expire'] if 'expire' in getfurure and getfurure['expire'] else ''
                    else:
                        expire = n['expiration date'] if 'expiration date' in n else ds[0]
                    strike = n['strike'] if 'strike' in n else ds[2]
                    if expire:
                        #ep = expire.split('/') if '/' in expire else expire.split('-')
                        de = parse(expire)
                        """if len(ep[2])==2:
                            de = ImportParams.get_trade_datetime(expire,"%m/%d/%y" if '/' in expire else "%m-%d-%y")
                        else:
                            de = ImportParams.get_trade_datetime(expire,"%m/%d/%Y" if '/' in expire else "%m-%d-%Y")"""
                        expire = de.strftime('%d %b %y').upper()
                elif '/' in n['symbol']:
                    type = 'crypto'
                    option = 'CRYPTO'
                    quantity = n['quantity'].replace('-', '').replace(',', '')
                elif '.' in n['symbol'] and sm > 6:
                    type = 'forex'
                    option = 'FOREX'
                n['symbol'] = s[0].replace('*','').strip() if not symb_fut else symb_fut

                #commission = n['commissions'].replace(',', '').replace('-', '').replace('$', '')
                commission = n['commissions'].replace(',', '').replace('-', '').replace('$', '') if 'commissions' in n else ''
                commission = float(commission) if ImportParams.isfloat(commission) and commission else 0.00

                fees = n['fees'].replace(',', '').replace('-', '').replace('$', '')
                fees = float(fees) if ImportParams.isfloat(fees) and fees else 0.00

                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = params['user_portfolio']
                    if 'order #' in n and n['order #']:
                        order_id = n['order #']
                    valid_file_row = ImportParams.validate_filerow(orders_filerow,
                                                                   njson=njson,
                                                                   order_id=order_id,
                                                                   date_tz=original_file_row['date_tz'],
                                                                   price=fp,
                                                                   option=option,
                                                                   action=n['action'],
                                                                   quantity=quantity,
                                                                   strike=strike,
                                                                   expire=expire,
                                                                   portfolio=portfolio_
                                                                  )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['fees'] = fees

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                n['original_file_row'] = original_file_row

                data_item = ImportParams.get_result_append(n)

                out_result.append(data_item)
                b = b - 1

                # out_result.append(n)
        except Exception as err:
            any_error = 9

        if len(out_result) > 0:
            return out_result, any_error
        else:
            if not any_error and not out_result and verify_njson_len:
                return out_result, any_error
            else:
                return BrokerTastyworks.getcsv3(params,content)



    def getcsv3(params, content, date_format='mdy'):
        data = "BrokerTastyworks3"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            content = content.replace(';', '').replace("\t",',').replace('"','').replace('\r\n\r\n','\r\n')
            content_b = content.splitlines()
            content_b = "\n".join(content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""

            if len(content_b) == 1:
                return out_result, 1202

            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                rl = rl + 1
                row = row.replace("\r", "")
                rs = row.split(',')

                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)

                    result_b.append(row)

                if len(rs) > 1 and rs[2].upper() == 'FILLED':
                    result_b.append(row)

            if len(result_b) == 1:
                #return out_result, 1202
                return BrokerTastyworks.getcsv4(params,content)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            verify_njson_len = 0
            try:
                if not BrokerTastyworks.ORDERS_FILEROW:
                    orders_filerow = []
                    try:
                        orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                                      var_sync='order-id',
                                                                      var_file='order #',
                                                                      broker=params['broker'])
                        BrokerTastyworks.ORDERS_FILEROW = orders_filerow

                    except:
                        pass
                else:
                    orders_filerow = BrokerTastyworks.ORDERS_FILEROW
            except:
                pass

            b = len(result)
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                n['date'] = n['time received'] if 'time received' in n else ''
                date_tz = n['date']
                original_file_row['date_tz'] = n['date']
                if 'date' in n and n['date']:
                    any_error, date_tz = ImportParams.convert_date_with_timezone(n['date'])
                    if any_error:
                        return out_result, any_error
                    if params['timezone'] != 'do-not-convert':
                        n['date'] = date_tz
                        params['timezone'] = 'America/New_York'

                n2 = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()


                action = n['buy/sell'].strip().replace(' ','_').upper()
                n['symbol'] = n['symbol'].strip()

                n['action'] = 'BUY' if action == 'BUY' else 'SELL' if action == 'SELL' else ''
                if 'status' in n and n['status'].upper() == "FILLED" and not n['symbol']:
                    n['symbol'] = result[a-1]['symbol']
                if ImportParams.isfloat(n['symbol']) or ImportParams.isfloat(n['symbol'][:4]) or n['action'] not in ['BUY', 'SELL'] or 'status' in n and n['status'].upper() != "FILLED":
                    continue

                any_error, date, time = ImportParams.get_param_datetime(n['date'],b)
                new_date_time = ImportParams.convert_date(date, time, date_format,_zone=params['timezone'])

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]


                fp = str(n['average fill price']).replace('-','').replace(',','') if 'average fill price' in n and n['average fill price'].upper() != "NAN" else str(n['limit price'])
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00

                s = n['symbol'].split(' ')
                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                expire = ''
                strike = ''
                if sm > 4 and sm < 8 and n['symbol'][:1]=='/':
                    type = 'future'
                    option = 'FUTURE'
                elif sm >= 8 or 'CALL' in n['security description'].upper() or 'PUT' in n['security description'].upper():
                    type = 'option'
                    option = 'CALL' if 'CALL' in n['security description'].upper() else 'PUT' if 'PUT' in n['security description'].upper() else 'OPTION'
                    ds = n['security description'].split(' ')
                    expire = ds[1]+' '+ds[0]+' '+ds[2][2:]
                    strike = ds[3]

                elif '.' in n['symbol'] and sm > 6:
                    type = 'forex'
                    option = 'FOREX'

                quantity = float(n['quantity'].replace('-', '').replace(',', ''))
                #commission = n['commissions'].replace(',', '').replace('-', '').replace('$', '')
                commission = n['commissions'].replace(',', '').replace('-', '').replace('$', '') if 'commissions' in n else ''
                commission = float(commission) if ImportParams.isfloat(commission) and commission else 0.00
                fees = n['fee'].replace(',', '').replace('-', '').replace('$', '') if 'fee' in n else n['fees'].replace(',', '').replace('-', '').replace('$', '') if 'fees' in n else ''
                fees = float(fees) if ImportParams.isfloat(fees) and fees else 0.00
                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = params['user_portfolio']
                    if 'order #' in n and n['order #']:
                        order_id = n['order #']
                    valid_file_row = ImportParams.validate_filerow(orders_filerow,
                                                                   njson=njson,
                                                                   order_id=order_id,
                                                                   date_tz=original_file_row['date_tz'],
                                                                   price=fp,
                                                                   option=option,
                                                                   action=n['action'],
                                                                   quantity=quantity,
                                                                   strike=strike,
                                                                   expire=expire,
                                                                   portfolio=portfolio_
                                                                  )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################

                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['fees'] = fees

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                n['original_file_row'] = original_file_row

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b - 1

                # out_result.append(n)

        except Exception as err:
            any_error = 12
            if not 'ACTION' in content.upper() and 'P/L YTD' in content.upper():
                any_error = 1201

        #any_error = 1
        if not 'ACTION' in content.upper() and 'P/L YTD' in content.upper():
            any_error = 1201

        if not any_error and not out_result and verify_njson_len:
            return out_result, any_error
        if not any_error and not out_result:
            any_error=12

        return out_result, any_error


    def getcsv4(params, content, date_format='mdy'):
        data = "BrokerTastyworks4"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0
        try:
            content = content.replace(';', '').replace("\t",',').replace('"','').replace('\r\n\r\n','\r\n')
            content_b = content.splitlines()
            content_b = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""

            if len(content_b) == 1:
                return out_result, 1202
            nl = 0
            rl = 0
            ath = False

            for row in content_b:
                row = re.sub(r'(?!(([^"]*"){2})*[^"]*$),', '', row)
                row = row.replace('"','')
                rl = rl + 1

                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
                result_b.append(row)

            if len(result_b) == 1:
                return out_result, 1202
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            b = len(result)
            verify_njson_len = 0
            if not BrokerTastyworks.ORDERS_FILEROW:
                orders_filerow = []
                try:
                    orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                                  var_sync='order-id',
                                                                  var_file='order #',
                                                                  broker=params['broker'])
                    BrokerTastyworks.ORDERS_FILEROW = orders_filerow

                except:
                    pass
            else:
                orders_filerow = BrokerTastyworks.ORDERS_FILEROW

            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                n2 = json.loads(json.dumps(n))
                njson = json.dumps(n) if not 'transaction id' in n or ('transaction id' in n and not n['transaction id']) else n['transaction id']
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                if not 'description' in n or ('description' in n and not '@' in n['description']) or ('transaction code' in n and n['transaction code'].lower() != "trade"):
                    continue
                # Sold 100 ENIA @ 7.31
                # Bought 1 SPY 09/18/20 Call 270.00 @ 23.59
                desc = n['description'].split(' @ ')
                desc_a = desc[0].split(' ')
                desc_b = desc[1].split(' ')
                ##############################
                action = desc_a[0].strip().upper()
                n['symbol'] = desc_a[2].strip().upper()
                n['quantity'] = desc_a[1].strip()
                n['expire'] = desc_a[3].strip() if 'CALL' in n['description'].upper() or 'PUT' in n['description'].upper() else ''
                n['type'] = desc_a[4].strip().upper() if 'CALL' in n['description'].upper() or 'PUT' in n['description'].upper() else 'SHARE'
                n['strike'] = desc_a[5].strip().upper() if 'CALL' in n['description'].upper() or 'PUT' in n['description'].upper() else ''
                n['price'] = desc_b[0].strip()
                n['date'] = n['time'] if 'time' in n else n['date/time'] if 'date/time' in n else ''
                n['action'] = 'BUY' if action == 'BOUGHT' else 'SELL' if action == 'SOLD' else action

                if ImportParams.isfloat(n['symbol']) or ImportParams.isfloat(n['symbol'][:4]) or n['action'] not in ['BUY', 'SELL']:
                    continue
                ###########################

                datetime = n['date']
                original_file_row['date_tz'] = n['date']
                any_error, date, time = ImportParams.get_param_datetime(datetime.strip(),b)
                new_date_time = ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                ############################

                fp = n['price'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00
                #############################
                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                expire = ''
                strike = ''
                if n['type'] == 'CALL' or n['type'] == 'PUT':
                    type = 'option'
                    option = n['type']
                    expire = n['expire']
                    de = ImportParams.parse_date(expire)
                    expire = de.strftime('%d %b %y').upper()
                    strike = n['strike'].replace(',','').replace('$','')
                #############################
                quantity = float(n['quantity'].replace(',', '').replace('-', ''))
                commission = n['commission'].replace(',', '').replace('-', '').replace('$', '') if 'commission' in n else ''
                commission = float(commission) if ImportParams.isfloat(commission) and commission else 0.00
                fees = n['fee'].replace(',', '').replace('-', '').replace('$', '') if 'fee' in n else ''
                fees = float(fees) if ImportParams.isfloat(fees) and fees else 0.00
                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = params['user_portfolio']
                    if 'order #' in n and n['order #']:
                        order_id = n['order #']
                    valid_file_row = ImportParams.validate_filerow(orders_filerow,
                                                                   njson=njson,
                                                                   order_id=order_id,
                                                                   date_tz=original_file_row['date_tz'],
                                                                   price=fp,
                                                                   option=option,
                                                                   action=n['action'],
                                                                   quantity=quantity,
                                                                   strike=strike,
                                                                   expire=expire,
                                                                   portfolio=portfolio_
                                                                  )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = fees
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                n['original_file_row'] = original_file_row

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b + 1

        except Exception as err:
            any_error = 9
        if not any_error and not out_result and verify_njson_len:
            return out_result, any_error
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error

    def getcsv5(params, content, date_format='mdy'):
        data = "BrokerTastyworks5"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:

            content = content.replace(';', '')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False

            for row in content_b:
                if len(row) == 0:
                    continue
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)

            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            verify_njson_len = 0
            orders_filerow = []
            if not BrokerTastyworks.ORDERS_FILEROW:
                try:
                    orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                                  var_sync='order-id',
                                                                  var_file='order #',
                                                                  broker=params['broker'])
                    BrokerTastyworks.ORDERS_FILEROW = orders_filerow

                except:
                    pass
            else:
                orders_filerow = BrokerTastyworks.ORDERS_FILEROW

            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                n2 = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                action = n['trade action'].upper() if 'trade action' in n else n['side'].upper() if 'side' in n else ''
                action = 'BUY' if action == 'BUY' or action=='BUY_TO_OPEN' or action=='B' or action=='BUY_TO_ClOSE' else 'SELL' if action == 'SELL' or action == 'SELL_TO_OPEN' or action=='S' or action=='SELL_TO_ClOSE' else ''
                symbol = n['symbol'].strip() if 'symbol' in n else ''
                n['symbol'] = (' '.join(symbol.split())).strip()
                if 'timestamp' in n:
                    date = str(n['timestamp']).split('T')
                    n['date'] = date[0]
                    n['time'] = date[1]
                if not n['symbol'] or not n['date'] or not n['price'] or not action or ('type' in n and  n['type'].upper() != "TRADES") or ('account' in n and  n['account'].upper() == "FUTURES"):
                    continue
                pip_value = 0
                date_split = n['date'].strip()
                d = date_split
                t = n['time'][:8] if 'time' in n else ''
                t2 = n['time'] if 'time' in n else ''
                date_time = (d+' '+t).strip()
                original_file_row['date_tz'] = (d+' '+t2).strip()
                any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                new_date_time = ImportParams.convert_date(date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                fp = n['price'].replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp),decimal)
                #price = round(float(n['price'].replace(',', '')),6)
                if not 'type' in n:
                    n['type'] = 'SHARE'

                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = ''
                smn = n['symbol'][-2:]

                if " " in n['symbol']:
                    extract = n['symbol'].split(" ")
                    n['symbol'] = extract[0]
                    option = 'CALL' if 'C' in extract[1].upper() else 'PUT' if 'P' in extract[1].upper() else 'OPTION'
                    type = 'option'
                    expire = extract[1][:-1]
                    try:
                        de = parse(expire)
                        expire = de.strftime('%d %b %y').upper()
                    except:
                        expire = expire
                    strike = extract[2]

                fee = n['fee'].replace(',', '').replace('$','') if 'fee' in n else n['fees'].replace(',', '').replace('$','') if 'fees' in n else ''
                fee = round(float(fee),2) if fee else 0.00
                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = params['user_portfolio']
                    if 'order #' in n and n['order #']:
                        order_id = n['order #']
                    valid_file_row = ImportParams.validate_filerow(orders_filerow,
                                                                   njson=njson,
                                                                   order_id=order_id,
                                                                   date_tz=original_file_row['date_tz'],
                                                                   price=fp,
                                                                   option=option,
                                                                   action=action,
                                                                   quantity=n['qty'].replace(',', '').replace('-', ''),
                                                                   strike=strike,
                                                                   expire=expire,
                                                                   portfolio=portfolio_
                                                                  )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################
                n['trade_notes'] = n['trade_notes'] if 'trade_notes' in n else ''
                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = fp
                n['shares'] = n['qty'].replace(',', '').replace('-', '')
                n['comm'] = n['commissions'].replace(',', '').replace('$','') if 'commissions' in n else '0.00'
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['pip_value'] = pip_value
                n['fees'] = fee
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                n['original_file_row'] = original_file_row

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            any_error = 9
        if not any_error and not out_result and verify_njson_len:
            return out_result, any_error
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error
