"""
Tastyworks-specific lookup tables and constants.

This module contains lookup tables and constants used for Tastyworks broker
data normalization, including symbol replacements, future option sizes, and
legacy compatibility mappings.
"""

# Symbol replacements for legacy compatibility
# Maps incorrect/old symbols to correct symbols
SYMBOL_REPLACEMENTS = {
    "RUTW": "RUT",  # Russell 2000 Index
    # Add more symbol mappings as discovered
}

# Future option contract sizes (multipliers)
# Different from standard equity options (100) and equity (1)
# Source: Legacy brokers_tastyworks.py lines 295-305
FUTURE_OPTION_SIZES = {
    # E-mini Indices
    "/ES": 50,      # E-mini S&P 500
    "/NQ": 20,      # E-mini NASDAQ-100
    "/YM": 5,       # E-mini Dow ($5 × Dow Jones)
    "/RTY": 50,     # E-mini Russell 2000

    # Commodities
    "/CL": 1000,    # Crude Oil (1000 barrels)
    "/GC": 100,     # Gold (100 troy oz)
    "/SI": 5000,    # Silver (5000 troy oz)
    "/NG": 10000,   # Natural Gas (10,000 mmBtu)

    # Agriculture
    "/ZC": 50,      # Corn (50 bushels)
    "/ZS": 50,      # Soybeans (50 bushels)
    "/ZW": 50,      # Wheat (50 bushels)

    # Currencies
    "/6E": 125000,  # Euro FX (125,000 EUR)
    "/6J": 12500000, # Japanese Yen (12,500,000 JPY)
    "/6B": 62500,   # British Pound (62,500 GBP)

    # Bonds
    "/ZN": 1000,    # 10-Year T-Note ($1000 × price)
    "/ZB": 1000,    # 30-Year T-Bond ($1000 × price)

    # Add more future symbols as needed
    # Default fallback: 100 (will be used if symbol not in this dict)
}

# User-specific edge cases (legacy compatibility)
# These users had a specific issue with duplicate timestamps in legacy system
# Legacy location: brokers_tastyworks.py lines 170-195
# Issue: Consecutive trades with identical timestamps needed +1 second adjustment
# Status: May not be needed in new architecture (p02_deduplicate handles this better)
DUPLICATE_OFFSET_USERS = {
    47132,   # User with historical duplicate timestamp issue
    242106,  # User with historical duplicate timestamp issue
    49127,   # User with historical duplicate timestamp issue
    137705,  # User with historical duplicate timestamp issue
}

# Note: Before implementing DUPLICATE_OFFSET_USERS logic, verify these users
# are still active in production. If inactive, this workaround can be omitted.
# Query: SELECT id, email, active FROM users WHERE id IN (47132, 242106, 49127, 137705);
