"""Tastyworks format detector."""

import polars as pl


def can_handle_tastyworks(df: pl.DataFrame, metadata: dict = None) -> bool:
    """
    Check if data is from Tastyworks.

    Tastyworks JSON has specific fields in the orders array:
    - exec-id
    - transaction-type
    - instrument-type
    - account-number
    """
    required_cols = {"exec-id", "transaction-type", "account-number"}
    return required_cols.issubset(set(df.columns))
