# Análisis de Validaciones Críticas Faltantes - Tastyworks Broker

## Resumen Ejecutivo

Este documento resume el análisis comparativo exhaustivo entre el código legacy de Tastyworks (1,833 líneas) y la nueva implementación (446 líneas), identificando **10 validaciones críticas** que faltan en el nuevo sistema.

### Hallazgos Principales

| Métrica | Legacy | Nuevo | Diferencia |
|---------|--------|-------|------------|
| **Líneas de Código** | 1,833 | 446 | -76% ✅ |
| **Formatos Soportados** | 5 CSV variants | 1 JSON API | Simplificado ✅ |
| **Validaciones Implementadas** | 18+ | 8 | -10 validaciones ❌ |
| **Arquitectura** | Monolítica | Modular | Mejor mantenibilidad ✅ |
| **Separación de Responsabilidades** | Baja | Alta | Mejor diseño ✅ |

### Validaciones Identificadas por Criticidad

#### 🔴 CRÍTICAS (3 validaciones - Fase 1)
1. **Validación de Símbolos Numéricos** - Rechaza símbolos inválidos + reemplazo RUTW→RUT
2. **Inferencia de Acción desde Descripción** - Detecta EXP/ASSIGNMENT/EXERCISE de descripción
3. **Filtrado de Assignment/Exercise Duplicados** - Previene duplicados con cash settlements

#### 🟡 MEDIA PRIORIDAD (3 validaciones - Fase 2)
4. **Normalización de Precio** - Precisión 6 decimales, manejo de valores inválidos
5. **Detección de Cash Settlement** - Flag para procesamiento downstream
6. **Cálculo de Tamaño para Future Options** - Multiplicadores variables por símbolo

#### ⚠️ CONDICIONALES (2 validaciones - Fase 3)
7. **Verificación de Código de Cuenta** - Solo si se soportan CSV uploads
9. **Manejo Especial de Usuarios** - Solo si usuarios 47132, 242106, 49127, 137705 están activos

#### ✅ YA MANEJADAS (2 validaciones)
8. **Validación de File Row vs DB** - Implementado en p02_deduplicate
10. **Validación de Contenido Vacío** - Ya manejado con logging

---

## Impacto Estimado

### Por Validación

| # | Validación | Impacto si Falta | Criticidad |
|---|------------|------------------|------------|
| 1 | Símbolos Numéricos | Trades con símbolos inválidos, errores en matching | 🔴 ALTA |
| 2 | Acción desde Descripción | P&L incorrecto para eventos de opciones | 🔴 ALTA |
| 3 | Assignment/Exercise Filter | Trades duplicados, posiciones incorrectas | 🔴 ALTA |
| 4 | Precio Normalización | Pérdida de precisión en display | 🟡 MEDIA |
| 5 | Cash Settlement | P&L incorrecto para opciones cash-settled | 🟡 MEDIA-ALTA |
| 6 | Future Option Size | Posiciones erróneas para futuros | 🟡 MEDIA |
| 7 | Account Verification | Riesgo de importar a portfolio incorrecto | ⚠️ CONDICIONAL |
| 9 | Usuarios Especiales | Duplicados no resueltos para 4 usuarios legacy | 🔵 BAJA |

### Métricas de Éxito Esperadas

**Antes de Implementación:**
- Match rate vs legacy: ~85-90% (baseline actual)
- Símbolos numéricos en DB: Posible
- Eventos de opciones mal clasificados: Posible
- Duplicados assignment/exercise: Posible

**Después de Fase 1:**
- Match rate vs legacy: ≥90% (sin regresión)
- Símbolos numéricos en DB: 0% ✅
- Eventos de opciones correctamente clasificados: 100% ✅
- Duplicados assignment/exercise: 0% ✅

**Después de Fase 2:**
- Match rate vs legacy: ~92-95%
- Precisión de precios: 6 decimales consistente ✅
- Cash settlements detectados: 100% ✅
- Future options sized: Correcto ✅

**Después de Fase 3:**
- Match rate vs legacy: ≥95%
- Account security: Validado ✅
- Cash settlements procesados: Correcto ✅

---

## Plan de Implementación

### Fase 1: Validaciones Críticas (Semana 1)
**Objetivo:** Prevenir datos inválidos en el pipeline
**Archivos:** `brokers/tastyworks/tastyworks.py`
**Estimado:** 2-3 días
**Riesgo:** BAJO

**Cambios:**
- Línea 280: Filtrado assignment/exercise vs cash settlement
- Línea 326: Validación símbolos + reemplazo RUTW→RUT
- Línea 333: Inferencia acción desde descripción

### Fase 2: Validaciones de Calidad (Semana 2)
**Objetivo:** Mejorar precisión de datos
**Archivos:** `brokers/tastyworks/tastyworks.py`, `brokers/tastyworks/lookups.py` (nuevo)
**Estimado:** 3-4 días
**Riesgo:** BAJO-MEDIO

**Cambios:**
- Línea 355: Normalización precio con precisión
- Línea 270: Detección cash settlement
- Línea 389: Cálculo multiplicador future options
- Crear lookup table para future option sizes

### Fase 3: Lógica de Negocio (Semana 3)
**Objetivo:** Implementar actualizaciones cross-módulo
**Archivos:** `p04_calculate/calculation.py`, `handler.py` (condicional)
**Estimado:** 5-7 días
**Riesgo:** MEDIO-ALTO

**Cambios:**
- Investigar módulo `ImportParams.Tastyworks_cash_settlement()`
- Implementar actualizaciones de trades para cash settlements
- Validación de cuenta (si se requiere)
- Verificar usuarios especiales

---

## Arquitectura del Pipeline

### Nueva Arquitectura (Confirmada)
```
┌──────────────┐     ┌──────────────┐     ┌──────────┐     ┌──────────────┐     ┌────────┐
│ p01_normalize│ ──→ │p02_deduplicate│ ──→ │ p03_group│ ──→ │p04_calculate │ ──→ │p05_write│
└──────────────┘     └──────────────┘     └──────────┘     └──────────────┘     └────────┘
      ↓                      ↓                   ↓                 ↓                   ↓
  Parse JSON          Hash vs DB          Group legs         P&L calc           DB write
  Normalize           Skip dups           Spreads            Updates
  Validate                                Orders             Settlement
```

### Responsabilidades por Stage

| Stage | Responsabilidad | Tastyworks Validations |
|-------|----------------|------------------------|
| **p01_normalize** | Parse + Validate + Transform | #1, #2, #3, #4, #5, #6 |
| **p02_deduplicate** | Detectar duplicados vs DB | #8 (ya implementado) |
| **p03_group** | Agrupar legs en spreads/orders | - |
| **p04_calculate** | P&L + Trade updates | #5b (cash settlement updates) |
| **p05_write** | Persistir en DB | - |

---

## Archivos Modificados

### Archivos a Crear
1. **`new_changes_tastywork/README.md`** (este archivo)
2. **`new_changes_tastywork/ANALISIS_VALIDACIONES_TASTYWORKS.md`** - Análisis detallado
3. **`new_changes_tastywork/CAMBIOS_IMPLEMENTADOS.md`** - Log de cambios (post-implementación)
4. **`brokers/tastyworks/lookups.py`** - Lookup tables (Fase 2)

### Archivos a Modificar
1. **`brokers/tastyworks/tastyworks.py`** - Validaciones Fase 1 y 2
2. **`tests/brokers/test_tastyworks.py`** - ~15 tests nuevos
3. **`p04_calculate/calculation.py`** - Cash settlement logic (Fase 3)
4. **`handler.py`** - Account validation (Fase 3 - condicional)

---

## Decisiones Pendientes

### 🔴 DECISIÓN CRÍTICA 1: Soporte CSV Upload
**Estado:** PENDIENTE
**Pregunta:** ¿El nuevo sistema soporta uploads CSV de Tastyworks?
**Impacto:** Determina si se implementa validación #7 (Account Verification)

### 🟡 DECISIÓN MEDIA 2: Usuarios Especiales
**Estado:** PENDIENTE
**Pregunta:** ¿Los usuarios 47132, 242106, 49127, 137705 siguen activos?
**Impacto:** Determina si se implementa validación #9 (timestamp adjustment)
**Acción:** Query DB production

### 🟡 DECISIÓN MEDIA 3: Future Options Volume
**Estado:** PENDIENTE
**Pregunta:** ¿Cuál es el volumen de Future Options en Tastyworks?
**Impacto:** Determina alcance de lookup table en validación #6
**Acción:** Analizar datos históricos

---

## Riesgos Identificados

### Riesgo 1: Compatibilidad Hash (MD5 vs SHA256)
- **Severidad:** ALTA
- **Probabilidad:** MEDIA
- **Mitigación:** ✅ VERIFICADO - p02 usa original_file_row completo, no hash directo

### Riesgo 2: Missing Cash Settlement Module
- **Severidad:** MEDIA
- **Probabilidad:** ALTA
- **Mitigación:** Fase 1-2 independientes, Fase 3 requiere investigación

### Riesgo 3: Performance Degradation
- **Severidad:** BAJA
- **Probabilidad:** BAJA
- **Mitigación:** Operaciones vectorizadas Polars, profiling antes/después

---

## Testing Strategy

### Tests Unitarios (~15 nuevos)
- Validación símbolos numéricos
- Reemplazo RUTW→RUT
- Inferencia acción desde descripción (EXP/ASSIGNMENT/EXERCISE)
- Filtrado assignment/exercise con cash settlement
- Normalización precio con precisión
- Detección cash settlement
- Cálculo multiplicador future options

### Tests de Integración
- Pipeline completo con todas las validaciones
- Compatibilidad con datos legacy
- Match rate vs legacy ≥95%

### Validación QA
```bash
python qa/validate_broker.py \
    --broker-id 26 \
    --user-id 99999 \
    --legacy-user-id <legacy_user>
```

---

## Conclusión

### Recomendación Final
✅ **Proceder con Fase 1 inmediatamente**

**Razones:**
1. **Sin dependencias externas** - Todas las validaciones son autocontenidas
2. **Bajo riesgo** - Operaciones Polars estándar, sin cambios arquitecturales
3. **Alto impacto** - Previene datos inválidos en el pipeline
4. **Quick wins** - 2-3 días para implementar 3 validaciones críticas

**Próximos Pasos:**
1. Implementar validaciones Fase 1
2. Agregar tests unitarios
3. Validar match rate (≥ baseline)
4. Proceder con Fase 2
5. Responder decisiones pendientes antes de Fase 3

---

## Referencias

- **Plan Completo:** `/root/.claude/plans/delegated-nibbling-hippo.md`
- **Código Legacy:** `old_code_from_legacy/brokers_tastyworks.py`, `old_code_from_legacy/tastyworks_export.py`
- **Código Nuevo:** `brokers/tastyworks/tastyworks.py`, `brokers/tastyworks/detector.py`
- **Tests:** `../../tests/brokers/test_tastyworks.py`
- **Pipeline Stages:** `p02_deduplicate/`, `p03_group/`, `p04_calculate/`, `p05_write/`

---

**Fecha de Análisis:** 2026-01-13
**Analista:** Claude Sonnet 4.5
**Estado:** ✅ PLAN APROBADO - LISTO PARA IMPLEMENTACIÓN FASE 1
