from .brokers_export import BrokerExport
import traceback
import requests
from flask_restful import Resource, request
from flask_jwt_extended import jwt_required
from dateutil.parser import parse
from .. import pusher_client
from ..security_service import verify_role
from ..models import BrokersConnections, Portfolios, PortfolioReferences
from ..responses import ErrorResponses, SuccessResponses
from ..user.users_params import *
import itertools
from ..import_params import ImportParams
from ..trade.trades_regroups import *
from ..server_info import ServerInfo
from ..event.events import UserEventList as EventUser
import time as tt
import datetime as dt
from urllib.parse import urlencode

class PropReportsExport(BrokerExport,ServerInfo, Resource):

    @verify_role('broker export')
    def post(self):                
        try:
            #start_time_t = tt.time() 
            """
            self.data = {"portfolio":"","broker":"tda","auto_login":true,"partial":true}
            """
            version = {}
            self.orders_filerow = []
            partial = True
            if 'partial' in self.data:
                partial = self.data['partial']
            # Start synchronization and update progress
            new_event_id=self.init_sync()
            self._update_progress('Saving Pre-Data', '1%')
            if not isinstance(new_event_id,UserEvents) and not self.is_lambda():
                return new_event_id
            self._update_progress('Checking Credentials', '5%')
            self.orders_filerow = ImportParams.filerow_orders(self.params['get_session_userid'],
                                                         var_sync='propreports id',
                                                         var_file='PropReports Id',
                                                         broker=self.params['broker'],
                                                         partial=partial
                                                     )
            for credential in self.credentials:
                self.reference_code_list = dict()
                self.credential = credential 
                self.not_error = self.validate()
                if self.not_error != True:
                    _end = self.end_sync(code=4,_exception='Error in validate')
                    if _end != True:
                        return _end            
                self._update_progress('Connecting to the server', '10%')
                
                self.not_error = self.login()
                if self.not_error != True:
                    if ' Contact our support team to unlock the connection' in str(self.not_error):
                        _code = 13
                    elif 'System Maintenance in Progress' in str(self.not_error):
                        _code = 14
                    else:
                        _code = 1
                    _end = self.end_sync(code=_code,_exception='Error in login')
                    if _end != True:
                        return _end
                self.time_out_lambda = False
                self.id_account = self.data.get('account',None)
                if self.condition_lambda() and not self.aws_autosync:
                    try:
                        self.not_error = self.call_lambda()
                    except Exception as err:
                        #print(traceback.print_exc())
                        self.not_error = err
                        self.executed_lambda = False
                
                if not self.executed_lambda: 
                    self.not_error = self.get_account()
                    if self.not_error != True:
                        _end = self.end_sync(_exception='Error in get_account')
                        if _end != True:
                            return _end
                  
                    self.not_error = self.select_account()
                    if self.not_error != True:
                        _end = self.end_sync(_exception='Error in select_account')
                        if _end != True:
                            return _end
 
                    self._update_progress('Saving data', '15%')
                    self.save_configs() 
                    self._update_progress('Retrieving orders', '16%')
                    self.not_error = self.get_propreports_orders()
                    if self.not_error != True:
                        _end = self.end_sync(code=7, _exception='Error in get_propreports_orders')
                        if _end != True:
                            return _end
                    self._update_progress('Retrieving orders', '17%')                     
                    self.save_accounts(self.accounts)
                    self.account = self.username   
                    self.check_status_connection_db()    
                    self._update_progress('Retrieving orders', '17%')        
                    self.save_files(file_type='json', portfolio_list=self.portfolio_list)                    
                    self.not_error  = self.save_params() 
                    ##### GET PORTFOLIO LIST #####
                    if not self.reference_code_list:
                        portfolio_ref = PortfolioReferences.query.\
                            with_entities(PortfolioReferences.reference_code, PortfolioReferences.fk_portfolio_id).\
                            filter_by(
                                fk_broker_id = self.broker.broker_id,
                                fk_user_id = self.user.id,
                                ).all()
                        for p in portfolio_ref:
                            if not p.reference_code in self.reference_code_list:
                                self.reference_code_list[p.reference_code] = p.fk_portfolio_id
                    self._update_progress('Reading orders', '19%')
                    self.not_error  =  self.interpret_save_orders(batch_size=40000)

                    if self.not_error != True:
                        self.not_error = str(self.not_error)
                        _end = self.end_sync(code=0,_exception='Error in interpret_save_orders')
                        if _end != True:
                            return _end 
                        
                    self.check_status_connection_db()  
                    self.not_error  = self.save_params()    
                    
            return self.end_sync(event_id=new_event_id)

        except requests.exceptions.ConnectionError as err:
            self.unlock_portfolios()
            self._update_progress('warning', 'Imported fail',True)
            message = 'ERROR'
            if 'Name or service not known' in str(err):
                message = 'Wrong host'
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(tt.time())-self.star_timestamp), 400, 'Fail')
            return ErrorResponses.error_400(message=message, status='warning')
        except Exception as err:
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(tt.time())-self.star_timestamp), 500, 'Fail')
            self.unlock_portfolios()
            self._update_progress('warning', 'Imported fail',True)
            return ErrorResponses.error_500(self.data, err, version)

    def validate(self):
        try:
            self.data = request.json
            self.user.users_configs.not_warning_import = self.data.get('not_warning_import',True)
            self.user.users_configs.save()
            self.symbols = self.data.get('symbols',self.symbols)
            self.auto_import = self.data['auto_import'] if 'auto_import' in self.data else False
            if self.credential and (not 'add' in self.data or self.data['add'] == False):
                #self.credential = BrokersConnections.find_by(**{'user_id':self.user.id, "broker_id":self.broker.broker_id, 'active': True})                
                self.username = self.credential.username
                self.password = self.credential.password
                self.test_account =  self.credential.test_account
                self.account =  self.credential.account
                self.host =  self.credential.host
                self.new_sync = False
            else:
                #print('si no')
                if self.data['username'] =='' or self.data['password'] == '' or self.data['username'] ==None or self.data['password'] == None:
                    return "Wrong credentials"
                if 'propreports' in request.url and self.data['host'] =='':
                    return "Wrong host"
                if self.data['host'] =='':
                    Account = BrokersConnections.find_by(**{'user_id':self.user.id, "username":self.data['username'].strip(), "active": True})
                else:
                    Account = BrokersConnections.find_by(**{'user_id':self.user.id, "username":self.data['username'].strip(),
                                                        "host":self.data.get('host',None), "active": True})
                if Account and self.data['broker'] == 'propreports':
                    if Account.broker_id==240 and Account.active==True:
                        text_broker = 'PropReport'
                    elif 'zim.propreports' in self.data.get('host',None):
                        text_broker = 'Zimtra'
                    elif 'stgmarkets' in self.data.get('host',None):
                        text_broker = 'Ocean One Securities'
                    elif 'centerpoint' in self.data.get('host',None):
                        text_broker = 'CenterPoint Securities'
                    else:
                        text_broker = 'Capital Market Elite Groups (CMEG)' 
                    return "Account already exists, "+text_broker
            
                #self.credential = BrokersConnections.find_by(**{'user_id':self.user.id, "broker_id":self.broker.broker_id, 'active': True})
                self.username = self.data['username'].strip()
                self.password = self.data['password'].strip()
                self.test_account =  self.data.get('test_account',None)
                self.account =  self.data.get('account',self.data['username'].strip())
                self.host =  self.data.get('host',None)
                self.data['partial'] = False
                self.new_sync = True

            if self.username =='' or self.password == '' or self.username ==None or self.password == None:
                #print('no hay credenciales')
                return "Wrong credentials"
                
            return True

        except Exception as err:
            #print(traceback.print_exc())
            if not self.credential:
                return "Wrong credentials"

            self.username = self.credential.username
            self.password = self.credential.password
            self.test_account =  self.credential.test_account
            self.account =  self.credential.account
            # self.host =  self.credential.host
            self.user.users_configs.not_warning_import = True
            self.user.users_configs.save()
            self.data = None
            return str(err)
    
    def login(self):
        try:
            # Build host and URL correctly
            host = self.broker.broker_host if getattr(self.broker, 'broker_host', None) else self.host
            host = host.replace("https://", "").replace("http://", "").split("/")[0]
            if 'propreports.com' not in host:
                host += '.propreports.com'
            self.url = f"https://{host}/api.php"

            # Prepare login data
            data = {
                'action': 'login',
                'user': self.username,
                'password': self.password
            }
            encoded_data = urlencode(data)

            # Make the POST request
            response = requests.post(self.url, headers=self.headers, data=encoded_data)
            self.log_response = response.text
            self.token = response.text
            # Handle HTTP errors and specific messages
            if response.status_code != 200:
                if "Too many invalid login attempts from this" in self.token:
                    if host == 'cmelitegroup.propreports.com':
                        self.host = 'cmelitegroupky.propreports.com'
                        return self.second_login()
                    return "You have 4 invalid login attempts. Contact our support team to unlock the connection"
                if "Incorrect password or User Id / E-mail" in self.token:
                    if host == 'cmelitegroup.propreports.com':
                        self.host = 'cmelitegroupky.propreports.com'
                        return self.second_login()
                    return "Incorrect password or User Id / E-mail - You have only 4 attempts to connect your account or the connection will be blocked"
                # Other errors: return response text
                return self.token

            # If status is 200 but response contains known errors
            if any(err_msg in self.token for err_msg in [
                "Too many invalid login attempts from this",
                "Incorrect password or User Id / E-mail"
            ]):
                return self.token

            # Successful login
            return True
        except Exception as err:
            return f"Login error: {err}"
            
    def second_login(self):
        """
        curl -X POST -d "action=login&user=superuser2&password=IG5VQiwnSZfD" https://demo.propreports.com/api.php
        """
        try:
            # Build host and URL correctly
            host = self.host.replace("https://", "").replace("http://", "").split("/")[0]
            if 'propreports.com' not in host:
                host += '.propreports.com'
            self.url = f"https://{host}/api.php"

            # Prepare login data
            data = {
                'action': 'login',
                'user': self.username,
                'password': self.password
            }
            encoded_data = urlencode(data)

            # Make the POST request
            response = requests.post(self.url, headers=self.headers, data=encoded_data)
            self.log_response = response.text
            self.token = response.text

            # Handle HTTP errors and specific messages
            if response.status_code != 200:
                if "Too many invalid login attempts from this" in self.token:
                    return "You have 4 invalid login attempts. Contact our support team to unlock the connection"
                if "Incorrect password or User Id" in self.token:
                    return "Incorrect password or User Id / E-mail - You have only 4 attempts to connect your account or the connection will be blocked"
                # Other errors: return response text
                return self.token

            # Always return True if status is 200
            return True
        except Exception as err:
            return f"Second login error: {err}"
        
    def get_account(self):
        """
        curl -X POST -d "action=accounts&token=2f556108fceb0476efa079267eb81523:8" https://demo.propreports.com/api.php
        """
        try:
            self.action = "accounts"
            self.payload = f"action={self.action}&token={self.token}"
            self.log_response = {"url": self.url, "headers": self.headers, "payload": self.payload}
            response = requests.post(self.url, headers=self.headers, data=self.payload)
            self.log_response = response.text

            # If response is not 200, try to return the 'msg' from the response
            if response.status_code != 200:
                try:
                    resp_json = response.json()
                    if 'msg' in resp_json:
                        return 'Account '+resp_json['msg']
                    return str(resp_json)
                except Exception:
                    return response.text

            self.csv_to_json(response.text)
            new_json = []
            if not self.new_sync:
                for row in self.new_json:
                    if row.get('account id', '') == self.api_key_information[0]:
                        new_json = [row]
                        break
            else:
                new_json = self.new_json

            self.new_json = new_json
            return True
        except Exception as e:
            print(traceback.print_exc())
            return e
        
    def select_account(self):
        try:
            self.first_trade=[]
            no_account = True
            if self.host == 'demo.propreports.com':
                self.accounts = []
                for row in self.new_json:
                    if self.account.lower() == row['account name'].lower():
                        self.accounts = []
                        self.accounts.append(row)
                        if self.credential.last_trade != [] and self.data['partial']:
                            self.first_trade.append(
                                {"account id": row['account id'], "account name": row['account name'], "first traded": row['last traded'], "last traded": "2023-12-31", "currency": row['currency'], "cash": row['cash'], "unrealized":  row['unrealized']})
                        else:
                            self.first_trade.append(row)
                        no_account = False
                        break
                    elif int(row['account id']) == 1 or int(row['account id'])==144:
                        self.accounts.append(row)
                        if self.credential and self.credential.last_trade != [] and self.data['partial']:
                            self.first_trade.append(
                                {"account id": row['account id'], "account name": row['account name'], "first traded": row['last traded'], "last traded": "2023-12-31", "currency": row['currency'], "cash": row['cash'], "unrealized":  row['unrealized']})
                        else:
                            self.first_trade.append(row)
                        no_account = False

                return True

            for row in self.new_json: 
                if self.account.lower() == row['account name'].lower() :
                    self.accounts = []
                    self.accounts.append(row)
                    if self.credential and self.credential.last_trade != [] and self.data['partial']:
                        self.first_trade.append(
                            {"account id": row['account id'], "account name": row['account name'], "first traded": row['last traded'], "last traded": "2023-12-31", "currency": row['currency'], "cash": row['cash'], "unrealized":  row['unrealized']})
                    else:
                        self.first_trade.append(row)
                    no_account = False
                    break

                self.accounts.append(row)
                if self.credential and self.credential.last_trade != [] and self.data['partial']:
                    self.first_trade.append(
                        {"account id": row['account id'], "account name": row['account name'], "first traded": row['last traded'], "last traded": "2023-12-31", "currency": row['currency'], "cash": row['cash'], "unrealized":  row['unrealized']})
                else:
                    self.first_trade.append(row)

            return True
        except:
            return  'Error getting Accounts'

    def get_propreports_orders(self, first_trade=None):
        """
        curl -X POST -d "action=accounts&token=2f556108fceb0476efa079267eb81523:8" https://demo.propreports.com/api.php
        """
        self.action = "fills"
        i = 0   
        self.first_trade=self.remove_duplicate(self.first_trade)
        for account in  self.first_trade:
            i = i+1
            max_len_orders = 50000
            
            if self.data['partial']:  
                timestamp=self.get_last_date_a(user_account=account['account id'])  #user_account=account['account id']             
                if timestamp > 0:                      
                    a_date = datetime.fromtimestamp(timestamp) #                
                    account['first traded'] = a_date.strftime('%Y-%m-%d')
                else:
                    account['first traded'] = '2010-08-02'
                    a_date = datetime.fromtimestamp(1276784048)
            else:
                 account['first traded'] = '2010-08-02'
                 a_date = datetime.fromtimestamp(1276784048)
                 
            date_last = datetime.fromtimestamp(int(tt.time()))
            account['last traded']=date_last.strftime('%Y-%m-%d')
            account['first traded'], account['last traded'] = self.validate_date_range(account['first traded'], account['last traded'])
            while max_len_orders >= 50000:

                self.payload = "action={}&token={}&startDate={}&endDate={}&accountId={}".format(self.action, self.token, account['first traded'], account['last traded'], account['account id'] )
                # self.payload = "action={}&token={}&startDate={}&endDate={}&accountId={}".format(self.action, self.token, "2022-05-04","2022-05-05", account['account id'] )
                #print(self.payload)
                self.log_response = {"url": self.url, "headers": self.headers, "payload": self.payload}
                response = requests.request("POST", self.url, headers=self.headers, data = self.payload)
                self.log_response = response.text
                if 'Date/Time' not in response.text:
                    continue
                self.portfolio= '{}{}'.format(self.broker.broker_key, account['account id'])
                self.response_type = 'csv'
                #print('response',response.text)
                #self.save_files(file_type='csv', response_txt = response.text)
                self.csv_to_json(response.text, self.portfolio, account['account id'])
                if self.new_json !=[]:
                    self.orders.append(self.new_json)
                max_len_orders = len(self.new_json)
                
                try:
                    date_str = self.new_json[-1]['date/time'].split('.')[0]
                    cr_date = datetime.strptime(date_str, '%m/%d/%Y %H:%M:%S')                   
                    cr_date = cr_date.strftime('%Y-%m-%d')
                    #print('cr_date1',cr_date)
                except:
                    #print(traceback.print_exc())
                    cr_date = a_date.strftime('%Y-%m-%d')
                    #print('cr_date2',cr_date)

                account['first traded'] = cr_date
            

        self.orders=list(itertools.chain.from_iterable(self.orders))
        # try:
        #     self.orders = list(sorted(self.orders, key=lambda i: i.get('date/time', ''), reverse=True))
        # except:
        #     pass
        self.all_orders = self.orders
        #self.all_orders=self.remove_duplicate(self.all_orders)
        #self.check_status_connection_db()
        return True

    def interpret_orders(self):
        try:
            b=0
            i=0
            #self.orders = []
            new_date_time = []
            self.out_result=[]
            self.out_result.clear()
            verify_njson_len = 0
            broker = 'PropReports'.upper() if 'propreports' not in self.broker.broker_name.lower() else self.host
            error_message = f'Please, continue importing with the same broker selection which is {broker.split(".")[0].upper()} as this was the first broker you started syncing with'
            for order in self.all_orders:
                get_portfolio = self.reference_code_list.get(order.get('reference_code'))
                if not get_portfolio:
                    return error_message
                try:
                    # Remove milliseconds from date/time format to maintain backward compatibility
                    # Converts "6/11/2025 15:03:12.000" to "6/11/2025 15:03:12"
                    order['date/time'] = order['date/time'].split('.')[0]
                except:
                    # If date/time format doesn't contain milliseconds or field is missing, keep original value
                    pass
                original_file_row = json.loads(json.dumps(order))
                njson = json.dumps(order)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest() 
                action = order['b/s'].upper() if 'b/s' in order else order['side'].upper() if 'side' in order else ''
                if 'action' in order:
                    action = 'BUY' if str(order['action'])=='1' else 'SELL' if str(order['action'])=='2' else ''
                action = 'BUY' if action == 'BUY' or action=='COVER' or action=='B' else 'SELL' if action == 'SELL' or action == 'SHORT' or action=='S' or action=='T' else ''
                order['date'] = order['date/time'].strip() if 'date/time' in order else ''

                if not order['symbol'] or not order['date'] or not order['price'] or not action:
                    continue
                i = i + 1
                order['orderby'] = b
                pip_value = 0
                date_split = order['date/time'].strip()
                original_file_row['date_tz'] = date_split
                any_error, date, time = ImportParams.get_param_datetime(date_split,b)
                try:
                    date_str = order['date/time'].split('.')[0]
                    dt = datetime.strptime(date_str, '%m/%d/%Y %H:%M:%S')
                    order['date'] = dt.strftime('%Y-%m-%d')
                    order['time'] = dt.strftime('%H:%M:%S')
                except:
                    new_date_time = ImportParams.convert_date(date, time, self.date_format)
                    order['date'] = new_date_time[0]
                    order['time'] = new_date_time[1]

                fp = order['price'].replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                if not 'type' in order:
                    order['type'] = 'SHARE'
                sm = len(order['symbol'])
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = '' 
                if sm >= 8 or order['type'].upper()=='OPTION':
                    extract = order['symbol']                
                    temp = next((i for i, chr in enumerate(order['symbol']) if chr.isdigit()), None)
                    order['symbol'] = str(order['symbol'][0 : temp]).replace('+','').replace('-','')
                    extract = extract[temp:]
                    option_extract = extract.split('C') if 'C' in extract else extract.split('P')
                    option = 'CALL' if 'C' in extract else 'PUT' if 'P' in extract else 'OPTION'
                    expire_extract = option_extract[0]
                    strike = option_extract[1]
                    date_format = "%y%m%d"
                    de = datetime.strptime(expire_extract, date_format)
                    expire = de.strftime('%d %b %y').upper()
                    try:
                        strike = int(float(strike))/1000
                    except:
                        strike= strike
    
                ecn = float(order['ecn fee'].replace(',', '').replace('(','').replace(')','')) if 'ecn fee' in order and order['ecn fee'] else 0.00
                sec = float(order['sec'].replace(',', '')) if 'sec' in order and order['sec'] else 0.00
                taf = float(order['taf'].replace(',', '')) if 'taf' in order and order['taf'] else 0.00
                nscc = float(order['nscc'].replace(',', '')) if 'nscc' in order and order['nscc'] else 0.00
                nasd = float("{:f}".format(float(str(order['nasd'])))) if 'nasd' in order and order['nasd'] else 0.00
                misc = float(order['misc'].replace(',', '')) if 'misc' in order and order['misc'] else 0.00
                clr = float(order['clr'].replace(',', '')) if 'clr' in order and order['clr'] else 0.00

                fees_sum = str(sec + taf + nscc + nasd + clr + misc)

                comm1 = float(order['exec'].replace(',', '').replace('$','').replace('-','').replace('(','').replace(')','')) if 'exec' in order and order['exec'] else float(order['comm'].replace(',', '').replace('$','').replace('-','').replace('(','').replace(')','')) if 'comm' in order and order['comm'] else 0.00
                comm1 = float(comm1)
                comm_sum = str(ecn + comm1)
                comm_sum = str(comm1) 
                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = get_portfolio
                    if self.portfolio_id==None:
                        self.portfolio_id = get_portfolio
                    if 'propreports id' in order and order['propreports id']:
                        order_id = order['propreports id']
                    valid_file_row = ImportParams.validate_filerow(self.orders_filerow, 
                                                                njson=njson, 
                                                                order_id=order_id,
                                                                date_tz=original_file_row['date_tz'],
                                                                price=fp,
                                                                option=option,
                                                                action=action,
                                                                quantity=order['qty'].replace(',', ''),
                                                                strike=strike,
                                                                expire=expire,
                                                                portfolio=portfolio_
                                                                )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ########################################################## 
                order['trade_notes'] = order['trade_notes'] if 'trade_notes' in order else ''
                order['type_stock'] = type
                order['type_option'] = option
                order['action'] = action
                order['price'] = fp
                order['shares'] = order['qty'].replace(',', '')
                order['comm'] = comm_sum
                order['swap'] = ecn*-1
                order['njson'] = njson
                order['decimal'] = decimal
                order['expire'] = expire
                order['strike'] = strike
                order['pip_value'] = pip_value
                order['fees'] = fees_sum
                order['original_file_row'] = original_file_row
                order['broker'] = self.params['broker']
                order['userid'] = self.params['get_session_userid']   
                order['portfolio'] = get_portfolio

                data_item = ImportParams.get_result_append(order)
                self.out_result.append(data_item)            
                b = b - 1
                if i==10000:
                    i=0
                    self._update_progress('Reading orders'+self.message_interpert, '19%')
                    
            #self.orders = self.out_result    
            return True, self.out_result
        except Exception as err:
            #print(traceback.print_exc())
            return True, []
