import re
import hashlib
import json
import traceback
import datetime

from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required
from datetime import date, timedelta, time
from dateutil.parser import parse
from copy import deepcopy

from .. import_params import ImportParams
from .. trade.trades_regroups import *
from .. security_service import *
from .. logs import create_log
from .. responses import ErrorResponses, SuccessResponses


class BrokerPropReports(Resource):

    def getcsv(params, content, date_format='mdy'):
        data = "PropReports 1"
        print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            cont = content

            content = content.replace(';', '').replace('\t',',').replace('\x00','') #issue3658
            if ('B/S' in content.upper() and 'DATE/TIME' in content.upper()) or 'Transaction Code' in content:
                return BrokerPropReports.getcsv2(params, content, date_format='mdy')
            if 'ROUTE' in content.upper():
                return BrokerPropReports.getcsv3(params, content, date_format='mdy')

            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 12
            rl = 0
            ath = False
            if 'EQUITIES' in cont.upper():

                result_b = ['symbol,date_global,datetime,closetime,type,entry_price, exit_price, qty,comm,fee 1,fee 2,fee 3,fee 4,fee 5,fee 6,fee 7,fee 8,fee 9']
                date_file =  datetime.now().strftime("%m/%d/%y")
                symbol = ''
                prev_date = False
                rs_next = False
                for a, row in enumerate(content_b):
                    row = row.replace("\r", "")
                    row = re.sub(r'(?!(([^"]*"){2})*[^"]*$),', '', row)
                    rs = row.split(',')
                    rs_next = content_b[a+1].split(',') if (a+1) < len(content_b) else False
                    if '/' in rs[0]:
                        ddf = ''
                        ds = rs[0].split('/')

                        if len(ds) == 3:

                            if len(ds[2]) == 4 and ImportParams.validate_date(rs[0].strip(), '%m/%d/%Y'):
                                ddf = datetime.strptime(rs[0].strip(), '%m/%d/%Y')
                            elif len(ds[2]) == 2 and ImportParams.validate_date(rs[0].strip(), '%m/%d/%y'):
                                ddf = datetime.strptime(rs[0].strip(), '%m/%d/%y')

                        if isinstance(ddf, datetime):
                            # print ("date valid")
                            date_file = rs[0]
                            continue

                    if not '-' in rs[0] and rs_next and rs_next[0].upper() == 'OPENED':
                        continue

                    if len(rs) >= 4 and rs[4] and rs[4].strip().upper() != 'TYPE':
                        try:

                            result_b.append(rs[3]+',' +date_file+','+rs[0]+','+rs[1]+','+rs[4]+','+rs[5]+','+rs[6]+','+rs[7]+','+rs[9]+','+rs[10]+','+rs[11]+','+rs[12]+','+rs[13]+','+rs[14]+','+rs[15]+','+rs[16]+','+rs[17]+','+rs[18])

                        except:

                            result_b.append(rs[3]+','
                                            +date_file+','
                                            +rs[0]+','
                                            +rs[1]+','
                                            +rs[4]+','
                                            +rs[5]+','
                                            +rs[6]+','
                                            +rs[7]+','
                                            +rs[9]+','
                                            +rs[10]+','
                                            +rs[11]+','
                                            +rs[12]+','
                                            +rs[13]+','
                                            +rs[14]+','
                                            +rs[15]+','
                                            +rs[16]
                                           )
            result = ImportParams.custom_getcsv(result_b, nl,False,True)
            b = len(result)
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n['orderid']) if 'orderid' in n else json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                #n['symbol'] = n['symbol'].split('-')[0].strip()
                n['symbol'] = n['symbol'].replace('-','/').strip()
                n['action'] = 'BUY' if n['type'].upper() == 'LONG' else \
                              'SELL' if n['type'].upper() == 'SHORT' else ''
                n['price'] = n['avg trading price'] if 'avg trading price' in n else n['price'] if 'price' in n else n['entry_price']  if 'entry_price' in n else  ''
                n['quantity'] = n['filled'] if 'filled' in n else n['amount'] if 'amount' in n else ''
                #n['fee'] = str(float(n['total'].replace('-', '')) * 0.507038) if 'total' in n and not 'fee' in n  else n['fee'] if 'fee' in n else ''
                quantity = abs(float(n['qty'].replace('-', '').replace(',', ''))) if 'qty' in n else 0
                n['date'] = n['datetime'] if 'datetime' in n else ''

                if (not n['action'] and n['price']) or n['action'] not in ['BUY', 'SELL'] or not n['price'] or not n['symbol'] or not n['date']:
                    continue

                if 'status' in n and n['status'] and n['status'].upper() == "CANCELED" and quantity == 0:
                    continue

                n['orderby'] = b
                date_time = n['date'].strip()
                original_file_row['date_tz'] = date_time
                any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                new_date_time =  ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                fp = n['price'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 and decimal <= 6 else 6 if decimal > 6 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00

                type = 'share'
                option = 'SHARE'
                expire = ''
                strike = ''
                sm = len(n['symbol'])
                if sm >= 8:
                    type = 'option'
                    m = re.search(r"\d",n['symbol'])
                    x = int(m.start())
                    extract = n['symbol'][x:]
                    n['symbol'] = n['symbol'][:x].replace('+','')
                    option = 'CALL' if 'C' in extract or 'CALL' in extract \
                                    else 'PUT' if 'P' in extract or 'PUT' in extract \
                                    else 'OPTION'
                    extract2 = extract.split('C') if 'C' in extract else extract.split('P')
                    strike = str(int(extract2[1]))
                    expire_extract = extract2[0]
                    try:
                        date_format = "%y%m%d"
                        de = datetime.strptime(expire_extract, date_format)
                        expire = de.strftime('%d %b %y').upper()
                    except Exception as err:
                        print(err)
                        expire = expire_extract
                commission = n['comm'].replace(',', '').replace('-', '').replace('(', '').replace(')', '') if 'comm' in n else ''
                commission = round(float(commission),2) if commission else 0.00

                #fee = n['fee 1'].replace('-', '').replace('(', '').replace(')', '').replace(',', '') if 'fee 1' in n else ''
                fee1 = n['fee 1'].replace('(', '').replace(')', '').replace(',', '.') if 'fee 1' in n and '(' in n['fee 1'] else '-'+n['fee 1'].replace('(', '').replace(')', '').replace(',', '.') if 'fee 1' in n  and n['fee 1'] else ''
                fee1 = round(float(fee1),2) if fee1 else 0.00


                fee2 = n['fee 2'].replace('-', '').replace('(', '').replace(')', '').replace(',', '') if 'fee 2' in n else ''
                fee2 = round(float(fee2), 2) if fee2 else 0.00

                fee3 = n['fee 3'].replace('-', '').replace('(', '').replace(')', '').replace(',', '') if 'fee 3' in n else ''
                fee3 = round(float(fee3), 2) if fee3 else 0.00

                fee4 = n['fee 4'].replace('-', '').replace('(', '').replace(')', '').replace(',', '') if 'fee 4' in n else ''
                fee4 = round(float(fee4), 2) if fee4 else 0.00

                fee5 = n['fee 5'].replace('-', '').replace('(', '').replace(')', '').replace(',', '') if 'fee 5' in n else ''
                fee5 = round(float(fee5), 2) if fee5 else 0.00

                fee6 = n['fee 6'].replace('-', '').replace('(', '').replace(')', '').replace(',', '') if 'fee 6' in n else ''
                fee6 = round(float(fee6), 2) if fee6 else 0.00

                fee7 = n['fee 7'].replace('-', '').replace('(', '').replace(')', '').replace(',', '') if 'fee 7' in n else ''
                fee7 = round(float(fee7), 2) if fee7 else 0.00

                fee8 = n['fee 8'].replace('-', '').replace('(', '').replace(')', '').replace(',', '') if 'fee 8' in n else ''
                fee8 = round(float(fee8), 2) if fee8 else 0.00

                fee9 = n['fee 9'].replace('-', '').replace('(', '').replace(')', '').replace(',', '') if 'fee 9' in n else ''
                fee9 = round(float(fee9), 2) if fee9 else 0.00

                fees = fee2 + fee3 + fee4 + fee5 + fee6
                if len(rs) > 17:
                    fees = fees + fee7 + fee8 + fee9
                swap = fee1


                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = fees
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['swap'] = swap
                n['original_file_row'] = original_file_row
                n['mistakes'] = n['mistake'] if 'mistake' in n else ''
                n['trade_notes'] = n['notes'] if 'notes' in n else ''

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)

                out_result.append(data_item)

                if n['closetime']:
                    original_file_row2 = deepcopy(original_file_row)
                    n['action'] = 'SELL' if n['action'] == 'BUY' else 'BUY'
                    b = b + 1

                    fp2 = n['exit_price'].replace(',', '').replace('$','')
                    decimal = fp2[::-1].find('.')
                    decimal = decimal if decimal > 1 else 2
                    price = round(float(fp2),decimal)
                    #fecha

                    n['date'] = n['date_global']
                    n['time'] = n['closetime']
                    date_split = n['date'].strip()
                    d = date_split
                    t = n['time'] if 'time' in n else ''
                    date_time = (d+' '+t).strip()
                    original_file_row2['date_tz'] = date_time
                    any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                    new_date_time = ImportParams.convert_date(date, time, date_format)
                    n['date'] = new_date_time[0]
                    n['time'] = new_date_time[1]

                    commission = 0.00
                    #n['symbol'] = n['symbol']
                    n['type_stock'] = type
                    n['type_option'] = option
                    n['price'] = fp2
                    n['shares'] = quantity
                    n['comm'] = 0.00
                    n['fees'] = 0.00
                    n['swap'] = 0.00
                    n['njson'] = njson + 'Closed'
                    n['decimal'] = decimal
                    n['expire'] = expire
                    n['strike'] = strike
                    #n['pips'] = pip
                    n['original_file_row'] = original_file_row2
                    n['broker'] = params['broker']
                    n['userid'] = params['get_session_userid']
                    n['portfolio'] = params['user_portfolio']

                    data_item = ImportParams.get_result_append(n)
                    out_result.append(data_item)
                b = b - 1

                # out_result.append(n)
        except Exception as err:
            print(err, traceback.format_exc())
            any_error = 9
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error

    def getcsv2(params, content, date_format='mdy'):
        data = "PropReports2"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:

            content = content.replace(';', '')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False

            for row in content_b:
                if len(row) == 0:
                    continue
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)

            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            b = len(result)

            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                action = n['b/s'].upper() if 'b/s' in n else n['transaction code'].upper() if 'transaction code' in n else n['side'].upper() if 'side' in n else ''
                if 'action' in n:
                    action = 'BUY' if str(n['action'])=='1' else 'SELL' if str(n['action'])=='2' else ''
                action = 'BUY' if 'BUY' in action or action=='COVER' or action=='B' else 'SELL' if 'SELL' in action or action == 'SHORT' or action=='S' or action=='T' else ''
                n['date'] = n['date/time'].strip() if 'date/time' in n else n['settle date']

                if not n['symbol'] or not n['date'] or not n['price'] or not action:
                    continue
                n['orderby'] = b
                pip_value = 0
                date_split = n['date'].strip()
                original_file_row['date_tz'] = date_split
                any_error, date, time = ImportParams.get_param_datetime(date_split,b)
                new_date_time = ImportParams.convert_date(date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                fp = n['price'].replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp),decimal)
                #price = round(float(n['price'].replace(',', '')),6)
                if not 'type' in n:
                    n['type'] = 'SHARE'
                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = ''
                smn = n['symbol'][-2:]
                if 'type' in n and n['type'].upper() != "SHARE" or not 'type' in n:
                    if (sm > 4 and sm < 8 and not 'type' in n) or ImportParams.isfloat(smn) or ('type' in n and n['type'].upper() == 'FUTURE'):
                        type = 'future'
                        option = 'FUTURE'
                        params_future = ImportParams.getFutureSymbol(n['symbol'])
                        n['symbol'] = params_future['symbol'] if 'symbol' in params_future and params_future['symbol'] else n['symbol']
                        expire = params_future['expire'] if 'expire' in params_future and params_future['expire'] else ''
                        n['size'] = params_future['size'] if 'size' in params_future and params_future['size'] else ''
                    elif sm >= 8 or n['type'].upper()=='OPTION':
                        type = 'option'
                        option = 'CALL' if 'CALL' in n['call or put'].upper() else 'PUT' if 'PUT' in n['call or put'].upper() else 'OPTION'
                        expire = str(n['expiration date']) if 'expiration date' in n else  str(n['expiration'])
                        try:
                            de = parse(expire)
                            expire = de.strftime('%d %b %y').upper()
                        except:
                            expire = expire
                        strike = str(n['strike price'])
                    elif '$' in n['symbol'] or n['type'].upper()=='FOREX':
                        type = 'forex'
                        option = 'FOREX'
                        pip_value = 1 if 'EURUSD' in n['symbol'].upper() else (1/price)*100 if 'JPY' in n['symbol'].upper() else (1/price)

                ecn = float(n['ecn fee'].replace(',', '').replace('-','').replace('(','').replace(')','')) if 'ecn fee' in n and n['ecn fee'] else 0.00
                sec = float(n['sec'].replace(',', '').replace('-','')) if 'sec' in n and n['sec'] else 0.00
                taf = float(n['taf'].replace(',', '').replace('-','')) if 'taf' in n and n['taf'] else 0.00
                nscc = float(n['nscc'].replace(',', '').replace('-','')) if 'nscc' in n and n['nscc'] else 0.00
                nasd = float("{:f}".format(float(str(n['nasd'])))) if 'nasd' in n and n['nasd'] else 0.00
                misc = float(n['misc'].replace(',', '').replace('-','')) if 'misc' in n and n['misc'] else 0.00
                clr = float(n['clr'].replace(',', '').replace('-','')) if 'clr' in n and n['clr'] else 0.00

                fees_sum = str(sec + taf + nscc + nasd + clr + misc)

                comm1 = float(n['exec'].replace(',', '').replace('$','').replace('-','').replace('(','').replace(')','')) if 'exec' in n and n['exec'] else float(n['comm'].replace(',', '').replace('$','').replace('-','').replace('(','').replace(')','')) if 'comm' in n and n['comm'] else 0.00
                comm1 = float(comm1)
                comm_sum = str(ecn + comm1)
                if 'total fees':
                    fees_sum = float(n['total fees'].replace(',', '').replace('-','').replace('(','').replace(')',''))
                    comm_sum = 0.00

                n['trade_notes'] = n['trade_notes'] if 'trade_notes' in n else ''
                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = fp
                n['shares'] = n['qty'].replace(',', '') if 'qty' in n else n['quantity'].replace(',', '').replace('-', '')
                n['comm'] = comm_sum
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['pip_value'] = pip_value
                n['fees'] = fees_sum
                n['original_file_row'] = original_file_row
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b - 1

                # out_result.append(n)
        except Exception as err:
            print(err, traceback.format_exc())
            any_error = 9
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error

    def getcsv3(params, content, date_format='mdy'):
        data = "PropReports3"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            cont = content

            content = content.replace(';', '').replace('\t',',').replace('\x00','')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 12
            rl = 0
            ath = False
            if 'TOTAL' in cont.upper():

                result_b = ['symbol,date,time,fill id,b/s,qty,price,comm,fee 1,fee 2,fee 3,fee 4, fee 5, fee 6, fee 7']
                #Order Id,	Fill Id,	Route,	Liq	,B/S,	Qty,	Price,	Position,	Gross,	Comm,	Ecn Fee,	SEC	ORF,	TAF	NFA	NSCC	Acc	Clr	Misc	Net
                date_file =  datetime.now().strftime("%m/%d/%y")
                symbol = ''
                prev_date = False
                rs_next = False
                #for row in content_b:
                for a, row in enumerate(content_b):
                    row = row.replace("\r", "")
                    row = re.sub(r'(?!(([^"]*"){2})*[^"]*$),', '.', row)
                    row = row.replace('"','')
                    rs = row.split(',')
                    rs_next = content_b[a+1].replace('"','').split(',') if (a+1) < len(content_b) else False
                    if '/' in rs[0]:
                        ddf = ''
                        ds = rs[0].split('/')

                        if len(ds) == 3:
                            if len(ds[2]) == 4 and ImportParams.validate_date(rs[0].strip(), '%m/%d/%Y'):
                                ddf = datetime.strptime(rs[0].strip(), '%m/%d/%Y')
                            elif len(ds[2]) == 2 and ImportParams.validate_date(rs[0].strip(), '%m/%d/%y'):
                                ddf = datetime.strptime(rs[0].strip(), '%m/%d/%y')

                        if isinstance(ddf, datetime):
                            date_file = rs[0]
                            continue

                    if '-' in rs[0]:
                        symbol = rs[0]
                        continue
                    if not '-' in rs[0] and rs_next and rs_next[0].upper() == 'TIME':
                        symbol = rs[0]
                        continue
                    if rs[5] and rs[5].strip().upper() != 'B/S':
                        try:
                            result_b.append( symbol+','
                                            +date_file+','
                                            +rs[0]+','
                                            +rs[2]+','
                                            +rs[5]+','
                                            +rs[6]+','
                                            +rs[7]+','
                                            +rs[10]+','
                                            +rs[11]+','
                                            +rs[12]+','
                                            +rs[13]+','
                                            +rs[14]+','
                                            +rs[15]+','
                                            +rs[16]
                                           )
                        except:
                            result_b.append( symbol+','
                                            +date_file+','
                                            +rs[0]+','
                                            +rs[2]+','
                                            +rs[5]+','
                                            +rs[6]+','
                                            +rs[7]+','
                                            +rs[10]+','
                                            +rs[11]+','
                                            +rs[12]+','
                                            +rs[13]+','
                                            +rs[14]+','
                                            +rs[15]
                                           )

            else:
                result_b = ['date,time,symbol,b/s,qty,price']
                #12/20/2018	Time	Sym	Side	Qty	Exe Price	Acct	Dest	Tif	Inst
                nl = 6
                for row in content_b:
                    row = row.replace("\r", "")
                    row = re.sub(r'(?!(([^"]*"){2})*[^"]*$),', '.', row)
                    rs = row.split(',')
                    if not rs or len(rs) < 6:
                        continue

                    if len(rs) == 9:
                        result_b[0] = 'date,time,symbol,qty,b/s,price,status'
                    if len(rs) > 9:
                        result_b[0] = 'time, status, symbol, b/s, qty, price, date'
                    if len(rs) <= 9:
                        try:

                            ddf = datetime.strptime(rs[1], '%H:%M:%S')
                            ddf = True
                        except ValueError:
                            ddf = False

                        if not rs[0] and ddf:
                            if params['tradedate']:
                                rs[0] = params['tradedate']
                            else:
                                rs[0] = datetime.now().strftime('%m/%d/%Y')

                        if rs[0] and not ddf and ':' in rs[0]:

                            if params['tradedate']:
                                d = params['tradedate']
                            else:
                                d = datetime.now().strftime('%m/%d/%Y')
                            rsm = [d]

                            if rs[1].upper() == 'FILLED' or (':' in rs[0]):
                                for r in rs:
                                    rsm.append(r)
                            else:
                                continue

                            rs = rsm
                    action_v = ['B','T','S','BOT','SLD','BUY','SELL', 'SSHRT']
                    if rs[3].upper() in action_v:
                        if len(rs) > 14:
                            # time, status, symbol, action, quanty, quanty fill, n/a, price, marke, type order, n/a, n/a, price fill, date
                            result_b.append(rs[0].replace('"','')+','+rs[1]+','+rs[2]+','+rs[3]+','+rs[5]+','+rs[12]+','+rs[13])
                        elif ImportParams.isfloat(rs[5]):
                            result_b.append(rs[0].replace('"','')+','+rs[1]+','+rs[2]+','+rs[3]+','+rs[4]+','+rs[5])
                    elif rs[4].upper() in action_v:
                        if ImportParams.isfloat(rs[7]):
                            result_b.append(rs[0].replace('"','')+','+rs[1]+','+rs[3]+','+rs[4]+','+rs[5]+','+rs[7])
                        else:
                            result_b.append(rs[0].replace('"','')+','+rs[1]+','+rs[2]+','+rs[3]+','+rs[4]+','+rs[5]+','+rs[6])
                    else:
                        if ImportParams.isfloat(rs[4]):
                            result_b.append(rs[0].replace('"','')+','+rs[1]+','+rs[2]+','+rs[5]+','+rs[3]+','+rs[4])
            # ['Date,Time,Symbol,Quantity,Price,Side,,,,,,,', ',11:02:47,CEI,8000,4.28,SLD,NYSE,DAY,Equity,,,,',',09:31:26,CEI,4000,3.7,BOT,NYSE,DAY,Equity,,,,', ',,,,,,,,,,,,', ',09:26:19,CEI,4000,4.02,BOT,NYSE,DAY,Equity,,,,']

            result = ImportParams.custom_getcsv(result_b, nl,False,True)
            b = len(result)
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                n['price'] = n['avg trading price'] if 'avg trading price' in n else n['price'] if 'price' in n else ''
                n['price'] = n['price'].replace('.', "", (n['price'].count('.')-1))

                n['qty'] = n['qty'] if 'qty' in n else 0
                n['qty'] = n['qty'].replace('.', "", (n['qty'].count('.')-1))


                njson = json.dumps(n['orderid']) if 'orderid' in n else json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                symbol = ' '.join(symbol.split())

                n['symbol'] = n['symbol'].split(' -')[0].strip()

                n['action'] = 'BUY' if n['b/s'].upper() == 'B' or 'BOT' in n['b/s'].upper() or 'BUY' in n['b/s'].upper() else \
                              'SELL' if n['b/s'].upper() == 'T' or n['b/s'].upper() == 'S' or n['b/s'].upper() == 'SSHRT' or n['b/s'].upper() == 'SS' or 'SLD' in n['b/s'].upper() or 'SELL' in n['b/s'].upper() else ''


                n['fee'] = str(float(n['total'].replace('-', '')) * 0.507038) if 'total' in n and not 'fee' in n  else n['fee'] if 'fee' in n else ''

                quantity = abs(float(n['qty'].replace('-', '').replace('.', '').replace(',', '.').replace(' ', '')))


                if (not n['action'] and n['price']) or n['action'] not in ['BUY', 'SELL'] or not n['price'] or not n['symbol'] or not n['date']:
                    continue

                if 'status' in n and n['status'] and n['status'].upper() == "CANCELED" and quantity == 0:
                    continue

                date_time = n['date'] + ' ' + n['time']
                original_file_row['date_tz'] = date_time
                any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                new_date_time =  ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                fp = n['price']
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 and decimal <= 6 else 6 if decimal > 6 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00

                type = 'share'
                option = 'SHARE'
                expire = ''
                strike = ''

                commission = n['comm'].replace(',', '.').replace('-', '').replace('(', '').replace(')', '') if 'comm' in n else ''
                commission = round(float(commission),2) if commission else 0.00
                fee1 = n['fee 1'].replace('(', '').replace(')', '').replace(',', '.') if 'fee 1' in n and '(' in n['fee 1'] else '-'+n['fee 1'].replace('(', '').replace(')', '').replace(',', '.') if 'fee 1' in n  and n['fee 1'] else ''
                fee1 = round(float(fee1),2) if fee1 else 0.00

                fee2 = n['fee 2'].replace('(', '').replace(')', '').replace('-', '').replace(',', '.') if 'fee 2' in n else ''
                fee2 = round(float(fee2),2) if fee2 else 0.00
                fee3 = n['fee 3'].replace('(', '').replace(')', '').replace('-', '').replace(',', '.') if 'fee 3' in n else ''
                fee3 = round(float(fee3),2) if fee3 else 0.00
                fee4 = n['fee 4'].replace('(', '').replace(')', '').replace('-', '').replace(',', '.') if 'fee 4' in n else ''
                fee4 = round(float(fee4),2) if fee4 else 0.00
                fee5 = n['fee 5'].replace('(', '').replace(')', '').replace('-', '').replace(',', '.') if 'fee 5' in n else ''
                fee5 = round(float(fee5),2) if fee5 else 0.00
                fee6 = n['fee 6'].replace('(', '').replace(')', '').replace('-', '').replace(',', '.') if 'fee 6' in n else ''
                fee6 = round(float(fee6),2) if fee6 else 0.00

                commission = commission
                fees = fee2 + fee3 + fee4 + fee5 + fee6
                swap = fee1

                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = str(commission).replace('-','')
                n['fees'] = fees
                n['njson'] = njson
                n['decimal'] = decimal
                n['original_file_row'] = original_file_row
                n['swap'] = swap
                n['expire'] = expire
                n['strike'] = strike
                n['mistakes'] = n['mistake'] if 'mistake' in n else ''
                n['trade_notes'] = n['notes'] if 'notes' in n else ''

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b - 1

                # out_result.append(n)
        except Exception as err:
            print(traceback.format_exc())
            print(err)
            any_error = 9
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error
