"""
Propreports format detector.

Detects and routes to appropriate interpreter based on data format.
"""

import polars as pl
from pipeline.p01_normalize.exceptions import UnknownFormatError
from .propreports import PropreportsInterpreter

INTERPRETERS = [PropreportsInterpreter]


def detect(df: pl.DataFrame, metadata: dict = None):
    """
    Detect the format of Propreports data and return appropriate interpreter.

    Args:
        df: Input DataFrame to analyze
        metadata: Optional metadata about the data source

    Returns:
        Interpreter instance that can handle the data

    Raises:
        UnknownFormatError: If no interpreter can handle the data
    """
    for cls in sorted(INTERPRETERS, key=lambda x: -x.get_priority()):
        if cls.can_handle(df, metadata or {}):
            return cls()

    raise UnknownFormatError(f"No Propreports format matched. Columns: {df.columns}")
