# Plan: Análisis de Validaciones Críticas Faltantes - Propreports Normalizer

## Status: READY FOR REVIEW - Phase 4 (Final Plan)

---

## Resumen Ejecutivo

Tras analizar las implementaciones legacy (1,280 líneas en 2 archivos) vs nueva (461 líneas + 554 tests), se han identificado las siguientes características clave:

### Nueva Implementación (1,015 líneas totales)

| Archivo | Líneas | Propósito |
|---------|--------|-----------|
| propreports.py | 423 | Main interpreter (JSON API) |
| detector.py | 32 | Format detection |
| __init__.py | 6 | Module exports |
| test_propreports.py | 554 | Comprehensive tests (54 test cases) |
| **TOTAL** | **1,015** | **Production-ready con tests** |

### Legacy Implementación (1,280 líneas totales)

| Archivo | Líneas | Scope |
|---------|--------|-------|
| propreports_export.py | 604 | API integration + validation |
| brokers_propreports.py | 676 | CSV normalization - 3 formats |
| **TOTAL** | **1,280** | **Mixed concerns** |

**Reducción efectiva:** 1,280 líneas (legacy) → 461 líneas (new) = **64% reduction** ✅

### Issue Crítico Confirmado: Portfolio/Reference_Code in Hash

**Hash match rate esperado**: **~0%** ⚠️⚠️⚠️ (Similar a Oanda)

**Causa**: Nueva implementación añade `portfolio` y `reference_code` al order object ANTES de hashear. Legacy NO los añade.

**Evidencia Confirmada:**
- **Legacy (propreports_export.py:476-482)**: Hash sin portfolio/reference_code
- **Nueva (propreports.py:173-178)**: Hash CON portfolio/reference_code añadidos explícitamente
- **Fixture (line 17)**: Dice "100% match" pero describe la fórmula legacy (sin estos campos)

**Impacto**: TODOS los trades se duplicarían en re-imports

### Validaciones Faltantes Identificadas

- **7 validaciones críticas** no implementadas:
  1. Required fields (symbol/date/price/action)
  2. Side validation post-mapping
  3. NASD fee missing from sum
  4. Commission column fallback ('exec' → 'comm')
  5. "COVER" side mapping
  6. CANCELED status skip
  7. Swap calculation from ECN fee

### CSV Support Gap

- **3 CSV parsers** (636 líneas, 50% de legacy) NO implementados
- Requiere SQL query para determinar necesidad

---

## Validaciones Identificadas

### CATEGORÍA 1: CRÍTICO - Hash Computation ⚠️⚠️⚠️

#### 1. Portfolio/Reference_Code in Hash (CRÍTICO)

**Criticidad:** CRÍTICA (afecta ~100% de trades)
**Estado:** INCOMPATIBLE CON LEGACY

**Ubicación Legacy:**
- propreports_export.py:476-482 (hash sin portfolio/reference_code)

**Ubicación Nueva:**
- propreports.py:173-178 (hash CON portfolio/reference_code)

**Problema:**
La nueva implementación añade `portfolio` y `reference_code` al order dict ANTES de hashear. El legacy hashea el order SIN estos campos, resultando en hashes completamente diferentes.

**Evidencia Código:**

**Legacy (propreports_export.py:476-482):**
```python
# Strip milliseconds
order['date/time'] = order['date/time'].split('.')[0]

# Hash WITHOUT portfolio/reference_code
njson = json.dumps(order)
njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
```

**Nueva (propreports.py:173-178):**
```python
# Strip milliseconds
order_for_hash[datetime_key] = dt_value.split('.')[0]

# ADD portfolio and reference_code BEFORE hashing
order_for_hash["portfolio"] = portfolio
order_for_hash["reference_code"] = reference_code

# Hash WITH these fields included
file_row_hash = hashlib.md5(json.dumps(order_for_hash).encode('utf-8')).hexdigest()
```

**Fixture Notes Contradictorios:**
- Fixture line 17 dice: "100% match rate on 20 records"
- Pero describe fórmula legacy: "strip ms from date/time, MD5(json.dumps(order))"
- NO menciona portfolio/reference_code en hash

**Impacto:**
- Hash match rate esperado: **~0%** (similar a Oanda)
- TODOS los trades se duplicarían en re-imports
- Data integrity: 100% ✓ (solo hash afectado)

**Solución Recomendada:**
```python
# propreports.py línea 173-178
# REMOVE portfolio/reference_code from hash computation
# Keep legacy formula for compatibility

# Build order for hash
order_for_hash = dict(order)

# Strip milliseconds (keep this)
if datetime_key in order_for_hash:
    dt_value = str(order_for_hash[datetime_key])
    order_for_hash[datetime_key] = dt_value.split('.')[0]

# DO NOT add portfolio/reference_code to hash
# (Remove lines 174-175)

# Hash the JSON (legacy compatible)
file_row_hash = hashlib.md5(json.dumps(order_for_hash).encode('utf-8')).hexdigest()
```

**Archivo:** `propreports.py` líneas 173-178
**Estimado:** 1-2 días (incluye testing con datos legacy)

---

### CATEGORÍA 2: ALTA - Data Validation Issues

#### 2. Required Fields Validation (ALTA)

**Estado:** FALTANTE

**Ubicación Legacy:**
- propreports_export.py:489-490

```python
if not order['symbol'] or not order['date'] or not order['price'] or not action:
    continue
```

**Estado Nuevo:** Sin validación

**Implementación:**
```python
# propreports.py después de línea 183
symbol = get_value("symbol", "Symbol")
date_time = get_value("date/time", "Date/Time")
price = get_value("price", "Price")
side = get_value("b/s", "B/S")

if not symbol or not date_time or not price or not side:
    logger.warning(
        f"[PROPREPORTS] Skipping order {order.get('propreports id', 'unknown')}: "
        f"missing required fields"
    )
    continue
```

**Archivo:** `propreports.py` línea ~183
**Estimado:** 0.5 días

---

#### 3. NASD Fee Missing from Sum (ALTA)

**Estado:** FALTANTE

**Ubicación Legacy:**
- propreports_export.py:538 (nasd incluido en fees_sum)

**Ubicación Nueva:**
- propreports.py:97-99 (FEE_COLUMNS sin "nasd")

**Implementación:**
```python
FEE_COLUMNS: ClassVar[list] = [
    "ecn fee", "sec", "orf", "cat", "taf", "nfa", "nscc", "nasd", "acc", "clr", "misc"
]

FEE_COLUMNS_ORIGINAL: ClassVar[list] = [
    "Ecn Fee", "SEC", "ORF", "CAT", "TAF", "NFA", "NSCC", "NASD", "Acc", "Clr", "Misc"
]
```

**Archivo:** `propreports.py` líneas 97-104
**Estimado:** 0.1 días

---

#### 4. Side Validation Post-Mapping (MEDIA-ALTA)

**Estado:** FALTANTE

**Ubicación Legacy:**
- brokers_propreports.py:124-125

```python
if n['action'] not in ['BUY', 'SELL']:
    continue
```

**Implementación:**
```python
# propreports.py en normalize() después de side mapping
.filter(pl.col("side").is_in(["BUY", "SELL"]))
```

**Archivo:** `propreports.py` línea ~310
**Estimado:** 0.25 días

---

### CATEGORÍA 3: MEDIA - Field Transformation Differences

#### 5. Commission Column Fallback (MEDIA)

**Estado:** PARCIAL

**Ubicación Legacy:**
- propreports_export.py:544 (fallback de 'exec' a 'comm')

**Nueva:** Solo usa 'comm', sin fallback

**Implementación:**
```python
# propreports.py línea ~330
# Update commission calculation
comm_value = get_value("comm", "Comm")
if not comm_value or str(comm_value).strip() == "0" or str(comm_value).strip() == "":
    comm_value = get_value("exec", "Exec", "0")
```

**Archivo:** `propreports.py` línea ~330
**Estimado:** 0.25 días

---

#### 6. "COVER" Side Mapping (MEDIA)

**Estado:** FALTANTE

**Ubicación Legacy:**
- propreports_export.py:486 (COVER → BUY)

**Implementación:**
```python
SIDE_MAP: ClassVar[dict] = {
    "B": "BUY",
    "BUY": "BUY",
    "COVER": "BUY",  # Add this
    "S": "SELL",
    "SELL": "SELL",
    "SHORT": "SELL",
    "T": "SELL",
}
```

**Archivo:** `propreports.py` líneas 90-94
**Estimado:** 0.1 días

---

#### 7. Swap Calculation from ECN (MEDIA)

**Estado:** DIFERENTE (posible cambio intencional)

**Ubicación Legacy:**
- propreports_export.py:581 (`order['swap'] = ecn*-1`)

**Nueva:** `pl.lit(0.0).alias("swap")`

**Nota:** ECN ahora en "fees", no swap. Clarificar si cambio es intencional.

**Estimado:** 0.5 días (si cambio requerido)

---

### CATEGORÍA 4: CONDICIONAL - CSV Support

#### 8. CSV Parser Support (CONDICIONAL)

**Estado:** NO IMPLEMENTADO

**Legacy Scope:**
- `brokers_propreports.py` - 676 líneas con 3 CSV formats:
  1. **Format 1 (EQUITIES)** - Lines 24-281: Split trades format
  2. **Format 2 (B/S + DATE/TIME)** - Lines 283-421: Combined datetime
  3. **Format 3 (ROUTE)** - Lines 423-676: Route information

**Decisión Requerida:** Ejecutar SQL query

```sql
-- Check CSV usage
SELECT
    COUNT(DISTINCT user_id) as unique_users,
    COUNT(*) as csv_imports,
    MAX(created_at) as last_csv_import
FROM import_files
WHERE broker_id = 240
  AND (file_name LIKE '%.csv' OR content_type = 'text/csv')
  AND created_at >= DATE_SUB(NOW(), INTERVAL 12 MONTH);

-- Format distribution
SELECT
    CASE
        WHEN content LIKE '%EQUITIES%' THEN 'Format 1: EQUITIES'
        WHEN content LIKE '%B/S%' AND content LIKE '%DATE/TIME%' THEN 'Format 2'
        WHEN content LIKE '%ROUTE%' THEN 'Format 3: ROUTE'
    END as format_type,
    COUNT(*) as file_count
FROM import_files
WHERE broker_id = 240
  AND file_name LIKE '%.csv'
  AND created_at >= DATE_SUB(NOW(), INTERVAL 12 MONTH)
GROUP BY format_type;
```

**Criterio:**
- Si CSV percentage > 5%: **IMPLEMENTAR** (3-4 días)
- Si CSV percentage < 5%: **OMITIR**

**Complejidad:** ALTA (3 formats, auto-detection, ~676 líneas)
**Estimado:** 3-4 días (solo si necesario)

---

### CATEGORÍA 5: ALREADY IMPLEMENTED ✅

#### 9-14. Ya Implementadas

- ✅ JSON Validation (parse_json_content validates structure)
- ✅ Timestamp Conversion (handles milliseconds)
- ✅ Symbol Normalization (uppercase, strip +)
- ✅ Option Parsing (OCC format)
- ✅ Asset Type Classification (stocks/options)
- ✅ Fee Summation (10 columns)

---

## Plan de Implementación por Fases

### FASE 1: Critical Hash Fix (1-2 días) ⚠️⚠️⚠️ URGENTE

**Objetivo:** Corregir hash match rate de ~0% a 95%+

**Tareas:**
1. Remove portfolio/reference_code from hash computation (0.5 días)
2. Testing con datos legacy user 4359 (0.5 días)
3. Validación con user 40888 si disponible (0.5 días)
4. Update fixture notes (0.5 días)

**Archivos:**
- `propreports.py:173-178` (hash fix)
- `test_propreports.py` (add hash compatibility tests)

**Métricas de Éxito:**
- [ ] Hash match rate >= 95% (vs actual ~0%)
- [ ] Hashes match legacy para mismo input
- [ ] Data integrity mantenida (100%)
- [ ] Fixture updated con resultados reales

**Complejidad:** ALTA
**Riesgo:** ALTO (critical para deduplication)
**Estimado:** 1-2 días

---

### FASE 2: Data Validation (1.5 días)

**Objetivo:** Prevenir datos inválidos

**Tareas:**
1. Required fields validation (0.5 días)
2. Add NASD to fees (0.1 días)
3. Side validation post-mapping (0.25 días)
4. Commission fallback (0.25 días)
5. "COVER" side mapping (0.1 días)
6. Swap calculation (0.25 días si necesario)

**Archivos:**
- `propreports.py:97-99, 183+, 310+, 330+`
- `test_propreports.py` (add validation tests)

**Métricas de Éxito:**
- [ ] Zero invalid records processed
- [ ] NASD fee included in sum
- [ ] All sides valid after mapping
- [ ] Commission fallback working
- [ ] Rejection rate < 0.1%

**Complejidad:** BAJA-MEDIA
**Riesgo:** BAJO
**Estimado:** 1.5 días

---

### FASE 3: CSV Support (0.5-4 días - CONDICIONAL) 🎯

**BLOQUEADOR:** Ejecutar SQL query primero

**Criterio:**
- Si CSV > 5%: **IMPLEMENTAR** (3-4 días)
- Si CSV < 5%: **DOCUMENTAR como no soportado** (0.5 días)

**Complejidad:** MUY ALTA (3 formats, 676 líneas legacy)
**Riesgo:** MEDIO
**Estimado:** 0.5-4 días

---

## Matriz de Priorización

| # | Validación | Criticidad | Estado | Complejidad | Fase | Días |
|---|------------|-----------|--------|-------------|------|------|
| 1 | Portfolio/Ref in Hash | ⚠️⚠️⚠️ CRÍTICO | INCOMPATIBLE | ALTA | 1 | 1-2 |
| 2 | Required Fields | ⭐⭐⭐ ALTA | MISSING | BAJA | 2 | 0.5 |
| 3 | NASD Fee | ⭐⭐⭐ ALTA | MISSING | BAJA | 2 | 0.1 |
| 4 | Side Validation | ⭐⭐ MEDIA-ALTA | MISSING | BAJA | 2 | 0.25 |
| 5 | Commission Fallback | ⭐⭐ MEDIA | PARTIAL | BAJA | 2 | 0.25 |
| 6 | COVER Mapping | ⭐⭐ MEDIA | MISSING | BAJA | 2 | 0.1 |
| 7 | Swap Calculation | ⭐ MEDIA | DIFFERENT | MEDIA | 2 | 0.25 |
| 8 | CSV Support (3 formats) | 🎯 CONDICIONAL | NOT IMPL | MUY ALTA | 3 | 0.5-4 |
| 9-14 | Ya Implementadas | ✅ DONE | DONE | - | - | 0 |

**Total Fase 1 (Hash Fix):** 1-2 días
**Total Fase 2 (Validations):** 1.5 días
**Total Fase 1-2:** 2.5-3.5 días
**Total Fase 3 (Condicional):** 0.5-4 días adicionales si necesario

---

## Comparación con Otros Brokers

| Broker | Legacy Lines | New Lines | Reduction | Hash Match | Critical Issues | Phase 1-2 Days |
|--------|--------------|-----------|-----------|------------|----------------|----------------|
| **Propreports** | **1,280** | **461** | **64%** ✅ | **~0%** ⚠️⚠️⚠️ | **7** | **2.5-3.5** |
| Oanda | 1,276 | 308 | 76% | ~0% ⚠️⚠️⚠️ | 7 | 3-4.5 |
| Deribit | 326 | 516 | -58% | 74.27% ⚠️ | 5 | 2-3.5 |
| Charles Schwab | 3,196 | 1,087 | 66% | 42% ⚠️ | 6 | 3.5-5.5 |
| OKX | 170 | 362 | -113% | 95-100% ✅ | 5 | 1.25-1.75 |
| KuCoin | 2,015 | 404 | 80% | 100% ✅ | 4-5 | 2.5-3.5 |

**Observaciones Propreports:**
- ⚠️⚠️⚠️ **Issue CRÍTICO con hash** - ~0% match (similar a Oanda)
- ✅ **Good code reduction** - 64% reduction
- ✅ **Strong test coverage** - 554 líneas (54 tests)
- ⚠️ **No CSV support** - 3 parsers (676 líneas) no implementados
- ⚠️ **NASD fee missing** - Afecta accuracy financiera

---

## Archivos Críticos

### 1. `brokers/propreports/propreports.py` (PRINCIPAL)
**Líneas Actuales:** 423
**Estimadas Post-Cambios:** ~470-490 (Fases 1-2)

**Cambios:**
- Líneas 173-178: Hash fix - REMOVE portfolio/reference_code (Fase 1 - CRÍTICO)
- Líneas 97-104: Add NASD to FEE_COLUMNS (Fase 2)
- Líneas 90-94: Add COVER to SIDE_MAP (Fase 2)
- Líneas 183+: Required fields validation (Fase 2)
- Líneas 310+: Side validation filter (Fase 2)
- Líneas 330+: Commission fallback (Fase 2)

### 2. `tests/brokers/test_propreports.py` (TESTS)
**Líneas Actuales:** 554
**Estimadas Post-Cambios:** 650-700

**Tests Nuevos Requeridos:**
- test_hash_without_portfolio_reference_code()
- test_hash_matches_legacy_format()
- test_required_fields_validation()
- test_nasd_fee_included_in_sum()
- test_side_validation_post_mapping()
- test_commission_exec_fallback()
- test_cover_side_mapping()
- test_invalid_records_rejected()

### 3. Legacy Files (REFERENCIA SOLO)
- `old_code_from_legacy/propreports_export.py` (604 líneas)
- `old_code_from_legacy/brokers_propreports.py` (676 líneas - CSV parsers)

---

## SQL Queries para Investigación

### Query 1: Verificar Portfolio en Legacy Data
```sql
SELECT
    fk_user_id,
    COUNT(*) as records,
    SUM(CASE WHEN original_file_row LIKE '%portfolio%' THEN 1 ELSE 0 END) as has_portfolio,
    SUM(CASE WHEN original_file_row LIKE '%reference_code%' THEN 1 ELSE 0 END) as has_ref,
    LEFT(original_file_row, 300) as sample_json
FROM trade_history
WHERE broker_id = 240
  AND fk_user_id IN (4359, 40888)
GROUP BY fk_user_id
LIMIT 5;
```

### Query 2: CSV Usage Check
```sql
SELECT
    COUNT(DISTINCT user_id) as unique_users,
    COUNT(*) as csv_imports,
    MAX(created_at) as last_csv_import,
    ROUND(100.0 * COUNT(*) / (SELECT COUNT(*) FROM import_files WHERE broker_id = 240), 2) as csv_percentage
FROM import_files
WHERE broker_id = 240
  AND (file_name LIKE '%.csv' OR content_type = 'text/csv')
  AND created_at >= DATE_SUB(NOW(), INTERVAL 12 MONTH);
```

### Query 3: Sample Hashes Comparison
```sql
SELECT
    file_row,
    original_file_row,
    symbol,
    price,
    execution_id
FROM trade_history
WHERE fk_user_id = 4359
  AND broker_id = 240
ORDER BY timestamp DESC
LIMIT 5;
```

---

## Conclusión

Análisis identifica **7 validaciones faltantes**:
- **1 CRÍTICA (Fase 1):** 1-2 días - Portfolio/reference_code in hash (~0% match rate)
- **6 ALTA/MEDIA (Fase 2):** 1.5 días - Data validations y field fixes
- **1 CONDICIONAL (Fase 3):** 0.5-4 días si necesario - CSV support (3 formats)

**Hallazgo Clave:** Nueva implementación es **sólida arquitecturalmente** (64% code reduction, 554 tests) pero tiene el **mismo issue crítico de hash que Oanda**:
- ~0% hash match rate esperado (portfolio/reference_code añadidos)
- TODOS los trades se duplicarían sin fix
- Data integrity 100% correcta (solo hash afectado)
- Fixture notes contradictorios sobre "100% match"

**RECOMENDACIÓN FINAL:**
1. **Implementar Fase 1 INMEDIATAMENTE** (1-2 días) - Hash fix CRÍTICO
2. **Implementar Fase 2** (1.5 días) - Data validations
3. **Ejecutar SQL query antes de Fase 3** - Decisión sobre CSV
4. **NO sobre-ingenierizar** - La implementación actual es buena

Total estimado crítico: **2.5-3.5 días**
Total con CSV condicional: **3-7.5 días** (solo si datos muestran necesidad)

---

## Verificación

### Tests a Ejecutar Post-Implementación

**Unit Tests:**
```bash
pytest tests/brokers/test_propreports.py -v
```

**Hash Match Rate Verification:**
```python
def test_hash_match_rate_legacy_compatibility():
    # Load sample trades from user 4359
    # Process with new code
    # Compare hashes with legacy
    # Assert match_rate >= 0.95
```

**Manual Verification:**
```bash
# 1. Verify hash formula
grep "_file_row_hash" logs/propreports.log | head -20

# 2. Verify required fields validation
grep "Skipping order" logs/propreports.log

# 3. Check NASD fee inclusion
# Verify FEE_COLUMNS includes "nasd"

# 4. Verify rejection rate
# Calculate: rejected_orders / total_orders
# Target: < 0.1%
```

---

**Fecha de Análisis:** 2026-01-14
**Broker ID:** propreports (240)
**Formato:** JSON API (stocks, options)
**Assets:** stocks, options (OCC format)
