import re
import hashlib
import json
import traceback

from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required

from .. import_params import ImportParams
from .. security_service import *
from .. logs import create_log
from .. trade.trades_regroups import *
from .. responses import ErrorResponses, SuccessResponses
from dateutil.parser import parse

class BrokerOkex(Resource):

    def getcsv(params, content, date_format='mdy'):
        data = "BrokerOKX"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            content = content.replace(';', '').replace('\nS', ' S').replace('\t',',')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                if 'amount' in row.lower():
                    ath = True
                elif not row:
                    ath = False
                if ath:
                    rl = rl + 1
                    result_b.append(row)
                    if rl == 1:
                        row = row.replace("\r", "")
                        ns = row.split(',')
                        nl = len(ns)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            firstday = False
            if params['date_format']['id'] == 3 or params['date_format']['id'] == 4:
                firstday = True
            b = len(result)
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                amount = float(n['filled amount'].replace(',', '')) if 'filled amount' in n else \
                         float(n['amount'].replace(',', '')) if 'amount' in n else ''
                if not 'side' in n and 'action' in n:
                    n['side'] = n['action']
                action = 'BUY' if 'side' in n and n['side'].upper() in ['BUY',
                                                                        'CLOSE SHORT',
                                                                        'OPEN LONG'
                                                                       ] else \
                         'SELL' if 'side' in n and n['side'].upper() in ['SELL',
                                                                         'CLOSE LONG',
                                                                         'OPEN SHORT'
                                                                        ] else ''
                if not action and 'action' in n:
                    action = n['action'].upper()

                n['symbol'] =  n['symbol'].replace('-','') if 'symbol' in n else n['instrument'].strip().replace('-SWAP','').replace('-','') if 'instrument' in n else ''

                n['action'] = action
                n['price'] = n['avg. price'] if 'avg. price' in n and ImportParams.isfloat(n['avg. price']) else \
                            n['avg. filled price'] if 'avg. filled price' in n and ImportParams.isfloat(n['avg. filled price']) else \
                             n['order price'] if 'order price' in n and ImportParams.isfloat(n['order price']) else \
                             n['filled price'] if 'filled price' in n else ''
                n['date'] = n['order time'] if 'order time' in n else n['time'] if 'time' in n else ''
                if n['action'] not in ['BUY', 'SELL'] \
                    or not n['symbol'] \
                    or not n['price'] \
                    or not ImportParams.isfloat(amount) \
                    or not n['date']:
                    continue
                date_format = '%m/%d/%Y %H:%M:%S'
                if firstday:
                    try:
                        date_split = ImportParams.parse_date(n['date'], firstday)
                    except:
                        pass
                else:
                    date_split = parse(n['date'])
                date_split = str(date_split.strftime(date_format))

                original_file_row['date_tz'] = date_split
                any_error, date, time = ImportParams.get_param_datetime(date_split,b,date_format)
                new_date_time = ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]


                fp = n['price'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00
                n['size'] = 1
                if abs(price) < 0.01:
                    n['size'] = 10000
                elif abs(price) < 0.1:
                    n['size'] = 1000
                elif abs(price) < 1:
                    n['size'] = 100

                type = 'crypto'
                option = 'CRYPTO'
                expire = ''
                strike = ''

                if 'trade type' in n and 'futures' in n['trade type'].lower():
                    extract = n['symbol'].split('-')
                    expire = extract[-1]
                    n['symbol'] = extract[0] + extract[1]
                    try:
                        date_format = "%y%m%d"
                        de = datetime.strptime(expire, date_format)
                    except:
                        de = parse(expire)
                    expire = de.strftime('%d %b %y').upper()
                    n['symbol'] = "{}|{}".format(n['symbol'], expire)

                quantity = abs(amount)
                commission = 0.00
                fee = n['fee'].replace('-','') if 'fee' in n and not '0E-8' in n['fee'] else ''
                fee = ImportParams.Extract_Numbers(str(fee))

                fee = round(float(fee),2) if fee else 0.00
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = fee
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['original_file_row'] = original_file_row

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b - 1

                # out_result.append(n)
        except Exception as err:
            print(traceback.format_exc())
            any_error = 9

        if not any_error and not out_result:
            any_error=9
        return out_result, any_error
