import traceback
from flask_restful import Resource, request
from flask_jwt_extended import jwt_required
from ..models import BrokersConnections, Portfolios, PortfolioReferences, PortfolioAdjustment, \
                      PortfolioAdjustmentType, BrokersApis, TradesHistories, \
                      TempOrders, TradesHistories, Trades, HandlingErrorsLog
from ..portfolio.adjustment import PortfolioAdjustmentDefinition as pad
from ..responses import ErrorResponses, SuccessResponses
from ..user.users_params import *
from ..import_params import ImportParams
from ..trade.trades_regroups import *
import time
from datetime import timedelta
from .brokers_export import BrokerExport
from ..event.events import UserEventList as EventUser
#from requests.exceptions import ConnectionError
import requests
import json
from urllib.parse import urlencode


class Oandav2Export(BrokerExport, ServerInfo, Resource):

    @verify_role('broker export')
    def post(self):
        try:
            """
            self.data = {"portfolio":"","broker":"tda","auto_login":true,"partial":true}
            """
            version = {}
            self.orders_execid = []
            self.data = request.json
            # Start synchronization and update progress
            new_event_id=self.init_sync()
            self._update_progress('Saving Pre-Data', '1%')
            if not isinstance(new_event_id,UserEvents) and not self.is_lambda():
                return new_event_id
            self.headers = {}
            self.orders_filerow = ImportParams.filerow_orders(self.params['get_session_userid'],
                                                                    var_sync='id', 
                                                                    broker=self.params['broker']
                                                                )
            for credential in self.credentials:
                self.credential = credential
                self._update_progress('Checking Credentials', '5%')
                self.not_error = self.validate()
                if self.not_error != True:
                    _end = self.end_sync(code=1)
                    if _end != True:
                        return _end
                self.symbols = []
                self.credential = None
                self.credential = credential
                self._update_progress('Login', '5%')
                self.not_error = self.login()
                if self.not_error != True:                    
                    self.test_account = not self.test_account
                    self.host = "https://api-fxpractice.oanda.com" if self.test_account == True else "https://api-fxtrade.oanda.com"
                    self._update_progress('Try Login Again', '5%')
                    not_error = self.login()
                    if not_error != True:
                        self.not_error = "{}|{}".format(self.not_error, not_error)
                        _end = self.end_sync(code=10)
                        if _end != True:
                            return _end
                self._update_progress('Save Account', '6%')
                self.save_account(self.account)
                
                # self.sessions.append(self.session)
                #if self.credential:
                    #self.symbols = self.symbols + self.credential.symbols_list

                #if self.data['symbols'] != [] and self.symbols == [] and (
                #        'add' in self.data or self.data['add'] == True):
                #    self.symbols = self.data['symbols']
                self.orders = []
                self.all_orders = []
                self.account_pusher = "Not Account Found"
                
                self.account_pusher = 'Account #' + str(self.secret_key)
                self.id_account = self.secret_key
                #self.account = self.secret_key
                self.time_out_lambda=False
                if self.condition_lambda() and not self.aws_autosync:
                    try:
                        self.not_error = self.call_lambda()
                    except Exception as err:
                        #print(err)
                        #print(traceback.print_exc())
                        self.not_error = err
                        self.executed_lambda = False

                
                if not self.executed_lambda:
                    #self.get_symbols()
                    self._update_progress('Connecting to Oanda', '15%')

                    self._update_progress('Saving data from Oanda', '16%')
                    self.save_configs()


                    self._update_progress('Retrieving orders', '18%')
                    self.not_error = self.get_orders()
                    if self.not_error != True:
                        _end = self.end_sync(code=7)
                        if _end != True:
                            return _end

                    #self.all_orders = self.all_orders + self.orders
                    self.orders = self.all_orders
                    
                    self._update_progress('Save Files', '19%')
                    self.save_files(file_type='json')
                    self._update_progress('Reading orders', '19%')
                    #self.interpret_orders()
                    #self.orders_filerow = []
                    #self.orders_filerow = ImportParams.filerow_orders(self.params['get_session_userid'],
                    #                                                var_sync='id', 
                    #                                                broker=self.params['broker']
                    #                                            )
                    self.not_error = self.interpret_save_orders()
                    if self.not_error != True:
                        self.not_error = str(self.not_error)
                        _end = self.end_sync(code=0)
                        if _end != True:
                            return _end

                    #UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, True)
                    #self.pusher_title = self.account_pusher + ' - Preparing all to save orders'
                    #self.pusher_message = '20%'
                    #self.pusher_complete = False
                    #self.send_pusher()
                    
                    #self.save_orders()

                if len(self.api_key_information) > 0:
                    self.check_status_connection_db()
                    self.user.users_configs.tda_import = True
                    self.user.users_configs.save()
                    self.not_error  = self.save_params()
                    mgs = getattr(self.out, 'mgs', 'successfully')
                    self.sync_status(healthy=True, message=mgs, status_code=200)
                
                else:
                    self._update_progress('warning', 'Not accounts founds', True)
                    self.errors.append(
                        str(self.not_error) + ' for Account #' + self.secret_key) 
                    self.sync_status(healthy=False, message=str(self.not_error))
                    if len(self.credentials) <= 1:
                        return ErrorResponses.error_500(self.data, 'Not accounts founds', version)
                    else:
                        continue
                    
            # TERMINA LA ITERACION
            return self.end_sync(event_id=new_event_id)

        except Exception as err:
            #UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, True)
            self.unlock_portfolios()
            self._update_progress('warning', 'Imported Fail', True)
            if self.is_lambda() and self.can_call_lambda():
                self.save_params_lambda((int(time.time()) - self.star_timestamp), 500, 'Fail')
            return ErrorResponses.error_500(self.data, err, version)

    def validate(self):
        try:
            self.data = request.json
            self.user.users_configs.not_warning_import = self.data.get('not_warning_import', True)
            self.symbols = self.data.get('symbols', self.symbols)
            self.user.users_configs.save()
            self.auto_import = self.data['auto_import'] if 'auto_import' in self.data else False

            if self.credential and self.add == False:
                #self.credential = BrokersConnections.find_by(**{'user_id':self.user.id, "broker_id":self.broker.broker_id, 'active': True})
                self.api_key = self.credential.api_key
                self.secret_key = self.credential.secret_key
                self.test_account = self.credential.test_account
                self.new_sync = self.credential.new_sync
                self.account = self.credential.account
                # self.content_type = 'application/x-www-form-urlencoded'
            else:
                # self.symbols = self.data['symbols']
                self.api_key = self.data['api_key'].strip()
                self.secret_key = self.data['secret_key'].strip()
                self.account = self.data['secret_key'].strip()
                self.test_account = self.data['test_account']  if 'test_account' in self.data and self.data['test_account'] != "" else False
                self.new_sync = True
                self.add = self.data.get('add', False)

            self.host = "https://api-fxpractice.oanda.com" if self.test_account == True else "https://api-fxtrade.oanda.com"
            self.headers = {
                "Authorization": f"Bearer {self.api_key}",
                "Accept-Datetime-Format": "UNIX"
            }

            return True

        except Exception as err:
            #print("Exception", err)
            #print(traceback.print_exc())
            if not self.credential:
                return "Wrong credentials"

            # self.symbols = self.credential.symbols
            self.api_key = self.credential.api_key
            self.secret_key = self.credential.secret_key
            self.test_account = self.credential.test_account
            self.host = "https://api-fxpractice.oanda.com" if self.test_account == True else "https://api-fxtrade.oanda.com"
            
            # self.content_type = 'application/x-www-form-urlencoded'
            self.user.users_configs.not_warning_import = True
            self.user.users_configs.save()
            self.data = None

    def login(self):
        try:
            self.api_key_information = []
            endpoint_accounts = f'/v3/accounts/{self.secret_key}/summary'
            
            
            response = requests.request('GET', self.host + endpoint_accounts, headers=self.headers)
            if response.status_code == 200:
                self.api_key_information = response.json()['account']
                return True
            else:
                err = response.json()
                return err['errorMessage'] if 'errorMessage' in err else err['rejectReason']
        except Exception as e:
            #print(e)
            #print(traceback.print_exc())
            #return 'Wrong login credentials'
            return e

    def get_symbols(self):
       return True

    def get_orders(self):
        try:
            last_date = self.get_last_date_a(user_account=self.account)
            last_time = 0 if self.data.get('partial', False) == False else last_date
            start_time = int(last_time)
            limit=500
            endpoint = f'/v3/accounts/{self.secret_key}/trades'
            params = {'state': 'CLOSED', 'count': limit}
            if last_time == 0:
                initial_date = datetime.fromtimestamp( float(self.api_key_information['createdTime']) )
            else:
                initial_date = datetime.fromtimestamp(start_time) 
            today=datetime.now()
            
            while True:
                response = requests.request("GET", f"{self.host}{endpoint}?{urlencode(params)}", headers=self.headers)
                trades = response.json()
                if len(trades['trades']) > 0:
                    for trade in trades["trades"]:
                        try:
                            open_time = datetime.fromtimestamp(float(trade['openTime']) )
                            if (self.data.get('partial', False)==True and (last_date or last_date != 0)) and (open_time <= initial_date or open_time >= today):
                                continue 
                            trade['instrument']=trade['instrument'].replace('_', '')
                            trade['instrument']='$'+trade['instrument']
                            if not 'averageClosePrice' in trade:
                                continue
                            if float(trade['realizedPL'])==0:
                                continue
                            if float(trade['realizedPL'])>0 and float(trade['price']) > float(trade['averageClosePrice']):                  
                                trade['buy/sell']='SELL'
                            elif float(trade['realizedPL'])>0 and float(trade['price']) < float(trade['averageClosePrice']):
                                trade['buy/sell']='BUY'
                            elif float(trade['realizedPL'])<0 and float(trade['price']) > float(trade['averageClosePrice']):
                                trade['buy/sell']='BUY' 
                            elif float(trade['realizedPL'])<0 and float(trade['price']) < float(trade['averageClosePrice']):
                                trade['buy/sell']='SELL' 
                            if float(trade['initialUnits']) > 0:
                                trade['currentUnits']=trade['initialUnits']
                            else:
                                trade['currentUnits']=abs(float(trade['initialUnits']))
                            trade['AccountID']=self.secret_key
                            self.all_orders.append(trade)
                            sell={}
                            try:
                                sell['AccountID']=self.secret_key
                                sell['id']=trade['id']
                                sell['instrument']=trade['instrument']
                                sell['price']=trade['averageClosePrice']
                                sell['openTime']=trade['closeTime']
                                sell['initialUnits']=trade['initialUnits']
                                sell['initialMarginRequired']=trade['initialMarginRequired']
                                sell['state']=trade['state']
                                if float(trade['initialUnits']) > 0:
                                    sell['currentUnits']=trade['initialUnits']
                                else:
                                    sell['currentUnits']=abs(float(trade['initialUnits']))
                                sell['buy/sell'] = 'BUY' if trade['buy/sell'] == 'SELL' else 'SELL'
                                self.all_orders.append(sell)
                            except Exception as err:
                                continue
                        except Exception as err:
                            #print(err)
                            #print(traceback.print_exc())
                            continue
                if len(trades['trades']) < limit:
                    break
                else:
                    params['beforeID'] = trades['trades'][-1]['id']
            
            return True
        except Exception as ex:
            #print(ex)
            #print(traceback.print_exc())
            return str(ex)
    
    def interpret_orders(self):
        pip_value_order = dict()
        result_b = []
        b=0
        new_date_time = []
        verify_njson_len = 0
        i = 0
        order_len = len(self.all_orders)
        verify_njson_len = 0
        
        for order in self.all_orders:
            i+=1          
            try:
                original_file_row = json.loads(json.dumps(order))
                njson = json.dumps(order)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                action = order['buy/sell'].upper() if 'buy/sell' in order else order['side'].upper() if 'side' in order else order['transaction category'].upper() if 'transaction category' in order else 'buy'
                action = 'BUY' if action == 'BUY' or action=='COVER' else 'SELL' if action == 'SELL' or action == 'SHORT' else 'buy'
                order['symbol']  = order['instrument'] if 'instrument' in order else ''
                
                base = order['marginAsset'] if 'marginAsset' in order else None
                # order['time']  =timestamp_set_tz
                order['date'] = order['openTime'] if 'openTime' in order else order['createTime']
                order['date'] = datetime.fromtimestamp(float(order['date'])  ).strftime("%Y-%m-%d %H:%M:%S")
                order['type'] = order['filled type'].upper() if 'filled type' in order else order['types'].upper() if 'types' in order else 'TRADE'
                order['quantity'] = order['origQty'] if 'origQty' in order else order['units'] if 'units' in order else order['currentUnits']
                order['price'] = order['exec price'] if 'exec price' in order else order['executed price'] if 'executed price' in order else order['price'] if 'price' in order else '0'
                # if not order['symbol'] or not order['date'] or not order['price'] or not action or order['type'] != "TRADE":
                #     print('aqiu')
                #     continue
                if "realizedPL" in order and float(order['realizedPL']) ==0:
                    continue
                if 'status' in order and order ['status'] != 'FILLED':
                    continue
                if 'isBuyer' in order:
                    action = 'BUY' if order['isBuyer'] == True else 'SELL'
                if not action:
                    continue
                pip_value = 1
                date_time = order['date']
                original_file_row['date_tz'] = date_time
                self.any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                new_date_time = ImportParams.convert_date(date, time, self.date_format,True,'UTC')
            except Exception as ex:
                #print(ex)
                #print(traceback.print_exc())
                continue

            order['date'] = new_date_time[0]
            order['time'] = new_date_time[1]
            fp = str(order['price']).replace(',', '').replace('$','')
            decimal = fp[::-1].find('.')
            decimal = decimal if decimal > 1 else 2
            price = round(float(fp),decimal)
            #price = round(float(order['price'].replace(',', '')),6)

            sm = len(order['symbol'])
            sym = order['symbol'][-3:]
            type = 'forex'
            option = 'FOREX'
            strike = ''
            expire = ''
            order['size'] = 1
            
            ################# PIP VALUE ####################
            if 'id' in order and 'realizedPL' in order:
                if i <= order_len:
                    try:
                        price1 = float(self.all_orders[i]['price'])
                        price2 = float(order['price'])
                        qty = float(order['quantity'])
                        profit = float(order['realizedPL'])
                        price3 = abs(price1 - price2)
                        pip_value =  abs(profit / (price3 * qty)) if price3 > 0 else 0
                        self.all_orders[i]['pip_value'] = pip_value
                    except:
                        continue
                    
                if not pip_value:
                    pip_value = float(ImportParams.value_pip_forex(order['date'],sym))    
            else:
                if 'pip_value' in order:
                    pip_value = order['pip_value']
                else:    
                    pip_value = float(ImportParams.value_pip_forex(order['date'],sym))
            if 'pair' in order:
                order['size'] = 10
                pip_value = self.convert_usdt(order, pip_value_order, date )
            #################### VERIFY FILE ROW ######################
            try:
                order_id = ''
                portfolio_ = self.params['user_portfolio']
                if 'id' in order and order['id']:
                    order_id = order['id']
                valid_file_row = ImportParams.validate_filerow(self.orders_filerow, 
                                                               njson=njson, 
                                                               order_id=order_id,
                                                               date_tz=original_file_row['date_tz'],
                                                               price=fp,
                                                               option=option,
                                                               action=action,
                                                               quantity=str(order['quantity']).replace(',', ''),
                                                               strike=strike,
                                                               expire=expire,
                                                               portfolio=portfolio_
                                                              )
                if valid_file_row:
                    verify_njson_len = verify_njson_len + 1
                    continue
            except:
                #print(traceback.format_exc())
                pass
            ##########################################################

            
            #order['symbol']  ='${}|{}'.format(order['symbol'],i)   
            order['trade_notes'] = order['trade_notes'] if 'trade_notes' in order else ''
            order['type_stock'] = type
            order['type_option'] = option
            order['action'] = action
            order['price'] = fp
            order['shares'] = str(order['quantity']).replace(',', '')
            order['comm'] = order['commission'].replace(',', '').replace('$','') if 'commission' in order else '0.00'
            order['njson'] = njson
            order['decimal'] = decimal
            order['expire'] = expire
            order['strike'] = strike
            order['pip_value'] = pip_value

            order['original_file_row'] = original_file_row
            order['broker'] = self.params['broker']
            order['userid'] = self.params['get_session_userid']
            order['portfolio'] = self.params['user_portfolio']
            #order['portfolio'] = self.params['user_portfolios'][order['AccountID']]
            valor= order['portfolio']
            broker=self.params['broker']
            data_item = ImportParams.get_result_append(order)
            self.out_result.append(data_item)
            b = b + 1