import traceback
from flask_restful import Resource, request
from ..security_service import verify_role
from ..models import BrokersConnections
from ..responses import ErrorResponses, SuccessResponses
from ..user.users_params import *
from ..import_params import ImportParams
from ..trade.trades_regroups import *
from datetime import datetime
import time as tt
from .brokers_export import BrokerExport
from ..event.events import UserEventList as EventUser
import requests
import json
from oandapyV20 import API    # the client
from oandapyV20.exceptions import V20Error
import oandapyV20.endpoints.trades as trades
import oandapyV20.endpoints.accounts as accounts

class OandaExport(BrokerExport, ServerInfo, Resource):
    @verify_role('broker export')
    def post(self):
        try:
            """
            self.data = {"portfolio":"","broker":"tda","auto_login":true,"partial":true}
            """
            version = {}
            self.orders_execid = []
            self.data = request.json
            
            # Start synchronization and update progress
            self._update_progress('Saving Pre-Data', '1%')
            new_event_id=self.init_sync()
            if not isinstance(new_event_id,UserEvents) and not self.is_lambda():
                return new_event_id

            
            if len(self.credentials) == 0:
                self.credentials = [None]
            
            for credential in self.credentials:
                self.credential = credential
                self.not_error = self.validate()
                self._update_progress('Checking Credentials', '5%')
                
                if self.not_error != True:
                    UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
                    if self.credential:
                        self.errors.append(
                            str(self.not_error.message) + ' for Account #' + self.apy_key)
                        self.credential.credential_healthy = False
                        self.credential.sync_status = self.not_error.message
                        self.credential.save()
                    if len(self.credentials) <= 1:
                        return ErrorResponses.error_400(message=self.not_error, status='warning',origen='broker_sync',code=1)
                    else:
                        continue
                if self.backend_domain_name() == 'https://api.tradersync.comkca dc asdv sd cksd k ':
                    UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
                    title = 'The connection has been temporarily disabled due to a connection issue. The dev team is working on it and it should be back in a couple of days'

                    return ErrorResponses.error_400(message=title, status='warning',origen='broker_sync')

                #if 'localhost' in self.backend_domain_name():
                    #ESTE METODO SOLO SE LLAMADESDE LOCAL
                self.not_error = self.login()
                if self.not_error != True:
                    UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, True)
                    if not isinstance(self.not_error, str):
                        title = self.not_error['errorMessage'] if self.not_error['errorMessage'] != 'Invalid Api-Key ID.' else 'Invalid Api-Key'
                        if self.credential:
                            self.errors.append(
                                str(self.not_error['errorMessage']) + ' for Account #' + self.credential.account)
                            self.credential.credential_healthy = False
                            self.credential.sync_status = title
                            self.credential.save()
                        if len(self.credentials) <= 1:
                            return ErrorResponses.error_400(message=title, status='warning',origen='broker_sync')
                        else:
                            continue
                    else:
                        if self.credential:
                            self.errors.append(
                                str(self.not_error) + ' for Account #' + self.credential.account)
                            self.credential.credential_healthy = False
                            self.credential.sync_status = self.not_error
                            self.credential.save()
                        if len(self.credentials) <= 1:
                            return ErrorResponses.error_400(message=self.not_error, status='warning',origen='broker_sync')
                        else:
                            continue
                self.not_error = self.get_account()
                if self.not_error != True:
                    UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, True)
                    if not isinstance(self.not_error, str):
                        title = self.not_error['errorMessage'] if self.not_error['errorMessage'] != 'Invalid Api-Key ID.' else 'Invalid Api-Key'
                        if self.credential:
                            self.errors.append(
                                str(self.not_error['errorMessage']) + ' for Account #' + self.credential.account)
                            self.credential.credential_healthy = False
                            self.credential.sync_status = title
                            self.credential.save()
                        if len(self.credentials) <= 1:
                            return ErrorResponses.error_400(message=title, status='warning',origen='broker_sync')
                        else:
                            continue
                    else:
                        if self.credential:
                            self.errors.append(
                                str(self.not_error) + ' for Account #' + self.credential.account)
                            self.credential.credential_healthy = False
                            self.credential.sync_status = self.not_error
                            self.credential.save()
                        if len(self.credentials) <= 1:
                            return ErrorResponses.error_400(message=self.not_error, status='warning',origen='broker_sync')
                        else:
                            continue
                    
                can_execute=True
                if self.condition_lambda():
                    try:
                        can_execute=False
                        response = self.call_lambda()
                        if 'status' in response:
                            if response['status'] == 'warning':
                                if self.credential:
                                    self.errors.append(
                                        str(response['message']) + ' for Account #' + self.credential.account)
                                    self.credential.credential_healthy = False
                                    self.credential.sync_status = response['message']
                                    self.credential.save()
                                if len(self.credentials) <= 1:
                                    return ErrorResponses.error_400(status=response['status'], message=response['message'])
                                else:
                                    can_execute=True
                        else:
                            can_execute=True
                                
                            
                    except Exception as err:
                        #print(err)
                        #print(traceback.print_exc())
                        can_execute=True
                
                if can_execute:
                    #print('esto no pasa', self.not_error)
                    self.pusher_title = 'Connecting to the oanda server'
                    self.pusher_message = '6%'
                    self.pusher_complete = False
                    self.send_pusher()
                    
                    

                    self.save_configs()
                    self.pusher_title = 'Saving data from oanda'
                    self.pusher_message = '10%'
                    self.pusher_complete = False
                    self.send_pusher()
                    
                    self.pusher_title = 'Get orders from Oanda'
                    self.pusher_message = '18%'
                    self.pusher_complete = False
                    self.send_pusher()
                    self.not_error,error=self.get_oanda_orders()
                    #print("not error", self.not_error)
                    mensaje=str(error)
                    title=""
                    if self.not_error != True:
                        if "Insufficient" in mensaje:
                            title="wrong credentials"
                        elif "accountID" in mensaje:
                            title="value invalid for account id"
                        elif "forbidden" in mensaje:
                            title="wrong credentials"
                        else:
                            title="Error with Oanda please try again"
                        UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
                        if self.credential:
                            self.errors.append(
                                str(mensaje) + ' for Account #' + self.credential.account)
                            self.credential.credential_healthy = False
                            self.credential.sync_status = title
                            self.credential.save()
                        if len(self.credentials) <= 1:
                            return ErrorResponses.error_400(message=mensaje, status='warning',origen='broker_sync',code=1)
                        else:
                            continue

                    self.pusher_title = 'Get accounts from Oanda'
                    self.pusher_message = '18%'
                    self.pusher_complete = False
                    self.send_pusher()
                    self.save_account(self.secret_key)
                    self.save_files(file_type='json')
                    
                    
                    self.pusher_title = 'Account '+self.secret_key+' - Reading orders'
                    self.pusher_message = '19%'
                    self.pusher_complete = False
                    self.send_pusher() 
                    self.interpret_orders()
                    self.save_orders()
                    if not self.is_lambda() or not self.can_call_lambda():
                        UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
                    self.user.users_configs.tda_import = True
                    self.user.users_configs.save()

            
                    if len(self.credentials) <= 1:
                        self.not_error  = self.save_params()
                    
            getattr(self.out, 'mgs', 'successfully')
            try:
                event_success = EventUser.update_user_events(new_event_id, {"message" : self.out['mgs'], 'request':self.data})
            except:
                pass
            msg = self.out['mgs'] if 'mgs' in self.out else 'successfully'
            self.pusher_title = 'Import completed'
            self.pusher_message = msg
            self.pusher_complete = True if len(self.credentials) <= 1 and not self.is_lambda()  else False
            self.send_pusher()
            
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(tt.time())-self.star_timestamp), 200, 'Success')
            return SuccessResponses.success_200(
                data='export',
                message=msg, out=self.all_orders)
        except Exception as err:
            UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
            self.pusher_title = 'warning'
            self.pusher_message = 'Imported Fail'
            self.pusher_complete = True
            self.send_pusher()
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(tt.time())-self.star_timestamp), 500, 'Fail') 
            return ErrorResponses.error_500(self.data, err, version)

    def validate(self):
        try:
            self.data = request.json
            self.user.users_configs.not_warning_import = self.data.get('not_warning_import',True)
            self.symbols = self.data.get('symbols',self.symbols)
            self.user.users_configs.save()
            self.auto_import = self.data['auto_import'] if 'auto_import' in self.data else False
            if 'timezone' in self.data and self.data['timezone']:
                self.params['timezone'] = self.data['timezone']


            if self.credential:
                self.api_key = self.credential.api_key
                self.secret_key = self.credential.secret_key
                self.test_account =  self.credential.test_account
                self.new_sync =  self.credential.new_sync
            else:
                if self.data['api_key'] =='' or self.data['secret_key'] == '' or self.data['test_account']=='':
                    return "Wrong credentials"

                self.credential = BrokersConnections.find_by(**{'user_id':self.user.id, "broker_id":self.broker.broker_id, 'active': True})
                self.api_key = self.data['api_key'].strip()
                self.secret_key = self.data['secret_key'].strip()
                self.test_account =  self.data['test_account']
                self.new_sync = True
            return True

        except Exception as err:
            #print(err)
            #print(traceback.print_exc())
            if not self.credential:
                return "Wrong credentials"

            self.api_key = self.credential.api_key
            self.secret_key = self.credential.secret_key
            self.test_account =  self.credential.test_account
            self.user.users_configs.not_warning_import = True
            self.user.users_configs.save()
            self.data = None

    def login(self):
        if self.test_account:
            environment='practice'
        else:
            environment='live'
        try:
            self.session  = API(environment=environment,access_token=self.api_key)


        except Exception as err:
            # if self.session.get_account_api_permissions()['result'] is None:
            #     return ErrorResponses.error_400(message=self.session.api_key_info()['ret_msg'], status='warning')
            #print('en este error antes de if')
            
            error = json.loads(err.msg)
            return str(error['errorMessage'])  
        return True

    def get_account(self):
        try:
            r = accounts.AccountList()
            self.session.request(r)
        except Exception as err:
            error = json.loads(err.msg)
            return str(error['errorMessage'])   
        # print(response.__dict__)
        self.save_accounts(self.accounts)
        self.save_files(file_type='json')
        return True

    def get_oanda_orders(self):
        #print('get spot order')
        try:
            get_orders_event = EventUser.post_user_events(100, new_user=self.user_id)
        except:
            pass
        self.orders = []
        self.all_orders = []
        futures_orders = None
        spot_orders = None
        futures_symbols = []
        spot_symbols = []
        self.accounts = []
        count=0
        f = 1
        if  self.credential:
            self.credential.first_trade = list(sorted(self.credential.first_trade, key=lambda i: i['symbol'])) if self.credential.first_trade else []
        symbol_count = 0
        start_time = 0
        paginated = False
        last_date = self.get_last_date_a()
        beforeID = 500000 if self.data['partial'] == False else None
        params ={
         
          "beforeID":beforeID,
          "state":"ALL",
          "count":500,
          #"instrument":'SPX500_USD'
        }
        try:
            r = accounts.AccountList()
            self.session .request(r)
            
            initialDate='01-01-2024'
            initialDate = datetime.strptime(initialDate, '%d-%m-%Y')
            #CurrentDate='18-02-2024'
            #CurrentDate = datetime.strptime(CurrentDate, '%d-%m-%Y')
            for i in r.response['accounts']:
             row={}
             row['AccountID']=i['id']
             self.accounts.append(row)
             resp = trades.TradesList(i['id'],params=params)
             tradesList=self.session .request(resp)
             for trade in tradesList["trades"]:
              
              #if trade['state']=='CLOSED':
               # trade['currentUnits']=1
              try:
               openTime=str(trade['openTime'])[:10]
               openTime = datetime.strptime(openTime, '%Y-%m-%d')
               if (self.data['partial']==True and (last_date or last_date != 0)) and (openTime<initialDate or openTime>datetime.now()):
                   continue 
               trade['instrument']=trade['instrument'].replace('_', '')
               trade['instrument']='$'+trade['instrument']
               if not 'averageClosePrice' in trade:
                continue
               if float(trade['realizedPL'])==0:
                continue
               if float(trade['realizedPL'])>0 and float(trade['price']) > float(trade['averageClosePrice']):                  
                trade['buy/sell']='SELL'
               elif float(trade['realizedPL'])>0 and float(trade['price']) < float(trade['averageClosePrice']):
                trade['buy/sell']='BUY'
               elif float(trade['realizedPL'])<0 and float(trade['price']) > float(trade['averageClosePrice']):
                trade['buy/sell']='BUY' 
               elif float(trade['realizedPL'])<0 and float(trade['price']) < float(trade['averageClosePrice']):
                trade['buy/sell']='SELL' 
               if float(trade['initialUnits']) > 0:
                trade['currentUnits']=trade['initialUnits']
               else:
                trade['currentUnits']=abs(float(trade['initialUnits']))
               trade['AccountID']=i['id']
               self.all_orders.append(trade)
               sell={}
               try:
                sell['AccountID']=i['id']
                sell['id']=trade['id']
                sell['instrument']=trade['instrument']
                sell['price']=trade['averageClosePrice']
                sell['openTime']=trade['closeTime']
                sell['initialUnits']=trade['initialUnits']
                sell['initialMarginRequired']=trade['initialMarginRequired']
                sell['state']=trade['state']
                if float(trade['initialUnits']) > 0:
                 sell['currentUnits']=trade['initialUnits']
                else:
                 sell['currentUnits']=abs(float(trade['initialUnits']))
                sell['buy/sell'] = 'BUY' if trade['buy/sell'] == 'SELL' else 'SELL'
                self.all_orders.append(sell)
               except Exception as err:
                continue
               count+=1
              except Exception as err:
               continue
             
            #r=orders.OrderList('101-011-24271270-001')
        except V20Error as err:
            return False,err

    
        #print(count)
        self.all_orders = self.list_futures_account_trades + self.all_orders
        self.orders=self.all_orders
            # spot_orders = self.session.get_my_trades( limit = 1000 ,  endTime = endTime )
            # self.all_orders = spot_orders + self.all_orders
            # coin_futures_orders = self.session.futures_coin_account_trades(limit = 1000, endTime = endTime)
            # self.all_orders = coin_futures_orders + self.all_orders

            # print('en esta mierda',datetime.utcfromtimestamp(tt.time()).strftime('%Y-%m-%d %H:%M:%S'))
        f = f +1
        # exit()
        #print("todas las ordenes ", self.all_orders)
        self.list_futures_account_trades = self.all_orders

        return True,""

    def interpret_orders(self):
        try:
            interpreter_orders_event = EventUser.post_user_events(101, new_user=self.user_id)
        except:
            pass
        pip_value_order = dict()
        result_b = []
        b=0
        new_date_time = []
        verify_njson_len = 0
        i = 0
        order_len = len(self.all_orders)
        verify_njson_len = 0
        orders_filerow = []
        orders_filerow = ImportParams.filerow_orders(self.params['get_session_userid'],
                                                         var_sync='id', 
                                                         broker=self.params['broker']
                                                     )
        for order in self.all_orders:
            i+=1          
            original_file_row = json.loads(json.dumps(order))
            njson = json.dumps(order)
            njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
            action = order['buy/sell'].upper() if 'buy/sell' in order else order['side'].upper() if 'side' in order else order['transaction category'].upper() if 'transaction category' in order else 'buy'
            action = 'BUY' if action == 'BUY' or action=='COVER' else 'SELL' if action == 'SELL' or action == 'SHORT' else 'buy'
            order['symbol']  = order['instrument'] if 'instrument' in order else ''
            
            base = order['marginAsset'] if 'marginAsset' in order else None
            # order['time']  =timestamp_set_tz
            order['date'] = order['openTime'] if 'openTime' in order else order['createTime']
            order['type'] = order['filled type'].upper() if 'filled type' in order else order['types'].upper() if 'types' in order else 'TRADE'
            order['quantity'] = order['origQty'] if 'origQty' in order else order['units'] if 'units' in order else order['currentUnits']
            order['price'] = order['exec price'] if 'exec price' in order else order['executed price'] if 'executed price' in order else order['price'] if 'price' in order else '0'
            # if not order['symbol'] or not order['date'] or not order['price'] or not action or order['type'] != "TRADE":
            #     print('aqiu')
            #     continue
            if "realizedPL" in order and float(order['realizedPL']) ==0:
                continue
            if 'status' in order and order ['status'] != 'FILLED':
                continue
            if 'isBuyer' in order:
                action = 'BUY' if order['isBuyer'] == True else 'SELL'
            if not action:
                continue
            pip_value = 1
            date_time = order['date']
            original_file_row['date_tz'] = date_time
            self.any_error, date, time = ImportParams.get_param_datetime(date_time,b)
            new_date_time = ImportParams.convert_date(date, time, self.date_format,True,'UTC')

            order['date'] = new_date_time[0]
            order['time'] = new_date_time[1]
            fp = str(order['price']).replace(',', '').replace('$','')
            decimal = fp[::-1].find('.')
            decimal = decimal if decimal > 1 else 2
            price = round(float(fp),decimal)
            #price = round(float(order['price'].replace(',', '')),6)

            sm = len(order['symbol'])
            sym = order['symbol'][-3:]
            type = 'forex'
            option = 'FOREX'
            strike = ''
            expire = ''
            order['size'] = 1
            
            ################# PIP VALUE ####################
            if 'id' in order and 'realizedPL' in order:
                if i <= order_len:
                    try:
                        price1 = float(self.all_orders[i]['price'])
                        price2 = float(order['price'])
                        qty = float(order['quantity'])
                        profit = float(order['realizedPL'])
                        price3 = abs(price1 - price2)
                        pip_value =  abs(profit / (price3 * qty)) if price3 > 0 else 0
                        self.all_orders[i]['pip_value'] = pip_value
                    except:
                        continue
            else:
                if 'pip_value' in order:
                    pip_value = order['pip_value']
                
            if 'pair' in order:
                order['size'] = 10
                pip_value = self.convert_usdt(order, pip_value_order, date )
            #################### VERIFY FILE ROW ######################
            try:
                order_id = ''
                portfolio_ = self.params['user_portfolio']
                if 'id' in order and order['id']:
                    order_id = order['id']
                valid_file_row = ImportParams.validate_filerow(orders_filerow, 
                                                               njson=njson, 
                                                               order_id=order_id,
                                                               date_tz=original_file_row['date_tz'],
                                                               price=fp,
                                                               option=option,
                                                               action=action,
                                                               quantity=str(order['quantity']).replace(',', ''),
                                                               strike=strike,
                                                               expire=expire,
                                                               portfolio=portfolio_
                                                              )
                if valid_file_row:
                    verify_njson_len = verify_njson_len + 1
                    continue
            except:
                #print(traceback.format_exc())
                pass
            ##########################################################

            
            #order['symbol']  ='${}|{}'.format(order['symbol'],i)   
            order['trade_notes'] = order['trade_notes'] if 'trade_notes' in order else ''
            order['type_stock'] = type
            order['type_option'] = option
            order['action'] = action
            order['price'] = fp
            order['shares'] = str(order['quantity']).replace(',', '')
            order['comm'] = order['commission'].replace(',', '').replace('$','') if 'commission' in order else '0.00'
            order['njson'] = njson
            order['decimal'] = decimal
            order['expire'] = expire
            order['strike'] = strike
            order['pip_value'] = pip_value

            order['original_file_row'] = original_file_row
            order['broker'] = self.params['broker']
            order['userid'] = self.params['get_session_userid']
            order['portfolio'] = self.params['user_portfolio']
            #order['portfolio'] = self.params['user_portfolios'][order['AccountID']]
            valor= order['portfolio']
            broker=self.params['broker']
            data_item = ImportParams.get_result_append(order)
            self.out_result.append(data_item)
            b = b + 1
        try:
            event_success = EventUser.update_user_events(interpreter_orders_event)
        except:
            pass

    def save_orders(self):
        try:
            get_orders_event = EventUser.post_user_events(102, new_user=self.user_id)
        except:
             pass
 
        self.pusher_title =  "Regrouping orders"
        self.pusher_message = '19%'
        self.pusher_complete = False
        self.send_pusher()
        import_broker = 'oanda'
        regroup_value = [group['code'] for group in self.user.users_configs.trade_grouping if group['active'] == True][0]
        error_mgs = "There was an error. Our support team will review the issue and get back to you"

        spread = False
        if regroup_value == 'split':
            output_group = TradeRegroups.regroup_trades_closed(self.out_result,import_broker,self.user.id)

        else:
            if regroup_value=='spread':
                spread = True
            output_group = TradeRegroups.regroup_trades(self.out_result, import_broker, self.user.id, spread=spread, user=self.user)
        if 'error' in output_group:
            self.out['mgs'] = error_mgs
            return self.out
        any_error, rows, return_total, error_issue, executions, self.upload_id = TradeRegroups.save_to_database(output_group,import_broker, self.user.id, archive = self.filename_csv, upload_id = self.upload_id)
        self.out_result = output_group
        """
            rows : total trades imported
            executions: total executions imported
        """
        self.rows = rows
        self.out = {'any_error': any_error, 'rows': rows, 'ordens': executions,
                'return_total': return_total, 'error_issue': error_issue,
                'broker': import_broker, 'error_code': any_error}
        if any_error and any_error != 21:
            self.out['mgs'] = error_mgs
            return self.out
        else:
            if rows > 0:
                try:
                    self.user.fk_user_status_id = 1
                    self.user.save()
                except:
                    pass
                mgs = f'{str(rows)} Trades, {str(executions)} Executions'
            else:
                if self.last_date == 0 or self.last_date == None:
                    mgs = "No new trades found."
                else:
                    mgs = "No new trades to import"
        self.out['mgs'] = mgs
        self.save_file(tmp_route = self.tmp_route_csv, archive = self.filename_csv,data = self.all_orders , to = self.to_csv, f_type= 'transactions_csv', content_type = 'text/csv',  portfolio =self.portfolio,  executions=executions , trades=rows, fk_broker_id = self.broker.broker_id, broker = self.broker.broker_key)

        # self.save_file(tmp_route = self.tmp_route_json, archive = self.filename_json , to = self.to_json, f_type= 'transactions_json', content_type = 'text/json',  portfolio =self.portfolio,  executions=executions , trades=rows, fk_broker_id = self.broker.broker_id, broker = self.broker.broker_key)
        UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,replace=True)
        try:
            event_success = EventUser.update_user_events(get_orders_event)
        except:
            pass
