import re
import hashlib
import json
import traceback
from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required
from collections import OrderedDict, defaultdict, namedtuple
from datetime import datetime, date, timedelta, tzinfo, time
from copy import deepcopy
from dateutil.parser import parse
from .. import_params import ImportParams
from .. models import Trades, TradesHistories
from .. trade.trades_regroups import *
from .. security_service import *
from .. logs import create_log
from .. responses import ErrorResponses, SuccessResponses

class BrokerOanda(Resource):
    TICKETS = []
    ORDERS_FILEROW = []
    """
    Class interpreter file broker Oanda.

    This class contains two formats:
      Format 1: getcsv for file with consecutive items
      Format 2: getcsv2 for file with items that contain the close on the same row.
    """
    def getcsv(params, content, date_format='mdy'):
        """
        This function validates the lines of the file and interprets its variables, format 1.

        Args:
          params (dict): {
                                "date_format": date_format,
                                "user_portfolio": user_portfolio,
                                "setups": trades_setups if trades_setups else [],
                                "get_session_userid": get_session_userid,
                                "broker": broker_code,
                                "tradedate": trade_date,
                                "file": url_format,
                                "extension": extension_file,
                                "timezone": TIMEZONE_NAME,
                                "textarea": textarea,
                                'filename': name_file_account
                          }
          content (str): File content.
          date_format (str): Format date.

        Returns:
          Parameters:
            out_result (Json): with orders data of file.
            any_error (int): Error code.
        """

        start_oanda = ImportParams.params_time()
        data = "BrokerOanda 1"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        pip_value_list = defaultdict(list)
        b=0

        try:
            if '売買' in content:
                return BrokerOanda.getcsv3(params, content, date_format='mdy')
            if ('Open Date' in content and 'Close Date' in content) or (not 'direction' in content.lower()):
                return BrokerOanda.getcsv2(params, content, date_format='mdy')
            if 'TRANSACTION TYPE' in content and 'TRANSACTION DATE' in content:
                content = content.replace('TRANSACTION TYPE', 'transaction').replace('TRANSACTION DATE','date')
            content = content.replace(';', '').replace('\nS', ' S').replace('\t',',')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                rl = rl + 1
                if rl == 1:
                    row = row.replace("\r", "")
                    row = row.replace(',,',',t,') if ',,' in row else row
                    ns = row.split(',')
                    nl = len(ns)

                result_b.append(row)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            b = len(result)
            firtday = False

            if params['date_format']['id'] == 3 or params['date_format']['id'] == 4:
                firtday = True
            var_head = ['ticket','date','timezone','transaction','details','instrument','price','units','direction','spread cost','stop loss','take profit','trailing stop','financing','commission','p/l','amount','balance']
            valid_ticket =  BrokerOanda.get_valid_ticket(params['get_session_userid'],'oanda','date',result)
            verify_njson_len = 0
            orders_filerow = []
            try:
                orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                              var_sync='id',
                                                              var_file='orderid',
                                                              broker=params['broker'])
                BrokerOanda.ORDERS_FILEROW = orders_filerow

            except:
                pass
            for a, n in enumerate(result):
                if 'pl' in n:
                    n['p/l'] = n['pl']

                if 'timezone' in n and n['timezone'].upper() != 'EDT':
                    n['timezone'] = 'EDT'
                len_pip_value = 0
                pip_value = float(n['conversion rate']) if 'conversion rate' in n and n['conversion rate']  else ''
                if pip_value:
                    split_pip_value = str(pip_value).split('.')
                    if len(split_pip_value) == 2:
                        len_pip_value = len(split_pip_value[1])
                newdict = {k: n[k] for k in n if k in var_head}
                n = newdict
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                take_profit = result[a-1]['take profit'] if a > 0 else ''
                stop_loss = result[a-1]['stop loss'] if a > 0 else ''
                valid = True if 'transaction' in n  and n['transaction'].upper() == 'ORDER_FILL' else False
                n['action'] = n['direction'].strip().upper() if n['direction'].strip().upper() == 'BUY' or n['direction'].strip().upper() == 'SELL' else ''
                if not valid or n['action'] not in ['BUY', 'SELL'] or not n['price']:
                    continue
                if 'ticket' in n:
                    tkt = '{}{}{}{}'.format(params['broker'],n['ticket'], n['instrument'].upper(), n['date'])
                    if tkt in BrokerOanda.TICKETS:
                        verify_njson_len = verify_njson_len + 1
                        continue

                n['orderby'] = float(n['ticket']) if 'ticket' in n and ImportParams.isfloat(n['ticket']) else ''
                n['symbol'] = n['instrument'].upper()

                #: Get format date and TIMEZONE for date file.
                datetime = n['date'].strip()
                original_file_row['date_tz'] = n['date'].strip()

                if firtday:
                    dp = ImportParams.parse_date(datetime, firtday)
                    date_split = dp.strftime('%m/%d/%Y %H:%M:%S')
                    dateformat = '%m/%d/%Y %H:%M:%S'
                    any_error, date, time = ImportParams.get_param_datetime(date_split,b,dateformat=dateformat)
                else:
                    any_error, date, time = ImportParams.get_param_datetime(datetime,b)
                if any_error:
                    return out_result, 15
                new_date_time = ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                #: Get quantity, price, type, multiplier
                quantity = float(n['units'])
                fp = n['price'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp),6)
                n['multiplier'] = 1
                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = ''
                if '/' in n['symbol']:
                    type='forex'
                    option = 'FOREX'
                    if pip_value:
                        n['pip_value'] = pip_value
                    n['symbol'] = '$'+n['symbol'].replace('/','')
                n['target'] = take_profit if ImportParams.isfloat(take_profit) and float(take_profit) > 0 else None
                n['stop'] = stop_loss if ImportParams.isfloat(stop_loss) and float(stop_loss) > 0 else None
                commission = n['commission'] if 'commission' in n and ImportParams.isfloat(n['commission']) else '0.00'
                fees = n['fees'] if 'fees' in n else n['spread cost'] if 'spread cost' in n and ImportParams.isfloat(n['spread cost']) else '0.00'

                try:
                    if not pip_value or (len_pip_value and len_pip_value <= 2):
                        pip_row = "{}{}".format(n['symbol'],n['date'])
                        if not pip_row in pip_value_list:
                            ValuePip = float(ImportParams.value_pip_forex(n['date'],n['symbol']))
                            pip_value_list[pip_row] = ValuePip
                        else:
                            ValuePip = pip_value_list[pip_row]
                        n['pip_value'] = ValuePip
                except:
                    pass

                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = params['user_portfolio']
                    if 'orderid' in n and n['orderid']:
                        order_id = n['orderid']
                    valid_file_row = ImportParams.validate_filerow(orders_filerow,
                                                                   njson=njson,
                                                                   order_id=order_id,
                                                                   date_tz=original_file_row['date_tz'],
                                                                   price=fp,
                                                                   option=option,
                                                                   action=n['action'],
                                                                   quantity=quantity,
                                                                   strike=strike,
                                                                   expire=expire,
                                                                   portfolio=portfolio_
                                                                  )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = fees
                n['njson'] = njson
                n['original_file_row'] = original_file_row
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['value_order'] = 1
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                #: This is to get the parameters for the calculations in regroup.
                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b - 1

        except Exception as err:
            any_error = 9
        if not any_error and not out_result and verify_njson_len:
            return out_result, any_error

        if not any_error and not out_result:
            any_error=9

        if not any_error and len(out_result) > 0:
            return out_result, any_error
        else:
            return BrokerOanda.getcsv2(params, content, date_format='mdy')


        return out_result, any_error

    def getcsv2(params, content, date_format='mdy'):
        """
        This function validates the lines of the file and interprets its variables, format 2.

        Args:
          params (dict): {
                                "date_format": date_format,
                                "user_portfolio": user_portfolio,
                                "setups": trades_setups if trades_setups else [],
                                "get_session_userid": get_session_userid,
                                "broker": broker_code,
                                "tradedate": trade_date,
                                "file": url_format,
                                "extension": extension_file,
                                "timezone": TIMEZONE_NAME,
                                "textarea": textarea,
                                'filename': name_file_account
                          }
          content (str): File content.
          date_format (str): Format date.

        Returns:
          Parameters:
            out_result (Json): with orders data of file.
            any_error (int): Error code.
        """

        data = "BrokerOanda 2"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            content = content.replace(';', '').replace('\nS', ' S').replace('\t',',')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                rl = rl + 1
                if rl == 1:
                    row = row.replace("\r", "")
                    row = row.replace(',,',',t,') if ',,' in row else row
                    ns = row.split(',')
                    nl = len(ns)

                result_b.append(row)

            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            pip_value_list = defaultdict(list)
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                action = n['l/s'].strip().upper() if 'l/s' in n else \
                         n['side'].strip().upper() if 'side' in n else \
                         n['action'] if 'action' in n else ''

                n['open time']  = ''
                n['close time']  = ''

                try:
                    if 'entry date' in n and 'entry time' in n:
                        date_time = '{0} {1}'.format(n['entry date'], n['entry time'])
                        n['open time'] = '{:%m/%d/%Y %H:%M:%S}'.format(parse(date_time))
                    elif 'opendate' in n and 'opentime' in n:
                        date_time = '{0} {1}'.format(n['opendate'], n['opentime'])
                        n['open time'] = '{:%m/%d/%Y %H:%M:%S}'.format(parse(date_time))
                    if 'exit date' in n and 'exit time' in n:
                        date_time = '{0} {1}'.format(n['exit date'], n['exit time'])
                        n['close time'] = '{:%m/%d/%Y %H:%M:%S}'.format(parse(date_time))
                    elif 'closedate' in n and 'closedate' in n:
                        date_time = '{0} {1}'.format(n['closedate'], n['closetime'])
                        n['close time'] = '{:%m/%d/%Y %H:%M:%S}'.format(parse(date_time))
                    if not n['open time'] and not n['close time'] and 'open date' in n and 'close date' in n:
                        date_time =  n['open date']
                        n['open time'] = '{:%m/%d/%Y %H:%M:%S}'.format(parse(date_time))
                        date_time = n['close date']
                        n['close time'] = '{:%m/%d/%Y %H:%M:%S}'.format(parse(date_time))

                except:
                    continue

                n['symbol'] = n['product'].replace('$', '').replace(' ', '').replace('/','') if 'product' in n else \
                              n['symbol'] if 'symbol' in n else ''

                n['action'] = 'BUY' if action == 'L' or action.upper() == 'BUY' else 'SELL' if action == 'S' or action.upper() == 'SELL' else action
                n['entry price'] = n['entry price'] if 'entry price' in n else n['open price'] if 'open price' in n else ''
                n['exit price'] = n['exit price'] if 'exit price' in n else n['close price'] if 'close price' in n else ''
                n['profit'] = n['gross p&l'] if 'gross p&l' in n else n['profit'] if 'profit' in n else '0'
                n['size'] = n['size'] if 'size' in n else \
                            n['units/lots'] if 'units/lots' in n else \
                            n['volume'] if 'volume' in n else ''
                if ImportParams.isfloat(n['symbol']) or ImportParams.isfloat(n['symbol'][:4]) or not n['symbol'] or not n['close time'] or n['action'] not in ['BUY', 'SELL'] or not 'entry price' in n or not 'exit price' in n:
                    continue
                #: Get format date and TIMEZONE for date file.
                original_file_row['date_tz'] = n['open time']
                any_error, date, time = ImportParams.get_param_datetime(n['open time'], b)
                new_date_time = ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                fp = n['entry price'].replace(',', '').replace('$', '').replace(' ', '')
                decimal_1 = fp[::-1].find('.')
                decimal_open = decimal_1 if decimal_1 > 1 else 2

                vfp = ImportParams.isfloat(fp)
                price = round(float(fp), 6) if vfp else 0.00
                sm = len(n['symbol'])

                fp2 = n['exit price'].replace(',', '').replace('$', '').replace(' ', '')
                decimal = fp2[::-1].find('.')
                decimal_closed = decimal if decimal > 1 else 2

                decimal = max([decimal_open, decimal_closed])
                type = 'forex'
                option = 'FOREX'

                try:
                    quantity = float(n['size'].replace('-', '').replace(',', '').replace(' ', '').replace('Lots',''))
                    lots = quantity/100000 if 'size' in n else quantity
                except:
                    continue



                n['p/l'] = n['profit'].replace(',', '').replace(' ', '') if n['profit'] and n['profit'] != '0' else '0'
                pip = (float(str(fp)) - float(str(fp2)))
                profit = float(n['p/l'].replace(',', '').replace(' ', '')) if 'p/l' in n and n['p/l'] and n['p/l'] != '0' else  0
                pip_value = 1

                """sym = n['symbol'][-3:]
                pip_row = "{}{}".format(sym,n['date'])
                if not pip_row in pip_value_list:
                    pip_value_params = float(ImportParams.value_pip_forex(n['date'],sym))
                    pip_value_list[pip_row] = pip_value_params
                else:
                    pip_value_params = pip_value_list[pip_row]

                ppq = (pip * quantity) if pip else 1
                if profit:
                    size_params = abs(profit / (ppq * pip_value_params))
                    size_params = ImportParams.size_params_value(size_params)
                    n['multiplier'] = size_params
                    pip_value = profit / (ppq * size_params)"""
                pip_value, size_params = ImportParams.value_pip_forex_lineal(quantity, fp, fp2, n['symbol'], profit, date=n['date'])


                commission = float(n['commission'].replace('-', '').replace(',', '').replace('$', '').replace(' ', '')) \
                              if 'commission' in n and ImportParams.isfloat(n['commission']) else \
                              float(n['commissions'].replace('-', '').replace(',', '').replace('$', '').replace(' ', '')) \
                              if 'commissions' in n and ImportParams.isfloat(n['commissions']) else 0
                fees = float(n['financing'].replace(',', '').replace('$', '').replace('-','').replace(' ','')) if 'financing' in n else 0.00
                swap = float(n['dividend'].replace(',', '').replace('$', '').replace(' ','')) if 'dividend' in n else float(n['swap'].replace(',', '').replace('$', '').replace(' ','')) if 'swap' in n else  0.00
                commission = round(commission, 2) if commission else 0.00
                take_profit = n['tp'] if 'tp' in n  else ''
                stop_loss = n['sl'] if 'sl' in n  else ''

                n['target'] = take_profit if ImportParams.isfloat(take_profit) and float(take_profit) > 0 else None
                n['stop'] = stop_loss if ImportParams.isfloat(stop_loss) and float(stop_loss) > 0 else None
                n['symbol'] = '$' + n['symbol'] +'|'+str(a)
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = fees
                n['swap'] = swap
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = ''
                n['strike'] = ''
                n['pip_value'] = abs(pip_value)
                n['size'] = abs(size_params)
                n['original_file_row'] = original_file_row
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)

                #: Get closed item in the row
                if n['close time']:
                    original_file_row2 = deepcopy(original_file_row)
                    n['action'] = 'SELL' if n['action'] == 'BUY' else 'BUY'
                    d = n['close time'].strip().split(' ')
                    b = b + 1
                    original_file_row2['date_tz'] = n['close time']
                    any_error, date, time = ImportParams.get_param_datetime(n['close time'], b)
                    new_date_time = ImportParams.convert_date(date, time, date_format)

                    n['date'] = new_date_time[0]
                    n['time'] = new_date_time[1]

                    commission = 0.00
                    n['type_stock'] = type
                    n['type_option'] = option
                    n['price'] = fp2
                    n['shares'] = quantity
                    n['comm'] = commission
                    n['fees'] = 0.00
                    n['swap'] = 0.00
                    n['njson'] = njson + 'Closed'
                    n['decimal'] = decimal
                    n['expire'] = ''
                    n['strike'] = ''
                    n['original_file_row'] = original_file_row2
                    n['broker'] = params['broker']
                    n['userid'] = params['get_session_userid']
                    n['portfolio'] = params['user_portfolio']

                    data_item = ImportParams.get_result_append(n)
                    out_result.append(data_item)

                b = b + 1
        except Exception as err:
            #print(n, err)
            #print(traceback.format_exc())
            any_error = 9

        if not any_error and not out_result:
            any_error=9
        return out_result, any_error

    def getcsv3(params, content, date_format='mdy'):
        data = "BrokerOanda333"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:

            content = content.replace(';', ',').replace('\x00','').replace('円','').replace('売','SELL').replace('買','BUY')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False

            result_b = ['ticker,symbol,transaction,side,price,quantity,date,profit loss, stop profit,swap,order id, contract price']

            for row in content_b:
                if len(row) == 0:
                    continue
                rl = rl + 1
                row = re.sub(r'(?!(([^"]*"){2})*[^"]*$),', '', row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
                result_b.append(row)

            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            firtday = False

            if params['date_format']['id'] == 3 or params['date_format']['id'] == 4:
                firtday = True
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                action = n['buy/sell'].upper() if 'buy/sell' in n else n['side'].upper() if 'side' in n else ''
                action = 'BUY' if action == 'BUY' or action=='COVER' or action=='B' else 'SELL' if action == 'SELL' or action == 'SHORT' or action=='S' else ''
                n['quantity'] = n['quantity'].replace(',', '').replace('-', '')

                if not n['symbol'] or not n['date'] or not n['price'] or not action or not ImportParams.isfloat(n['quantity']):
                    continue
                pip_value = 0
                date_split = n['date'].strip()
                date_time = date_split
                original_file_row['date_tz'] = date_time
                original_file_row['firtday'] = firtday
                if firtday:
                    dp = ImportParams.parse_date(date_time, firtday)
                    date_split = dp.strftime('%m/%d/%Y %H:%M:%S')
                    dateformat = '%m/%d/%Y %H:%M:%S'
                    any_error, date, time = ImportParams.get_param_datetime(date_split,b,dateformat=dateformat)
                else:
                    any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                new_date_time = ImportParams.convert_date(date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                fp = n['price'].replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp),decimal)
                #price = round(float(n['price'].replace(',', '')),6)

                sm = len(n['symbol'])
                strike = ''
                expire = ''
                smn = n['symbol'][-2:]
                type = 'forex'
                option = 'FOREX'

                if not 'pip_value' in n:
                    sym = n['symbol'].replace('/','')[-3:]
                    n['pip_value'] = TradeRegroups.value_pip_forex(n['date'],sym)

                n['symbol'] = '$'+n['symbol'].replace('/','')
                if (not 'type size' in n) or ('type size' in n and not n['type size']):
                    n['type_size'] = 'VOLUME' if ImportParams.isfloat(n['quantity']) and float(n['quantity']) > 10 else 'LOTS'
                else:
                    n['type_size'] = 'VOLUME' if 'VOLUME' in n['type size'].upper() else 'LOTS'


                fee = n['fee'].replace(',', '').replace('$','') if 'fee' in n else n['fees'].replace(',', '').replace('$','') if 'fees' in n else ''
                fee = round(float(fee),2) if fee else 0.00



                n['trade_notes'] = n['trade_notes'] if 'trade_notes' in n else ''
                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = fp
                n['shares'] = n['quantity']
                n['comm'] = n['commission'].replace(',', '').replace('$','') if 'commission' in n else '0.00'
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['original_file_row'] = original_file_row
                n['fees'] = fee
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            any_error = 9
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error

    def get_valid_ticket(userid, broker, key_date, result):
        try:
            date_min = min([parse(row[key_date]) for (index, row) in enumerate(result)
                                        if key_date in row]) - timedelta(30)

            qry = TradesHistories.query\
                            .join(Trades, Trades.trade_id == TradesHistories.fk_trade_id)\
                            .with_entities(TradesHistories.ticket, TradesHistories.broker,TradesHistories.original_file_row)\
                            .filter(TradesHistories.broker==broker,
                                    Trades.fk_user_id==userid,
                                    Trades.date_a >= date_min
                                   )\
                            .order_by(desc(Trades.date_a))\
                            .all()
            if qry:
                for r in qry:
                  original_file_row = r.original_file_row
                  tkt = '{}{}{}{}'.format(r.broker,r.ticket,original_file_row['instrument'].upper(),original_file_row['date'])
                  if not tkt in BrokerOanda.TICKETS:
                      BrokerOanda.TICKETS.append(tkt)

        except:
            pass
