import re
import hashlib
import json
import traceback

from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required
from dateutil.parser import parse
from datetime import datetime, date, timedelta, tzinfo, time

from .. import_params import ImportParams
from .. security_service import *
from .. logs import create_log
from .. responses import ErrorResponses, SuccessResponses


#9150
class BrokerKucoin(Resource):
    ORDERS_FILEROW = []
    def getcsv(params, content, date_format='mdy'):
        data = "BrokerKucoin"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0
        return_is_base_currency = False
        currency_trade = 'USD'
        try:
            return_is_base_currency = current_user.users_configs.return_is_base_currency
            currency_trade = current_user.users_configs.fk_currency.code
        except:
            pass
        try:
            if 'TIME' in content.upper() and ('CONTRACTS' in content.upper() or 'CONTRACT' in content.upper()):
                return BrokerKucoin.getcsv2(params, content, date_format='mdy')
            elif 'ZEIT' in content.upper() and 'KONTRAKTE' in content.upper():
                return BrokerKucoin.getcsv3(params, content, date_format='mdy')
            if 'created_at_formated' in content:
                return BrokerKucoin.getcsv4(params, content, date_format='mdy')
            if '"\n"\n' in content:
                content = content.replace('"\n"\n','|n').replace('"\n','"').replace('|n','"\n"')

            content = content.replace(';', '').replace('\nS', ' S').replace('\t',',')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            pip_value_list = dict()
            verify_njson_len = 0
            orders_filerow = []
            try:
                orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                              var_sync='orderId',
                                                              var_file='order id',
                                                              broker=params['broker'])
                BrokerTastyworks.ORDERS_FILEROW = orders_filerow

            except:
                pass

            for a, n in enumerate(result):

                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                order_time = ''
                for k, v in n.items():
                    if 'order time' in k:
                        order_time = v
                    if 'filled time' in k:
                        order_time = v
                if order_time:
                    n['order time'] = order_time
                if 'status' in n and 'deal' in n['status']:
                    n['status'] = 'COMPLETED'
                ##### issue 10562 ######
                if 'status' in n and n['status'].upper() not in ['COMPLETED']:
                    continue

                if 'size' in n and 'dealsize' in n:
                    n['size'] = n['dealsize']

                if 'qty.lot' in n:
                    n['size'] = n['qty.lot']

                if 'filled amount' in n:
                    n['size'] = n['filled amount']

                if 'averageprice' in n and 'dealsize' in n:
                    n['price'] = n['averageprice']

                if 'order value' in n:
                    order_value = re.compile(r'[^\d.]+')
                    n['order value'] = order_value.sub('', n['order value'])
                    if ImportParams.isfloat(n['order value']) and ImportParams.isfloat(n['size']):
                        n['price'] = str(float(n['order value']) / float(n['size']))
                if 'avg. filled price' in n:
                    n['price'] = n['avg. filled price']
                if 'filled price' in n:
                    n['price'] = n['filled price']

                #######################

                n['symbol'] = n['symbol'].strip() if 'symbol' in n else ''
                n['action'] = 'BUY' if 'side' in n and n['side'].upper() == 'BUY' else 'SELL' if 'side' in n and n['side'].upper() == 'SELL' else ''
                n['price'] = n['price'].strip() if 'price' in n else ''
                n['date'] = n['tradecreatedat'].strip() if 'tradecreatedat' in n else n['ordercreatedat'] \
                                                        if 'ordercreatedat' in n else n['order time'] \
                                                        if 'order time' in n else ''


                if n['action'] not in ['BUY', 'SELL'] or not n['symbol'] or not n['price']:
                    continue
                original_file_row['date_tz'] = n['date']
                any_error, date, time = ImportParams.get_param_datetime(n['date'],b)
                new_date_time = ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                fp = n['price'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00

                pip_value = 1
                pip_value_fee = 1
                type = 'crypto'
                option = 'CRYPTO'
                expire = ''
                strike = ''

                quantity = abs(float(n['size'])) if 'size' in n and ImportParams.isfloat(n['size']) else ''

                ##################
                if 'filled value' in n:
                    n['filled volumeusdt'] = n['filled value']
                if 'filled volumeusdt' in n and ImportParams.isfloat(n['filled volumeusdt']):
                    pq = price * quantity
                    value = float(n['filled volumeusdt'])
                    pip_value = value / pq
                if 'fee currency' in n and n['fee currency'].upper() != 'USDT':
                    if not n['fee currency'] in pip_value_list:
                        pip_fee = ImportParams.pip_value_crypto_(date = n['date'], currency = n['fee currency'])
                        if ImportParams.isfloat(pip_fee):
                            pip_value_fee = float(pip_fee)
                            pip_value_list[n['fee currency']] = pip_value_fee
                    else:
                        pip_value_fee = pip_value_list[n['fee currency']]

                if return_is_base_currency:
                    sym = currency_trade.upper()
                    pip_row = "{}{}".format(sym,n['date'])
                    if not pip_row in pip_value_list:
                        pip_value_params = float(ImportParams.value_pip_forex(n['date'],sym))
                        pip_value_list[pip_row] = pip_value_params
                    else:
                        pip_value_params = pip_value_list[pip_row]
                    pip_value = pip_value * pip_value_params
                    pip_value_fee = pip_value_fee * pip_value_params
                #############################

                commission = 0.00
                fee = n['fee'] if 'fee' in n and ImportParams.isfloat(n['fee']) else ''
                fee = float(fee) * pip_value_fee if fee else 0.00
                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = params['user_portfolio']
                    if 'order id' in n and n['order id']:
                        order_id = n['order id']
                    valid_file_row = ImportParams.validate_filerow(orders_filerow,
                                                                   njson=njson,
                                                                   order_id=order_id,
                                                                   date_tz=original_file_row['date_tz'],
                                                                   price=fp,
                                                                   option=option,
                                                                   action=n['action'],
                                                                   quantity=quantity,
                                                                   strike=strike,
                                                                   expire=expire,
                                                                   portfolio=portfolio_
                                                                  )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################

                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = fee
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['size'] = 1
                n['pip_value'] = pip_value
                n['original_file_row'] = original_file_row

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)

                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            any_error = 9
            # print(err, traceback.format_exc())
        if not any_error and not out_result and not verify_njson_len:
            any_error=9

        return out_result, any_error

    def getcsv2(params, content, date_format='mdy'):
        data = "BrokerKucoin2"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            if '"\n"\n' in content:
                content = content.replace('"\n"\n','|n').replace('"\n','"').replace('|n','"\n"')
            content = content.replace(';', '').replace('\nS', ' S').replace('\t',',')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            count_trade = ImportParams.count_trade_user(params['get_session_userid'],'kucoin')

            try:
                if count_trade:
                    valid_multiplier_trade_user = ImportParams.valid_price_multiplier_trades(params['get_session_userid'], 'kucoin')
                    if valid_multiplier_trade_user:
                        count_trade = 0
            except:
                pass
            verify_njson_len = 0
            orders_filerow = []
            try:
                orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                              var_sync='orderId',
                                                              var_file='transaction id',
                                                              broker=params['broker'])
                BrokerTastyworks.ORDERS_FILEROW = orders_filerow

            except:
                pass
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                for k in list(n):
                    if 'order time' in k:
                        n['time'] = n[k].replace('/','-')
                    if 'amountlots' in k and ImportParams.isfloat(n[k]):
                        n['filled amountlots'] = n[k]
                    if 'filled amountlot' in k and ImportParams.isfloat(n[k]):
                        n['filled amountlots'] = n[k]
                    if 'filled price' in k and ImportParams.isfloat(n[k]):
                        n['price'] = n[k]
                    if 'fill price' in k and ImportParams.isfloat(n[k]):
                        n['price'] = n[k]
                    if 'contract' in k and n[k]:
                        n['contracts'] = n[k]

                ##### issue 10562 ######
                if not 'filled amountlots' in n or \
                    not 'price' in n or \
                    ('filled amountlots' in n and not n['filled amountlots'].upper()) or \
                    ('price' in n and not ImportParams.isfloat(n['price'])):
                    continue
                n['size'] = n['filled amountlots']
                order_value = re.compile(r'[^\d.]+')
                pip_value = 1
                multiplier = 1
                if 'value' in n:
                    n['value'] = order_value.sub('', n['value'])
                    if ImportParams.isfloat(n['value']) and ImportParams.isfloat(n['size']):
                        if not params['get_session_userid'] in [105261] :
                            if count_trade > 0:
                                n['price'] = str(float(n['value']) / float(n['size']))
                            else:
                                multiplier = float(n['value']) / (float(n['price']) * float(n['size']))
                                original_file_row['valid_price_multiplier'] = 1
                        else:
                            multiplier = float(n['value']) / (float(n['price']) * float(n['size']))
                            original_file_row['valid_price_multiplier'] = 1
                if 'order value' in n:
                    order_value = n['order value'].replace(',','')
                    value = ImportParams.Extract_Numbers(order_value)
                    if count_trade > 0:
                        pip_value = float(value) / (float(n['size'])*float(n['price']))
                    else:
                        multiplier = float(value) / (float(n['size'])*float(n['price']))
                        original_file_row['valid_price_multiplier'] = 1

                n['contracts'] = n['contracts'].replace(' Perpetual/','')
                #######################

                n['symbol'] = n['contracts'].strip() if 'contracts' in n else ''
                n['action'] = 'BUY' if 'side' in n and n['side'].upper() == 'BUY' else 'SELL' if 'side' in n and n['side'].upper() == 'SELL' else ''
                n['price'] = n['price'].strip() if 'price' in n and ImportParams.isfloat(n['price']) else ''
                n['date'] = n['time'].strip() if 'time' in n else ''

                if n['action'] not in ['BUY', 'SELL'] or not n['symbol'] or not n['price']:
                    continue

                original_file_row['date_tz'] = n['date']
                any_error, date, time = ImportParams.get_param_datetime(n['date'],b)
                new_date_time = ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                fp = n['price'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00

                type = 'crypto'
                option = 'CRYPTO'
                expire = ''
                strike = ''

                quantity = abs(float(n['size'])) if 'size' in n and ImportParams.isfloat(n['size']) else ''
                commission = 0.00
                if 'commission' in n:
                    if '%' in n['commission']:
                        commission = n['commission'].replace('%','')
                        if ImportParams.isfloat(commission):
                            commission = float(commission) / 100
                            commission = float(n['value']) * commission

                if 'fees' in n:
                    n['fee'] = order_value.sub('', n['fees'])
                fee_ = ImportParams.clear_numb(str(n['fee'])) if 'fee' in n else ''
                fee = fee_
                fee = float(fee) if fee else 0.00
                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = params['user_portfolio']
                    if 'transaction id' in n and n['transaction id']:
                        order_id = n['transaction id']
                    valid_file_row = ImportParams.validate_filerow(orders_filerow,
                                                                   njson=njson,
                                                                   order_id=order_id,
                                                                   date_tz=original_file_row['date_tz'],
                                                                   price=fp,
                                                                   option=option,
                                                                   action=n['action'],
                                                                   quantity=quantity,
                                                                   strike=strike,
                                                                   expire=expire,
                                                                   portfolio=portfolio_
                                                                  )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = fee
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['size'] = multiplier
                n['pip_value'] = pip_value
                n['original_file_row'] = original_file_row

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            print(traceback.format_exc())
            any_error = 9

        if not any_error and not out_result and not verify_njson_len:
            any_error=9

        return out_result, any_error

    def getcsv3(params, content, date_format='mdy'):
        data = "BrokerKucoin3"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            if '"\n"\n' in content:
                content = content.replace('"\n"\n','|n').replace('"\n','"').replace('|n','"\n"')
            content = content.replace(';', '').replace('\nS', ' S').replace('\t',',')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                rl = rl + 1
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
                result_b.append(row)

            result = ImportParams.custom_getcsv(result_b, nl,True,True)

            verify_njson_len = 0
            orders_filerow = []

            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                n['date'] = n['zeit'] if 'zeit' in n else ''
                n['symbol'] = n['kontrakte'] if 'kontrakte' in n else ''
                n['action'] = n['richtung'] if 'richtung' in n else ''
                n['action'] = 'BUY' if n['action'].upper() in ['BUY', 'KAUFEN'] else \
                              'SELL' if n['action'].upper() in ['SELL', 'VERKAUFEN'] else ''
                n['quantity'] = n['gesamtmengepositionen'] if 'gesamtmengepositionen' in n else ''
                n['price'] = n['endpreis'] if 'endpreis' in n else ''
                n['amount'] = ImportParams.clear_numb(n['wert']) if 'wert' in n else ''
                n['commission'] = ImportParams.clear_numb(n['geb  hren']) if 'geb  hren' in n else ''

                if n['action'] not in ['BUY', 'SELL'] or not n['symbol'] or not n['price']:
                    continue

                original_file_row['date_tz'] = n['date']
                any_error, date, time = ImportParams.get_param_datetime(n['date'],b)
                new_date_time = ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                fp = n['price'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00

                type = 'crypto'
                option = 'CRYPTO'
                expire = ''
                strike = ''
                pip_value = 1

                quantity = abs(float(n['quantity'])) if 'quantity' in n and ImportParams.isfloat(n['quantity']) else ''
                commission = n['commission'] if 'commission' in n and ImportParams.isfloat(n['commission']) else ''
                commission = float(commission) if commission else 0.00
                if 'amount' in n and ImportParams.isfloat(n['amount']) \
                                 and ImportParams.isfloat(price) \
                                 and ImportParams.isfloat(quantity) :

                    pip_value = float(n['amount']) / (float(price) * float(quantity))
                fee = 0.00

                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = fee
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['size'] = 1
                n['pip_value'] = pip_value
                n['original_file_row'] = original_file_row

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)

                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            any_error = 9

        if not any_error and not out_result:
            any_error=9

        return out_result, any_error

    def getcsv4(params, content, date_format='mdy'):
        data = "BrokerKucoin4"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0
        future = True

        try:
            if '"\n"\n' in content:
                content = content.replace('"\n"\n','|n').replace('"\n','"').replace('|n','"\n"')
            content = content.replace(';', '').replace('\nS', ' S').replace('\t',',')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            pip_value_order = dict()
            verify_njson_len = 0
            orders_filerow = []
            try:
                orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                              var_sync='orderId',
                                                              var_file='orderid',
                                                              broker=params['broker'])
                BrokerTastyworks.ORDERS_FILEROW = orders_filerow

            except:
                pass
            for a, order in enumerate(result):
                original_file_row = json.loads(json.dumps(order))
                njson = json.dumps(order)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                multiplicator = 1
                if future:
                    multiplicator = float(order['value'])/ (float(order['price'])* float(order['size']))
                action = order['buy/sell'].upper() if 'buy/sell' in order else order['side'].upper() if 'side' in order else order['transaction category'].upper() if 'transaction category' in order else ''
                action = 'BUY' if action == 'BUY' or action=='COVER' else 'SELL' if action == 'SELL' or action == 'SHORT' else ''
                order['symbol']  = order['symbol'].replace('-', '').replace('XBTUSDT', 'BTCUSDT')
                last_symbol = order['symbol'][-1:]
                if last_symbol == 'M':
                    order['symbol'] = order['symbol'][:-1]
                order['date'] = order['createdat']
                order['date'] = datetime.utcfromtimestamp(int(order['date'])/1000).strftime('%Y-%m-%d %H:%M:%S')
                order['type'] = order['tradeType'].upper() if 'tradeType' in order else order['types'].upper() if 'types' in order else 'TRADE'
                if not future:
                    if not 'dealFunds' in order:
                        order['price'] = float(float(order['dealValue']) / float(order['dealSize']) ) if float(order['dealSize']) != 0 else 0
                    else:
                        order['price'] = float(float(order['dealFunds']) / float(order['dealSize']) ) if float(order['dealSize']) != 0 else 0
                    order['quantity'] =  abs(float(order['dealSize'])) if 'dealSize' in order and ImportParams.isfloat(order['dealSize']) else ''
                    qty =  str(order['quantity']).split('.')
                    try:
                        decimal = qty[1][:4]
                    except Exception as err:
                        decimal = qty
                    qty[1] = decimal
                    qty[1] = re.findall('[0-9]+',  qty[1])[0]
                    order['quantity']  = float(".".join(qty))
                else:
                    order['price'] = order['price']
                    order['quantity'] =  order['size']



                if not order['symbol'] or not order['date'] or not order['price'] or not action or order['type'] != "TRADE":
                    continue
                if order['type'].lower() != 'trade' and order['type'].lower() != 'busttrade':
                    continue
                pip_value = 1
                if 'time' in order:
                    date_split = order['date'].strip()
                    d = date_split
                    t = order['time'].replace('.',':') if 'time' in order else ''
                    date_time = (d+' '+t).strip()
                else:
                    date_time = order['date']
                original_file_row['date_tz'] = date_time
                any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                new_date_time = ImportParams.convert_date(date, time, date_format,True,'UTC')

                order['date'] = new_date_time[0]
                order['time'] = new_date_time[1]
                fp = str(order['price']).replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp),decimal)
                #price = round(float(order['price'].replace(',', '')),6)

                sm = len(order['symbol'])
                type = 'crypto'
                option = 'CRYPTO'
                strike = ''
                expire = ''
                #value / (precio *size)
                pip_value = BrokerKucoin.convert_usdt(order, pip_value_order, date )

                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = params['user_portfolio']
                    if 'orderid' in order and order['orderid']:
                        order_id = order['orderid']
                    valid_file_row = ImportParams.validate_filerow(orders_filerow,
                                                                   njson=njson,
                                                                   order_id=order_id,
                                                                   date_tz=original_file_row['date_tz'],
                                                                   price=fp,
                                                                   option=option,
                                                                   action=action,
                                                                   quantity=order['quantity'],
                                                                   strike=strike,
                                                                   expire=expire,
                                                                   portfolio=portfolio_
                                                                  )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################
                if 'size' in order:
                    order['size'] = 1
                if future:
                    order['size'] = multiplicator
                order['trade_notes'] = order['trade_notes'] if 'trade_notes' in order else ''
                order['type_stock'] = type
                order['type_option'] = option
                order['action'] = action
                order['price'] = price
                order['shares'] = order['quantity']
                order['fees'] = order['fee'] if 'fee' in order else '0.00'
                order['njson'] = njson
                order['decimal'] = decimal
                order['expire'] = expire
                order['strike'] = strike
                order['pip_value'] = pip_value
                order['original_file_row'] = original_file_row
                order['broker'] = params['broker']
                order['userid'] = params['get_session_userid']
                order['portfolio'] = params['user_portfolio']
                order['app_broker'] = 1
                data_item = ImportParams.get_result_append(order)
                out_result.append(data_item)
                b = b + 1

        except Exception as err:
            any_error = 9

        if not any_error and not out_result and not verify_njson_len:
            any_error=9

        return out_result, any_error

    def convert_usdt(order, pip_value_order , date):
        """
        Se puede cambiar los if anidados por un .endswith('USDT')
        """
        pip_value = 1
        try:
            # Tomamos los 4 ultimos caracteres del simbolo
            sym_last_1 = order['symbol'][-4:]
            # Validamos si los ultimos 4 caracteres del simbolo es diferente USDT
            if sym_last_1.upper() != 'USDT':
                # Tomamos los 3 ultimos caracteres del simbolo
                sym_last_2 = order['symbol'][-3:]
                # Validamos si los ultimos 3 caracteres del simbolo es igual USD
                if sym_last_2.upper() == 'USD':
                    # Borramos USD del simbolo para que nos quede solo el codigo del que vamos a
                    # sacar el rate USDT
                    smn = order['symbol'].replace(sym_last_2,'')
                    # Convertimos la fecha de la orden en el formato que requiere el api para sacar el rate
                    date_sym = str(parse(date)).split(' ')[0]
                    # Para evitar que se este llamando el api constantemente para un codico y fecha repetida se valida esto
                    # si el key_date_sym se encuentra en pip_value_order no se hace el llamado al api sino que se toma de la
                    # variable pip_value_order
                    key_date_sym = '{}{}'.format(smn, date_sym)
                    if not key_date_sym in pip_value_order:
                        # date_sym = la fecha de la orden formateada a como lo requiere el api
                        # smn = code base que vamos a sacar el valor RATE de USDT
                        pip_value = ImportParams.pip_value_crypto_(date = date_sym, base = smn)
                        if pip_value == 1:
                            try:
                                price = float(order['price'])
                                price_inv = 1/price
                                pip_value = price_inv
                            except:
                                pip_value = 1
                        pip_value_order[key_date_sym] = pip_value
                    else:
                        pip_value = pip_value_order[key_date_sym]
            return pip_value
        except:
            return 1
