import re
import hashlib
import json
import traceback

from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required

from .. import_params import ImportParams
from .. security_service import *
from .. logs import create_log
from .. responses import ErrorResponses, SuccessResponses

#9150
class BrokerFutureKucoin(Resource):

    def getcsv(params, content, date_format='mdy'):
        data = "BrokerFutureKucoin"
        # print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            if '"\n"\n' in content:
                content = content.replace('"\n"\n','|n').replace('"\n','"').replace('|n','"\n"')
            content = content.replace(';', '').replace('\nS', ' S').replace('\t',',')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)

            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                ##### issue 10562 ######
                if not 'filled amountlots' in n or ('filled amountlots' in n and not n['filled amountlots'].upper()):
                    continue
                n['size'] = n['filled amountlots']
                order_value = re.compile(r'[^\d.]+')
                if 'value' in n:
                    n['value'] = order_value.sub('', n['value'])
                    if ImportParams.isfloat(n['value']) and ImportParams.isfloat(n['size']):
                        n['price'] = str(float(n['value']) / float(n['size']))

                #######################

                n['symbol'] = n['contracts'].strip() if 'contracts' in n else ''
                n['action'] = 'BUY' if 'side' in n and n['side'].upper() == 'BUY' else 'SELL' if 'side' in n and n['side'].upper() == 'SELL' else ''
                n['price'] = n['price'].strip() if 'price' in n else ''
                n['date'] = n['time'].strip() if 'time' in n else ''

                if n['action'] not in ['BUY', 'SELL'] or not n['symbol'] or not n['price']:
                    continue

                original_file_row['date_tz'] = n['date']
                any_error, date, time = ImportParams.get_param_datetime(n['date'],b)
                new_date_time = ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                fp = n['price'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00


                type = 'crypto'
                option = 'CRYPTO'
                expire = ''
                strike = ''

                quantity = abs(float(n['size'])) if 'size' in n and ImportParams.isfloat(n['size']) else ''
                commission = 0.00
                if 'commission' in n:
                    if '%' in n['commission']:
                        commission = n['commission'].replace('%','')
                        if ImportParams.isfloat(commission):
                            commission = float(commission) / 100
                            commission = float(n['value']) * commission
                if 'fees' in n:
                    n['fee'] = order_value.sub('', n['fees'])
                fee = n['fee'] if 'fee' in n and ImportParams.isfloat(n['fee']) else ''
                fee = float(fee) if fee else 0.00
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = fee
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['size'] = 1
                n['original_file_row'] = original_file_row

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)

                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            print(err, traceback.format_exc())
            any_error = 9

        if not any_error and not out_result:
            any_error=9

        return out_result, any_error
