from .brokers_export import BrokerExport
from flask_restful import Resource, request
from ..security_service import verify_role
from ..models import BrokersConnections
from ..responses import ErrorResponses, SuccessResponses
from ..user.users_params import *
from ..import_params import ImportParams
from ..trade.trades_regroups import *
from ..server_info import ServerInfo
from ..event.events import UserEventList as EventUser
import pandas as pd
import urllib.parse
from urllib.parse import quote
import hashlib
import hmac
import base64
import requests
import time
import time as tt
import traceback
from .kraken.client import Client
from datetime import datetime


class KrakenExport(BrokerExport,ServerInfo, Resource):

    @verify_role('broker export')
    def post(self):
        try:
            version = {}
            self.orders_execid = []
            self.data = request.json
            self.orders_filerow = []
            # Start synchronization and update progress
            new_event_id=self.init_sync()
            self._update_progress('Saving Pre-Data', '1%')
            if not isinstance(new_event_id,UserEvents) and not self.is_lambda():
                return new_event_id
            
            self.orders_filerow = ImportParams.filerow_orders(self.params['get_session_userid'],
                                                                        var_sync='ordertxid', 
                                                                        var_file='orderid',
                                                                        broker='kraken'
                                                                    ) 
            for credential in self.credentials:
                self.credential = credential
                self._update_progress('Checking Credentials', '5%')
                self.not_error = self.validate()
                if self.not_error != True:
                    _end = self.end_sync()
                    if _end != True:
                        return _end
                self.time_out_lambda=False
                can_execute=True
                if self.condition_lambda() and not self.aws_autosync:
                    try:
                        can_execute=False
                        self.not_error = self.call_lambda()
                    except Exception as err:
                        self.not_error = err
                
                if can_execute:
                    self._update_progress('Login', '6%')
                    self.not_error = self.login()                
                    if self.not_error != True:
                        _end = self.end_sync(code=1)
                        if _end != True:
                            return _end
                    if self.future1:
                        self._update_progress("Saving account", '8%')
                        self.save_account(self.api_key_information, category='Future')
                    if self.spot:
                        self._update_progress("Saving account", '9%')
                        self.save_account(self.api_key_information, category='Spot')
                    self.account_pusher = 'Account #'+str(self.api_key_information)

                    self._update_progress('Saving data', '16%')
                    self.save_configs()
                    
                    if self.spot:
                        self._update_progress('Retrieving Spot orders', '18%')
                        self.not_error = self.get_kraken_orders()
                        if self.not_error != True:
                            _end = self.end_sync(code=7)
                            if _end != True:
                                return _end
                        
                    if self.future1  and self.kraken_client != None:
                        self._update_progress('Retrieving Future orders', '18%')
                        self.not_error = self.get_kraken_orders_future()
                        if self.not_error != True:
                            _end = self.end_sync(code=7)
                            if _end != True:
                                return _end
                    self.orders = list(sorted(self.orders, key=lambda i: i['time'], reverse=True))
                    self.check_status_connection_db()
                    self._update_progress('Saving Files', '19%')
                    self.save_files(file_type='json')
                    self._update_progress('Reading orders', '20%')
                    self.not_error  =  self.interpret_save_orders() 
                    if self.not_error != True:
                        self.not_error = str(self.not_error)
                        _end = self.end_sync(code=0)
                        if _end != True:
                            return _end
                    

                    # self.save_file(tmp_route = self.tmp_route_csv, archive = self.filename_csv , to = self.to_csv, f_type= 'transactions_csv', content_type = 'text/csv',  portfolio =self.portfolio,  executions=executions , trades=rows, fk_broker_id = self.broker.broker_id, broker = self.broker.broker_key)
                    self.not_error  = self.save_params()
                    #getattr(self.out, 'mgs', 'successfully') 
                    self.sync_status(healthy=True, message=self.out['mgs'] if 'mgs' in self.out else 'Sync Success', status_code=200)
                  
            return self.end_sync(event_id=new_event_id)

        except requests.exceptions.ConnectionError as err:
            #print(err)
            #print(traceback.print_exc())
            #UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
            self.unlock_portfolios()
            self._update_progress('warning', 'Imported fail', True)
            message = 'ERROR'
            if 'Name or service not known' in str(err):
                message = 'Wrong host'
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(tt.time())-self.star_timestamp), 500, 'Fail') 
            return ErrorResponses.error_400(message=message, status='warning')
        except Exception as err:
            #print(traceback.print_exc())
            #UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
            self.unlock_portfolios()
            self._update_progress('warning', 'Imported fail', True)
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(tt.time())-self.star_timestamp), 500, 'Fail') 
            return ErrorResponses.error_500(self.data, err, version)

    def validate(self):
        try:
            self.data = request.json
            self.user.users_configs.not_warning_import = self.data.get(
                'not_warning_import', True)
            self.user.users_configs.save()
            self.symbols = self.data.get('symbols', self.symbols)
            self.auto_import = self.data['auto_import'] if 'auto_import' in self.data else False

            if self.credential:
                #self.credential = BrokersConnections.find_by(**{'user_id': self.user.id, "broker_id": self.broker.broker_id, 'active': True})
                self.api_key = self.credential.api_key
                self.secret_key = self.credential.secret_key
                self.test_account = self.credential.test_account
                self.passphrase = self.credential.passphrase
                self.spot =  self.credential.spot
                self.future1 =  self.credential.future1
                self.host  = "https://api.kraken.com"
                self.new_sync =  self.credential.new_sync
            else:
                #self.credential = BrokersConnections.find_by(**{'user_id': self.user.id, "broker_id": self.broker.broker_id, 'active': True})
                self.api_key = self.data['api_key'].strip()
                self.secret_key = self.data['secret_key'].strip()
                self.test_account = self.data['test_account']  if 'test_account' in self.data and self.data['test_account'] != "" else False
                self.passphrase = self.data.get('passphrase', None)
                self.spot =  self.data['spot'] if 'spot' in self.data and self.data['spot'] != "" else False
                self.future1 =  self.data['future1'] if 'future1' in self.data and self.data['future1'] != "" else False
                self.host  = "https://api.kraken.com"
                self.new_sync = True
            if not any([self.spot, self.future1]): 
                return 'select_type'

            self.api_key_information = ''.join(e for e in self.api_key if e.isalnum()) [:10]
            return True
        except Exception as err:
            if not self.credential:
                #print(err)
                return "Wrong credentials"

            self.api_key = self.credential.api_key
            self.secret_key = self.credential.secret_key
            self.test_account = self.credential.test_account
            self.passphrase = self.credential.passphrase
            self.spot =  self.credential.spot
            self.future1 =  self.credential.future1
            self.host  = "https://api.kraken.com"
            self.user.users_configs.not_warning_import = True
            self.user.users_configs.save()            
            self.data = None
            self.new_sync =  self.credential.new_sync

    def get_kraken_signature(self, urlpath,data, secret):
        try:
            postdata = urllib.parse.urlencode(data)
            encoded = (str(data['nonce']) + postdata).encode()
            message = urlpath.encode() + hashlib.sha256(encoded).digest()
            mac = hmac.new(base64.b64decode(secret), message, hashlib.sha512)
            sigdigest = base64.b64encode(mac.digest())
            return sigdigest.decode()
        except Exception as ex:
            #print(ex)
            #print(traceback.print_exc())
            return "Invalid Api-Key ID."
    
    def kraken_request(self, uri_path,method="POST", data={}, host=None):
        try:
            host = self.host
            headers = {}
            headers['API-Key'] = self.api_key 
            headers['API-Sign'] = self.get_kraken_signature(uri_path,data, self.secret_key)             
            response = requests.request(method, f"{host}{uri_path}", headers=headers, data=data)
            return response
        except Exception as ex:
            #print(ex)
            #print(traceback.print_exc())
            return "Invalid Api-Key ID."

    def login(self): 
        try:
            self.kraken_client = None
            spot_message  = ''
            future_message  = ''
            can_spot  = False
            can_future = False
            if self.spot:
                response = self.kraken_request('/0/private/Balance',data={"nonce": str(int(1000*time.time()))}) 
                if isinstance(response, str):
                    return response
                data = response.json()
                if not data['error']==[]:
                    if data['error'][0] =='EAPI:Invalid key':
                        spot_message =  'Invalid Api Key/Secret Key'
                    elif data['error'][0] =='EAPI:Rate limit exceeded':
                        time.sleep(2)
                        self.login()
                    else:
                        spot_message = data['error'][0]  
                else:
                    can_spot = True
            if self.future1 and can_spot == False:  
                timeout = 20
                checkCertificate = True  # when using the test environment, this must be set to "False"
                useNonce = False  # nonce is optional
                host = 'https://demo-futures.kraken.com' if self.test_account else 'https://futures.kraken.com'
                self.kraken_client = Client(host,
                                    apiPublicKey=self.api_key,
                                    apiPrivateKey=self.secret_key,
                                    timeout=timeout,
                                    checkCertificate=checkCertificate,
                                    useNonce=useNonce)
                response =  self.kraken_client.get_accounts()
                if response['result'] == 'error':
                    if response['error'] == 'apiLimitExceeded':
                        time.sleep(2)
                        self.login()
                    future_message = 'Invalid Api Key/Secret Key'
                else:
                    can_future = True
            
            if self.spot and (can_spot == False and can_future == False ):
                return spot_message
            elif self.future1 and (can_spot == False and can_future == False ):
                return future_message
                
            return True
        
        except Exception as ex:
            print(ex)
            print(traceback.print_exc())
            return "Invalid Api-Key ID."

    def get_kraken_orders(self):
        """
        Optimized extraction of Kraken orders - Python 3.6 with improved rate limit handling
        Implementa delays preventivos y backoff exponencial más agresivo.
        """
        
        # Get the last synchronization date for partial updates
        last_date = self.get_last_date_a(user_account=self.api_key_information, category='Spot')
        
        # Set start time: 0 for full sync, last_date for partial sync
        startTime = 0 if not self.data.get('partial', False) else last_date
        
        # Fetch asset pairs symbols only once to reduce API calls
        try:
            response = self.kraken_request('/0/public/AssetPairs', data={}).json()
            pair_symbols = response.get('result', {})
        except Exception:
            pair_symbols = {}
        
        # Control variables for pagination and retry logic
        jsonStr = {}  # Dictionary to accumulate all trades
        offset = 0  # Current pagination offset
        batch_size = 50  # Number of records per request
        max_retries = 10  # Maximum retry attempts per request (increased for rate limits)
        base_retry_delay = 33  # Base delay in seconds for rate limit (Kraken requirement)
        request_delay = 1.5  # Delay between successful requests to avoid rate limit
        consecutive_rate_limits = 0  # Counter for consecutive rate limit hits
        
        # Main extraction loop - continues until all orders are retrieved
        while True:
            success = False  # Flag to track if current batch was successful
            
            # Add preventive delay between requests if we've hit rate limits before
            if consecutive_rate_limits > 0:
                preventive_delay = min(request_delay * (2 ** consecutive_rate_limits), 60)
                self._update_progress(
                    'Preventive delay: {}s (avoiding rate limit)'.format(preventive_delay), 
                    '18%'
                )
                time.sleep(preventive_delay)
            elif offset > 0:
                # Small delay between normal requests
                time.sleep(request_delay)
            
            # Retry loop - attempts up to max_retries times
            for attempt in range(max_retries):
                try:
                    # Build request payload with current offset
                    payload = {
                        "nonce": str(int(1000 * time.time())),  # Timestamp for request uniqueness
                        "type": "all",  # Get all trade types
                        "trades": True,  # Include trade details
                        "start": startTime,  # Start timestamp for filtering
                        "ofs": offset  # Pagination offset
                    }
                    
                    # Make API request to Kraken
                    response = self.kraken_request('/0/private/TradesHistory', data=payload)
                    data = response.json()
                    
                    # Error handling - check if API returned errors
                    errors = data.get('error', [])
                    if errors:
                        error = errors[0]
                        
                        # Permission denied - critical error, stop immediately
                        if error == 'EGeneral:Permission denied':
                            self.orders = []
                            self.all_orders = []
                            return "Permission denied"
                        
                        # Rate limit exceeded - implement aggressive exponential backoff
                        elif error == 'EAPI:Rate limit exceeded':
                            consecutive_rate_limits += 1
                            
                            # More aggressive exponential backoff: 33s, 66s, 99s, 132s, etc.
                            wait_time = base_retry_delay * (consecutive_rate_limits + attempt)
                            wait_time = min(wait_time, 180)  # Cap at 3 minutes
                            
                            remaining = max_retries - attempt - 1
                            
                            # Update progress with retry information
                            self._update_progress(
                                'Rate limit hit #{} - Waiting {}s ({} retries left)'.format(
                                    consecutive_rate_limits, wait_time, remaining
                                ), 
                                '18%'
                            )
                            
                            # If too many consecutive rate limits, increase delay significantly
                            if consecutive_rate_limits > 3:
                                wait_time = min(wait_time * 2, 300)  # Double wait time, cap at 5 min
                                self._update_progress(
                                    'Multiple rate limits detected - Extended wait: {}s'.format(wait_time), 
                                    '18%'
                                )
                            
                            # If last attempt, break and continue with collected data
                            if attempt == max_retries - 1:
                                break
                            
                            # Wait before retrying
                            time.sleep(wait_time)
                            continue
                        else:
                            # Other errors - stop processing
                            break
                    
                    # Process successful response
                    result = data.get('result', {})
                    trades = result.get('trades', {})
                    
                    # Reset consecutive rate limit counter on success
                    if consecutive_rate_limits > 0:
                        self._update_progress(
                            'Rate limit cleared - Resuming normal operation', 
                            '18%'
                        )
                        consecutive_rate_limits = max(0, consecutive_rate_limits - 1)
                    
                    # Add new trades to accumulated dictionary
                    if trades:
                        jsonStr.update(trades)
                        
                        # Update progress bar with current count
                        total = result.get('count', len(jsonStr))
                        self._update_progress(
                            'Retrieving orders [{}/{}]'.format(len(jsonStr), total), 
                            '18%'
                        )
                    
                    # Mark this batch as successful
                    success = True
                    
                    # Stop condition - received less than batch_size, means we got all data
                    if len(trades) < batch_size:
                        break
                    
                    # Move to next page
                    offset += batch_size
                    break
                    
                except Exception as e:
                    # Handle unexpected exceptions
                    if attempt == max_retries - 1:
                        # Last attempt failed, continue with collected data
                        break
                    # Wait before retrying
                    time.sleep(base_retry_delay)
            
            # Exit main loop if request failed or we got all data
            if not success or len(trades) < batch_size:
                break
        
        # Process collected data
        orders = []
        
        # Handle empty result
        if not jsonStr:
            self.orders = []
            self.all_orders = []
            return True
        
        # Create DataFrame from collected trades
        self.orders = pd.DataFrame.from_dict(jsonStr, orient="index")
        print('orders', self.orders)
        
        if not self.orders.empty:
            # Convert numeric columns to float for calculations
            self.orders[['price', 'cost', 'fee', 'vol', 'margin']] = self.orders[
                ['price', 'cost', 'fee', 'vol', 'margin']
            ].astype(float)
            
            # Group by order ID and aggregate related trades
            grouped_orders = self.orders.groupby('ordertxid').agg({
                'postxid': 'first',  # Take first position ID
                'pair': 'first',  # Take first pair (should be same for all)
                'time': 'first',  # Take first timestamp
                'type': 'first',  # Trade type (buy/sell)
                'ordertype': 'first',  # Order type (market/limit)
                'price': lambda x: (  # Calculate volume-weighted average price
                    (x.astype(float) * self.orders.loc[x.index, 'vol'].astype(float)).sum() / 
                    self.orders.loc[x.index, 'vol'].astype(float).sum()
                ),
                'cost': 'sum',  # Sum total cost
                'fee': 'sum',  # Sum all fees
                'vol': lambda x: x.sum().round(8),  # Sum total volume, round to 8 decimals
                'margin': 'sum',  # Sum total margin
                'misc': 'first'  # Take first misc field
            }).reset_index()
            
            # Convert grouped data to list of dictionaries
            for _, row in grouped_orders.iterrows():
                # Get human-readable symbol name, fallback to pair code
                try:
                    symbol = pair_symbols.get(row['pair'], {}).get('altname', row['pair'])
                except Exception:
                    symbol = row['pair']
                
                # Build order dictionary with all required fields
                orders.append({
                    'ordertxid': row['ordertxid'],  # Order transaction ID
                    'postxid': row['postxid'],  # Position transaction ID
                    'pair': symbol,  # Trading pair symbol
                    'time': row['time'],  # Execution timestamp
                    'type': row['type'],  # Buy or sell
                    'ordertype': row['ordertype'],  # Market, limit, etc.
                    'price': row['price'],  # Weighted average price
                    'cost': row['cost'],  # Total cost
                    'fee': row['fee'],  # Total fees
                    'vol': row['vol'],  # Total volume
                    'margin': row['margin'],  # Total margin
                    'misc': row['misc'],  # Miscellaneous info
                    'category': 'Spot'  # Trading category
                })
        
        # Store processed orders in instance variables
        self.orders = orders
        self.all_orders = self.orders
        
        return True

    def get_kraken_orders_future(self):
        #last_fill = quote(datetime.utcfromtimestamp(start_time).strftime("%Y-%m-%dT%H:%M:%SZ"))
        last_fill = ""
        trades = []
        last_date = self.get_last_date_a(user_account=self.api_key_information, category='Future')        
        start_time = 0 if self.data['partial'] == False else last_date
        try:
            
            while True:
                response = self.kraken_client.get_fills(last_fill)
                if isinstance(response, str):
                    if '429' in response:
                        time.sleep(2)
                        continue
                    else:
                        return response
                if response['result'] == 'success':
                    for order in response['fills']:
                        if datetime.strptime(order['fillTime'][:-1], "%Y-%m-%dT%H:%M:%S.%f").timestamp() > start_time or self.data['partial'] == False:
                            temp = order
                            symbol = order['symbol'].split("_")
                            temp['symbol'] = symbol[1]
                            temp['future_type'] = symbol[0]
                            temp['category'] = "Future"
                            temp['ordertxid'] = order['fill_id']
                            temp['time'] = order['fillTime']
                            trades.append(temp)
                self._update_progress('Retrieving Future orders [{}]'.format(len(trades)), '18%')
                if len(response['fills']) < 100:
                    break
                else:
                    last_fill = response['fills'][-1]['fillTime']
                    dt_last_fill = datetime.strptime(last_fill[:-1], "%Y-%m-%dT%H:%M:%S.%f")
                    if(dt_last_fill.timestamp() < start_time):
                        break
                
            self.orders.extend(trades)
            self.all_orders =self.orders  
            
            return True
        except Exception as ex:
            print(ex)
            print(traceback.print_exc())
            return str(ex)
     
    def interpret_orders(self):
        orders = []
        date_format='mdy'
        pip_value_order_btc = dict()
        verify_njson_len = 0
        b = 0
        j = 1
        #print(self.orders)
        for row in self.orders:
            order=row
            original_file_row = json.loads(json.dumps( row))
            try:
                njson = json.dumps(row['ordertxid'])
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                #{'txid': 'TEW652-B4TEI-XRWDQ4', 'ordertxid': 'OXA7UJ-EWU7B-64GZP4', 'pair': 'XXBTZUSD', 'time': '2019-08-21 21:16:53', 'type': 'buy', 'ordertype': 'limit', 'price': '10174.1', 'cost': '1.01741', 'fee': '0.00275', 'vol': '0.0001', 'margin': '0.20348', 'misc': '', 'ledgers': 'L6CZE6-SMOVS-I7CWXL'}
                if row['category'] == 'Spot':
                    order['symbol'] = row['pair']
                    order['action'] = row['type'].upper()
                    order['quantity'] = row['vol']
                    order['category'] = row['category']
                    if order['action'] not in ['BUY', 'SELL'] or not order['symbol']:
                        continue
                    order['date'] = datetime.utcfromtimestamp(row['time']).strftime('%Y-%m-%d %H:%M:%S')
                elif row['category'] == 'Future':
                    quantity = row['size']
                    order['symbol'] = row['symbol']
                    order['action'] = row['side'].upper()
                    order['quantity'] = quantity
                    order['date'] = row['fillTime']
                    order['category'] = row['category']
                    order['commission'] = ''
                    order['fees'] = ''
            except Exception as ex:
                #print(ex)        
                #print(traceback.print_exc())
                pass
            date_time = order['date']
            original_file_row['date_tz'] = date_time
            any_error, date, time = ImportParams.get_param_datetime(date_time,b)
            new_date_time =  ImportParams.convert_date(date, time, date_format)

            order['date'] = new_date_time[0]
            order['time'] = new_date_time[1]
            
            fp = str(row['price']).replace(',', '').replace('$','')
            decimal = fp[::-1].find('.')
            decimal = decimal if decimal > 1 else 2
            price = float(fp)

            type = 'crypto'
            option = 'CRYPTO'
            expire = ''
            strike = ''
            symbol = order['symbol']
            sym = symbol[-3:]
            pip_value = 1
            if sym.upper() in ['BTC','XBT']:
                row_btc = '{}{}'.format(order['date'],sym)
                if not row_btc in pip_value_order_btc:
                    pip_value_btc = ImportParams.pip_value_crypto_(order['date'], base='usdt', currency='btc')
                    pip_value_order_btc[row_btc] = pip_value_btc
                else:
                    pip_value_btc = pip_value_order_btc[row_btc]
                pip_value = float(pip_value_btc)
            # quantity = abs(float(order['quantity'].replace('-', ''))) if 'quantity' in order else 0
            quantity = abs(float(order['quantity']))
            commission = order['commission'].replace(',', '').replace('-', '') if 'commission' in order else ''
            commission = float(commission) if commission else 0.00
            fee = row['fee'] if 'fee' in row else ''
            fee = float(fee) if fee else 0.00
                
            #################### VERIFY FILE ROW ######################
            try:
                order_id = ''
                user_portfolio=None
                if order['category'] in self.params['user_portfolios']:
                    user_portfolio = self.params['user_portfolios'][order['category']]
                else:
                    user_portfolio = self.params['user_portfolio']


                if 'ordertxid' in row and row['ordertxid']:
                    order_id = row['ordertxid']
                valid_file_row = ImportParams.validate_filerow(self.orders_filerow,
                                                               njson=njson,
                                                               order_id=order_id,
                                                               date_tz=original_file_row['date_tz'],
                                                               price=price,
                                                               option=option,
                                                               action=order['action'],
                                                               quantity=quantity,
                                                               strike=strike,
                                                               expire=expire,
                                                               portfolio=user_portfolio
                                                              )
                if valid_file_row:
                    verify_njson_len = verify_njson_len + 1
                    continue
            except:
                #print(traceback.print_exc())
                pass
            order['type_stock'] = type
            order['type_option'] = option
            order['price'] = price
            order['shares'] = quantity
            order['comm'] = commission
            order['fees'] = fee
            order['njson'] = njson
            order['decimal'] = decimal
            order['expire'] = expire
            order['strike'] = strike
            order['original_file_row'] = original_file_row
            order['mistakes'] = order['mistake'] if 'mistake' in order else ''
            order['trade_notes'] = order['notes'] if 'notes' in order else ''
            order['pip_value'] = pip_value
            order['broker'] = self.params['broker']
            order['userid'] = self.params['get_session_userid']
            order['portfolio'] = user_portfolio

            data_item = ImportParams.get_result_append(order)
            self.out_result.append(data_item)
            b = b - 1 
            j = j +1

            #aqui termina


        self.orders = self.out_result
        self.all_orders = self.orders
        return True