import re
import hashlib
import json

from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required

from .. import_params import ImportParams
from .. security_service import *
from .. logs import create_log
from .. responses import ErrorResponses, SuccessResponses
from .. trade.trades_filerow_temp import *

class BrokerKraken(Resource):

    def getcsv(params, content, date_format='mdy'):
        data = "BrokerKraken"
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            content = content.replace(';', '')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = content.split("\n") if "\n" in content else content.split("\r") if "\r" in content else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                if len(row) == 0:
                    continue
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            b = len(result)
            verify_njson_len = 0
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n['orderid']) if 'orderid' in n else json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                #{'txid': 'TEW652-B4TEI-XRWDQ4', 'ordertxid': 'OXA7UJ-EWU7B-64GZP4', 'pair': 'XXBTZUSD', 'time': '2019-08-21 21:16:53', 'type': 'buy', 'ordertype': 'limit', 'price': '10174.1', 'cost': '1.01741', 'fee': '0.00275', 'vol': '0.0001', 'margin': '0.20348', 'misc': '', 'ledgers': 'L6CZE6-SMOVS-I7CWXL'}
                
                if 'txid' in n:
                    row_exists = TradesFilerow().valid_orderid_trade(params['broker'],
                                                          params['get_session_userid'],
                                                          params['user_portfolio'],
                                                          n['txid'],
                                                          var='txid')
                    if row_exists:
                        verify_njson_len = verify_njson_len + 1
                        continue
                n['symbol'] = n['pair'] if 'pair' in n else ''
                n['action'] = n['type'].upper() if 'type' in n else ''
                n['quantity'] = n['vol'] if 'vol' in n else ''

                if n['action'] not in ['BUY', 'SELL'] or not n['symbol']:
                    continue

                date_time = n['time'] if 'time' in n else n['date'] if 'date' in n else ''
                original_file_row['date_tz'] = date_time
                any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                new_date_time =  ImportParams.convert_date(date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                fp = n['price'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),8) if vfp else 0.00

                type = 'crypto'
                option = 'CRYPTO'
                expire = ''
                strike = ''

                quantity = abs(float(n['quantity'].replace('-', ''))) if 'quantity' in n else 0
                commission = n['commission'].replace(',', '').replace('-', '') if 'commission' in n else ''
                commission = round(float(commission),2) if commission else 0.00
                fee = n['fee'] if 'fee' in n else ''
                fee = round(float(fee),2) if fee else 0.00
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = fee
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['original_file_row'] = original_file_row
                n['mistakes'] = n['mistake'] if 'mistake' in n else ''
                n['trade_notes'] = n['notes'] if 'notes' in n else ''

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b - 1

        except Exception as err:
            print(err)
            any_error = 9

        
        if not any_error and not out_result:
            any_error=9

        return out_result, any_error

      