# Análisis de Validaciones - Kraken Broker

## Resumen Ejecutivo

Análisis exhaustivo de validaciones faltantes entre implementación legacy (787 líneas en 2 archivos) y nueva (361 líneas).

**Hallazgo Principal:** La nueva implementación es **arquitecturalmente superior** con **54% menos código**. Solo **3-4 validaciones críticas** faltantes, principalmente **side validation permisiva**.

---

## Estadísticas del Análisis

### Código Analizado

| Componente | Legacy | Nuevo | Reducción |
|------------|--------|-------|-----------|
| API Sync | 662 líneas (kraken_export.py) | 306 líneas (kraken.py) | -54% |
| CSV Parser | 125 líneas (brokers_kraken.py) | - | - |
| Detector | - | 44 líneas (detector.py) | - |
| **TOTAL** | **787 líneas** | **361 líneas** | **-54%** |

### Validaciones Identificadas

| Categoría | Cantidad | Criticidad | Estimado |
|-----------|----------|-----------|----------|
| Críticas (Fase 1) | 3 | ⭐⭐⭐ ALTA | 1.5 días |
| Calidad (Fase 2) | 2 | 💰 BAJA | 0.5 días |
| Condicionales (Fase 3-4) | 2 | 🎯 CONDICIONAL | 5-7 días |
| Out of Scope | 3 | ✅ CORRECTO | - |
| Ya Manejadas | 5 | ✅ DONE | - |
| **TOTAL** | **15** | - | **2 días críticos** |

---

## Validaciones Críticas (Fase 1)

### 1. ⭐⭐⭐ Side Validation Estricta (ALTA)
**Legacy:** `brokers_kraken.py:67`

**Descripción:** Validación estricta de BUY/SELL. Legacy rechaza sides inválidos.

**Estado Actual:** **PERMISIVO** - Convierte sides inválidos a SELL **silenciosamente**

**Problema Crítico:**
```python
# kraken.py:116-118 (ACTUAL - PROBLEMA)
side = order.get("side", "").upper()
if side not in ("BUY", "SELL"):
    side = "BUY" if side.lower() in ("buy", "b") else "SELL"  # DEFAULT SILENCIOSO!
```

**Implementación:**
```python
# Validación estricta con rechazo
side = order.get("side", "").upper()
if not side or side not in ("BUY", "SELL"):
    logger.warning(f"Skipping fill {ordertxid}: invalid side '{side}'")
    continue
```

**Tests:**
- `test_side_validation_rejects_invalid()`
- `test_side_validation_rejects_empty()`

---

### 2. ⭐⭐ Required Fields Validation (MEDIA-ALTA)
**Legacy:** `brokers_kraken.py:63,67`

**Descripción:** Valida que fill_id, symbol, side no estén vacíos.

**Estado Actual:** Sin validación explícita

**Implementación:**
```python
# Después de línea 114 en parse_json_content()
if not fill_id:
    logger.warning(f"Skipping order: missing fill_id")
    continue

if not symbol:
    logger.warning(f"Skipping fill {fill_id}: missing symbol")
    continue

if not side:
    logger.warning(f"Skipping fill {fill_id}: missing side")
    continue
```

**Tests:**
- `test_required_fields_missing_fill_id()`
- `test_required_fields_missing_symbol()`

---

### 3. ⭐ Price/Quantity Zero Validation (MEDIA)
**Legacy:** `brokers_kraken.py:78-82`

**Descripción:** Rechaza precios/quantities zero o negativos.

**Estado Actual:** Sin validación

**Implementación:**
```python
# Después de líneas 145-146
try:
    price_float = float(order.get("price", 0) or 0)
    if price_float <= 0:
        logger.warning(f"Skipping fill {ordertxid}: invalid price")
        continue
except (ValueError, TypeError):
    logger.warning(f"Skipping fill {ordertxid}: non-numeric price")
    continue

try:
    qty_float = float(order.get("qty", 0) or 0)
    if qty_float <= 0:
        logger.warning(f"Skipping fill {ordertxid}: invalid quantity")
        continue
except (ValueError, TypeError):
    logger.warning(f"Skipping fill {ordertxid}: non-numeric quantity")
    continue
```

**Tests:**
- `test_price_quantity_zero_rejected()`
- `test_price_quantity_negative_rejected()`

---

## Validación de Calidad (Fase 2)

### 4. 💰 Fee Absolute Value + Rounding (BAJO)
**Legacy:** `brokers_kraken.py:91-93`

**Descripción:** Aplica abs() y redondea fees a 2 decimales.

**Estado Actual:** Fee hardcoded a 0.0 (API no devuelve fees aún)

**Implementación:**
```python
# Línea 157
"fee": abs(round(float(order.get("fee", 0) or 0), 2)),

# Línea 205 (cuando se agregue columna fee)
pl.col("fee").abs().round(2).alias("fees"),
```

**Tests:**
- `test_fee_absolute_value_negative()` (preparar para futuro)

---

### 5. 💰 Quantity Absolute Value (BAJO)
**Legacy:** `brokers_kraken.py:89`

**Descripción:** Normaliza quantities a valores positivos.

**Estado Actual:** Sin abs()

**Implementación:**
```python
# Línea 164
"qty": abs(float(order.get("qty", 0) or 0)),
```

**Tests:**
- `test_quantity_absolute_value_negative()`

---

## Validaciones Condicionales (Fase 3-4)

### 6. 🎯 Spot Support (Condicional)
**Decisión:** ¿Usuarios operan Kraken Spot (además de Futures)?

**Query:**
```sql
SELECT
    CASE
        WHEN symbol LIKE 'PF_%' THEN 'Futures'
        ELSE 'Spot'
    END as account_type,
    COUNT(*) as count,
    COUNT(DISTINCT user_id) as user_count
FROM kraken_orders_raw
WHERE created_at > NOW() - INTERVAL '6 months'
GROUP BY account_type;
```

**Si Spot count > 0 Y user_count > 5:** Implementar soporte (2-3 días)

---

### 7. 🎯 CSV Support (Condicional)
**Decisión:** ¿Usuarios suben CSVs manualmente?

**Query:**
```sql
SELECT
    source_type,
    COUNT(*) as count,
    COUNT(DISTINCT user_id) as user_count,
    ROUND(100.0 * COUNT(*) / SUM(COUNT(*)) OVER (), 2) as percentage
FROM data_sources
WHERE broker_id = 'kraken'
  AND created_at > NOW() - INTERVAL '6 months'
GROUP BY source_type;
```

**Si CSV percentage > 5%:** Implementar parser (3-4 días)

---

## Validaciones Out of Scope ✅

### 8. ✅ Order Aggregation / VWAP Calculation
**Legacy:** `kraken_export.py:440-481`

**Conclusión:** **OUT OF SCOPE** - Pertenece a **p03_group** stage

**Razón:** Pipeline separation of concerns

---

### 9. ✅ Rate Limiting / Exponential Backoff
**Legacy:** `kraken_export.py:312-419`

**Conclusión:** **OUT OF SCOPE** - Pertenece a **sync service**

**Razón:** Normalizer no hace API calls

---

### 10. ✅ Pip Value Calculation (BTC/XBT)
**Legacy:** `kraken_export.py:588-597`

**Conclusión:** **OUT OF SCOPE** - Pertenece a **p04_calculate** stage

**Razón:** P&L calculations no van en normalizer

---

## Validaciones Ya Implementadas ✅

### 11. ✅ Column Detection
**Estado:** YA IMPLEMENTADO (línea 80)
```python
def can_handle(df_sample: "pl.DataFrame") -> bool:
    required_columns = {"fill_id", "symbol", "side", "qty", "price"}
    return required_columns.issubset(set(df_sample.columns))
```

### 12. ✅ JSON Structure Validation
**Estado:** YA IMPLEMENTADO (líneas 102-110)

### 13. ✅ Hash Computation
**Estado:** 100% COMPATIBLE (líneas 120-124)
- Match rate: 261/261 records (100%)

### 14. ✅ PF_ Prefix Detection
**Estado:** YA IMPLEMENTADO (líneas 128-133)

### 15. ✅ Timezone Conversion
**Estado:** YA IMPLEMENTADO (líneas 233-238)
- UTC → America/New_York

---

## Matriz de Priorización

| # | Validación | Criticidad | Días | Fase |
|---|------------|-----------|------|------|
| 1 | Side Validation Estricta | ⭐⭐⭐ ALTA | 0.5 | 1 |
| 2 | Required Fields | ⭐⭐ MEDIA-ALTA | 0.5 | 1 |
| 3 | Price/Qty Zero | ⭐ MEDIA | 0.5 | 1 |
| 4 | Fee Abs + Round | 💰 BAJA | 0.25 | 2 |
| 5 | Qty Absolute | 💰 BAJA | 0.25 | 2 |
| 6 | Spot Support | 🎯 CONDICIONAL | 2-3 | 3 |
| 7 | CSV Support | 🎯 CONDICIONAL | 3-4 | 4 |
| 8-10 | Out of Scope | ✅ N/A | 0 | - |
| 11-15 | Ya Implementadas | ✅ DONE | 0 | - |

**Total Fase 1-2 (Crítico):** 2 días
**Total Fase 3-4 (Condicional):** 5-7 días

---

## Comparación con Otros Brokers

| Broker | Legacy | Nuevo | Reducción | Críticas | Días |
|--------|--------|-------|-----------|----------|------|
| **Kraken** | **787** | **361** | **54%** | **3-4** | **2** |
| Coinbase | 1,725 | 324 | 81% | 2 | 2-3 |
| Bybit | 1,584 | 384 | 76% | 2 | 3-5 |
| Tastyworks | ~1,200 | ~350 | 71% | 3 | 4-6 |

**Observaciones Kraken:**
- Menor reducción (54%) porque legacy era más conciso
- Side validation permisiva es el issue principal
- Excelente separación de concerns
- Rate limiting y VWAP correctamente excluidos

---

## Archivos Incluidos

```
new_changes_kraken/
├── README.md                                    # Este archivo
├── PLAN_ANALISIS_VALIDACIONES_KRAKEN.md         # Plan detallado
├── CAMBIOS_IMPLEMENTADOS.md                     # Log de cambios
├── EJEMPLOS_CAMBIOS_CODIGO.md                   # Ejemplos código
├── brokers/kraken/
│   ├── kraken.py.original                      # Código actual (306 líneas)
│   ├── detector.py                             # Detector (44 líneas)
│   └── README.md                                # Guía implementación
├── tests/
│   └── test_kraken.py.original                 # Tests actuales (406 líneas)
└── old_code_from_legacy/
    ├── kraken_export.py                         # Legacy API (662 líneas)
    └── brokers_kraken.py                        # Legacy CSV (125 líneas)
```

---

## Recomendación Final

1. **✅ Implementar Fase 1 inmediatamente** (1.5 días)
   - Side validation estricta (CRÍTICO)
   - Required fields validation
   - Price/quantity zero validation

2. **✅ Implementar Fase 2** (0.5 días)
   - Fee absolute value + rounding
   - Quantity absolute value

3. **⚠️ Ejecutar queries antes de Fase 3-4**
   - Verificar si Spot support es necesario
   - Verificar volumen de CSVs

4. **🚫 NO sobre-ingenierizar**
   - Preservar simplicidad arquitectural
   - No replicar deuda técnica legacy
   - Rate limiting/VWAP ya están en lugares correctos

---

**Match Rate Actual:** 100% (261/261 records)
**Última Actualización:** 2026-01-14
**Estado:** ✅ ANÁLISIS COMPLETADO - LISTO PARA FASE 1

**Issue Principal:** Side validation **demasiado permisiva** - convierte inválidos a SELL silenciosamente. **DEBE corregirse**.
