""" Coinbase V2 Export Module """
import hashlib
import re
import time
import traceback
import codecs
import json
import base64
# from io import StringIO
from datetime import datetime
from urllib.parse import urlencode
from flask_restful import Resource
import requests
from app.security_service import verify_role
from app.event.events import UserEventList as EventUser
from app.models import BrokersConnections, UserEvents
from app.responses import ErrorResponses
# from ..user.users_params import UserParams
from app.import_params import ImportParams
from app.trade.trades_regroups import TradeRegroups
from app.broker.brokers_export import BrokerExport
from app.server_info import ServerInfo
try:
    import jwt
    from cryptography.hazmat.primitives import serialization
    from cryptography.hazmat.primitives.asymmetric import ed25519
    import secrets
except ImportError:
    pass


class CoinbaseV2Export(BrokerExport, ServerInfo, Resource):
    """ Coinbase V2 Export Class """
    @verify_role('broker export')
    def post(self):
        """
        Handles the synchronization and import process for Coinbase accounts.
        This method performs the following steps:
        1. Initializes the synchronization event and updates progress.
        2. Iterates through each credential to:
            - Validate credentials.
            - Log in to Coinbase.
            - Optionally call an AWS Lambda function for processing.
            - Save account information for spot and future categories.
            - Retrieve and process orders for spot and future accounts, using either a microservice or direct API calls.
            - Save configuration and order data.
            - Update user configuration status.
        3. Handles errors and exceptions by unlocking portfolios, sending notifications, and returning appropriate error responses.
        Returns:
            Response object indicating the result of the synchronization process, or an error response if an exception occurs.
        """
        try:
            # Start synchronization and update progress
            new_event_id = self.init_sync()
            if self.user.id == 306332:

                print('post coinbase')
                print('post coinbase')
                print('post coinbase')
                print('post coinbase')
                print('post coinbase')
                print('post coinbase')
                print('post coinbase')
                print('post coinbase')
                print('post coinbase')
            self._update_progress('Saving Pre-Data', '1%')
            if not isinstance(new_event_id, UserEvents) and not self.is_lambda():
                return new_event_id
            if self.user.id == 306332:
                print('credentials',self.credentials ) 
                print('credentials',self.credentials ) 
                print('credentials',self.credentials ) 
                print('credentials',self.credentials ) 
                print('credentials',self.credentials ) 
                print('credentials',self.credentials ) 
                print('credentials',self.credentials ) 
                print('credentials',self.credentials ) 
                print('credentials',self.credentials ) 
            for credential in self.credentials:
                if self.user.id == 306332:
                    print('credential',credential ) 
                    print('credential',credential ) 
                    print('credential',credential ) 
                    print('credential',credential ) 
                    print('credential',credential ) 
                    print('credential',credential ) 
                    print('credential',credential ) 
                    print('credential',credential ) 
                    print('credential',credential ) 
                self.credential = credential
                self._update_progress('Checking Credentials', '5%')
                self.not_error = self.validate()
                if self.not_error is not True:
                    _end = self.end_sync(code=1)
                    if _end is not True:
                        return _end
                self.symbols = []
                self._update_progress('Login To Coinbase', '5%')
                self.not_error = self.login()
                if self.user.id == 306332:
                    print('login', self.not_error )
                    print('login', self.not_error )
                    print('login', self.not_error )
                    print('login', self.not_error )
                    print('login', self.not_error )
                    print('login', self.not_error )
                    print('login', self.not_error )
                    print('login', self.not_error )
                if self.not_error is not True:
                    _end = self.end_sync(code=1)
                    if _end is not True:
                        return _end
                self.account_pusher = 'Account #' + \
                    str(self.api_key_information['id'])
                self.time_out_lambda = False
                if self.condition_lambda() and not self.aws_autosync:
                    try:
                        self.not_error = self.call_lambda()
                    except Exception as err:
                        # print(err)
                        # print(traceback.print_exc())
                        self.not_error = err
                        self.executed_lambda = False
                if not self.executed_lambda:
                    if self.spot:
                        self._update_progress('Save Account Spot', '8%')
                        self.save_account(
                            self.api_key_information['id'], category="SPOT")
                    if self.future1:
                        self._update_progress('Save Account Future', '8%')
                        self.save_account(
                            self.api_key_information['id'], category="FUTURE")
                    self._update_progress('Connecting to the server', '15%')
                    self._update_progress('Saving data', '16%')
                    self.save_configs()
                    if self.spot:
                        self.orders = []
                        self.all_orders = []
                        self._update_progress('Retrieving Spot orders ', '18%')
                        #if self.use_microservice() is True:
                        #    self.not_error = self.get_orders_microservice(
                        #        category="SPOT")
                        #else:
                        #    self.not_error = self.get_orders("SPOT")
                        self.not_error = self.get_orders("SPOT")
                        if self.not_error is not True:
                            _end = self.end_sync(code=7)
                            if _end is not True:
                                return _end
                        self.all_orders = self.orders
                        self._update_progress('Saving Files', '19%')
                        if len(self.all_orders) > 0:
                            self.save_files(file_type='json')
                            self._update_progress('Reading orders Spot', '20%')
                            self.interpret_orders()
                            self._update_progress('Save orders Spot', '20%')
                            self.save_orders()
                        self.not_error = self.save_params("SPOT")
                    if self.future1:
                        self.orders = []
                        self.all_orders = []
                        self._update_progress(
                            'Retrieving Future orders ', '18%')
                        #if self.use_microservice() is True:
                        #    self.not_error = self.get_orders_microservice(
                        #        category="FUTURE")
                        #else:
                        #    self.not_error = self.get_orders("FUTURE")
                        self.not_error = self.get_orders("FUTURE")
                        if self.not_error is not True:
                            _end = self.end_sync(code=7)
                            if _end is not True:
                                return _end
                        self.all_orders = self.orders
                        if len(self.all_orders) > 0:
                            self.save_files(file_type='json')
                            self._update_progress('Reading orders', '19%')
                            self.interpret_orders()
                            self._update_progress('Save orders', '20%')
                            self.save_orders()
                        self.not_error = self.save_params("FUTURE")
                    self.user.users_configs.tda_import = True
                    self.user.users_configs.save()
                    # self._update_progress('Import completed', '100%')
                    # if len(self.credentials) <= 1:
                    self.sync_status(
                        healthy=True, message=self.out['mgs'] if 'mgs' in self.out else 'Sync Success', status_code=200)
            # TERMINA LA ITERACION
            return self.end_sync(event_id=new_event_id)

        except Exception:
            # print(err)
            # print(traceback.print_exc())
            # UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, True)
            self.unlock_portfolios()
            self._update_progress('warning', 'Imported Fail', True)
            if self.is_lambda() and self.can_call_lambda():
                self.save_params_lambda(
                    (int(time.time())-self.star_timestamp), 500, 'Fail')
            return ErrorResponses.error_500(self.data, err, {})

    def validate(self):
        """
        Validates and initializes broker connection credentials and configuration.
        This method performs the following actions:
        - Loads symbols from input data if provided.
        - Saves user configuration.
        - If credentials exist and not adding a new connection:
            - Loads API key, secret key, passphrase, test account, spot, future1, and sync status from credentials.
            - If both spot and future1 are False, sets them to True and updates the database.
        - If adding a new connection:
            - Loads API key, secret key, test account, spot, future1, and add flag from input data.
            - If both spot and future1 are False, sets them to True.
            - Sets new_sync to True and host to Coinbase API URL.
        - Returns True on successful validation and initialization.
        - Returns the traceback string if an exception occurs.
        Returns:
            bool or str: True if validation succeeds, otherwise the exception traceback.
        """
        try:
            self.host = "https://api.coinbase.com"
            self.symbols = self.data.get('symbols', self.symbols)
            self.user.users_configs.save()
            if self.credential and self.add is False:
                self.api_key = self.credential.api_key
                self.secret_key = codecs.decode(
                    self.credential.secret_key, 'unicode_escape')
                self.passphrase = self.credential.passphrase
                self.test_account = self.credential.test_account
                self.spot = self.credential.spot
                self.future1 = self.credential.future1
                self.new_sync = self.credential.new_sync
                if self.spot is False and self.future1 is False:
                    self.spot = True
                    self.future1 = True
                    BrokersConnections.query.filter_by(user_id=self.user.id, id=self.credential.id).update({
                        "spot": self.spot,
                        "future1": self.future1
                    })
                    db.session.commit()
                return True
            
            self.api_key = self.data['api_key'].strip()
            self.secret_key = codecs.decode(
                self.data['secret_key'], 'unicode_escape')
            self.test_account = self.data['test_account'] if 'test_account' in self.data and self.data['test_account'] != "" else False
            self.spot = self.data['spot'] if 'spot' in self.data and self.data['spot'] != "" else False
            self.future1 = self.data['future1'] if 'future1' in self.data and self.data['future1'] != "" else False
            self.add = self.data.get('add', False)
            if self.spot is False and self.future1 is False:
                self.spot = True
                self.future1 = True
            self.new_sync = True

            return True

        except:
            return traceback.format_exc()

    def extraer_identificador(self, _str):
        """
        Extracts the organization identifier from a given string using a regular expression.
        The method searches for a pattern matching 'organizations/{identifier}/apiKeys/' 
        and returns the extracted identifier if found.
        Args:
            _str (str): The input string to search for the organization identifier.
        Returns:
            str: The extracted organization identifier if found.
            bool: False if the pattern is not found or an exception occurs.
        """
        
        try:
            pattern = r'organizations/([^/]+)/apiKeys/'
            result = re.search(pattern, _str)
            if result:
                return result.group(1)
            return False
        except Exception:
            return False

    def build_jwt(self, key_var, secret_var, uri=None):
        """
        Generates a JSON Web Token (JWT) using either ECDSA (ES256) or Ed25519 algorithms based on the format of the key.
        If the key starts with 'organizations/', ECDSA (ES256) is used with PyJWT. Otherwise, Ed25519 is used with a manual implementation.
        Args:
            key_var (str): The key identifier. If it starts with 'organizations/', ECDSA is used; otherwise, Ed25519.
            secret_var (str): The secret or private key used for signing the JWT. For ECDSA, it should be a PEM-encoded string. For Ed25519, it should be a base64-encoded private key.
            uri (str, optional): An optional URI to include in the JWT payload.
        Returns:
            str: The generated JWT as a string.
        Raises:
            Exception: If there is an error during Ed25519 JWT generation.
        """
        jwt_data = {
            "sub": key_var,
            "iss": "cdp",
            "nbf": int(time.time()),
            "exp": int(time.time()) + 120,
        }

        if uri:
            jwt_data["uri"] = uri

        # Determine protocol based on key format
        if key_var.startswith('organizations/'):
            # ECDSA - Use PyJWT
            private_key_bytes = secret_var.encode("utf-8")
            # DEBUG - quitar después de diagnosticar
            print("DEBUG secret_var type:", type(secret_var))
            print("DEBUG secret_var repr:", repr(secret_var[:100]) if len(secret_var) > 100 else repr(secret_var))
            print("DEBUG secret_var starts with:", secret_var[:50])
            # ORIGINAL - descomentar para rollback:
            # private_key = serialization.load_pem_private_key(
            #     private_key_bytes, password=None
            # )
            # FIX: Envolver en try/except para normalizar si falla
            try:
                private_key = serialization.load_pem_private_key(
                    private_key_bytes, password=None
                )
            except ValueError:
                # FIX: Si falla, reformatear clave PEM (header pegado al contenido)
                import re
                key_body = re.sub(r'-----[A-Z ]+-----', '', secret_var).replace("\n", "").replace("\\n", "").strip()
                formatted_key = "-----BEGIN EC PRIVATE KEY-----\n" + "\n".join([key_body[i:i+64] for i in range(0, len(key_body), 64)]) + "\n-----END EC PRIVATE KEY-----"
                print("DEBUG formatted_key:", repr(formatted_key[:150]))
                private_key = serialization.load_pem_private_key(formatted_key.encode("utf-8"), password=None)

            jwt_token = jwt.encode(
                jwt_data,
                private_key,
                algorithm="ES256",
                headers={"kid": key_var, "nonce": secrets.token_hex()},
            )

            if isinstance(jwt_token, bytes):
                return jwt_token.decode('UTF-8')
            return jwt_token
        
        # Ed25519 - Manual implementation because PyJWT < 2.0 doesn't support EdDSA
        try:

            # 1. Prepare Header
            header = {
                "alg": "EdDSA",
                "typ": "JWT",
                "kid": key_var,
                "nonce": secrets.token_hex()
            }

            # 2. Encode Header and Payload
            def base64url_encode(input_bytes):
                return base64.urlsafe_b64encode(input_bytes).rstrip(b'=')

            header_json = json.dumps(
                header, separators=(',', ':')).encode('utf-8')
            payload_json = json.dumps(
                jwt_data, separators=(',', ':')).encode('utf-8')

            header_b64 = base64url_encode(header_json)
            payload_b64 = base64url_encode(payload_json)

            signing_input = header_b64 + b'.' + payload_b64

            # 3. Sign
            # Decode secret key
            private_key_bytes = base64.b64decode(secret_var)
            private_key = ed25519.Ed25519PrivateKey.from_private_bytes(
                private_key_bytes[:32])

            signature = private_key.sign(signing_input)
            signature_b64 = base64url_encode(signature)

            # 4. Construct Token
            jwt_token = signing_input + b'.' + signature_b64
            return jwt_token.decode('utf-8')

        except Exception as e:
            # print(f"Error generating Ed25519 JWT: {e}")
            raise e

    def extract_value_regex(self):
        """
        Extracts the value between '-----BEGIN EC PRIVATE KEY-----' and '-----END EC PRIVATE KEY-----'
        from the `self.secret_key` string using a regular expression.
        Returns:
            str or None: The extracted private key value if found, otherwise None.
        """
        pattern = r"-----BEGIN EC PRIVATE KEY-----(.*?)-----END EC PRIVATE KEY-----"
        _search = re.search(pattern, self.secret_key, re.DOTALL)
        if _search:
            return _search.group(1)
        return None

    def verify_secret_key(self):
        """
        Verifies and formats the extracted secret key as an EC private key.
        Extracts the secret key using a regular expression. If extraction fails,
        returns the existing secret key. Otherwise, removes newline characters,
        splits the key into 64-character lines, and wraps it with EC private key
        PEM headers.
        Returns:
            str: The formatted EC private key string.
        """
        secret_key = self.extract_value_regex()
        if secret_key is None:
            return self.secret_key
        secret_key = secret_key.replace("\n", "").replace("\\n", "")
        new_secret_key = ""
        for i in range(0, len(secret_key), 64):
            new_secret_key += secret_key[i:i+64] + "\n"

        return f"-----BEGIN EC PRIVATE KEY-----\n{new_secret_key}-----END EC PRIVATE KEY-----"

    def login(self):
        """
        Authenticates with the Coinbase API using the provided API key and secret key.
        Depending on the format of the secret key, selects the appropriate JWT signing method (ECDSA or Ed25519).
        Builds a JWT token and sends a GET request to the Coinbase brokerage accounts endpoint.
        If authentication is successful and accounts are found, extracts and stores the account identifier.
        Returns True on success, a message if no accounts are found, or the error response text on failure.
        In case of an exception, prints the traceback if running in a Lambda environment and returns the formatted traceback.
        Returns:
            bool or str: True if authentication and account retrieval succeed,
                         'Not accounts founds' if no accounts are found,
                         response text or formatted traceback on failure.
        """
        try:
            endpoint = '/api/v3/brokerage/accounts'
            # jwt_token = self.generate_jwt("get",endpoint )
            uri = f"GET api.coinbase.com{endpoint}"
            if '\n' in self.secret_key or self.api_key.startswith('organizations/'):
                # ECDSA usually has newlines in PEM or starts with organizations/
                if '\\n' in self.secret_key:
                    jwt_token = self.build_jwt(
                        self.api_key, self.secret_key.replace("\\n", "\n"), uri)
                else:
                    # If it's already formatted or we need to verify/format it
                    if not self.secret_key.startswith('-----BEGIN'):
                        self.secret_key = self.verify_secret_key()
                    jwt_token = self.build_jwt(
                        self.api_key, self.secret_key, uri)
            else:
                # Ed25519
                jwt_token = self.build_jwt(self.api_key, self.secret_key, uri)

            header = {
                "Authorization": f"Bearer {jwt_token}"
            }
            response = requests.get(f"{self.host}{endpoint}", headers=header)
            if self.user.id == 306332:

                print(response.text)
                print(response.text)
                print(response.text)
                print(response.text)
                print(response.text)
                print(response.text)
                print(response.text)
                print(response.text)
                print(response.text)
            if response.status_code == 200:
                response = response.json()
                if len(response['accounts']) > 0:
                    id = self.extraer_identificador(self.api_key)
                    if id != False:
                        self.api_key_information = {"id": id[:6]}
                    else:
                        self.api_key_information = {"id": self.api_key[:6]}
                    return True
                else:
                    return 'Not accounts founds'
            else:
                return response.text
        except Exception:
            if self.is_lambda():
                print(traceback.print_exc())
            return traceback.format_exc()

    def get_orders(self, category='SPOT'):
        """
        Retrieves historical filled orders from Coinbase brokerage API for the specified product category.
        Args:
            category (str, optional): The product category to filter orders by (e.g., 'SPOT', 'FUTURE'). Defaults to 'SPOT'.
        Returns:
            bool: True if orders were successfully retrieved and processed.
            str: Formatted traceback string if an exception occurred.
        Side Effects:
            - Updates self.orders with the list of retrieved trades.
            - Calls self._update_progress to report progress during retrieval.
        Notes:
            - Handles pagination using cursors to retrieve all available orders.
            - Fetches additional product details for FUTURE trades.
            - Limits API request attempts to 5 in case of errors.
        """
        
        try:
            trades = []
            next_cursor = ''
            limit = 1000
            last_date = self.get_last_date_a(
                user_account=self.api_key_information['id'], category=category)
            star_time = last_date if self.partial is True else 0
            dt_utc = datetime.utcfromtimestamp(star_time)
            endpoint = '/api/v3/brokerage/orders/historical/batch'
            # jwt_token = self.generate_jwt("get",endpoint )
            uri = f"GET api.coinbase.com{endpoint}"
            if '\n' in self.secret_key or self.api_key.startswith('organizations/'):
                jwt_token = self.build_jwt(
                    self.api_key, self.secret_key.replace("\\n", "\n") if "\\n" in self.secret_key else self.secret_key, uri)
            else:
                jwt_token = self.build_jwt(self.api_key, self.secret_key, uri)
            header = {
                "Authorization": f"Bearer {jwt_token}",
                'Content-Type': 'application/json'
            }
            trades = []
            c = category.lower().capitalize()
            attempts = 0
            while True:
                timestamp = datetime.utcfromtimestamp(time.time())

                params = {
                    # 'limit':limit,
                    'order_status': 'FILLED',
                    'end_date': timestamp.strftime('%Y-%m-%dT%H:%M:%SZ'),
                    'start_date': dt_utc.strftime('%Y-%m-%dT%H:%M:%SZ'),
                    'product_type': category,
                    'limit': limit
                }
                if next_cursor != '':
                    params['cursor'] = next_cursor
                params_str = urlencode(params)
                response = requests.get(
                    f"{self.host}{endpoint}?{params_str}", headers=header, timeout=10)
                if response.status_code == 200:
                    data = response.json()
                    # trades.extend(response['orders'])
                    for orden in data['orders']:
                        if datetime.strptime(orden['created_time'], '%Y-%m-%dT%H:%M:%S.%fZ').timestamp() > star_time:
                            trades.append(orden)
                    time.sleep(.16)
                    if data['has_next'] == False:
                        break
                    else:
                        self._update_progress(
                            f"Retrieving {c} orders: [{len(trades)}]", '18%')
                        next_cursor = data['cursor']
                else:
                    # print(f"Error retrieving {category} orders: {response.text}")
                    attempts += 1
                    if attempts >= 5:
                        break

            products = {}
            i = 1
            total = len(trades)
            for trade in trades:
                if i % 100 == 0 or i == 1 or i == total:
                    self._update_progress(
                        f"Retrieving details for {c} trades: {i}/{total}", '18%')
                i += 1

                trade['category'] = trade['product_type']
                if trade['product_type'] == 'FUTURE':
                    if not trade['product_id'] in products:
                        endpoint = '/api/v3/brokerage/market/products/{}'.format(
                            trade['product_id'])
                        response = requests.get(
                            f"{self.host}{endpoint}", headers=header)
                        if response.status_code == 200:
                            response = response.json()
                            products[trade['product_id']] = response
                    product = products[trade['product_id']]
                    trade['product'] = product

            self.orders = trades
            return True
        except Exception:
            # print(e)
            # print(traceback.print_exc())
            return traceback.format_exc()

    def get_orders_microservice(self, category='SPOT'):
        """
        Fetches orders from a microservice for the specified category (default: 'SPOT').
        This method constructs a payload with user and account information, including credentials,
        and sends a POST request to the microservice to retrieve order data. If partial fetching is enabled,
        it uses the last known date for the user account as the start time; otherwise, it fetches all orders.
        The response is processed to extract the file path containing the orders, which are then loaded and
        appended to the instance's orders list.
        Events are posted and updated for tracking the order retrieval process.
        Args:
            category (str, optional): The category of orders to fetch (e.g., 'SPOT'). Defaults to 'SPOT'.
        Returns:
            bool: True if the orders were successfully fetched and processed.
            str: Error message if an exception occurs or if the response is not successful.
        """
        get_orders_event = EventUser.post_user_events(100, new_user=self.user_id)
        spot_orders = []
        url = self.url_microservice()
        headers = {
            'Content-Type': 'application/json'
        }
        if self.partial is True:
            start_time = self.get_last_date_a(
                user_account=self.api_key_information['id'], category=category) if self.add is False else 0  # - 86400 menos un dia
            start_time = max(start_time, 0)
        else:
            start_time = 0
        end_time = int(time.time() * 1000)
        account = {
            "broker": self.broker.broker_key.lower(),
            "credentials": {
                "user": self.api_key,
                "password": self.secret_key,
                "passphrase": self.passphrase,
                "test_account": self.test_account
            },
            "categories": [
                category.lower()
            ]
        }
        if start_time > 0:
            account["date_range"] = {
                "start": start_time,
                "end": end_time
            }
        payload = {
            "users": [
                {
                    "id": self.user.uuid,
                    "accounts": [account]
                }
            ]
        }
        response = requests.request("POST", url, headers=headers, json=payload)
        # print(response.json())
        if response.status_code == 200:
            try:
                if 'body' in response.json()['result']:
                    body = response.json()['result']['body']
                    # print('body',body)
                    if body['final_path'] is not None and body['final_path'] != '':
                        file_path = body['final_path']
                        order = self.s3_to_json_microservice(s3_url=file_path)
                        spot_orders = order['orders']
                    else:
                        spot_orders = []
            except Exception as e:
                # print(response.text)
                # print(traceback.print_exc())
                return str(e)
        else:
            return response.text
        # print(
        #    f"Total orders fetched from microservice for {category}: {len(spot_orders)}")
        # self.all_orders = spot_orders
        self.orders.extend(spot_orders if spot_orders is not None else [])

        if get_orders_event:
            EventUser.update_user_events(get_orders_event)
        return True

    def interpret_orders(self):
        """
        Processes and interprets all orders in `self.all_orders`, transforming and validating each order's data for further use.
        The method performs the following steps for each order:
        - Updates progress at intervals.
        - Normalizes and converts order fields (price, quantity, commission, symbol, etc.).
        - Handles different order categories (e.g., FUTURE, crypto).
        - Converts date and time formats to UTC.
        - Validates orders using various checks (status, action, duplicate detection, etc.).
        - Calculates additional fields (pip value, decimal precision, etc.).
        - Appends processed order data to `self.out_result`.
        Skips orders that do not pass validation or are not filled. Updates user events at the end of processing.
        Raises:
            Exception: If any error occurs during order processing, the order is skipped.
        Side Effects:
            - Modifies `self.out_result` with processed order data.
            - Updates user events via `EventUser`.
        """
        interpreter_orders_event = EventUser.post_user_events(101, new_user=self.user_id)
        pip_value_order = dict()
        b = 0
        new_date_time = []
        verify_njson_len = 0
        orders_orderid = []
        i = 0

        for order in self.all_orders:
            i += 1
            if i % 100 == 0 or i == 1 or i == len(self.all_orders):
                self._update_progress(
                    "Reading orders: {}/{}".format(i, len(self.all_orders)), '20%')

            original_file_row = json.loads(json.dumps(order))
            njson = json.dumps(order)
            njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
            try:
                action = order['side'].upper()

                order['price'] = float(order['average_filled_price'])
                quantity = float(order['filled_size'])

                order['side'] = action
                order['date'] = order['created_time']
                order['quantity'] = quantity
                order['commission'] = float(
                    order['commission']) if 'commission' in order else 0
                if order['category'] == 'FUTURE':
                    details = order['product']['future_product_details']
                    s = order['product']['display_name'].split(" ")
                    order['symbol'] = f"{s[0]}{order['product']['quote_display_symbol']}"
                    order['quantity'] = order['quantity'] * \
                        float(details['contract_size'])
                else:
                    order['symbol'] = order['product_id'].replace("-", "")
                order['fees'] = float(order['total_fees'])
                # order['symbol'] = order['symbol'].replace("#", "")
            except Exception:
                # print(err)
                # print(traceback.format_exc())
                continue
            if order['status'] != 'FILLED':
                continue
            if not action:
                continue
            pip_value = 1
            date_time = order['date']
            original_file_row['date_tz'] = date_time
            self.any_error, date, time = ImportParams.get_param_datetime(
                date_time, b)
            new_date_time = ImportParams.convert_date(
                date, time, self.date_format, True, 'UTC')

            order['date'] = new_date_time[0]
            order['time'] = new_date_time[1]
            fp = str(order['price']).replace(',', '').replace('$', '')
            decimal = fp[::-1].find('.')
            decimal = decimal if decimal > 1 else 2
            price = round(float(fp), decimal)
            # price = round(float(order['price'].replace(',', '')),6)

            sm = len(order['symbol'])
            type = 'crypto'
            option = 'CRYPTO'
            strike = ''
            expire = ''
            # order['size'] = 1

            if order['category'] in self.params['user_portfolios']:
                user_portfolio = self.params['user_portfolios'][order['category']]
            else:
                user_portfolio = self.params['user_portfolio']

            # user_portfolio = self.params['user_portfolio']

            if 'pair' in order:
                order['size'] = 10
                pip_value = self.convert_usdt(order, pip_value_order, date)

            #################### VERIFY FILE ROW ######################
            if ImportParams.verify_njson(njson, self.params['get_session_userid'], user_portfolio):
                verify_njson_len = verify_njson_len + 1
                continue
            
            if 'order_id' in original_file_row and original_file_row['order_id']:
                n2 = original_file_row['order_id']
                njson2 = json.dumps(n2)
                njson2 = hashlib.md5(njson2.encode('utf-8')).hexdigest()
                if ImportParams.verify_njson(njson2, self.params['get_session_userid'], user_portfolio):
                    verify_njson_len = verify_njson_len + 1
                    continue
                
                if ImportParams.verify_date_file_row(self.params['get_session_userid'],
                                                        self.params['broker'],
                                                        original_file_row,
                                                        argv2='order_id' if 'order_id' in original_file_row
                                                        else '',
                                                        portfolio=user_portfolio
                                                        ):
                    verify_njson_len = verify_njson_len + 1
                    continue
                
                njson3 = {
                    'price': float(fp) if fp else 0.00,
                    'date': order['date'] + ' ' + order['time'],
                    'option_type': option,
                    'action': 1 if action == 'BUY' else 2,
                    'shares': order['quantity'],
                    'strike': float(strike) if ImportParams.isfloat(strike) else '',
                    'expire': expire,

                }
                if ImportParams.verify_njson_webull(njson3, self.params['get_session_userid']):
                    verify_njson_len = verify_njson_len + 1
                    continue
                
                njson = njson2

            order['trade_notes'] = order['text'] if 'text' in order else ''
            order['type_stock'] = type
            order['type_option'] = option
            order['action'] = action
            order['price'] = price
            order['shares'] = str(order['quantity']).replace(',', '')
            order['comm'] = str(order['commission']).replace(',', '').replace('$',
                                                                              '') if 'commission' in order else '0.00'
            order['njson'] = njson
            order['decimal'] = decimal
            order['expire'] = expire
            order['strike'] = strike
            order['pip_value'] = pip_value

            order['original_file_row'] = original_file_row
            order['broker'] = self.params['broker']
            order['userid'] = self.params['get_session_userid']
            order['portfolio'] = user_portfolio

            data_item = ImportParams.get_result_append(order)
            self.out_result.append(data_item)
            b = b + 1

        if interpreter_orders_event:
            EventUser.update_user_events(
                interpreter_orders_event)
        return True


    def save_orders(self):
        get_orders_event = EventUser.post_user_events(102, new_user=self.user_id)
        self.check_status_connection_db()
        self.pusher_title = "Regrouping orders"
        self.pusher_message = '19%'
        self.pusher_complete = False
        self.send_pusher()
        import_broker = 'coinbase'
        regroup_value = [group['code'] for group in self.user.users_configs.trade_grouping if group['active'] == True][
            0]
        error_mgs = "There was an error. Our support team will review the issue and get back to you"

        spread = False
        if regroup_value == 'split':
            output_group = TradeRegroups.regroup_trades_closed(
                self.out_result, import_broker, self.user.id)

        else:
            if regroup_value == 'spread':
                spread = True
            output_group = TradeRegroups.regroup_trades(
                self.out_result, import_broker, self.user.id, spread=spread, user=self.user)
        if 'error' in output_group:
            self.out['mgs'] = error_mgs
            return self.out
        any_error, rows, return_total, error_issue, executions, self.upload_id = TradeRegroups.save_to_database(
            output_group, import_broker, self.user.id, archive=self.filename_csv, upload_id=self.upload_id)
        """
            rows : total trades imported
            executions: total executions imported
        """
        # self.rows = self.rows+rows
        # self.executions = self.executions + executions
        self.rows = rows
        self.out_result = output_group
        self.out = {'any_error': any_error, 'rows': rows, 'ordens': executions,
                    'return_total': return_total, 'error_issue': error_issue,
                    'broker': import_broker, 'error_code': any_error}
        if any_error and any_error != 21:
            self.out['mgs'] = error_mgs
            return self.out
        else:
            if rows > 0:
                try:
                    self.user.fk_user_status_id = 1
                    self.user.save()
                except:
                    # print(traceback.format_exc())
                    pass
                mgs = f'{str(rows)} Trades, {str(executions)} Executions'
            else:
                if self.last_date == 0 or self.last_date is None:
                    mgs = "No new trades found."
                else:
                    mgs = "No new trades to import"
        self.out['mgs'] = mgs
        self.save_file(tmp_route=self.tmp_route_csv, archive=self.filename_csv, to=self.to_csv, data=self.json_to_csv_data, f_type='transactions_csv', content_type='text/csv',
                       portfolio=self.portfolio,  executions=executions, trades=rows, fk_broker_id=self.broker.broker_id, broker=self.broker.broker_key)
        if get_orders_event:
            EventUser.update_user_events(get_orders_event)
