import traceback
from flask_restful import Resource, request
from flask_jwt_extended import jwt_required, current_user
from .. import pusher_client
from ..security_service import verify_role
from ..models import BrokersConnections
from ..responses import ErrorResponses, SuccessResponses
from ..user.users_params import *
import itertools
from ..import_params import ImportParams
from ..trade.trades_regroups import *
from datetime import datetime
import time as tt
from .brokers_export import BrokerExport
from ..event.events import UserEventList as EventUser
import requests
import json
from coinbase.wallet.client import Client
from coinbase.wallet.client import OAuthClient


class CoinbaseExport(BrokerExport, ServerInfo, Resource):
    @verify_role('broker export')
    def post(self):
        version = {}
        valor=self.params['user_portfolio']
        symbol=self.data['symbols']
        #self.data = {}


        try:
            """
            self.data = {"portfolio":"","broker":"tda","auto_login":true,"partial":true}
            """
            user_params = UserParams.get_param_value(
                current_user.id, 'IMPORT_UPLOAD')

            if not user_params:
                UserParams.append_param(current_user.id, 'IMPORT_UPLOAD', True)
            elif user_params.field_value == "1":
                return ErrorResponses.error_400(message="We are still processing the previous Coinbase import", status='warning',origen='broker_sync')
            UserParams.append_param(
                current_user.id, 'IMPORT_UPLOAD', True, True)
            current_user.users_configs.not_warning_import = request.json.get(
                'not_warning_import', True)
            current_user.users_configs.save()
            if self.auto_import == True and  self.user.users_configs.tda_import == True:
                return SuccessResponses.success_200(message="Today's self.data has already been imported", status='warning',origen='broker_sync')
            try:
                new_event_id = EventUser.post_user_events(90, request.json)
            except:
                pass
            self.not_error = self.validate()
            pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                                    'id':3,
                                    'title': 'Checking Credentials',
                                    'message': '5%',
                                    'complete': False,
                                    })
            if self.not_error != True:
                UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
                return ErrorResponses.error_400(message=self.not_error, status='warning',origen='broker_sync',code=1)
            print('otro')
            if self.backend_domain_name() == 'https://api.tradersync.comkca dc asdv sd cksd k ':
                UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
                title = 'The connection has been temporarily disabled due to a connection issue. The dev team is working on it and it should be back in a couple of days'

                return ErrorResponses.error_400(message=title, status='warning',origen='broker_sync')

            #if 'localhost' in self.backend_domain_name():
                #ESTE METODO SOLO SE LLAMADESDE LOCAL
            self.not_error = self.login_oauth()

            print('esto no pasa', self.not_error)
            pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                                    'id':3,
                                    'title': 'Connecting to the Coinbase server',
                                    'message': '6%',
                                    'complete': False,
                                    })
            if self.not_error != True:
                if not isinstance(self.not_error, str):
                    title = self.not_error.message if self.not_error.message != 'Invalid Api-Code.' else 'Invalid Api-Code'

                    return ErrorResponses.error_400(message=title, status='warning',origen='broker_sync')
                UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
                return ErrorResponses.error_400(message=str(self.not_error), status='warning',origen='broker_sync',code=1)

            self.save_configs()
            pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                                    'id':3,
                                    'title': 'Saving data from Coinbase',
                                    'message': '10%',
                                    'complete': False,
                                    })
            pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                                    'id':3,
                                    'title': 'Get pairs from Coinbase',
                                    'message': '11%',
                                    'complete': False,
                                    })
            #prueba
            # if self.user.id == 666:
            #     self.get_symbols()
            #     print(len(self.symbols))
            #     for symbol in self.symbols:
            #         pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
            #                     'id':3,
            #                     'title': '{}'.format(symbol),
            #                     'message': '12%',
            #                     'complete': False,
            #                     })
            #         try:
            #             spot_orders = self.session.get_my_trades(symbol= symbol, limit = 1000  )
            #         except Exception as err:
            #             tt.sleep(10)
            #             print(err)
            #         if len(spot_orders)>0:
            #             print(symbol, len(spot_orders))
            # exit()
            #if 'localhost' in self.backend_domain_name():
                #ESTOS DEBEN EJECUTARSE SOLO EN LOCAL
            if self.symbols == [] or self.symbols != []:
                    #self.get_account()
                    #self._get_symbols()
                    self.not_error,error=self.get_coinbase_orders_oauth()
                    mensaje=str(error)
                    title=""
                    if self.not_error != True:
                        if "Insufficient" in mensaje:
                         title="wrong credentials"
                        elif "accountID" in mensaje:
                         title="value invalid for account id"
                        elif "forbidden" in mensaje:
                         title="wrong credentials"
                        else:
                         title="Error with coinbase please try again"
                        UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
                        return ErrorResponses.error_400(message=title, status='warning',origen='broker_sync')

                #self.not_error = self.get_oanda_orders()
            else:
                pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                                                'id':3,
                                                'title': 'Get orders from Coinbase',
                                                'message': '18%',
                                                'complete': False,
                                                })
            if self.not_error != True:
                UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
                if not isinstance(self.not_error, str):
                    return ErrorResponses.error_400(message=self.not_error, status='warning',origen='broker_sync')
                else:
                    return ErrorResponses.error_400(message=self.not_error, status='warning',origen='broker_sync')
            # exit()
            pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                                    'id':3,
                                    'title': 'Get orders from Coinbase',
                                    'message': '18%',
                                    'complete': False,
                                    })
            #if 'localhost' in self.backend_domain_name():
                #ESTE METODO SE LLAMA DESDE LOCAL
            self.save_account(self.account)
            self.save_files(file_type='json')
            pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                                    'id':3,
                                    'title': 'Get accounts from Coinbase',
                                    'message': '19%',
                                    'complete': False,
                                    })
            self.interpret_orders()
            self.save_orders()
            UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
            self.user.users_configs.tda_import = True
            self.user.users_configs.save()
            self.not_error  = self.save_params()
           
            self.delete_credentials()
            getattr(self.out, 'mgs', 'successfully')
            try:
                event_success = EventUser.update_user_events(new_event_id, {"message" : self.out['mgs'], 'request':self.data})
            except:
                pass
            msg = self.out['mgs'] if 'mgs' in self.out else 'successfully'
            pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                'id': 1,
                'title':'Import completed',
                'message':msg,
                'complete': True,
            })
            return SuccessResponses.success_200(
                data='export',
                message=self.out['mgs'], out=self.all_orders)
        except Exception as err:
            print(err)
            UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
            return ErrorResponses.error_400(message='Invalid Api-Key ID', status='warning',origen='broker_sync')
        except Exception as err:
            UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
            pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                'id':1,
                'title': 'warning',
                'message': 'Imported Fail',
                'complete': True,
                })
            return ErrorResponses.error_500(self.data, err, version)

    def validate(self):
        try:

            self.data = request.json
            self.user.users_configs.not_warning_import = self.data.get('not_warning_import',True)
            self.symbols = self.data.get('symbols',self.symbols)
            self.user.users_configs.save()
            self.auto_import = self.data['auto_import'] if 'auto_import' in self.data else False


            if self.credential:
                self.credential = BrokersConnections.find_by(**{'user_id':self.user.id, "broker_id":self.broker.broker_id, 'active': True})
                self.api_key = self.credential.api_key
                self.secret_key = self.credential.secret_key
                self.test_account =  self.credential.test_account
            else:
                if self.data['api_key'] =='':
                    return "Invalid Api-Code."

                self.credential = BrokersConnections.find_by(**{'user_id':self.user.id, "broker_id":self.broker.broker_id, 'active': True})
                self.api_key = self.data['api_key'].strip()
                self.secret_key = self.data['secret_key'].strip()
                self.test_account =  self.data['test_account']
            return True

        except Exception as err:
            if not self.credential:
                return "Wrong credentials"

            self.api_key = self.credential.api_key
            self.secret_key = self.credential.secret_key
            self.test_account =  self.credential.test_account
            self.user.users_configs.not_warning_import = True
            self.user.users_configs.save()
            self.data = None

    def login(self):
        try:
            coinbase_API_key = self.api_key
            coinbase_API_secret = self.secret_key
            self.session = Client(coinbase_API_key, coinbase_API_secret)

            accounts = self.session.get_accounts()
            if accounts['data']!=[]:
                self.account=accounts['data'][0]['id']

            for wallet in accounts.data:
             print(str(wallet['name']))


        except Exception as err:
            # if self.session.get_account_api_permissions()['result'] is None:
            #     return ErrorResponses.error_400(message=self.session.api_key_info()['ret_msg'], status='warning')
            if 'invalid signature' in str(err):
             return 'invalid api secret'
            else:
             return err;
        return True

    def _get_symbols(self):
        try:
            currencies = self.session.get_exchange_rates()
        except Exception as err:
            return False
        len_positions=len(currencies['rates'])
        j=1
        for i in currencies['rates']:
            pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                                    'id':3,
                                    'title': 'Finding traded pairs - Checking {} - Tickers to check: {}/{}'.format(i, j, len_positions),
                                    'message': '11%',
                                    'complete': False,
                                    })
            self.used_symbols.append(i)
            j+=1
        print(self.symbols)
        return True
    
    def get_account(self):
        try:
           account = self.session.get_primary_account()
           self.account=account['id']
        except Exception as err:
         print(err)   
        # print(response.__dict__)
        return True
    
    def delete_credentials(self):
        try:
            self.credentials = BrokersConnections.get_all(**{'user_id':self.user.id, "broker_id":self.broker.broker_id})
            if not self.credentials:
                return ErrorResponses.error_404(message='Credential not found', status='warning')
            for credential in self.credentials:
                credential.active = False
                credential.last_trade = []
                credential.first_trade = []
                credential.save()
        except Exception as err:
            return ErrorResponses.error_500(self.data, err, version)

    def login_oauth(self):
        try:        
         params = {'grant_type':'authorization_code', 'code':self.api_key, 'client_id':'dc27f0e8d9c325d593941bfef9749f93ebf821b24ce7fb71c6118c5cbc7eb3c1', 'client_secret':'480283a1ea6e86f2274a3200a8b207a92bb05ac073df61eecce75976f9b32705', 'redirect_uri':'https://qa.tradersync.com/authorization/coinbasetoken'}
         response = requests.post('https://api.coinbase.com/oauth/token', data = params)

         result=json.loads(response.text)
         self.api_key=result['access_token']
         self.secret_key=result['refresh_token']
         
         access_token=self.api_key
         refresh_token=self.secret_key
         self.session = OAuthClient(access_token, refresh_token)
         accounts=self.session.get_accounts()
         if accounts['data']!=[]:
             self.account=accounts['data'][0]['id']
        except Exception as err:
            # if self.session.get_account_api_permissions()['result'] is None:
            #     return ErrorResponses.error_400(message=self.session.api_key_info()['ret_msg'], status='warning')
         return str(err);
        return True
        
        
    def get_coinbase_orders_oauth(self):
        #url authorization https://www.coinbase.com/oauth/authorize?client_id=dc27f0e8d9c325d593941bfef9749f93ebf821b24ce7fb71c6118c5cbc7eb3c1&redirect_uri=https%3A%2F%2Fapp.tradersync.com&response_type=code&scope=wallet%3Atransactions%3Aread       
        #paginacion
        #for account in accounts.data:
         #txns = client.get_transactions(account.id, limit=25)
         #while True: 
          #for tx in txns.data:
           # print(tx.id)

          #if txns.pagination.next_uri != None:
           # starting_after_guid = re.search('starting_after=([0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12})', txns.pagination.next_uri, re.I)[1]
            #txns = client.get_transactions(account.id, limit=25, starting_after=starting_after_guid)
          #else:
           # break
           
        accounts=self.session.get_accounts()
        if accounts['data']!=[]:
            for account in accounts['data']:
                accountid=account['id']
                #for symbol in self.used_symbols if self.symbols==[] else self.symbols:
                try:
                  """
                  pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                                    'id':3,
                                    'title': 'Getting orders from ',
                                    'message': str(symbol),
                                    'complete': False,
                                    })
                  """   
                  transacciones=''
                  transactions=self.session.get_transactions(accountid,limit=200)
                  if transactions['data']!=[]: 
                   for transaction in transactions['data']:
                    order={}
                    order['price']=float(transaction['advanced_trade_fill']['fill_price'])
                    order['order_id']=transaction['advanced_trade_fill']['order_id']
                    order['commission']=transaction['advanced_trade_fill']['commission']
                    order['side']=transaction['advanced_trade_fill']['order_side']
                    order['quantity']=abs(float(transaction['amount']['amount']))
                    order['instrument']=transaction['advanced_trade_fill']['product_id'].replace('-', '')
                    order['createTime']=transaction['created_at']
                    order['status']=transaction['status']
                    order['type']=transaction['type']
                    self.all_orders.append(order)
                except Exception as err:
                  continue
      
        self.all_orders = self.list_futures_account_trades + self.all_orders
        self.orders=self.all_orders
            # spot_orders = self.session.get_my_trades( limit = 1000 ,  endTime = endTime )
            # self.all_orders = spot_orders + self.all_orders
            # coin_futures_orders = self.session.futures_coin_account_trades(limit = 1000, endTime = endTime)
            # self.all_orders = coin_futures_orders + self.all_orders

            # print('en esta mierda',datetime.utcfromtimestamp(tt.time()).strftime('%Y-%m-%d %H:%M:%S'))
        #f = f +1
        # exit()
        print("todas las ordenes ", self.all_orders)
        self.list_futures_account_trades = self.all_orders

        return True,""
        
    def get_coinbase_orders(self):
        print('get spot order')
        transactions=self.session.get_transactions(self.account)
        for transaction in transactions['data']:
            order={}
            order['price']=transaction['advanced_trade_fill']['fill_price']
            order['order_id']=transaction['advanced_trade_fill']['order_id']
            order['commission']=transaction['advanced_trade_fill']['commission']
            order['side']=transaction['advanced_trade_fill']['order_side']
            order['quantity']=transaction['amount']['amount']
            order['instrument']=transaction['advanced_trade_fill']['product_id']
            order['createTime']=transaction['created_at']
            order['status']=transaction['status']
            order['type']=transaction['type']
            self.all_orders.append(order)

        self.all_orders = self.list_futures_account_trades + self.all_orders
        self.orders=self.all_orders
            # spot_orders = self.session.get_my_trades( limit = 1000 ,  endTime = endTime )
            # self.all_orders = spot_orders + self.all_orders
            # coin_futures_orders = self.session.futures_coin_account_trades(limit = 1000, endTime = endTime)
            # self.all_orders = coin_futures_orders + self.all_orders

            # print('en esta mierda',datetime.utcfromtimestamp(tt.time()).strftime('%Y-%m-%d %H:%M:%S'))
        #f = f +1
        # exit()
        print("todas las ordenes ", self.all_orders)
        self.list_futures_account_trades = self.all_orders

        return True,""

    def interpret_orders(self):
        try:
            interpreter_orders_event = EventUser.post_user_events(101, new_user=self.user_id)
        except:
            pass
        pip_value_order = dict()
        result_b = []
        b=0
        new_date_time = []
        i = 0
        verify_njson_len = 0
        orders_filerow = []
        orders_filerow = ImportParams.filerow_orders(self.params['get_session_userid'],
                                                         var_sync='order_id',
                                                         var_file='trade id', 
                                                         broker=self.params['broker']
                                                     )
        for order in self.all_orders:
            i+=1
            if i%100 == 0 or i == 1 or i == len( self.all_orders):
                self._update_progress("Reading orders: {}/{}".format(i, len( self.all_orders)), '19%')
           
            original_file_row = json.loads(json.dumps(order))
            njson = json.dumps(order)
            njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
            # unix_to_date = datetime.utcfromtimestamp(int( order['time'])/1000)
            # est = timezone('UTC') #data['timezone'] es el timezone que quieres setear
            # tz1 = est
            # tz2 = timezone('America/New_York')
            # dt = tz1.localize(unix_to_date) # timestamp es la fecha a convertir
            # dt = dt.astimezone(tz2)
            # timestamp_set_tz = dt.strftime('%Y-%m-%d %H:%M:%S') # aqui tienes la fecha convertida
            action = order['buy/sell'].upper() if 'buy/sell' in order else order['side'].upper() if 'side' in order else order['transaction category'].upper() if 'transaction category' in order else 'buy'
            action = 'BUY' if action == 'BUY' or action=='COVER' else 'SELL' if action == 'SELL' or action == 'SHORT' else 'buy'
            order['symbol']  = order['instrument'] if 'instrument' in order else ''
            
            base = order['marginAsset'] if 'marginAsset' in order else None
            # order['time']  =timestamp_set_tz
            order['date'] = order['openTime'] if 'openTime' in order else order['createTime']
            order['type'] = order['filled type'].upper() if 'filled type' in order else order['types'].upper() if 'types' in order else 'TRADE'
            order['quantity'] = order['origQty'] if 'origQty' in order else order['units'] if 'units' in order else order['quantity']
            order['price'] = order['exec price'] if 'exec price' in order else order['executed price'] if 'executed price' in order else order['price'] if 'price' in order else '0'
            # if not order['symbol'] or not order['date'] or not order['price'] or not action or order['type'] != "TRADE":
            #     print('aqiu')
            #     continue
            if 'status' in order and order ['status'] != 'completed':
                continue
            if 'isBuyer' in order:
                action = 'BUY' if order['isBuyer'] == True else 'SELL'
            if not action:
                continue
            pip_value = 1
            date_time = order['date']
            original_file_row['date_tz'] = date_time
            self.any_error, date, time = ImportParams.get_param_datetime(date_time,b)
            new_date_time = ImportParams.convert_date(date, time, self.date_format,True,'UTC')

            order['date'] = new_date_time[0]
            order['time'] = new_date_time[1]
            fp = str(order['price']).replace(',', '').replace('$','')
            decimal = fp[::-1].find('.')
            decimal = decimal if decimal > 1 else 2
            price = round(float(fp),decimal)
            #price = round(float(order['price'].replace(',', '')),6)
 
            sm = len(order['symbol'])
            sym = order['symbol'][-3:]
            type = 'crypto'
            option = 'CRYPTO'
            strike = ''
            expire = ''
            order['size'] = 1
            pip_value = float(ImportParams.value_pip_forex(order['date'],sym))
            if 'pair' in order:
                order['size'] = 10
                pip_value = self.convert_usdt(order, pip_value_order, date )

            #################### VERIFY FILE ROW ######################
            try:
                order_id = ''
                portfolio_ = self.params['user_portfolio']
                if 'order_id' in order and order['order_id']:
                    order_id = order['order_id']
                valid_file_row = ImportParams.validate_filerow(orders_filerow, 
                                                               njson=njson, 
                                                               order_id=order_id,
                                                               date_tz=original_file_row['date_tz'],
                                                               price=fp,
                                                               option=option,
                                                               action=action,
                                                               quantity=str(order['quantity']).replace(',', ''),
                                                               strike=strike,
                                                               expire=expire,
                                                               portfolio=portfolio_
                                                              )
                if valid_file_row:
                    verify_njson_len = verify_njson_len + 1
                    continue
            except:
                pass
            ##########################################################

            
            #order['symbol']  ='${}|{}'.format(order['symbol'],i)   
            order['trade_notes'] = order['trade_notes'] if 'trade_notes' in order else ''
            order['type_stock'] = type
            order['type_option'] = option
            order['action'] = action
            order['price'] = fp
            order['shares'] = str(order['quantity']).replace(',', '')
            order['comm'] = order['commission'].replace(',', '').replace('$','') if 'commission' in order else '0.00'
            order['njson'] = njson
            order['decimal'] = decimal
            order['expire'] = expire
            order['strike'] = strike
            order['pip_value'] = pip_value

            order['original_file_row'] = original_file_row
            order['broker'] = self.params['broker']
            order['userid'] = self.params['get_session_userid']
            order['portfolio'] = self.params['user_portfolio']
            #order['portfolio'] = self.params['user_portfolios'][order['AccountID']]
            valor= order['portfolio']
            broker=self.params['broker']
            data_item = ImportParams.get_result_append(order)
            self.out_result.append(data_item)
            b = b + 1
        try:
            event_success = EventUser.update_user_events(interpreter_orders_event)
        except:
            pass

    def save_orders(self):
        try:
            get_orders_event = EventUser.post_user_events(102, new_user=self.user_id)
        except:
             pass

        pusher_client.trigger('import-{}'.format(self.user.username), 'import_trade', {
                                        'id':3,
                                        'title':  "Regrouping orders",
                                        'message': '19%',
                                        'complete': False,
                                        })
        import_broker = 'coinbase'
        regroup_value = [group['code'] for group in self.user.users_configs.trade_grouping if group['active'] == True][0]
        error_mgs = "There was an error. Our support team will review the issue and get back to you"

        spread = False
        if regroup_value == 'split':
            output_group = TradeRegroups.regroup_trades_closed(self.out_result,import_broker,self.user.id)

        else:
            if regroup_value=='spread':
                spread = True
            output_group = TradeRegroups.regroup_trades(self.out_result, import_broker, self.user.id, spread=spread, user=self.user)
        if 'error' in output_group:
            self.out['mgs'] = error_mgs
            return self.out
        any_error, rows, return_total, error_issue, executions, self.upload_id = TradeRegroups.save_to_database(output_group,import_broker, self.user.id, archive = self.filename_csv, upload_id = self.upload_id)
        self.out_result = output_group
        """
            rows : total trades imported
            executions: total executions imported
        """
        self.out = {'any_error': any_error, 'rows': rows, 'ordens': executions,
                'return_total': return_total, 'error_issue': error_issue,
                'broker': import_broker, 'error_code': any_error}
        if any_error and any_error != 21:
            self.out['mgs'] = error_mgs
            return self.out
        else:
            if rows > 0:
                try:
                    self.user.fk_user_status_id = 1
                    self.user.save()
                except:
                    pass
                mgs = f'{str(rows)} Trades, {str(executions)} Executions'
            else:
                if self.last_date == 0 or self.last_date == None:
                    mgs = "No new trades found."
                else:
                    mgs = "No new trades to import"
        self.out['mgs'] = mgs
        self.save_file(tmp_route = self.tmp_route_csv, archive = self.filename_csv,data = self.all_orders , to = self.to_csv, f_type= 'transactions_csv', content_type = 'text/csv',  portfolio =self.portfolio,  executions=executions , trades=rows, fk_broker_id = self.broker.broker_id, broker = self.broker.broker_key)

        # self.save_file(tmp_route = self.tmp_route_json, archive = self.filename_json , to = self.to_json, f_type= 'transactions_json', content_type = 'text/json',  portfolio =self.portfolio,  executions=executions , trades=rows, fk_broker_id = self.broker.broker_id, broker = self.broker.broker_key)
        UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,replace=True)
        try:
            event_success = EventUser.update_user_events(get_orders_event)
        except:
            pass

class CoinbaseExportBck( ServerInfo, Resource):
    def post(self):
        data = request.json
        print(data)
        s = Client(api_key=data['api_key'], api_secret=data['api_secret'])
        return s
