import re
import hashlib
import json
import traceback

from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required

from .. import_params import ImportParams
from .. security_service import *
from .. logs import create_log
from .. responses import ErrorResponses, SuccessResponses
from dateutil.parser import parse

class BrokerCoinbase(Resource):

    def getcsv(params, content, date_format='mdy'):
        data = "BrokerCoinbase 1"
        # print(data)

        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0
        row_upload = False
        try:

            content = content.replace(';', '')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                if 'TIMESTAMP' in row.upper() or 'STATUS TIME' in row.upper()  or 'DATE' in row.upper() or 'CREATED AT' in row.upper():
                    ath = True
                elif not row:
                    ath = False

                if ath:
                    if rl == 0:
                        row = row.replace("\r", "")
                        ns = row.split(',')
                        nl = len(ns)
                        result_b.append(row)
                    if rl > 0:
                        result_b.append(row)
                    rl = rl + 1
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            verify_njson_len = 0
            orders_filerow = []
            try:
                orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                              var_sync='order_id',
                                                              var_file='trade id',
                                                              broker=params['broker'])
                BrokerTastyworks.ORDERS_FILEROW = orders_filerow

            except:
                pass
            pip_value_list = dict()
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                action = n['transaction type'].upper() if 'transaction type' in n else n['side'].upper() if 'side' in n else ''
                if 'action' in n:
                    action = 'BUY' if str(n['action'])=='1' else 'SELL' if str(n['action'])=='2' else ''
                action = 'BUY' if 'BUY' in action or action=='COVER' else 'SELL' if 'SELL' in action or action == 'SHORT' else ''
                date = str(n['timestamp']) if 'timestamp' in n else str(n['created at']) if 'created at' in n else str(n['initiated time']) if 'initiated time' in n else ''
                date = date.replace('UTC','')
                if date and 'T' in date:
                    date = date.split('T')
                elif date and ' ' in date:
                    date = date.split(' ')
                if date:
                    n['date'] = date[0]
                    n['time'] = date[1]
                n['price'] = n['usd spot price at transaction'] if 'usd spot price at transaction' in n else \
                             n['spot price at transaction'] if 'spot price at transaction' in n else \
                             n['price at transaction'] if 'price at transaction' in n else \
                             n['average fill price'] if 'average fill price' in n else \
                             n['price'] if 'price' in n else ''
                #n['symbol'] = n['asset'] if 'asset' in n else n['symbol'] if 'symbol' in n else n['size unit'] if 'size unit' in n else ''
                symbol_split = False if (not 'symbol_split' in params) \
                                        or ( 'symbol_split' in params and params['symbol_split']=='false') \
                                     else True

                n['symbol'] = n['asset'] if 'asset' in n else \
                              n['symbol'] if 'symbol' in n else \
                              n['market'].replace('/','') if 'market' in n else \
                              n['product'] if 'product' in n and not symbol_split else \
                              n['size unit'] if 'size unit' in n else ''

                n['orderby'] = a
                if not n['symbol'] or not n['date'] or not n['price'] or not action or ('status' in n and n['status'].lower() != 'completed'):
                    continue

                pip_value = 1
                date_split = n['date'].strip()
                d = date_split
                t = n['time'] if 'time' in n else ''
                date_time = (d+' '+t).strip()
                original_file_row['date_tz'] = date_time
                any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                new_date_time = ImportParams.convert_date(date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                fp = n['price'].replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp),decimal)
                #price = round(float(n['price'].replace(',', '')),6)

                sm = len(n['symbol'])
                type = 'crypto'
                option = 'CRYPTO'
                strike = ''
                expire = ''
                smn = n['symbol'][-2:]
                if 'fees and/or spread' and not '-' in n['fees and/or spread']:
                    #swap = n['fees and/or spread'].replace(',', '').replace('$','')
                    fee = n['fees and/or spread'].replace(',', '').replace('$','')
                #fee = n['fee'].replace(',', '').replace('-', '').replace('$', '') if 'fee' in n else n['usd fees'].replace(',', '').replace('$','') if 'usd fees' in n else n['fees and/or spread'].replace(',', '').replace('$','').replace('-','') if 'fees and/or spread' in n and '-' in n['fees and/or spread'] else ''
                fee = n['fee'].replace(',', '').replace('-', '').replace('$', '') if 'fee' in n else n['usd fees'].replace(',', '').replace('$','') if 'usd fees' in n else ''
                if 'fee' in n and ImportParams.isfloat(n['fee']):
                    fee = str(abs(float(n['fee'])))
                fee = round(float(fee), 2) if fee else 0.00
                if 'price/fee/total unit' in n:
                    if not n['price/fee/total unit'] in ['USD','USDT','USDC','EUR']:
                        try:
                            pip_value_params = float(ImportParams.value_pip_forex(n['date'],n['price/fee/total unit']))
                            if pip_value_params == 1:
                                if 'product' in n:
                                    a_index = next((index for (index, d) in enumerate(result) if n['product'] == d['product']), -1)
                                    if a_index> -1:
                                        price_r = result[a_index]['price'].replace(',', '').replace('$','')
                                        pip_value_params = float(price_r)
                                    else:
                                        pip_value_params = float(ImportParams.value_pip_crypto(base=n['price/fee/total unit']))
                            if pip_value_params != 1:
                                fp = str(float(fp) * pip_value_params)
                                fee = str(float(fee) * pip_value_params)

                        except:
                            pass
                
                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = params['user_portfolio']
                    if 'trade id' in n and n['trade id']:
                        order_id = n['trade id']
                    quantity = n['quantity transacted'].replace(',', '') if 'quantity transacted' in n else n['total order quantity'].replace(',', '') if 'total order quantity' in n else n['size'].replace(',', '') if 'size' in n else ''
                    valid_file_row = ImportParams.validate_filerow(orders_filerow,
                                                                   njson=njson,
                                                                   order_id=order_id,
                                                                   date_tz=original_file_row['date_tz'],
                                                                   price=fp,
                                                                   option=option,
                                                                   action=action,
                                                                   quantity=quantity,
                                                                   strike=strike,
                                                                   expire=expire,
                                                                   portfolio=portfolio_
                                                                  )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################

                n['trade_notes'] = n['trade_notes'] if 'trade_notes' in n else ''
                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = fp
                n['shares'] = n['quantity transacted'].replace(',', '').replace('-', '') if 'quantity transacted' in n else n['total order quantity'].replace(',', '').replace('-', '') if 'total order quantity' in n else n['size'].replace(',', '').replace('-', '') if 'size' in n else ''
                n['comm'] = n['commission'].replace(',', '').replace('$','') if 'commission' in n else n['total commission'].replace(',', '').replace('$','') if 'total commission' in n else '0.00'
                n['fees'] = fee
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['pip_value'] = pip_value
                n['size'] = 1
                n['swap'] = ''
                n['original_file_row'] = original_file_row
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                data_item = ImportParams.get_result_append(n)

                out_result.append(data_item)
                b = b + 1

        except Exception as err:
            print(err, traceback.format_exc())
            any_error = 9
        if not any_error and not out_result and not verify_njson_len:
                any_error=9
        return out_result, any_error
