import traceback
from werkzeug.exceptions import BadRequest
from json.decoder import JSONDecodeError
import time as tt
import itertools
import werkzeug
import requests
from flask_restful import Resource, request
from flask_jwt_extended import jwt_required
from pytz import all_timezones, timezone as pytz_timezone
from datetime import datetime, date, timedelta, tzinfo, time, timezone
from collections import OrderedDict, defaultdict
import sys
from . brokers_export import BrokerExport
from .. import pusher_client
from .. security_service import verify_role
from .. import db
from .. models import Portfolios, PortfolioReferences, \
    TradesHistories,  TempOrders, TradesHistories, HandlingErrorsLog
from .. trade.trades_regroups import *
from .. trade.trades_filerow_temp import *
from .. import_params import ImportParams
from .. responses import ErrorResponses, SuccessResponses
from ..default_configs import APP_TIMEZONE
from dateutil.parser import parse
from collections import OrderedDict, defaultdict, namedtuple
from ..portfolio.adjustment import PortfolioAdjustmentDefinition as pad
from .. user.users_params import *
from .. event.events import UserEventList as EventUser


class CharlesSchwabExport(BrokerExport, Resource):

    @verify_role('broker export')
    def post(self):
        try:
            print('Charles Schwab Export')
            self.portfolio_list = []
            version = {}
            self.data = request.json
            cusips_list = []
            symbol_list = [] 
            self.new_sync = False
            # ini syncronization
            new_event_id=self.init_sync()
            self._update_progress('Checking Credentials', '5%')           
            
            if not isinstance(new_event_id,UserEvents) and not self.is_lambda():
                return new_event_id
                                
            executions = 0
            trades = 0
            data = self.data
            self.orders_filerow = ImportParams.filerow_orders(self.user.id,
                                                                var_sync='activityId',
                                                                var_file='orderId',
                                                                broker='CharlesSchwab')
            for credential in self.credentials: 
                if credential:
                    self.new_sync = False
                    self.account = credential.account
                    self.api_key = credential.api_key
                    self.secret_key = credential.secret_key
                    self.refresh_token = credential.refresh_token
                    self.access_token = credential.access_token
                    self.credential = credential
                     
                self._update_progress('Login', '6%')           
                self.not_error = self.login_charles(broker='charlesschwab')       
                if self.not_error != True:
                    self.log_response = self.not_error 
                    if credential:
                        BrokersConnections.query.filter_by(id=credential.id).update(dict(active=False))  
                        db.session.commit()    
                    self.extra_params_pusher['reconnect'] = True           
                    _end = self.end_sync(code=1)
                    if _end != True:
                        return _end
                       
                self._update_progress('Save Data', '7%')           
                self.save_configs(data)
                
                if credential and self.not_error == True:
                    self._update_progress('Update Token', '8%')           
                    BrokersConnections.query.filter_by(id=credential.id).update({'access_token': self.access_token, 'refresh_token': self.refresh_token})
                    db.session.commit()

                self.user.users_configs.save()
                
                self._update_progress('Get Accounts', '9%')
                
                self.broker_data = data['broker'] if 'broker' in data else 'CharlesSchwab'
                response = self.get_account_charles_schwab()
                self.log_response = response
                if not self.accounts:
                    self.not_error = 'We have not received your account information, so we cannot retrieve your trades. Please contact your broker and inform them that the account ID is not accessible via their APIs'
                    _end = self.end_sync()
                    if _end != True:
                        return _end
                     
                
                self.executed_lambda=False
                
                if self.condition_lambda() and not self.aws_autosync:
                    try:
                        print('Attempting to call AWS Lambda for processing')
                        self.call_lambda()
                    except Exception as err:
                        print(f"Lambda execution error: {traceback.format_exc()}")
                        self.not_error = err
                        self.executed_lambda = True
                        self.unlock_portfolios()
                        self._update_progress('warning', 'Imported fail', True)
                        return self.end_sync(event_id=new_event_id, _exception='lambda execution', code=0)
                    
                if not self.executed_lambda:
                    self._update_progress('Saving Accounts', '12%')
                    self.user.users_configs.save()
                    # function to save portfolios and reference accounts
                    portfolio_list = self.save_account_charles_schwab(self.accounts)
                    #print('portfolio_list', self.portfolio_list)
                    if 'error' in portfolio_list:
                        self.not_error = portfolio_list['error']
                        _end = self.end_sync()
                        if _end != True:
                            return _end

                    self._update_progress('Saving Data', '13%')
                    self.save_configs(data) 
                    self.not_error = True
                    out = {}
                    out['accounts'] = self.accounts

                    self._update_progress('Retrieving orders', '15%')
                    self.not_error  = self.get_transactions_charles_schwab()
                    out['transactions'] = self.transactions
                    
                    response = {}
                    try: 
                        self._update_progress('Saving Files', '18%')
                    except:
                        pass

                    self.check_status_connection_db()

                    self.not_error = self.save_files_charles_schwab(executions=executions, trades=trades,
                                                portfolio_list=portfolio_list, file_type='json')
                     
                    try:
                        self._update_progress('Reading orders', '19%')
                    except:
                        pass
                    self.trade_cusip = dict()
                    self.charles_schwab_portfolio_id = []
                    self.delete_orders_tda = []
                    self.orders_filerow_tos_tda = []
                    
                    self._update_progress('Deleting Expires', '20%')
                    
                    try:
                        delete_autoexpire = TradesExpired.delete_autoexpire(self.user.id)
                    except:
                        pass
                    self.check_status_connection_db(execute=True) 
                    self._update_progress('Change Cusips for account', '20%')                   

                    for transaction in self.transactions:                
                        response = self.get_cusip_charles_schwab(transaction)
                        self.log_response = response
                        cusips_list = cusips_list + response
                    
                    cusips_list = list(set(cusips_list))
                    symbol_list = self.get_symbol_data_charles_schwab(cusips_list)
                    self.not_error = True
                    self._update_progress('Change Cusips for account', '20%')

                    for transaction in self.transactions:
                        list_transaction = self.split_orders_list(transaction)
                        total = len(list_transaction)
                        i = 0
                        message = ''
                        for order in list_transaction:
                            if total > 1:
                                message  = ' {}/{}'.format(i, total)
                                                        
                            #response = self.export_trades_charles_schwab(order, symbol_list,message)

                            response = self.optimized_export_trades_charles_schwab(order, symbol_list,message)
                            self.log_response = response
                            if 'rows' in response:
                                trades = response['rows'] + trades
                            if 'ordens' in response:
                                executions = response['ordens'] + executions
                    
                    # auto expire function
                    try: 
                        self._update_progress('Auto Expires', '20%')
                        expired_ = UpdateTrade.update_subprocess_import(self.user.id, 'expired')
                    except:
                        pass     
                    
                    self.not_error = True    
                    if trades > 0 or executions > 0:  
                        self.out['rows']=trades
                        self.out['executions']=executions
                        try:
                            not_error = self.save_files_charles_schwab(
                                executions=executions,
                                trades=trades,
                                portfolio_list=portfolio_list,
                                file_type='transactions'
                            )
                        except Exception as e:
                            db.session.rollback()
                            raise         
                        mgs =  str(trades)+' Trades, '+str(executions)+' Executions'
                    else:
                        mgs = "No new trades found"
                    self.out['mgs'] = mgs    
                self.check_status_connection_db()
                self.not_error  = self.save_params()
                
            return self.end_sync(event_id=new_event_id)
        
        except JSONDecodeError as err:
            self.unlock_portfolios()
            HandlingErrorsLog(
                **{
                    'user_id': self.user.id,
                    'error': str(err),
                    'data': self.log_response,
                    'path': '{}.{}.{}'.format(__name__, type(self).__name__, sys._getframe().f_code.co_name),
                    'exception': 'JSONDecodeError',
                    'origin': getattr(request, 'origin',  'object has no attribute "origin"'),
                }
            ).save()
        except requests.JSONDecodeError as err:
            self.unlock_portfolios()
            HandlingErrorsLog(
                **{
                    'user_id': self.user.id,
                    'error': str(err),
                    'data': self.log_response,
                    'path': '{}.{}.{}'.format(__name__, type(self).__name__, sys._getframe().f_code.co_name),
                    'exception': 'JSONDecodeError',
                    'origin': getattr(request, 'origin',  'object has no attribute "origin"'),
                }
            ).save()
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(time.time())-self.star_timestamp), 400, 'Fail',error=str(err))                     
            return ErrorResponses.error_400(data='picture',message='Please try again',status='warning',origen='broker_sync')
        except requests.exceptions.JSONDecodeError as err:
            self.unlock_portfolios()
            HandlingErrorsLog(
                **{
                    'user_id': self.user.id,
                    'error': str(err),
                    'data': self.log_response,
                    'path': '{}.{}.{}'.format(__name__, type(self).__name__, sys._getframe().f_code.co_name),
                    'exception': 'JSONDecodeError',
                    'origin': getattr(request, 'origin',  'object has no attribute "origin"'),
                }
            ).save()
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(time.time())-self.star_timestamp), 400, 'Fail',error=str(err))
            return ErrorResponses.error_400(data='picture',message='Please try again',status='warning',origen='broker_sync')
        except requests.exceptions.ConnectionError as err:
            self.unlock_portfolios()
            HandlingErrorsLog(
                **{
                    'user_id': self.user.id,
                    'error': str(err),
                    'data': self.log_response,
                    'path': '{}.{}.{}'.format(__name__, type(self).__name__, sys._getframe().f_code.co_name),
                    'exception': 'ConnectionError',
                    'origin': getattr(request, 'origin',  'object has no attribute "origin"'),
                }
            ).save()
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(time.time())-self.star_timestamp), 400, 'Fail',error=str(err))
            return ErrorResponses.error_400(data='picture',message='Please try again',status='warning',origen='broker_sync')
        except werkzeug.exceptions.BadRequest as err:
            self.unlock_portfolios()
            HandlingErrorsLog(
                **{
                    'user_id': self.user.id,
                    'error': str(err),
                    'data': data,
                    'path': '{}.{}.{}'.format(__name__, type(self).__name__, sys._getframe().f_code.co_name),
                    'exception': 'werkzeug.exceptions.BadRequest',
                    'origin': getattr(request, 'origin',  'object has no attribute "origin"'),
                }
            ).save()
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(time.time())-self.star_timestamp), 400, 'Fail',error=str(err))
            return ErrorResponses.error_400(data='picture',message='Please try again',status='warning',origen='broker_sync')
        except Exception as err:
            self.unlock_portfolios()
            self._update_progress('warning', 'Imported fail',True)
            data = self.log_response
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(time.time())-self.star_timestamp), 500, 'Fail',error=str(err))
            return ErrorResponses.error_500(data, err, version)

    def save_files_charles_schwab(self, executions=None, trades=None, portfolio_list=None, file_type=''):  
        try:
            json.dumps(self.json_data)
        except:
            return False
        
        if file_type == 'json':
            self.upload_json()
            self.save_file(tmp_route=self.tmp_route_json, archive=self.filename_json, data=self.json_data,
                           to=self.to_json, f_type='all_json', content_type='text/json', portfolio_list=portfolio_list, fk_broker_id=15, broker='CharlesSchwab')

        if file_type == 'transactions':
            self.transactions_json()  
            self.save_file(tmp_route=self.tmp_route_json_to_csv,  data=self.json_to_csv_data,  executions=executions, trades=trades, content_type='json',
                           f_type='transactions_json', portfolio_list=portfolio_list, fk_broker_id=15, broker='CharlesSchwab')
            self.upload_csv(f_type='transactions', name='CharlesSchwab')
            self.trades_archive = self.filename_csv if self.filename_csv else None
            
            my_list = [value for value in self.json_to_csv_data.values()]
            data_temp = my_list           
            self.save_file(tmp_route=self.tmp_route_csv, archive=self.filename_csv,data=data_temp, to=self.to_csv, f_type='transactions_csv',
                           content_type='text/csv', executions=executions, trades=trades, portfolio_list=portfolio_list, broker='CharlesSchwab')

        if file_type == 'orders':
            self.orders_json()
            self.save_file(tmp_route=self.tmp_route_json_to_csv,  data=self.json_to_csv_data,
                           f_type='orders_json', portfolio_list=portfolio_list, fk_broker_id=15, broker='CharlesSchwab')
            self.upload_csv(f_type='orders')
            self.trades_archive = self.filename_csv if self.filename_csv else None
        return True

    def save_account_charles_schwab(self, accounts):
        """ Function to save portfolio and reference account.
        Args:
            accounts(list): list with user account
        """
        portofolio_list = []
        self.portfolio_list = []
        if self.portfolio_ids is None and self.portfolio_ids == []:
            self.portfolio_ids = []
        for row in accounts:
            if not 'portfolio' in row:
                continue
            _portfolio = Portfolios.query.join(PortfolioReferences, Portfolios.portfolio_id == PortfolioReferences.fk_portfolio_id).filter(
                Portfolios.fk_user_id == self.user.id, PortfolioReferences.reference_code == row[
                    'account_number']
            ).first()
            
            if not _portfolio:
                # Saving Portfolio if not exist
                portfolio_add = Portfolios(
                    fk_user_id=self.user.id,
                    name=row['portfolio'],
                    lock=True,
                    broker_ids=[15]
                    )
                db.session.add(portfolio_add)
                db.session.commit()
                portfolio_id = portfolio_add.portfolio_id
                portofolio_list.append(row['portfolio'])
                self.portfolio_list.append(row['portfolio'])
                self.portfolio_ids.append(portfolio_id)
            else:
                if _portfolio.portfolio_references.fk_broker.broker_key.lower() != row['broker'].lower():
                    return {'error': 'The portfolio "{}" exist with this reference "{}" therefore we can not upload trades to portfolio "{}"'.format(_portfolio.name, row['account_number'], row['portfolio'])}
                portfolio_id = _portfolio.portfolio_id
                self.portfolio_list.append(_portfolio.name)
                self.portfolio_ids.append(portfolio_id)
                portofolio_list.append(row['portfolio'])
            # Saving Reference if not exist
            if 'account_number' in row:
                if not PortfolioReferences.query.\
                        filter_by(fk_portfolio_id=portfolio_id).first():
                    add_ref = PortfolioReferences(
                        reference_code=row['account_number'],
                        force=True,
                        fk_broker_id=15 if row['broker'].lower(
                        ) == 'charlesschwab' else 8,
                        fk_portfolio_id=portfolio_id,
                        fk_user_id=self.user.id
                    )
                    db.session.add(add_ref)
                    db.session.commit()

        return portofolio_list

    def get_symbol_data_charles_schwab(self, cusips_list):
        api_key = 'nkqCXigD6ZeeX5QXcD3xQda3MOLK4zvo'
        base_url = 'https://financialmodelingprep.com/api/v3/cusip/'
        out = []
        for cusip in cusips_list:
            url = f'{base_url}{cusip}?apikey={api_key}'

            response = requests.get(url)
            if response.status_code == 200:
                data = response.json()
                # Asegúrate de ajustar el acceso al campo correcto en la respuesta JSON
                # Ajusta 'symbol' según la estructura de la respuesta JSON
                if data != []:
                    out = out + data
        return out

    def get_cusip_charles_schwab(self, transactions):
        """ Function to format the orders and save in database.

        Args:
            transactions(list): list with user transactions
        """
        out = []
        d = False
        unique_symbols = set()
        symbol = None
        for row in transactions:

            if not 'transferItems' in row:
                continue
            for item in row['transferItems']:
                if not 'instrument' in item:
                    continue
                if item['instrument']['assetType'] == 'FOREX':
                    if not 'feeType' in item:
                        if 'status' in item['instrument'] and item['instrument']['status'].lower() == 'disabled':
                            d = True
                        if not 'symbol' in item['instrument']:
                            continue
                        symbol = "$" + item['instrument']['symbol'].replace("/", "") 
                elif item['instrument']['assetType'] == 'EQUITY' or item['instrument']['assetType'] == 'COLLECTIVE_INVESTMENT':
                    # if item['instrument']['status'].lower() != 'active':
                    #     continue
                    if not 'feeType' in item:
                        if 'status' in item['instrument'] and item['instrument']['status'].lower() == 'disabled':
                            d = True
                        if not 'symbol' in item['instrument']:
                            continue
                        symbol = item['instrument']['symbol']
                elif item['instrument']['assetType'] == 'OPTION':
                    # if item['instrument']['status'].lower() != 'active':
                    #     continue
                    if not 'feeType' in item:
                        if 'status' in item['instrument'] and item['instrument']['status'].lower() == 'disabled':
                            d = True
                        try:
                            symbol = item['instrument']['underlyingSymbol'] if 'underlyingSymbol' in item['instrument'] else item['instrument']['symbol'].split('_')[0]
                        except:
                            symbol = None

            if not symbol:
                continue
            if '.' not in symbol and d == True and len(symbol) >= 7:
                if symbol not in unique_symbols:  # Verificar si el símbolo ya está en el conjunto
                    out.append(symbol)
                    # Agregar el símbolo al conjunto
                    unique_symbols.add(symbol)
        return out

    def export_trades_charles_schwab(self, transactions, symbol_list,message):
        """ Function to format the orders and save in database.

        Args:
            transactions(list): list with user transactions
        """
        try:
            out = {}
            trades_list = []
            new_list = []
            update_trades = []
            fk_portfolio_id = 0
            # type = 'share'
            option = 'SHARE'
            spread = 'SINGLE'
            expire = ''
            strike = ''
            # timezone setting
            fmt = '%Y-%m-%d %H:%M:%S'
            est = default_configs.APP_TIMEZONE
            reverse_split = defaultdict()
            reverse_count = 0
            reverse_split_rate = 1
            reverse_qty_1 = 0
            reverse_qty_2 = 0
            share_list = []
            type_trade = ''
            type_trade_list = []
            activityId = []
            commission = 0
            fee = 0
            a = len(transactions)
            i = 0
            cant =0
            file_row_saved = None
            verify_njson_len = 0            
            dict_amount = dict()
            self._update_progress("Reading orders {}".format(message), '20%') 
            for row in transactions:
                cant += 1
                #if cant % 500 == 0 or cant == 1 or cant == len(transactions): #
                #    self._update_progress("Reading orders {}/{} {}".format(cant, len(transactions),message), '20%')               
                d = False
                if 'activityId' in row:
                    if not str(row['activityId']) in str(activityId):
                        activityId.append(row['activityId'])
                    else:
                        continue
                commission = 0
                fee = 0
                shares_ = 0
                type = 'share'
                option = 'SHARE'
                spread = 'SINGLE'
                expire = ''
                strike = ''
                opt = ''
                symbol = None
                attributes = []
                check_json = json.dumps(row)
                check_json = hashlib.md5(
                    check_json.encode('utf-8')).hexdigest()
                if check_json in new_list:
                    continue

                new_list.append(check_json)
                i += 1
                if not 'type' in row or row['type'].upper() not in [
                    "TRADE"
                ] or not\
                        'accountNumber' in row:
                    continue
                type_trade = row['type'].upper()
                if 'status' in row and row["status"] == 'INVALID':
                    continue
                # order file row
                original_file_row = json.loads(json.dumps(row))
                njson = json.dumps(row)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                stock_split = False
                if not 'time' in row or ('time' in row and row["time"] == ''):
                    continue
                row["orderDate"] = row["time"]
                # "description": "TRADE CORRECTION" invalid orders for now
                # validate the reference account
                reference_code = row['accountNumber'] 
                self.portfolio = reference_code
                orderby = a
                get_portfolio = PortfolioReferences.query.\
                    filter_by(
                        reference_code=reference_code,
                        fk_broker_id=15,
                        fk_user_id=self.user.id,
                    )
                get_portfolio = get_portfolio.first()
                if not get_portfolio:
                    continue
                fk_portfolio_id = get_portfolio.fk_portfolio_id
                if not fk_portfolio_id in self.charles_schwab_portfolio_id:
                    self.charles_schwab_portfolio_id.append(fk_portfolio_id)

                if not 'transferItems' in row:
                    continue
                size=0
                for item in row['transferItems']:
                    if not 'instrument' in item:
                        continue
                    if item['instrument']['assetType'] == 'CURRENCY' or item['instrument']['assetType'] == 'EQUITY':
                        if 'feeType' in item:
                            if 'COMMISSION' in item['feeType']:
                                commission = item['amount'] + commission
                            elif 'FEE' in item['feeType']:
                                fee = item['amount'] + fee
                    i += 1
                    if item['instrument']['assetType'] == 'EQUITY' or item['instrument']['assetType'] == 'COLLECTIVE_INVESTMENT':
                        # if item['instrument']['status'].lower() != 'active':
                        #     continue
                        if not 'feeType' in item:
                            if item['instrument']['status'].lower() == 'disabled':
                                d = True
                            if not 'symbol' in item['instrument']:
                                continue
                            symbol = item['instrument']['symbol']
                            if 'amount' in item and 'cost' in item and 'price' in item:
                                price = item['price']
                                shares = abs(item['amount'])
                                if item['amount'] < 0:
                                    action = 'SELL'
                                else:
                                    action = 'BUY'
                            if 'type' in item['instrument'] and ('COMMON_STOCK' in item['instrument']['type'] \
                                                                 or 'EXCHANGE_TRADED_FUND' in item['instrument']['type']):
                                shares_ = shares_ + shares
                                shares = shares_
                    elif item['instrument']['assetType'] == 'FOREX':
                        if not 'feeType' in item:
                            size=1
                            if item['instrument']['status'].lower() == 'disabled':
                                d = True
                            if not 'symbol' in item['instrument']:
                                continue
                            type = 'forex'
                            option = 'FOREX'    
                            symbol = "$" + item['instrument']['symbol'].replace("/", "")
                            if 'amount' in item and 'cost' in item and 'price' in item:
                                price = item['price']
                                shares = abs(item['amount'])
                                if item['amount'] < 0:
                                    action = 'SELL'
                                else:
                                    action = 'BUY'             
                    elif item['instrument']['assetType'] == 'OPTION':
                        # if item['instrument']['status'].lower() != 'active':
                        #     continue
                        if 'optionPremiumMultiplier' in item['instrument']:
                            size=item['instrument']['optionPremiumMultiplier']
                        if not 'feeType' in item:
                            if item['instrument']['status'].lower() == 'disabled':
                                d = True
                            symbol = item['instrument']['underlyingSymbol'] if 'underlyingSymbol' in item['instrument'] else item['instrument']['symbol'].split('_')[
                                0]
                            if 'symbol' in item['instrument']:
                                if '/' in item['instrument']['symbol']:
                                    # /E3BG24_P5010:XCME Option Futures
                                    strike = item['instrument']['strikePrice']
                                    option = item['instrument']['putCall']
                                    expire = item['instrument']['expirationDate']
                                    expire = datetime.strptime(expire, "%Y-%m-%dT%H:%M:%S%z")

                                    expire = expire.strftime("%d %b %y")
                                    
                                    try:
                                        future_params = ImportParams.getFutureSymbol(
                                            symbol.replace('/', ''))
                                        day_week = ImportParams.get_date_week_expire(
                                            symbol, future_params['expire'])
                                        if day_week:
                                            expire = day_week
                                        symbol = future_params['symbol']
                                    except:
                                        pass
                                elif '.' in item['instrument']['symbol']:
                                    # 0EA...WG80100000
                                    strike = item['instrument']['strikePrice']
                                    option = item['instrument']['putCall']
                                    expire = item['instrument']['expirationDate']

                                    expire = datetime.strptime(
                                        expire, "%Y-%m-%dT%H:%M:%S%z")
                                    expire = expire.strftime("%d %b %y")

                                elif '_' in item['instrument']['symbol']:
                                    # AMZN_031524C180

                                    opt = item['instrument']['symbol'].split('_')
                                    if 'C' in opt[1]:
                                        strike = opt[1].split('C')[1]
                                        expire = opt[1].split('C')[0]
                                        option = 'CALL'
                                    elif 'P' in opt[1]:
                                        strike = opt[1].split('P')[1]
                                        expire = opt[1].split('P')[0]
                                        option = 'PUT'
                                    expire = datetime.strptime(
                                        expire, "%m%d%y")

                                    expire = expire.strftime("%d %b %y")

                                elif str(item['instrument']['symbol']) == str(item['instrument']['instrumentId']):
                                    # 165780651 symbol == instrumentId
                                    strike = item['instrument']['strikePrice']
                                    option = item['instrument']['putCall']
                                    expire = item['instrument']['expirationDate']
                                    expire = datetime.strptime(
                                        expire, "%Y-%m-%dT%H:%M:%S%z")

                                    expire = expire.strftime("%d %b %y")
                                else:
                                    # AEM   240621C00070000 hacer join segun elis preguntar
                                    parte_alfabetica = item['instrument']['symbol'][:3].strip(
                                    )
                                    opt = item['instrument']['symbol'].split()

                                    if len(opt) < 2:
                                        continue
                                    if 'C' in opt[1]:
                                        expire = opt[1].split('C')[0]
                                        option = 'CALL'
                                    elif 'P' in opt[1]:
                                        expire = opt[1].split('P')[0]
                                        option = 'PUT'
                                    strike = item['instrument']['strikePrice']
                                    expire = datetime.strptime(
                                        expire, "%y%m%d")

                                    expire = expire.strftime("%d %b %y")
                                # de = ImportParams.get_trade_datetime(
                                #     expire, "%m/%d/%Y")
                                # print(de)

                            spread = item['instrument']['type'] if item['instrument']['type'] != 'VANILLA' else 'SINGLE'
                            if 'amount' in item and 'cost' in item and 'price' in item:
                                price = item['price']
                                shares = abs(item['amount'])
                                if item['amount'] < 0:
                                    action = 'SELL'
                                else:
                                    action = 'BUY'
                
                try:
                    if expire != '':  # and 'T' in expire and not ' ' in expire:
                        # Example dates
                        date1_str = "2024-02-01"
                        date2_str = "2013-04-05"

                        # Convert strings to datetime objects
                        orderDate = datetime.strptime(
                            row["orderDate"], "%Y-%m-%dT%H:%M:%S%z")
                        expire = datetime.strptime(expire, "%d %b %y")

                        # Determine the greater year
                        greater_year = max(orderDate.year, expire.year)
                        if orderDate.year > expire.year:
                            # Create new dates with the greater year
                            new_orderDate = orderDate.replace(year=orderDate.year)
                            new_expire = expire.replace(year=orderDate.year)
                            row["orderDate"] = new_orderDate.strftime(
                                "%Y-%m-%dT%H:%M:%S%z")
                            expire = new_expire.strftime("%d %b %y")
                        else:
                            row["orderDate"] = orderDate.strftime(
                                "%Y-%m-%dT%H:%M:%S%z")
                            expire = expire.strftime("%d %b %y")
                        # Convert the new dates to strings
                    # print(row["orderDate"], expire)
                except:
                    pass
                data_trade = {}
                if strike !=0 and strike != '' and strike != None:
                    type = 'option'
                if size>0:
                    #print('size',size)
                    data_trade['size'] = size
                data_trade['portfolio'] = fk_portfolio_id
                data_trade['file_row'] = njson
                data_trade['userid'] = self.user.id
                data_trade['spread'] = spread
                data_trade['expire'] = expire
                data_trade['strike'] = strike
                if not symbol:
                    continue
                data_trade['symbol'] = symbol
                for item in symbol_list:
                    if symbol == item['cusip']:
                        data_trade['symbol'] = item['ticker']
                # continue
                # if symbol == "SPXW":
                #     symbol = "SPX"
                data_trade['broker'] = "CharlesSchwab"
                data_trade['action'] = action

                # original_file_row['date_tz'] = str(row["orderDate"])
                # timestamp = parse(row["orderDate"])
                original_file_row['date_tz'] = str(row["orderDate"])
                timestamp = parse(row["orderDate"])
                timestamp_set_tz = timestamp.astimezone(est).strftime(fmt)
                dt = str(timestamp_set_tz).strip().split(' ') 
                data_trade['date'] = dt[0]
                data_trade['time'] = dt[1][:8]
                fp = str(price).replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp), decimal)
                data_trade['price'] = price
                data_trade['decimal'] = decimal
                data_trade['shares'] = shares
                data_trade['original_file_row'] = original_file_row

                data_trade['type_stock'] = type
                data_trade['type_option'] = option

                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = data_trade['portfolio']
                    if 'activityId' in row and row['activityId']:
                        order_id = row['activityId']
                    valid_file_row = ImportParams.validate_filerow(self.orders_filerow,
                                                                njson=njson,
                                                                order_id=order_id,
                                                                date_tz=original_file_row['date_tz'],
                                                                price=price,
                                                                option=option,
                                                                action=data_trade['action'],
                                                                quantity=data_trade['shares'],
                                                                strike=strike,
                                                                expire=expire,
                                                                portfolio=portfolio_,
                                                                broker='CharlesSchwab'
                                                                )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################

                # sum of fees
                data_trade['comm'] = commission
                data_trade['fees'] = fee
                data_trade['orderby'] = a
                if self.user.id in [0]:
                    if 'orderId' in row:
                        data_trade['search_key'] = action+str(row['orderId'])+data_trade['symbol']+str(price)
                        if action+str(row['orderId'])+data_trade['symbol']+str(price) not in dict_amount:
                            dict_amount[action+str(row['orderId'])+data_trade['symbol']+str(price)] = shares
                            data_item = ImportParams.get_result_append(data_trade)
                            data_item['search_key'] = action+str(row['orderId'])+data_trade['symbol']+str(price)
                            if data_item not in trades_list:
                                trades_list.append(data_item)
                        else:
                            #print('entro a editar.')
                            dict_quatity = shares + dict_amount[action+str(row['orderId'])+data_trade['symbol']+str(price)]
                            for row2 in trades_list:
                                if row2['search_key'] == action+str(row['orderId'])+data_trade['symbol']+str(price):
                                    row2['shares'] = dict_quatity
                                    break
                    else:
                        data_item = ImportParams.get_result_append(data_trade)
                        data_item['search_key'] = ''
                        if data_item not in trades_list:
                            trades_list.append(data_item)
                else:                                    
                    data_item = ImportParams.get_result_append(data_trade)
                    if data_item not in trades_list:
                        trades_list.append(data_item)
                a = a - 1 
            self.check_status_connection_db()
            import_broker = 'CharlesSchwab'
            try:
                self._update_progress('Regrouping Orders', '20%')
            except:
                pass
            try:
                regroup_orders_event = EventUser.post_user_events(102, new_user=self.user_id)
            except:
                pass
            if update_trades:
                for t in update_trades:
                    response = UpdateTrade.getTrade(t)

            regroup_value = [group['code']
                            for group in self.user.users_configs.trade_grouping if group['active'] == True][0]
            error_mgs = "There was an error. Our support team will review the issue and get back to you"
            ################## DELETE AUTO EXPIRE ##########################
            # delete_autoexpire =  TradesExpired.delete_autoexpire(self.user.id, regroup_value, broker=import_broker)
            # Delete orders not in transactions file
            # if type_trade.upper() in ['TRADE']:
            #    delete_orders_tda = TradesExpired.delete_orders_tda(self.user.id, fk_portfolio_id=fk_portfolio_id, testapi=True)
            
            ################## AUTO SPREAD ####################
            if regroup_value == 'spread' and self.user.users_configs.spread_detection:
                TempOrders.delete_all()
                trades_list = TradeRegroups.insertTempOrders(trades_list,user_id = self.user.id,is_sync=True)
               
            ################## SAVE TO DATABASE ####################
            spread = False
            if regroup_value == 'split':
                output_group = TradeRegroups.regroup_trades_closed(trades_list, import_broker, self.user.id)
            else:
                if regroup_value == 'spread':
                    spread = True
                output_group = TradeRegroups.regroup_trades(trades_list, import_broker, self.user.id, spread=spread, user=self.user)
            if 'error' in output_group:
                #print('error in regroup trades', output_group['error'])
                out['mgs'] = error_mgs
                return out
            any_error, rows, return_total, error_issue, executions = False, 0, 0, 0, 0
            try:
                title = "Saving csv file {} transactions {}".format(message, len(transactions))
                self._update_progress(title, '20%')
            except:
                pass
            #print('antes del save to database de charles')
            if output_group:
                #print('antes del save to database de charles 2', len(output_group))
                not_error = self.save_files_charles_schwab(executions=executions,file_type='transactions')
                
                #print('dentro')
                
                any_error, rows, return_total, error_issue, executions, self.upload_id = TradeRegroups.save_to_database(
                    output_group, import_broker, self.user.id, archive=self.trades_archive, upload_id=self.upload_id)
            """
                rows : total trades imported
                executions: total executions imported
            """
            self.rows = rows
            out = {'any_error': any_error, 'rows': rows, 'ordens': executions,
                'return_total': return_total, 'error_issue': error_issue,
                'broker': import_broker, 'error_code': any_error}
            #print('despues del save to database de charles',out)
            if any_error and any_error != 21:
                out['mgs'] = error_mgs
                return out
            else:
                if rows > 0 or executions > 0:
                    try:
                        self.user.fk_user_status_id = 1
                        self.user.save()
                    except:
                        pass
                    mgs = f'{str(rows)} Trades, {str(executions)} Executions'
                else:
                    if self.last_date == 0 or self.last_date == None:
                        mgs = "No new trades found."
                    else:
                        mgs = "No new trades to import"
            out['mgs'] = mgs
            try:
                event_success = EventUser.update_user_events(regroup_orders_event)
            except:
                pass
            return out
        except Exception as err:
            #print('Error in export_trades_charles_schwab', str(err))
            out = {'any_error': True, 'rows': 0, 'ordens': 0,
                   'return_total': 0, 'error_issue': 0}
            out['mgs'] = str(err)
            return out

    def optimized_export_trades_charles_schwab(self, transactions, symbol_list, message):
        try:
            out = {}
            trades_list = []
            processed_activity_ids = set()
            processed_jsons = set()
            est = default_configs.APP_TIMEZONE
            fmt = '%Y-%m-%d %H:%M:%S'
            dict_amount = {}
            self._update_progress(f"Reading orders {message}", '20%')
            total_transactions = len(transactions)
            
            for cant, row in enumerate(transactions, 1):
                if cant % 500 == 0 or cant == 1 or cant == total_transactions:
                    self._update_progress(f"Reading orders {cant}/{total_transactions} {message}", '20%')
                
                if 'activityId' in row:
                    activity_id = row['activityId']
                    if activity_id in processed_activity_ids:
                        continue
                    processed_activity_ids.add(activity_id)
                
                check_json = hashlib.md5(json.dumps(row).encode('utf-8')).hexdigest()
                if check_json in processed_jsons:
                    continue
                processed_jsons.add(check_json)
                
                if not ('type' in row and 
                        row['type'].upper() == "TRADE" and 
                        'accountNumber' in row and
                        'time' in row and row["time"] != '' and
                        'transferItems' in row):
                    continue
                
                if 'status' in row and row["status"] == 'INVALID':
                    continue
                
                original_file_row = json.loads(json.dumps(row))
                njson = hashlib.md5(json.dumps(row).encode('utf-8')).hexdigest()
                row["orderDate"] = row["time"]
                reference_code = row['accountNumber']
                self.portfolio = reference_code
                
                get_portfolio = PortfolioReferences.query.filter_by(
                    reference_code=reference_code,
                    fk_broker_id=15,
                    fk_user_id=self.user.id
                ).first()
                
                if not get_portfolio:
                    continue
                    
                fk_portfolio_id = get_portfolio.fk_portfolio_id
                if fk_portfolio_id not in self.charles_schwab_portfolio_id:
                    self.charles_schwab_portfolio_id.append(fk_portfolio_id)
                
                commission = fee = 0
                shares_ = 0
                type_trade = row['type'].upper()
                type_stock = 'share'
                option_type = 'SHARE'
                spread = 'SINGLE'
                expire = ''
                strike = ''
                symbol = None
                action = ''
                price = 0
                shares = 0
                size = 0
                
                for item in row['transferItems']:
                    if 'instrument' not in item:
                        continue
                        
                    instrument = item['instrument']
                    asset_type = instrument.get('assetType', '')
                    
                    if 'feeType' in item:
                        if 'COMMISSION' in item['feeType']:
                            commission += item['amount']
                        elif 'FEE' in item['feeType']:
                            fee += item['amount']
                        continue
                    
                    if asset_type in ('EQUITY', 'COLLECTIVE_INVESTMENT'):
                        if instrument.get('status', '').lower() == 'disabled':
                            d = True
                        if 'symbol' not in instrument:
                            continue
                            
                        symbol = instrument['symbol']
                        
                        if all(k in item for k in ('amount', 'cost', 'price')):
                            price = item['price']
                            shares = abs(item['amount'])
                            action = 'SELL' if item['amount'] < 0 else 'BUY'
                            
                        if 'type' in instrument and ('COMMON_STOCK' in instrument['type'] or 'EXCHANGE_TRADED_FUND' in instrument['type']):
                            shares_ += shares
                            shares = shares_
                    
                    elif asset_type == 'FOREX':
                        if instrument.get('status', '').lower() == 'disabled':
                            d = True
                        if 'symbol' not in instrument:
                            continue
                            
                        type_stock = 'forex'
                        option_type = 'FOREX'
                        symbol = "$" + instrument['symbol'].replace("/", "")
                        
                        if all(k in item for k in ('amount', 'cost', 'price')):
                            price = item['price']
                            shares = abs(item['amount'])
                            action = 'SELL' if item['amount'] < 0 else 'BUY'
                        size = 1
                    
                    elif asset_type == 'OPTION':
                        if 'optionPremiumMultiplier' in instrument:
                            size = instrument['optionPremiumMultiplier']
                            
                        if instrument.get('status', '').lower() == 'disabled':
                            d = True
                            
                        symbol = instrument.get('underlyingSymbol', instrument.get('symbol', '').split('_')[0])
                        
                        if 'symbol' in instrument:
                            symbol_str = instrument['symbol']
                            
                            if '/' in symbol_str:
                                strike = instrument['strikePrice']
                                option_type = instrument['putCall']
                                expire = instrument['expirationDate']
                                expire = datetime.strptime(expire, "%Y-%m-%dT%H:%M:%S%z").strftime("%d %b %y")
                                
                                try:
                                    future_params = ImportParams.getFutureSymbol(symbol.replace('/', ''), broker='CharlesSchwab')
                                    # day_week = ImportParams.get_date_week_expire(symbol, future_params['expire'])
                                    # if day_week:
                                    #    expire = day_week
                                    symbol = future_params['symbol']
                                except:
                                    pass
                                    
                            elif '.' in symbol_str:
                                strike = instrument['strikePrice']
                                option_type = instrument['putCall']
                                expire = datetime.strptime(instrument['expirationDate'], "%Y-%m-%dT%H:%M:%S%z").strftime("%d %b %y")
                                
                            elif '_' in symbol_str:
                                opt = symbol_str.split('_')
                                if 'C' in opt[1]:
                                    strike = opt[1].split('C')[1]
                                    expire = opt[1].split('C')[0]
                                    option_type = 'CALL'
                                elif 'P' in opt[1]:
                                    strike = opt[1].split('P')[1]
                                    expire = opt[1].split('P')[0]
                                    option_type = 'PUT'
                                expire = datetime.strptime(expire, "%m%d%y").strftime("%d %b %y")
                                
                            elif str(symbol_str) == str(instrument.get('instrumentId', '')):
                                strike = instrument['strikePrice']
                                option_type = instrument['putCall']
                                expire = datetime.strptime(instrument['expirationDate'], "%Y-%m-%dT%H:%M:%S%z").strftime("%d %b %y")
                                
                            else:
                                parte_alfabetica = symbol_str[:3].strip()
                                opt = symbol_str.split()
                                
                                if len(opt) < 2:
                                    continue
                                    
                                if 'C' in opt[1]:
                                    expire = opt[1].split('C')[0]
                                    option_type = 'CALL'
                                elif 'P' in opt[1]:
                                    expire = opt[1].split('P')[0]
                                    option_type = 'PUT'
                                    
                                strike = instrument['strikePrice']
                                expire = datetime.strptime(expire, "%y%m%d").strftime("%d %b %y")
                        
                        spread = instrument.get('type', '') if instrument.get('type', '') != 'VANILLA' else 'SINGLE'
                        
                        if all(k in item for k in ('amount', 'cost', 'price')):
                            price = item['price']
                            shares = abs(item['amount'])
                            action = 'SELL' if item['amount'] < 0 else 'BUY'
                
                if not symbol:
                    continue
                    
                try:
                    if expire:
                        orderDate = datetime.strptime(row["orderDate"], "%Y-%m-%dT%H:%M:%S%z")
                        expire_date = datetime.strptime(expire, "%d %b %y")
                        
                        if orderDate.year > expire_date.year:
                            new_expire = expire_date.replace(year=orderDate.year)
                            expire = new_expire.strftime("%d %b %y")
                            row["orderDate"] = orderDate.strftime("%Y-%m-%dT%H:%M:%S%z")
                        else:
                            row["orderDate"] = orderDate.strftime("%Y-%m-%dT%H:%M:%S%z")
                except:
                    pass
                
                if strike and strike != 0 and strike != '':
                    type_stock = 'option'
                
                data_trade = {
                    'portfolio': fk_portfolio_id,
                    'file_row': njson,
                    'userid': self.user.id,
                    'spread': spread,
                    'expire': expire,
                    'strike': strike,
                    'symbol': symbol,
                    'broker': "CharlesSchwab",
                    'action': action,
                    'type_stock': type_stock,
                    'type_option': option_type,
                    'comm': commission,
                    'fees': fee
                }
                
                for item in symbol_list:
                    if symbol == item['cusip']:
                        data_trade['symbol'] = item['ticker']
                        break
                
                original_file_row['date_tz'] = str(row["orderDate"])
                timestamp = parse(row["orderDate"])
                timestamp_set_tz = timestamp.astimezone(est).strftime(fmt)
                dt = str(timestamp_set_tz).strip().split(' ')
                data_trade['date'] = dt[0]
                data_trade['time'] = dt[1][:8]
                fp = str(price).replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp), decimal)
                data_trade['price'] = price
                data_trade['decimal'] = decimal
                data_trade['shares'] = shares
                data_trade['original_file_row'] = original_file_row
                
                if size > 0:
                    data_trade['size'] = size
                
                # Verificar si la fila ya existe en la base de datos
                try:
                    order_id = row.get('activityId', '')
                    portfolio_ = data_trade['portfolio']
                    
                    valid_file_row = ImportParams.validate_filerow(
                        self.orders_filerow,
                        njson=njson,
                        order_id=order_id,
                        date_tz=original_file_row['date_tz'],
                        price=price,
                        option=option_type,
                        action=data_trade['action'],
                        quantity=data_trade['shares'],
                        strike=strike,
                        expire=expire,
                        portfolio=portfolio_,
                        broker='CharlesSchwab'
                    )
                    
                    if valid_file_row:
                        continue
                except:
                    pass
                
                if self.user.id in [0]:
                    if 'orderId' in row:
                        search_key = action + str(row['orderId']) + data_trade['symbol'] + str(price)
                        data_trade['search_key'] = search_key
                        
                        if search_key not in dict_amount:
                            dict_amount[search_key] = shares
                            data_item = ImportParams.get_result_append(data_trade)
                            data_item['search_key'] = search_key
                            trades_list.append(data_item)
                        else:
                            # Actualizar cantidad en operación existente
                            dict_amount[search_key] += shares
                            for row2 in trades_list:
                                if row2['search_key'] == search_key:
                                    row2['shares'] = dict_amount[search_key]
                                    break
                    else:
                        data_item = ImportParams.get_result_append(data_trade)
                        data_item['search_key'] = ''
                        trades_list.append(data_item)
                else:
                    data_item = ImportParams.get_result_append(data_trade)
                    trades_list.append(data_item)
            
            self.check_status_connection_db()
            import_broker = 'CharlesSchwab'
            
            try:
                self._update_progress(f'Regrouping Orders {message}', '20%')

            except:
                pass
            
            # Registrar evento de reagrupación
            try:
                regroup_orders_event = EventUser.post_user_events(102, new_user=self.user_id)
            except:
                pass
            
            # Obtener valor de reagrupación
            regroup_value = [group['code'] for group in self.user.users_configs.trade_grouping if group['active'] == True][0]
            error_mgs = "There was an error. Our support team will review the issue and get back to you"
            
            # Reagrupar operaciones según configuración
            if regroup_value == 'spread' and self.user.users_configs.spread_detection:
                TempOrders.delete_all()
                trades_list = TradeRegroups.insertTempOrders(trades_list, user_id=self.user.id, is_sync=True)
            
            # Guardar en la base de datos
            spread = False
            if regroup_value == 'split':
                output_group = TradeRegroups.regroup_trades_closed(trades_list, import_broker, self.user.id)
            else:
                if regroup_value == 'spread':
                    spread = True
                output_group = TradeRegroups.regroup_trades(trades_list, import_broker, self.user.id, spread=spread, user=self.user)
            
            if 'error' in output_group:
                out['mgs'] = error_mgs
                return out
            
            any_error, rows, return_total, error_issue, executions = False, 0, 0, 0, 0
            
            # Actualizar progreso
            try:
                title = f"Saving csv file {message}"
                self._update_progress(title, '20%')
            except:
                pass
            
            # Guardar archivos y actualizar base de datos
            if output_group:
                not_error = self.save_files_charles_schwab(executions=executions, file_type='transactions')
                title = f"Save orders {message}"
                self._update_progress(title, '20%')
                any_error, rows, return_total, error_issue, executions, self.upload_id = TradeRegroups.save_to_database(
                    output_group, import_broker, self.user.id, archive=self.trades_archive, upload_id=self.upload_id
                )
            
            # Guardar resultados
            self.rows = rows
            out = {
                'any_error': any_error, 
                'rows': rows, 
                'ordens': executions,
                'return_total': return_total, 
                'error_issue': error_issue,
                'broker': import_broker, 
                'error_code': any_error
            }
            
            if any_error and any_error != 21:
                out['mgs'] = error_mgs
                return out
            else:
                if rows > 0 or executions > 0:
                    try:
                        self.user.fk_user_status_id = 1
                        self.user.save()
                    except:
                        pass
                    mgs = f'{str(rows)} Trades, {str(executions)} Executions'
                else:
                    if self.last_date == 0 or self.last_date is None:
                        mgs = "No new trades found."
                    else:
                        mgs = "No new trades to import"
            
            out['mgs'] = mgs
            
            try:
                event_success = EventUser.update_user_events(regroup_orders_event)
            except:
                pass
            
            return out
            
        except Exception as err:
            out = {
                'any_error': True, 
                'rows': 0, 
                'ordens': 0,
                'return_total': 0, 
                'error_issue': 0,
                'mgs': str(err)
            }
            return out
 
    def save_configs(self, data):
        timezone_name = data['timezone'] if 'timezone' in data and data['timezone'] else ""
        self.user.users_configs.sync_form = {"broker": 'CharlesSchwab', "portfolio": data.get(
            'portfolio', ''), "timezone": timezone_name, "dateformat": ""}
        self.user.users_configs.tda_auto_login = data['auto_login'] if 'auto_login' in data else True
        self.user.users_configs.save()

    def get_transactions_charles_schwab(self):
        if not self.accounts_id:
            self.get_account_charles_schwab()

        transactions = []
        per = (int(tt.strftime("%Y")) - 2010) + len(self.accounts)
        per_ = (per / len(self.accounts) if len(self.accounts) != 0 else 0)
        per = 1 
        self.start_date = ''
        #print('start_date', start_date)
        
        self.accounts=self.remove_duplicate(self.accounts)
        for account in self.accounts: 
            if 'account' in self.data: 
                if self.data['account'] != account['account_number']:
                    continue
            self.user.users_configs.save() 
            start_date = self.get_last_date_a(user_account=account['account_number'],format='%Y-%m-%d')
            #print('start_date', start_date) 
            if start_date != 0:
                self.start_date=start_date 
            self._update_progress('Retrieving orders account: {}'.format(account['account_number']), '15%')
            time.sleep(0.5)
            n = 'trade'
            self.account_id = account['accountId']
            #print('start_date ',account['account_number'], self.start_date)
            is_year_now=False
            if self.start_date != '':
                object_new_date = datetime.strptime(self.start_date, '%Y-%m-%d')
                year_now = datetime.now().year
                is_year_now = object_new_date.year == year_now
                #print('is_year_now',is_year_now)
            #print(self.data['partial'], self.start_date, is_year_now)
            if self.start_date != '' and ('partial' in self.data and self.data['partial'] == True) and is_year_now:
                self._update_progress('Retrieving orders account: {} {}'.format(account['account_number'],int(tt.strftime("%Y"))), '15%') 
                
                self.end_date = '{}-12-31'.format(int(tt.strftime("%Y")))                 
                r = self.access('transactions_{}'.format(n))
                self.log_response = r
                if not 'error' in r and not 'message' in r:
                    transactions.append(r)
                self.batch = True
            else:
                if self.start_date == '':
                    self.start_year = 2015
                    self.end_year = 2015
                    is_year_now =True
                elif self.start_date != '' and ('partial' in self.data and self.data['partial'] == True) and not is_year_now:
                    self.start_year = object_new_date.year
                    self.end_year = object_new_date.year
                else:
                    self.start_year = 2015
                    self.end_year = 2015
                    is_year_now =True
                    
                self.batch = False
                all_years_transactions = []
                error = None
                timeout = 0
                while int(tt.strftime("%Y")) >= self.start_year:
                    self._update_progress('Retrieving orders account: {} {}'.format(account['account_number'],self.start_year), '15%')
                    if self.start_date != '' and ('partial' in self.data and self.data['partial'] == True) and not is_year_now:                        
                        is_year_now=True
                        #print('entro')
                    else:
                        self.start_date = '{}-01-01'.format(self.start_year)
                    
                    self.end_date = '{}-12-31'.format(self.end_year)
                    #print('self.start_date',self.start_date)
                    #print('self.end_date',self.end_date)
                    if self.user.id == 158560 or self.user.id == 729:
                        self.start_date = '{}-01-01'.format(
                            self.start_year)
                        self.end_date = '{}-12-31'.format(self.end_year)
                    r = self.access('all_transactions_{}'.format(n))
                    #print(r)
                    if 'fault' in r:
                        #print('error',r)
                        if 'errorcode' in r['fault']['detail']:
                            if 'Timeout' in r['fault']['detail']['errorcode']:
                                time.sleep(5)
                                timeout = timeout + 1
                                if timeout == 1:
                                    self.start_year = self.start_year + 1
                                    self.end_year = self.end_year + 1
                                    timeout = 0
                                    self.fail_years.append(self.start_year)
                                continue
                    # self.log_response = r
                    if r != []:
                        for i in r:
                            if 'error' in r:
                                #print('error',r)
                                if 'An unexpected server error occurred while trying to process the request. The associated error referenceID is' in r['error']:
                                    continue
                                time.sleep(5)
                                error = True
                                continue
                            if not 'transactionDate' in i and isinstance(i, dict):
                                i['transactionDate'] = ''
                        if error:
                            error = None
                            continue
                        if not 'error' in r:
                            all_years_transactions.append(r)
                        
                        try:
                            r = sorted(r, key=lambda x: parse(x['time']), reverse=True)
                        except:
                            pass
                        
                        if len(r) == 3000:
                            date_original = r[-1]['time']
                            date_obj = datetime.strptime(date_original, "%Y-%m-%dT%H:%M:%S%z")
                            self.end_date_paginated =  date_obj.strftime("%Y-%m-%dT%H:%M:59.999Z")
                            self.start_date_paginated = '{}-01-01'.format(
                                self.start_year)
                            timeout = 0
                            date_obj_anterior = date_obj
                            while len(r) == 3000:
                                self._update_progress('Retrieving orders account: {} {}'.format(account['account_number'],date_obj.strftime("%Y-%m-%d")), '15%')
                               
                                r = self.access('transactions_paginated_{}'.format(n))    
                                #print(r)                            
                                if 'fault' in r:
                                    #print('error bucle 3000 ',r)
                                    if 'errorcode' in r['fault']['detail']:
                                        if 'Timeout' in r['fault']['detail']['errorcode']:
                                            time.sleep(7)
                                            timeout = timeout + 1
                                            if timeout == 1:
                                                self.start_year = self.start_year + 1
                                                self.end_year = self.end_year + 1
                                                timeout = 0
                                                self.fail_years.append(
                                                    self.start_year)
                                            continue
                                
                                if r != []:
                                    for i in r:
                                        if 'error' in r:
                                            #print('error 2',r)
                                            if 'An unexpected server error occurred while trying to process the request. The associated error referenceID is' in r['error']:
                                                continue
                                            time.sleep(2.5)
                                            error = True
                                            continue
                                    if error:
                                        error = None
                                        continue
                                    if not 'error' in r:
                                        all_years_transactions.append(r)
                                    
                                    r = sorted(r, key=lambda x: parse(x['time']), reverse=True)
                                    if len(r) == 3000:
                                        #print('time',r[-1]['time'])
                                        date_original = r[-1]['time']
                                        date_obj = datetime.strptime(date_original, "%Y-%m-%dT%H:%M:%S%z")
                                        
                                        if date_obj == date_obj_anterior:
                                            date_obj = date_obj - timedelta(hours=24)                                            
                                        
                                        date_obj_anterior = date_obj                                      
                                        
                                        self.end_date_paginated =  date_obj.strftime("%Y-%m-%dT%H:%M:59.999Z")
                                        #print(self.end_date_paginated)
                                        self.start_date_paginated = '{}-01-01'.format(self.start_year)
                                        
                    self.start_year = self.start_year + 1
                    self.end_year = self.end_year + 1
                per = int(per + per_)

                # aqui se puede hacer el itertools.chain.from_iterable, por si falla, hay que recordar los cambios en la iteracion del
                # json para el csv, igual existe un archivo copia\
                if all_years_transactions != []:
                    try:
                        order_transactions = list(sorted(list(itertools.chain.from_iterable(

                            all_years_transactions)), key=lambda i: i['time'] if isinstance(i, dict) and 'time' in i else '', reverse=True))
    
                        transactions.append(order_transactions)
                    except:
                        pass
        
                    
                    
        self.transactions = list(
            itertools.chain.from_iterable(self.transactions))
        self.transactions = transactions
        self.json_data['transactions'] = self.transactions
        # self.transactions = APIJSON['transactions']
        return True

    def get_account_charles_schwab(self):
        response = self.access('accounts')
        if self.account_list is None or self.account_list == []:
            self.account_list = [item["accountNumber"] for item in response] 
        if (response and 'error' in response and response['error'] == 'invalid_grant') or (response and 'error' in response and 'per seconds' in response['error']) or (response and 'error' in response and 'service is unavailable.' in response['error']):
            return response
        if (response and 'errors' in response):
            return response
        self.log_response = response
        
        accounts = []
        if 'sync_all_v2' in self.data and self.data['sync_all_v2'] == True:
            for data in response:
                if not 'accountNumber' in data:
                    continue
                if data['accountNumber'] == self.api_key_information[0]:
                    accounts.append(data)
        else:
            accounts = response
        
        # return
        currentBalances = ''
        for r in accounts:
            if not 'accountNumber' in r:
                continue
            if self.data.get('account_list', []) != [] and r['accountNumber'] not in self.data.get('account_list', []):
                continue
            self.account = r['accountNumber']
            self.accounts.append(
                {
                    'broker': self.broker_data,
                    # if 'accountNumber' in r else self.broker_data + '#' + r['hashValue'],
                    'portfolio':  self.broker_data + r['accountNumber'],
                    # if 'accountNumber' in r else '#' + r['hashValue'],
                    'account_number': r['accountNumber'],
                    'accountId': r['hashValue'],
                    'currentBalances': currentBalances,
                    'start_date':  "",
                    'start_year':  ""
                }
            )
            self.accounts_id.append(r['hashValue'])
            self.json_data['accounts'] = self.accounts

    def filerow_orders(self, id):
        """
        This function get the file_row upload user orders.

        Parameters::
            id (int): User Id.
        """
        data = "DeleteFilerowTemp"
        version = {}
        out = []
        try:
            """trade_p = TradesHistories.query\
                                  .join(Trades,
                                        TradesHistories.fk_trade_id == Trades.trade_id)\
                                  .filter(Trades.fk_user_id == id,
                                         TradesHistories.file_row.contains("TDA"))\
                                  .all()"""
            trade_p = TradesHistories.query\
                .with_entities(TradesHistories.id,
                               TradesHistories.original_file_row,
                               TradesHistories.file_row,
                               TradesHistories.shares,
                               TradesHistories.price)\
                .filter(TradesHistories.fk_user_id == id,
                        TradesHistories.broker == "CharlesSchwab")
            trade_p = trade_p.all()
            if trade_p:
                out = trade_p

        except Exception as err:
            #print("filerow_orders", traceback.format_exc())
            pass
        return out
