from .base import BrokerBase


class BrokerCharlesSchwab(BrokerBase):

    # names in the file
    USE_COLS = [
        'Symbol/CUSIP', 'Action', 'Quantity',
        'Price', 'Date', 'Fee/Comm'
    ]
    # rename names USE_COLS in FIELDS must have same length
    FIELDS = [
         BrokerBase.SYMBOL, BrokerBase.ACTION,
        BrokerBase.SHARES, BrokerBase.PRICE,
         BrokerBase.DATE, BrokerBase.COMM
    ]
    TOACTION = {
        'Buy': BrokerBase.ACTION_BUY, 'Sell': BrokerBase.ACTION_SELL
    }

    FORMAT_DATE = '%m/%d/%Y'

    SKIPROWS = 5
    TRANSFORMERS = BrokerBase.TRANSFORMERS
    REMOVES = BrokerBase.REMOVES

    REMOVES[BrokerBase.PRICE] = '$()'
    REMOVES[BrokerBase.SHARES] = '-'
    REMOVES[BrokerBase.SHARES] = ','
    REMOVES[BrokerBase.COMM] = '()$'

    @classmethod
    def parse_action(cls, df):
        df[cls.ACTION] = df[cls.ACTION].apply(cls.TOACTION.get)

    @classmethod
    def filter(cls, df):
        # the file is in descendant order
        df.sort_index(ascending=False, inplace=True)
        df.reset_index(inplace=True)
        # only accept buy or sell actions
        valids = ((df[cls.ACTION] == 'Buy') | (df[cls.ACTION] == 'Sell') |
                  (df[cls.ACTION] == 'BUY') | (df[cls.ACTION] == 'SELL') )
        df = df[valids]

        return df
