import re
import hashlib
import json
import traceback

from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required

from .. import_params import ImportParams
from .. security_service import *
from .. logs import create_log
from .. trade.trades_regroups import *
from .. responses import ErrorResponses, SuccessResponses
from dateutil.parser import parse

class BrokerSchwabStreet(Resource):

    def getcsv(params, content, date_format='mdy'):
        data = "BrokerSchwabStreet"
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            if 'table' in content:
                return BrokerSchwabStreet.getcsv2(params, content, date_format='mdy')
            content = content.replace(';', '')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False

            for row in content_b:
                if 'SYMBOL' in row.upper() or 'DESCRIPTION' in row.upper():
                    ath = True
                elif not row:
                    continue
                    #ath = False

                if ath:
                    if rl == 0:
                        row = row.replace("\r", "")
                        ns = row.split(',')
                        nl = len(ns)
                        result_b.append(row)
                    if rl > 0:
                        result_b.append(row)
                    rl = rl + 1

            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            b = len(result)

            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                # issue 7162
                if 'status' in n and 'Part Fill' in n['status']:
                    n['status'] = 'FILLED'
                action = n['action'].upper() if 'action' in n else n['action description'].upper() if 'action description' in n else n['side'].upper() if 'side' in n else ''
                action = action.replace('TO CLOSE','').replace('TO OPEN','').strip()
                action = 'BUY' if 'CANCEL SELL' in action or ('BUY' in action and not 'CANCEL BUY' in action) or action=='COVER' or action=='LONG' or action=='B' else 'SELL' if 'CANCEL BUY' in action or 'SELL' in action or action == 'SHORT' or action=='S' else ''

                if 'description' in n and 'EXPIRED' in n['description']:
                    action = "EXP"
                n['date'] = n['submit date/time'] if 'submit date/time' in n else n['time and date et'] if 'time and date et' in n else n['date'] if 'date' in n else n['execution date'] if 'execution date' in n else ''
                n['price'] = n['qty filled at'].split('@')[1].strip() if 'qty filled at' in n and '@' in n['qty filled at'] else n['price'].lower().replace('limit','').strip() if 'price' in n else ''
                if 'description' in n and 'EXPIRED' in n['description']:
                    action = "EXP"
                n['price'] = n['price'].replace(',', '').replace('$','')
                if not ImportParams.isfloat(n['price']):
                    continue
                n['symbol'] = n['symbol'] if 'symbol' in n else n['description'].split(' ')[0]
                if not n['symbol'] or not n['date'] or not n['price'] or action not in ["BUY", "SELL", "EXP"] or ('status' in n and 'FILLED' not in n['status'].upper()):
                    continue

                pip_value = 0
                date_split = n['date'].strip().split(' ')[0] if not ':' in n['date'] else n['date'].strip()
                if not ':' in n['date'] and 'time'in n and n['time']:
                    date_split = n['date'] + ' ' + n['time'].strip()
                d = date_split
                original_file_row['date_tz'] = date_split
                any_error, date, time = ImportParams.get_param_datetime(date_split,b)
                new_date_time = ImportParams.convert_date(date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                fp = n['price'].replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp),decimal)
                #price = round(float(n['price'].replace(',', '')),6)

                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = ''
                smn = n['symbol'][-2:]

                if '/' in n['symbol'] and sm < 8 or (sm > 4 and sm < 8 and ImportParams.isfloat(smn)):
                    type = 'future'
                    option = 'FUTURE'
                    if 'description' in n:
                        desc = n['description'].split(' ')
                        symbol = desc[0]
                        future_params = ImportParams.getFutureSymbol(symbol)
                        symbol = future_params['symbol']
                        expire = future_params['expire']
                        n['size'] = future_params['size']
                        n['symbol'] = symbol
                elif sm >= 8 and not ImportParams.isfloat(n['symbol']):
                    type = 'option'
                    desc_opt = True
                    if 'description' in n:
                        n['description'] = ' '.join(n['description'].split())
                        desc = n['description'].split(' ')
                        if not desc[0].upper() in ['CALL','PUT']:
                            desc_opt = False
                            symbol = desc[0]
                            option = 'CALL' if desc[-1].upper() == 'CALL' else 'PUT' if desc[-1].upper() == 'PUT' else 'OPTION'
                            expire = desc[-3]
                            strike = desc[-2]

                            if 'transaction type id' in n and float(n['transaction type id'])==21:
                                symbol_future = symbol[:-1].replace(strike,'')
                                future_params = ImportParams.getFutureSymbol(symbol_future)
                                symbol = future_params['symbol']
                            n['symbol'] = symbol
                            try:
                                de = parse(expire)
                                expire = de.strftime('%d %b %y').upper()
                            except:
                                expire = expire

                    if desc_opt:
                        n['symbol'] = ' '.join(n['symbol'].split())
                        extract_data = n['symbol'].split(' ')
                        n['symbol'] = extract_data[0]
                        option = 'CALL' if extract_data[-1] == 'C' else 'PUT' if extract_data[-1] == 'P' else 'OPTION'
                        expire = extract_data[1]
                        strike = extract_data[2]
                        try:
                            de = parse(expire)
                            expire = de.strftime('%d %b %y').upper()
                        except:
                            expire = expire

                fee = n['fee'].replace(',', '').replace('$','') if 'fee' in n else n['fees'].replace(',', '').replace('$','') if 'fees' in n else n['fees & comm'].replace(',', '').replace('$','') if 'fees & comm' in n else n['reg fees'].replace(',', '').replace('$','')  if 'reg fees' in n else ''
                fee = round(float(fee),2) if fee else 0.00
                quantity = n['quantity'].replace(',', '') if 'quantity' in n else n['quantity|face value'].strip().split(' ')[0].replace(',', '') if 'quantity|face value' in n else ''
                if 'qty filled at' in n and '@' in n['qty filled at']:
                    extract = n['qty filled at'].split("@")
                    quantity = extract[0].strip() if extract else ''

                n['trade_notes'] = n['trade_notes'] if 'trade_notes' in n else ''
                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = price
                n['shares'] = quantity
                n['comm'] = n['commission'].replace(',', '').replace('$','') if 'commission' in n else '0.00'
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['pip_value'] = pip_value
                n['fees'] = fee
                n['original_file_row'] = original_file_row
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b - 1

                # out_result.append(n)
        except Exception as err:
            print(err, traceback.format_exc())
            any_error = 9
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error

    def getcsv2(params, content, date_format='mdy'):
        data = "BrokerSchwab2"
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            content = content.replace('th', 'td')
            content = content.replace('\n', '')
            result = ImportParams.convert_html_to_csv(content, 0, 0, 16)
            firtday = False
            if params['date_format']['id'] == 3 or params['date_format']['id'] == 4:
                firtday = True

            for a, n in enumerate(result):
                n = {k: v.decode('utf8') for k, v in n.items()}
                am_pm = 'AM' if 'fill time14' in n and 'AM' in n['fill time14'].upper() else 'PM'
                n = {k: v.split('-0')[0] for k, v in n.items()}
                n = {k: ' '.join(v.split()) for k, v in n.items()}
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                action = n['buy/sell'].upper() if 'buy/sell' in n else n['b/s8'].upper() if 'b/s8' in n else ''
                action = 'BUY' if action == 'BUY' or action=='COVER' or action=='B' else 'SELL' if action == 'SELL' or action == 'SHORT' or action=='S' else ''
                n['quantity'] = float(n['qty9'].replace(',', '')) if 'qty9' in n and ImportParams.isfloat(n['qty9']) else ''
                n['symbol'] = n['symbol4'] if 'symbol4' in n else ''
                n['price'] = n['type10'].lower().replace('limit','')


                d = n['fill time14'] if 'fill time14' in n else ''
                if d:
                    try:
                        n['date'] =  d[4:6] + "/" + d[6:8]+ "/" + d[:4] + " " + d[8:10] + ":" + d[10:12]+ ":" + d[12:14]
                    except:
                        continue

                if not n['symbol'] or not n['date'] or ('status16' in n and n['status16'].lower() != 'filled') or not n['price'] or not action or not ImportParams.isfloat(n['quantity']):
                    continue

                pip_value = 0
                date_time = n['date'].strip()
                original_file_row['date_tz'] = date_time
                original_file_row['firtday'] = firtday
                dateformat = '%m/%d/%Y %H:%M:%S'
                any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                new_date_time = ImportParams.convert_date(date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                fp = n['price'].replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp),decimal)
                #price = round(float(n['price'].replace(',', '')),6)

                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = ''
                smn = n['symbol'][-2:]

                if sm > 8:
                    type = 'option'
                    extract = n['symbol'].strip()
                    extract = ' '.join(extract.split()).split(' ')
                    n['symbol'] = extract[0]
                    option = 'CALL' if 'C' in extract[-1] else 'PUT'
                    expire = extract[1]
                    try:
                        de = parse(expire)
                        expire = de.strftime('%d %b %y').upper()
                    except:
                        expire = expire
                    strike = str(extract[-2]).replace(',', '').replace('$','')
                fee = n['fee'].replace(',', '').replace('$','') if 'fee' in n else n['fees'].replace(',', '').replace('$','') if 'fees' in n else ''
                fee = round(float(fee),2) if fee else 0.00

                n['trade_notes'] = n['trade_notes'] if 'trade_notes' in n else ''
                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = fp
                n['shares'] = n['quantity']
                n['comm'] = n['commission'].replace(',', '').replace('$','') if 'commission' in n else '0.00'
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                #n['pip_value'] = pip_value
                n['original_file_row'] = original_file_row
                n['fees'] = fee
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            print(err, traceback.format_exc())
            any_error = 9
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error
