import re
import hashlib
import json

from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required
from collections import OrderedDict, defaultdict, namedtuple

from .. import_params import ImportParams
from .. security_service import *
from .. logs import create_log
from .. responses import ErrorResponses, SuccessResponses
from .. portfolio.portfolios import *

# issues 9296


class BrokerCharlesSchwab(Resource):
    ORIGINAL_FILE_ROW = []

    def getcsv(params, content, date_format='mdy'):
        data = "BrokerCharlesSchwab"
        print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b = 0
        size = ''
        verify_row = False
        
        try:
            content = content.replace(';', '')
            if 'Qty Filled At' in content:
                return BrokerCharlesSchwab.getcsv3(params, content, date_format='mdy')
            if 'Quantity|Face Value' in content:
                return BrokerCharlesSchwab.getcsv4(params, content, date_format='mdy')
            if 'Exec Time,Spread,Side' in content:
                return BrokerCharlesSchwab.getcsv5(params, content, date_format='mdy')
            """if 'Action Description' in content:
                return BrokerCharlesSchwab.getcsv2(params, content, date_format='mdy')"""
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split(
                "\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            code_not_found = True
            verify = True
            action_lable = ['SELL', 'BUY', 'SHORT', 'LONG', 'EXPIRED', 'ASSIGNED', 'JOURNAL',
                            'SECURITY TRANSFER', 'CASH/STOCK', 'NAME CHANGE', 'REINVEST SHARES', 'Stock Split', ]
            filename_csv =  params['filename_orig'] if 'filename_orig' in params else params['filename'] if 'filename' in params else ''
            for row in content_b:

                ''' validate Account Reference Code '''
                str_account = 'FOR ACCOUNT'
                if verify:
                    if str_account in row.upper() and 'AS' in row.upper():
                        account_code = row.upper().split(str_account)[
                            1].strip().split('AS')[0].strip()
                        if account_code:
                            error, error_code, portfolio_id = ReferenceVerify.verify_code(
                                account_code,
                                params['get_session_userid'],
                                params['broker'],
                                params['user_portfolio'])
                            if error:
                                any_error = error_code
                                out_result = account_code
                                if error_code in [1011, 1014]:
                                    out_result = portfolio_id
                                return out_result, any_error
                            if portfolio_id:
                                params['user_portfolio'] = portfolio_id
                        code_not_found = False
                        verify = False
                    elif filename_csv and 'XXXXX' in filename_csv:
                        extract_account = filename_csv.strip().split('_')[
                            0]
                        account_code = extract_account.replace('XXXXX', '...')
                        if account_code:
                            error, error_code, portfolio_id = ReferenceVerify.verify_code(
                                account_code,
                                params['get_session_userid'],
                                params['broker'],
                                params['user_portfolio'])
                            if error:
                                any_error = error_code
                                out_result = account_code
                                if error_code in [1011, 1014]:
                                    out_result = portfolio_id
                                return out_result, any_error
                            if portfolio_id:
                                params['user_portfolio'] = portfolio_id
                        code_not_found = False
                        verify = False
                    elif filename_csv and '_XXX' in filename_csv:
                        try:
                            extract_account = filename_csv.strip().split('_XXX')[
                                1].split('_')[0]
                            account_code = '...' + extract_account
                            if account_code:
                                error, error_code, portfolio_id = ReferenceVerify.verify_code(
                                    account_code,
                                    params['get_session_userid'],
                                    params['broker'],
                                    params['user_portfolio'])
                                if error:
                                    any_error = error_code
                                    out_result = account_code
                                    if error_code in [1011, 1014]:
                                        out_result = portfolio_id
                                    return out_result, any_error
                                if portfolio_id:
                                    params['user_portfolio'] = portfolio_id
                            code_not_found = False
                            verify = False
                        except:
                            pass
                if 'PRICE' in row.upper() and 'ACTION' in row.upper():
                    ath = True
                elif not row:
                    ath = False
                if ath:
                    # if 'REALIZED GAIN/LOSS' in row.upper() or 'TRANSACTIONS  FOR ACCOUNT' in row.upper() or 'BROKERAGE' in row.upper():
                    #     continue
                    if rl == 0:
                        row = row.replace("\r", "")
                        ns = row.split(',')
                        nl = len(ns)
                        result_b.append(row)
                    if rl > 0 and ('SELL' in row.upper() or
                                   'BUY' in row.upper() or
                                   'SHORT' in row.upper() or
                                   'LONG' in row.upper() or
                                   'EXPIRED' in row.upper() or
                                   'ASSIGNED' in row.upper() or
                                   'JOURNAL' in row.upper() or
                                   'SECURITY TRANSFER' in row.upper() or
                                   'CASH/STOCK' in row.upper() or
                                   'NAME CHANGE' in row.upper() or
                                   'REINVEST SHARES' in row.upper() or
                                   'STOCK SPLIT' in row.upper() or
                                   # 'REV STOCK' in row.upper() or
                                   'JOURNALED SHARES' in row.upper()
                                   ):
                        result_b.append(row)
                    rl = rl + 1

            if code_not_found:
                result_out, any_error = ReferenceVerify.validate_reference_code_format(
                    portfolio_id=params['user_portfolio']
                )
                if any_error:
                    return result_out, any_error

            result = ImportParams.custom_getcsv(result_b, nl, True, True)
            b = len(result)
            symbol_list = OrderedDict()

            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                if 'action description' in n:
                    n['action'] = n['action description']
                    n['symbol'] = n['description'].split(' ')[0] if 'description' in n and ImportParams.isfloat(
                        n['price'].replace(',', '')) and float(n['price'].replace(',', '').replace('$', '')) > 0 else ''
                    n['date'] = n['execution date'] if 'execution date' in n else ''
                    n['order #'] = n['order number'] if 'order number' in n else ''

                if 'symbol/desc' in n:
                    n['action'] = n['action']
                    n['symbol'] = n['symbol/desc'].split(' ')[0] if 'symbol/desc' in n and ImportParams.isfloat(
                        n['price'].replace(',', '')) and float(n['price'].replace(',', '').replace('$', '')) > 0 else ''
                    n['date'] = n['trade date'] if 'trade date' in n else ''
                    n['order #'] = n['order number'] if 'order number' in n else ''
                    n['quantity'] = n['qty'] if 'qty' in n else ''

                if 'date' in n and 'AS' in n['date'].upper():
                    date_as = n['date'].upper().split(' AS OF ')
                    if len(date_as) == 2 and '/' in date_as[1]:
                        n['date'] = date_as[1]

                d = n['date'].split(' ') if 'date' in n else ''
                if len(d) > 2:
                    n['date'] = d[0] if d and len(
                        d) == 1 else d[3] if d else n['submit date/time'] if 'submit date/time' in n else ''

                if not 'symbol' in n:
                    n['symbol'] = n['symbol/cusip'] if 'symbol/cusip' in n else ""

                # code = str(n['date'].replace('-','').replace('/','')) + (n['action'] if n['action'].upper() !='EXPIRED' and n['action'] else '') + n['symbol'] + n['quantity'] + (str(float(n['price'].replace('$','').replace(',',''))) if n['price'] else '0.0') + ''
                n['price'] = n['price'].replace(' ', '')
                user_id = current_user.id if hasattr(
                    current_user, 'id') else params['get_session_userid']
                if 'description' in n:
                    # verify_file_row = BrokerCharlesSchwab.verify_file_row_chwab(user_id,n)
                    verify_file_row = ImportParams.verify_date_file_row(params['get_session_userid'],
                                                                        params['broker'],
                                                                        original_file_row,
                                                                        argv1='date' if 'date' in original_file_row
                                                                        else '',
                                                                        argv2='action' if 'action' in original_file_row
                                                                        else '',
                                                                        argv3='symbol' if 'symbol' in original_file_row
                                                                        else '',
                                                                        argv4='quantity' if 'quantity' in original_file_row
                                                                        else '',
                                                                        argv5='price' if 'price' in original_file_row
                                                                        else '',
                                                                        portfolio=params['user_portfolio']
                                                                        )

                    if verify_file_row:
                        verify_row = True
                        continue
                    n['price'] = ImportParams.get_price_char_decimal(
                        n['price'], 4)

                code = "{}{}{}{}{}".format(str(n['date'].replace('-', '').replace('/', '')),
                                           n['action'] if n['action'].upper(
                ) != 'EXPIRED' and n['action'] else '',
                    n['symbol'],
                    n['quantity'],
                    str(float(n['price'].replace('$', '').replace(
                        ',', ''))) if n['price'] else '0.0'
                )

                # if 'order #' in n and ImportParams.isfloat(n['order #'].replace(' ','')):
                #     code = n['order #'].replace(' ','')
                if 'order #' in n and ImportParams.isfloat(n['order #'].replace(' ', '')):
                    if BrokerCharlesSchwab.verify_file_row_code(user_id, n):
                        verify_row = True
                        continue
                    symbol_n = n['symbol']
                    code_n = n['order #'].replace(' ', '')
                    code = '{}{}'.format(symbol_n, code_n)
                njson = json.dumps(code)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                n['date'] = d[0] if d else n['submit date/time'] if 'submit date/time' in n else ''
                if d and len(d) == 2:
                    n['date'] = d[0] + " " + d[1]
                if 'quantity' in n and (n['action'].upper() == 'SPIN-OFF'):
                    n['action'] = 'BUY'
                if 'quantity' in n and ('STOCK SPLIT' in n['action'].upper()):
                    continue
                    # n['action'] = 'SELL'
                not_price = False
                if 'quantity' in n and ('JOURNAL' in n['action'].upper() or
                                        'SECURITY TRANSFER' in n['action'].upper() or
                                        'CASH/STOCK' in n['action'].upper() or
                                        'NAME CHANGE' in n['action'].upper() or
                                        'REINVEST SHARES' in n['action'].upper() or
                                        # 'REV STOCK' in n['action'].upper() or
                                        'JOURNALED SHARES' in n['action'].upper(
                )

                ):

                    n['action'] = 'BUY' if ImportParams.isfloat(n['quantity']) and float(
                        n['quantity']) > 0 else 'SELL' if ImportParams.isfloat(n['quantity']) and float(n['quantity']) < 0 else ''
                    if 'price' in n and not n['price'] or (ImportParams.isfloat(n['price']) and int(float(n['price'])) == 0):
                        not_price = True
                        continue

                n['action'] = 'BUY' if 'BUY' in n['action'].upper() or \
                                       'ASSIGNED' in n['action'].upper() or \
                                       'LONG' in n['action'].upper() or \
                                       'BUY TO OPEN' in n['action'].upper() or \
                                       'BUY TO CLOSE' in n['action'].upper() \
                    else 'SELL' if 'SELL' in n['action'].upper() or \
                                       'SHORT' in n['action'].upper() or \
                                       'SELL TO OPEN' in n['action'].upper() or \
                                       'SELL TO CLOSE' in n['action'].upper() \
                    else 'EXP' if n['action'].upper() == 'EXPIRED' or \
                    'EXPIRED' in n['description'].upper() \
                    else n['action']
                n['action'] = 'EXP' if 'description' in n and 'EXP' in n['description'] and n['action'] not in [
                    'BUY', 'SELL'] else n['action'].upper()
                if not_price and n['action'] != 'EXP':
                    continue
                qty = n['quantity'].replace(',', '')
                if not ImportParams.isfloat(qty):
                    continue

                if not 'symbol' in n or not n['date'] or not n['symbol'] or n['action'] not in ['BUY', 'SELL', 'EXP', 'ASG']:
                    continue

                if n['action'] == 'EXP' and float(qty) > 0:
                    n['action'] = 'BUY'

                if n['action'] == 'EXP' and float(qty) < 0:
                    n['action'] = 'SELL'
                original_file_row['date_tz'] = n['date']
                any_error, date, time = ImportParams.get_param_datetime(
                    n['date'], b)
                new_date_time = ImportParams.convert_date(
                    date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                sm = len(n['symbol'])

                if sm > 8 and 'description' in n and ('DUE' in n['description'] or 'EFF' in n['description']):
                    continue

                fp = n['price'].replace(',', '').replace(
                    '$', '').replace(' ', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp), 6) if fp else 0.00
                if price == 0:
                    fp = '0.0001'
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = ''
                symbol_code = n['symbol']
                symbol_list[symbol_code] = dict()

                n['quantity'] = n['quantity'].replace(',', '').replace('-', '')
                quantity = float(n['quantity']) if n['quantity'] else 0
                commission = n['fees & comm'].replace(',', '').replace('$', '').replace('*', '') if 'fees & comm' in n and n['fees & comm'] else n['commission'].replace(
                    ',', '').replace('$', '').replace('-', '').replace('*', '') if 'commission' in n and n['commission'] else '0.00'
                fees = n['fee'].replace(',', '').replace('$', '') if 'fee' in n else n['fees'].replace(',', '').replace(
                    '$', '') if 'fees' in n else n['reg fees'].replace(',', '').replace('$', '') if 'reg fees' in n else '0.00'

                if sm >= 4 and sm < 8 and ImportParams.isfloat(n['symbol'][-1:]) and n['symbol'] not in ['CIMA10','MMDA1']:
                    type = 'future'
                    option = 'FUTURE'
                    try:
                        future_params = ImportParams.getFutureSymbol(
                            n['symbol'].replace('/', ''))
                        n['symbol'] = future_params['symbol']
                        expire = future_params['expire']
                        size = future_params['size']
                        if 'total cost' in n:
                            total_cost = n['total cost'].replace(
                                '$', '').replace(',', '')
                            if ImportParams.isfloat(total_cost):
                                qp = (float(quantity) * float(fp))
                                vg = float(total_cost) + \
                                    float(commission) + float(fees)
                                try:
                                    n['multiplier'] = abs(vg / qp)
                                    size = n['multiplier']
                                except:
                                    pass
                    except:
                        type = 'share'
                        option = 'SHARE'
                        strike = ''
                        expire = ''
                        if 'description' in n and '(' in n['description'] and ')' in n['description']:
                            n['symbol'] = n['description'].split('(')[1].split(")")[0]
                elif sm >= 8 and not ImportParams.isfloat(n['symbol'][:1]):
                    type = 'option'

                    if ' ' in n['symbol']:
                        symbol = n['symbol'].split(' ')

                        # AIG 06/22/2018 54.50 C
                        if len(symbol) >= 4:
                            n['symbol'] = symbol[0]

                            strike = symbol[2]
                            expire = symbol[1]
                            if expire:
                                de = ImportParams.get_trade_datetime(
                                    expire, "%m/%d/%Y")
                                expire = de.strftime('%d %b %y').upper()
                            option = 'CALL' if symbol[3].upper(
                            ) == 'C' else 'PUT' if symbol[3].upper() == 'P' else 'OPTION'
                    else:
                        option = 'CALL' if n['symbol'].upper() == 'C' or ('action description' in n and 'description' in n and 'CALL' in n['description'].upper(
                        )) else 'PUT' if n['symbol'].upper() == 'P' or ('action description' in n and 'description' in n and 'PUT' in n['description'].upper()) else 'OPTION'
                        if 'action description' in n and 'description' in n:
                            desc = n['description'].split(' ')
                            if len(desc) > 3:
                                expire = desc[(len(desc)-3)]
                                strike = desc[(len(desc)-2)]
                                ss = ''
                                t = 0
                                for s in n['symbol']:
                                    t = t + 1
                                    if not ImportParams.isfloat(s):
                                        ss = ss + s
                                    else:
                                        if t > 2:
                                            break
                                        else:
                                            ss = ss + s
                                n['symbol'] = ss

                                if ImportParams.isfloat(desc[(len(desc)-4)]) or 'FUTOPTEXP' in n['description']:
                                    n['symbol'] = '/'+n['symbol'] if len(
                                        n['symbol']) < 4 else '/'+n['symbol'][:-1]

                        if 'total cost' in n:
                            total_cost = n['total cost'].replace(
                                '$', '').replace(',', '')
                            if ImportParams.isfloat(total_cost):
                                qp = (float(quantity) * float(fp))
                                vg = float(total_cost) + \
                                    float(commission) + float(fees)
                                try:
                                    n['multiplier'] = abs(vg / qp)
                                    size = n['multiplier']
                                except:
                                    pass

                    if not strike and not expire and option == 'OPTION':
                        type = 'share'
                        option = 'SHARE'
                        strike = ''
                        expire = ''
                        if 'description' in n and '(' in n['description'] and ')' in n['description']:
                            n['symbol'] = n['description'].split('(')[1].split(")")[0]
                elif '.' in n['symbol'] and sm > 6:
                    type = 'forex'
                    option = 'FOREX'

                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp.strip()
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = n['reg fees'].replace(',', '').replace(
                    '$', '') if 'reg fees' in n else '0.00'
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['size'] = size
                n['original_file_row'] = original_file_row

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                n['valid_row'] = True

                data_item = ImportParams.get_result_append(n)

                out_result.append(data_item)

                b = b - 1
        except Exception as err:
            print(traceback.format_exc())
            print(err)
            any_error = 9

        if len(out_result) > 0 or verify_row:
            return out_result, any_error
        else:
            return BrokerCharlesSchwab.getcsv2(params, content)

    def getcsv2(params, content, date_format='mdy'):
        data = "BrokerCharlesSchwab2"
        print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b = 0

        try:
            content = content.replace(';', '').replace(
                '\nS', ' S').replace('\t', ',')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split(
                "\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            code_not_found = True
            verify = True
            for row in content_b:

                ''' validate Account Reference Code '''
                str_account = 'FOR ACCOUNT'
                if verify:
                    if str_account in row.upper() and 'AS' in row.upper():
                        account_code = row.upper().split(str_account)[
                            1].strip().split('AS')[0].strip()
                        if account_code:
                            error, error_code, portfolio_id = ReferenceVerify.verify_code(
                                account_code,
                                params['get_session_userid'],
                                params['broker'],
                                params['user_portfolio'])
                            if error:
                                any_error = error_code
                                out_result = account_code
                                if error_code in [1011, 1014]:
                                    out_result = portfolio_id
                                return out_result, any_error
                            if portfolio_id:
                                params['user_portfolio'] = portfolio_id
                        code_not_found = False
                        verify = False

                if 'REALIZED GAIN/LOSS' in row.upper() or 'TRANSACTIONS  FOR ACCOUNT' in row.upper() or 'BROKERAGE' in row.upper():
                    continue
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)

            if code_not_found:
                result_out, any_error = ReferenceVerify.validate_reference_code_format(
                    portfolio_id=params['user_portfolio']
                )
                if any_error:
                    return result_out, any_error

            result = ImportParams.custom_getcsv(result_b, nl, True, True)
            out_result = []
            b = len(result)

            for n in result:
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                action = n['term'].upper().replace(' ', '') if 'term' in n else n['action description'].upper(
                ) if 'action description' in n else n['action'].upper() if 'action' in n else ''
                n['action'] = 'BUY' if action == 'LONG' or 'BUY' in action else 'SELL' if action == 'SHORT' or 'SELL' in action else ''

                if not 'symbol' in n or not n['symbol'] or n['action'] not in ['BUY', 'SELL']:
                    continue

                do = n['opened date'].split(' ')
                n['date'] = do[0]
                original_file_row['date_tz'] = n['date']

                any_error, date, time = ImportParams.get_param_datetime(
                    n['date'], b)
                new_date_time = ImportParams.convert_date(
                    date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                fp = n['proceeds per share'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 and decimal <= 6 else 6 if decimal > 6 else 2

                price = round(float(fp), 6) if fp else 0.00
                # price = round(float(n['price'].replace(',', '').replace('$', '')),6) if n['price'] else '0.00'
                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = ''
                if sm > 4 and sm < 8 and n['symbol'][:1] == '/':
                    type = 'future'
                    option = 'FUTURE'
                elif sm >= 8 and not ImportParams.isfloat(n['symbol'][:1]):
                    type = 'option'
                    symbol = n['symbol'].split(' ')
                    n['symbol'] = symbol[0]
                    strike = symbol[2]
                    expire = symbol[1]
                    if expire:
                        de = ImportParams.get_trade_datetime(
                            expire, "%m/%d/%Y")
                        expire = de.strftime('%d %b %y').upper()
                    option = 'CALL' if symbol[3].upper(
                    ) == 'C' else 'PUT' if symbol[3].upper() == 'P' else 'OPTION'
                elif '.' in n['symbol'] and sm > 6:
                    type = 'forex'
                    option = 'FOREX'

                quantity = int(float(n['quantity']))
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = price
                n['shares'] = quantity
                n['comm'] = n['fees & comm'].replace(',', '').replace(
                    '$', '') if 'fees & comm' in n else '0.00'
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['original_file_row'] = original_file_row
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                if 'closed date' in n and n['closed date']:
                    n['action'] = 'BUY' if n['action'] == 'SELL' else 'SELL'
                    do = n['closed date'].split(' ')
                    n['date'] = do[0]
                    original_file_row['date_tz'] = n['date']
                    any_error, date, time = ImportParams.get_param_datetime(
                        n['date'], b)
                    new_date_time = ImportParams.convert_date(
                        date, time, date_format)
                    n['date'] = new_date_time[0]
                    n['time'] = new_date_time[1]

                    fp = n['cost per share'].replace(',', '').replace('$', '')
                    decimal = fp[::-1].find('.')
                    decimal = decimal if decimal > 1 and decimal <= 6 else 6 if decimal > 6 else 2

                    price = round(float(fp), 6) if fp else 0.00
                    # price = round(float(n['price'].replace(',', '').replace('$', '')),6) if n['price'] else '0.00'

                    n['type_stock'] = type
                    n['type_option'] = option
                    n['price'] = price
                    n['shares'] = quantity
                    n['comm'] = n['fees & comm'].replace(',', '').replace(
                        '$', '') if 'fees & comm' in n else '0.00'
                    n['njson'] = njson
                    n['decimal'] = decimal
                    n['expire'] = expire
                    n['strike'] = strike
                    n['original_file_row'] = original_file_row
                    n['broker'] = params['broker']
                    n['userid'] = params['get_session_userid']
                    n['portfolio'] = params['user_portfolio']

                    n['valid_row'] = True

                    data_item = ImportParams.get_result_append(n)
                    out_result.append(data_item)

                b = b - 1
        except Exception as err:
            print(err)
            any_error = 9
        # print(data)
        if not any_error and not out_result:
            any_error = 9
        return out_result, any_error

    def getcsv3(params, content, date_format='mdy'):
        data = "BrokerCharlesSchwab3"
        print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        verify_row = False
        b = 0

        try:

            content = content.replace(';', '').replace('—', '')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split(
                "\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            code_not_found = True
            verify = True
            for row in content_b:

                ''' validate Account Reference Code '''
                str_account = 'FOR ACCOUNT'
                if verify:
                    if str_account in row.upper() and 'AS' in row.upper():
                        account_code = row.upper().split(str_account)[
                            1].strip().split('AS')[0].strip()
                        if account_code:
                            error, error_code, portfolio_id = ReferenceVerify.verify_code(
                                account_code,
                                params['get_session_userid'],
                                params['broker'],
                                params['user_portfolio'])
                            if error:
                                any_error = error_code
                                out_result = account_code
                                if error_code in [1011, 1014]:
                                    out_result = portfolio_id
                                return out_result, any_error
                            if portfolio_id:
                                params['user_portfolio'] = portfolio_id
                        code_not_found = False
                        verify = False

                if len(row) == 0:
                    continue
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)

            if code_not_found:
                result_out, any_error = ReferenceVerify.validate_reference_code_format(
                    portfolio_id=params['user_portfolio']
                )
                if any_error:
                    return result_out, any_error

            result = ImportParams.custom_getcsv(result_b, nl, True, True)

            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                # issue 7162
                if 'status' in n and 'Part Fill' in n['status']:
                    n['status'] = 'FILLED'
                if 'status' in n and n['status'].upper() != "FILLED":
                    continue
                if not 'qty filled at' in n or not "@" in n['qty filled at']:
                    continue
                user_id = current_user.id if hasattr(
                    current_user, 'id') else ""
                code = n
                if 'order #' in n and ImportParams.isfloat(n['order #'].replace(' ', '')):
                    if BrokerCharlesSchwab.verify_file_row_code(user_id, n):
                        verify_row = True
                        continue
                    symbol_n = n['symbol']
                    code_n = n['order #'].replace(' ', '')
                    code = '{}{}'.format(symbol_n, code_n)

                njson = json.dumps(code)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                action = n['action'].upper(
                ) if 'action' in n else n['side'].upper() if 'side' in n else ''
                action = 'BUY' if action == 'BUY' or action == 'COVER' or action == 'B' or action == 'LONG' or action == 'BUY TO CLOSE' or action == 'BUY TO OPEN' else 'SELL' if action == 'SELL' or action == 'SHORT' or action == 'S' or action == 'SELL TO CLOSE' or action == 'SELL TO OPEN' else ''
                n['date'] = n['submit date/time'] if 'submit date/time' in n else ''
                extract = n['qty filled at'].split("@")
                n['quantity'] = extract[0].strip() if extract else ''
                n['price'] = extract[1].strip() if extract else ''
                if not n['symbol'] or not n['date'] or not n['price'] or not n['quantity'] or not action:
                    continue

                original_file_row['date_tz'] = n['date']
                pip_value = 0
                date_split = n['date'].strip()
                any_error, date, time = ImportParams.get_param_datetime(
                    date_split, b)
                new_date_time = ImportParams.convert_date(
                    date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                fp = n['price'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp), decimal)
                # price = round(float(n['price'].replace(',', '')),6)
                if not 'type' in n:
                    n['type'] = 'SHARE'

                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = ''
                if sm > 4 and sm < 8 and n['symbol'][:1] == '/':
                    type = 'future'
                    option = 'FUTURE'
                elif sm >= 8 and not ImportParams.isfloat(n['symbol'][:1]):
                    type = 'option'
                    symbol = n['symbol'].split(' ')
                    # AIG 06/22/2018 54.50 C
                    if len(symbol) >= 4:
                        n['symbol'] = symbol[0]
                        strike = symbol[2]
                        expire = symbol[1]
                        if expire:
                            de = ImportParams.get_trade_datetime(
                                expire, "%m/%d/%Y")
                            expire = de.strftime('%d %b %y').upper()
                        option = 'CALL' if symbol[3].upper(
                        ) == 'C' else 'PUT' if symbol[3].upper() == 'P' else 'OPTION'
                elif '.' in n['symbol'] and sm > 6:
                    type = 'forex'
                    option = 'FOREX'

                fee = n['fee'].replace(',', '').replace('$', '') if 'fee' in n else n['fees'].replace(
                    ',', '').replace('$', '') if 'fees' in n else ''
                fee = round(float(fee), 2) if fee else 0.00

                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = price
                n['shares'] = n['quantity'].replace(',', '')
                n['comm'] = n['commission'].replace(',', '').replace(
                    '$', '') if 'commission' in n else '0.00'
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['pip_value'] = pip_value
                n['fees'] = fee
                n['original_file_row'] = original_file_row
                # n['valid_row'] = True

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            print(err)
            any_error = 9

        if len(out_result) > 0 or verify_row:
            return out_result, any_error

        if not any_error and not out_result:
            any_error = 9
        return out_result, any_error

    def getcsv4(params, content, date_format='mdy'):
        data = "BrokerCharlesSchwab4"
        print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b = 0

        try:

            content = content.replace(';', ',')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split(
                "\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False

            for row in content_b:
                if len(row) == 0:
                    continue
                rl = rl + 1
                row = re.sub(r'(?!(([^"]*"){2})*[^"]*$),', '', row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
                result_b.append(row)

            result = ImportParams.custom_getcsv(result_b, nl, True, True)
            firtday = False

            if params['date_format']['id'] == 3 or params['date_format']['id'] == 4:
                firtday = True
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                action = n['buy/sell'].upper(
                ) if 'buy/sell' in n else n['action'].upper() if 'action' in n else ''
                action = 'BUY' if action == 'BUY' or action == 'COVER' or action == 'B' or 'BUY' in action else 'SELL' if action == 'SELL' or action == 'SHORT' or action == 'S' or 'SELL' in action  else ''
                n['date'] = n['last activity date et'] if 'last activity date et' in n else n['last activity dateet'] if 'last activity dateet' in n else n['time and dateet'] if 'time and dateet' in n else n['time and date et'] if 'time and date et' in n else ''
                n['quantity'] = n['quantity|face value'].replace(
                    ',', '').lower().replace('shares', '') if 'quantity|face value' in n else ''
                if not n['symbol'] or not n['date'] or not n['price'] or not action or ('status' in n and 'filled' not in n['status'].lower()) or not ImportParams.isfloat(n['quantity']):
                    continue
                pip_value = 0
                am_or_pm = "PM" if "PM" in n['date'] else "AM"
                extract_date = n['date'].split(am_or_pm)
                date_time = extract_date[1].strip(
                ) + ' ' + extract_date[0].strip() + ' ' + am_or_pm
                original_file_row['date_tz'] = date_time
                original_file_row['firtday'] = firtday
                if firtday:
                    dp = ImportParams.parse_date(date_time, firtday)
                    date_split = dp.strftime('%m/%d/%Y %H:%M:%S')
                    dateformat = '%m/%d/%Y %H:%M:%S'
                    any_error, date, time = ImportParams.get_param_datetime(
                        date_split, b, dateformat=dateformat)
                else:
                    any_error, date, time = ImportParams.get_param_datetime(
                        date_time, b)
                new_date_time = ImportParams.convert_date(
                    date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                if n['price'].lower() == 'market' and 'fill price' in n:
                    n['price'] = n['fill price']
                fp = n['price'].split('$')[1].replace(
                    ',', '') if '$' in n['price'] else n['price']
                if not ImportParams.isfloat(fp):
                    continue
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp), decimal)
                # price = round(float(n['price'].replace(',', '')),6)
                if not 'type' in n:
                    n['type'] = 'SHARE'

                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = ''
                smn = n['symbol'][-2:]

                fee = n['fee'].replace(',', '').replace('$', '') if 'fee' in n else n['fees'].replace(
                    ',', '').replace('$', '') if 'fees' in n else ''
                fee = round(float(fee), 2) if fee else 0.00

                n['trade_notes'] = n['trade_notes'] if 'trade_notes' in n else ''
                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = fp
                n['shares'] = n['quantity']
                n['comm'] = n['commission'].replace(',', '').replace(
                    '$', '') if 'commission' in n else '0.00'
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                # n['pip_value'] = pip_value
                n['original_file_row'] = original_file_row
                n['fees'] = fee
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            print(err, traceback.format_exc())
            any_error = 9
        if not any_error and not out_result:
            any_error = 9
        return out_result, any_error

    def getcsv5(params, content, date_format='mdy'):
        data = "BrokerCharlesSchwab5"
        #print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0
        try:

            content = content.replace(';', ',').replace('\x00','')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                if len(row) == 0 or len(row) < 30:
                    continue
                rl = rl + 1
                row = re.sub(r'(?!(([^"]*"){2})*[^"]*$),', '', row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
                result_b.append(row)

            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            firtday = False

            if params['date_format']['id'] == 3 or params['date_format']['id'] == 4:
                firtday = True
            pip_value_list = dict()
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                action = n['buy/sell'].upper().strip() if 'buy/sell' in n else n['side'].upper().strip() if 'side' in n else ''
                action = 'BUY' if action == 'BUY' or 'COVER' in action or action=='B' else 'SELL' if action == 'SELL' or 'SHORT' in action or action=='S' else ''
                n['date'] = n['exec time']
                n['quantity'] =n['qty'].replace(',', '').replace('-', '')

                if not n['symbol'] or not n['date'] or not n['price'] or not action or not ImportParams.isfloat(n['quantity']):
                    continue

                pip_value = 0
                date_split = n['date'].strip()
              
                date_time = date_split

                original_file_row['date_tz'] = date_time
                original_file_row['firtday'] = firtday
                if firtday:
                    dp = ImportParams.parse_date(date_time, firtday)
                    date_split = dp.strftime('%m/%d/%Y %H:%M:%S')
                    dateformat = '%m/%d/%Y %H:%M:%S'
                    any_error, date, time = ImportParams.get_param_datetime(date_split,b,dateformat=dateformat)
                else:
                    any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                if any_error:
                    return out_result, 15

                new_date_time = ImportParams.convert_date(date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                if "'" in n['price']:
                    n['price'] = ImportParams.get_price_future(n['price'])

                fp = n['price'].replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                if not ImportParams.isfloat(fp):
                    continue
                price = round(float(fp),decimal)
                #price = round(float(n['price'].replace(',', '')),6)
                if not 'type' in n:
                    n['type'] = 'SHARE'
                else:
                    n['type'] = n['type'].strip()
              
                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = ''
                smn = n['symbol'][-2:]
                size_param = 1
                if 'type' in n and n['type'].upper() != "SHARE" or not 'type' in n:

                    if (sm > 4 and sm < 8 and not 'type' in n) or (ImportParams.isfloat(smn) and not 'type' in n) or ('type' in n and n['type'].upper() in ['FUTURE','FUTURES']):
                        type = 'future'
                        option = 'FUTURE'
                        params_future = ImportParams.getFutureSymbol(n['symbol'].replace('/',''))
                        n['symbol'] = params_future['symbol'] if 'symbol' in params_future and params_future['symbol'] else n['symbol']
                        expire = params_future['expire'] if 'expire' in params_future and params_future['expire'] else ''
                        size_param = params_future['size'] if 'size' in params_future and params_future['size'] else ''
                        if not expire:
                            if 'expiration date' in n and n['expiration date']:
                                exp_date_valid = ImportParams.get_date_valid(n['expiration date'])
                                if exp_date_valid:
                                    expire = exp_date_valid.strftime('%b %y').upper()
                                else:
                                    de = datetime.now()
                                    expire = de.strftime('%b %y').upper()

                            else:
                                de = datetime.now()
                                expire = de.strftime('%b %y').upper()
                        if not size_param and 'multiplier' in n and ImportParams.isfloat(n['multiplier']):
                            size_param = float(n['multiplier'])
                        else:
                            symb = ImportParams.get_size('FUTURE',n['symbol'])
                            if symb:
                                size_param= symb
                    elif sm >= 8 or n['type'].upper()=='OPTION' or n['type'].upper()=='OPTIONS' or n['type'].upper() in ['CALL','PUT']:
                        type = 'option'
                        option = 'CALL' if 'CALL' in n['call or put'].upper() else 'PUT' if 'PUT' in n['call or put'].upper() else 'OPTION'
                        expire = str(n['expiration date']) if 'expiration date' in n else  str(n['expiration'])
                        try:
                            de = parse(expire)
                            expire = de.strftime('%d %b %y').upper()
                        except:
                            expire = expire
                        strike = str(n['strike price']).replace(',', '').replace('$','')
                    elif '$' in n['symbol'] or n['type'].upper()=='FOREX':
                        type = 'forex'
                        symbol = n['symbol']
                        sym = symbol[-3:]
                        option = 'FOREX'
                        if n['symbol'][:1] != '$':
                            n['symbol'] = '${0}'.format(n['symbol'])
                        if (not 'type size' in n) or ('type size' in n and not n['type size']):
                            n['type_size'] = 'VOLUME' if ImportParams.isfloat(n['quantity']) and float(n['quantity']) > 10 else 'LOTS'
                        else:
                            n['type_size'] = 'VOLUME' if 'VOLUME' in n['type size'].upper() else 'LOTS'
                        if n['type_size'] == 'LOTS':
                            fx_dec = decimal if decimal <= 5 else 5
                            size_param = 100000
                            """if 'JPY' in n['symbol']:
                                size_param = 10000"""
                        pip_value_params = float(ImportParams.value_pip_forex(n['date'],sym))
                        pip_value = float(pip_value_params)
                    elif n['type'].upper() in ['CFD','FXCFD']:
                        type = n['type'].lower()
                        option = n['type'].upper()
                    elif n['type'].upper() in ['CRYPTO','CRYPTOS']:
                        type = 'crypto'
                        option = 'CRYPTO'
                        if n['symbol'][:1] != '#':
                            if len(n['symbol']) < 6 and (not 'USD' in n['symbol'] or not 'USDT' in n['symbol']):
                                n['symbol'] = '{0}USDT'.format(n['symbol'])
                            n['symbol'] = '#{0}'.format(n['symbol'])

                fee = n['fee'].replace(',', '').replace('$','') if 'fee' in n else n['fees'].replace(',', '').replace('$','') if 'fees' in n else ''
                fee = round(float(fee),2) if fee else 0.00

                n['trade_notes'] = n['trade_notes'] if 'trade_notes' in n else ''
                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = fp
                n['shares'] = n['quantity']
                n['comm'] = n['commission'].replace(',', '').replace('$','') if 'commission' in n else n['commissions'].replace(',', '').replace('$','') if 'commissions' in n else '0.00'
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['size'] = size_param
                n['pip_value'] = pip_value
                n['original_file_row'] = original_file_row
                n['fees'] = fee
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            print(err, traceback.format_exc())
            any_error = 9
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error

    def verify_file_row_chwab(user_id, data):
        """This function checks if the line is duplicated in the history table in the original_file_row field."""
        out = False
        try:
            query = TradesHistories.query.\
                join(Trades, Trades.trade_id == TradesHistories.fk_trade_id).\
                filter(Trades.fk_user_id == user_id).all()
            date = str(data['date'].replace('-', '').replace('/', ''))
            action = data['action'] if data['action'].upper(
            ) != 'EXPIRED' and data['action'] else ''
            symbol = data['symbol']
            quantity = data['quantity']
            # get the price for 4 characters in decimals
            price = ImportParams.get_price_char_decimal(data['price'], 4)
            code1 = "{}{}{}{}{}".format(date,
                                        action,
                                        symbol,
                                        quantity,
                                        price
                                        )
            for row in query:
                data2 = row.original_file_row
                date = str(data2['date'].replace('-', '').replace('/', ''))
                action = data2['action'] if data2['action'].upper(
                ) != 'EXPIRED' and data2['action'] else ''
                symbol = data2['symbol']
                quantity = data2['quantity']
                # get the price for 4 characters in decimals
                price = ImportParams.get_price_char_decimal(data2['price'], 4)
                code2 = "{}{}{}{}{}".format(date,
                                            action,
                                            symbol,
                                            quantity,
                                            price
                                            )
                if code1 == code2:
                    out = True
                    break

        except:
            # print(traceback.format_exc())
            return False
        return out

    def verify_file_row_code(user_id, data):
        """This function checks if the line is duplicated in the history table in the original_file_row field."""
        out = False
        try:
            if not BrokerCharlesSchwab.ORIGINAL_FILE_ROW:
                query = TradesHistories.query.\
                    join(Trades, and_(Trades.trade_id == TradesHistories.fk_trade_id,
                                      Trades.fk_user_id == TradesHistories.fk_user_id))\
                    .with_entities(TradesHistories.original_file_row.label('original_row'))\
                    .filter(Trades.fk_user_id == user_id)

                # SQLHelper.print_sql(query)
                query = query.all()

                for n in query:
                    code_r = n.original_row['order #'].replace(
                        ' ', '') if 'order #' in n.original_row else ''
                    symbol_r = n.original_row['symbol'] if 'symbol' in n.original_row else ''
                    file_row_r = '{}{}'.format(symbol_r, code_r)
                    njson_r = json.dumps(file_row_r)
                    njson_r = hashlib.md5(njson_r.encode('utf-8')).hexdigest()
                    BrokerCharlesSchwab.ORIGINAL_FILE_ROW.append(njson_r)
            data_code = data['order #'].replace(' ', '')
            data_symbol = data['symbol']
            data_file_row = '{}{}'.format(data_symbol, data_code)
            data_njson = json.dumps(data_file_row)
            data_njson = hashlib.md5(data_njson.encode('utf-8')).hexdigest()
            if data_njson in BrokerCharlesSchwab.ORIGINAL_FILE_ROW:
                out = True

        except:
            # print(traceback.format_exc())
            return False
        return out
