# Log de Implementación - Charles Schwab Normalizer

Este documento rastrea el progreso de implementación de las validaciones identificadas en el análisis.

**Fecha Inicio:** 2026-01-14
**Broker:** charles_schwab
**Formato:** JSON API (Equity, Options, ETF, Futures)

---

## Estado General

### FASE 1: Critical Hash Fix (1-2 días) ⚠️ URGENTE

**Estado:** ❌ NO INICIADO
**Objetivo:** Corregir 42% hash match rate a 95-100%
**Blocker:** Requiere coordinación con legacy team

- [ ] **1.1 Implementar closingPrice Zeroing**
  - Archivo: `schwab.py:305-310`
  - Días: 0.5
  - [ ] Modificar `compute_file_row_hash()` para zero out closingPrice
  - [ ] Deep copy del order antes de modificar
  - [ ] Aplicar zeroing a `transferItems[].instrument.closingPrice`
  - [ ] Verificar que no afecta original_file_row

- [ ] **1.2 Implementar transferItems Sorting**
  - Archivo: `schwab.py:305-310`
  - Días: 0.5
  - [ ] Definir sort key (assetType, feeType, instrumentId)
  - [ ] Aplicar sorted() a transferItems array
  - [ ] Verificar orden determinístico

- [ ] **1.3 Actualizar Legacy Code**
  - Archivo: `schwab_export.py:952,968`
  - Días: 0.5
  - [ ] Aplicar mismo fix en legacy
  - [ ] Coordinar con legacy team
  - [ ] Testing en legacy environment
  - [ ] Code review

- [ ] **1.4 SQL Rebuild Script**
  - Archivo: `scripts/rebuild_schwab_file_row.py` (nuevo)
  - Días: 0.5
  - [ ] Crear script de rebuild
  - [ ] Fetch all WHERE broker='CharlesSchwab'
  - [ ] Parse original_file_row JSON
  - [ ] Apply new hash formula
  - [ ] UPDATE file_row column
  - [ ] Log progress + validation
  - [ ] Dry-run mode
  - [ ] Production execution

**Métricas de Éxito:**
- [ ] Hash match rate >= 95% (actual: 42%)
- [ ] Data integrity mantenida (100%)
- [ ] Legacy y mirror producen hashes idénticos
- [ ] SQL rebuild completa sin errores
- [ ] Sin cambios user-facing

---

### FASE 2: Data Validation (1.5-2 días)

**Estado:** ❌ NO INICIADO
**Objetivo:** Prevenir datos inválidos de entrar al pipeline

- [ ] **2.1 Required Fields Validation**
  - Archivo: `schwab.py:268`
  - Días: 0.5
  - [ ] Validar activityId not empty
  - [ ] Validar accountNumber not empty
  - [ ] Validar time not empty
  - [ ] Validar transferItems not empty
  - [ ] Logger.warning para cada skip
  - [ ] Tests: test_required_fields_validation()

- [ ] **2.2 Status Filter Validation**
  - Archivo: `schwab.py:270`
  - Días: 0.25
  - [ ] Check status == "INVALID"
  - [ ] Skip órdenes INVALID
  - [ ] Logger.debug para skip
  - [ ] Tests: test_status_filter()

- [ ] **2.3 Symbol Validation**
  - Archivo: `schwab.py:351`
  - Días: 0.25
  - [ ] Validar resolved_symbol not empty
  - [ ] Validar resolved_symbol.strip() not empty
  - [ ] Logger.warning para skip
  - [ ] Tests: test_empty_symbol_validation()

- [ ] **2.4 Price/Quantity Zero Validation**
  - Archivo: `schwab.py:302`
  - Días: 0.5
  - [ ] Validar price > 0
  - [ ] Validar total_amount != 0
  - [ ] Logger.warning para skip
  - [ ] Tests: test_zero_price_validation(), test_zero_quantity_validation()

- [ ] **2.5 Disabled Instrument Filter**
  - Archivo: `schwab.py:277-282`
  - Días: 0.25
  - [ ] Check instrument.status == "disabled"
  - [ ] Skip disabled instruments
  - [ ] Logger.debug para skip
  - [ ] Tests: test_disabled_instrument_filter()

**Métricas de Éxito:**
- [ ] Zero symbols vacíos en output
- [ ] Zero trades con price zero/negativo
- [ ] Zero trades con quantity zero
- [ ] Zero órdenes INVALID procesadas
- [ ] Warnings logged para todos rechazos
- [ ] Rejection rate < 0.1% del total

---

### FASE 3: Quality Improvements (1-1.5 días)

**Estado:** ❌ NO INICIADO
**Objetivo:** Robustez y seguridad

- [ ] **3.1 CUSIP Retry Logic**
  - Archivo: `schwab.py:172-199`
  - Días: 1
  - [ ] Definir MAX_RETRIES = 3
  - [ ] Definir RETRY_DELAY = 2 seconds
  - [ ] Implementar exponential backoff
  - [ ] Handle HTTP 429 (rate limit)
  - [ ] Handle Timeout exceptions
  - [ ] Logger.warning para retries
  - [ ] Logger.error para failures después de retries
  - [ ] Tests: test_cusip_retry_on_timeout(), test_cusip_rate_limit_handling()

- [ ] **3.2 CUSIP Rate Limiting**
  - Archivo: `schwab.py:172-199`
  - Días: (incluido en 3.1)
  - [ ] Detectar HTTP 429 response
  - [ ] Exponential backoff: wait_time = RETRY_DELAY * (2 ** retries)
  - [ ] Logger.warning con wait time
  - [ ] Tests: test_cusip_exponential_backoff()

- [ ] **3.3 API Key Security**
  - Archivo: `schwab.py:119`
  - Días: 0.25
  - [ ] Remover hardcoded API key
  - [ ] os.getenv("CUSIP_API_KEY", "")
  - [ ] Validar API key not empty al inicio
  - [ ] Logger.error si no configurado
  - [ ] Documentar env variable en README
  - [ ] Tests: test_cusip_api_key_from_env()

**Métricas de Éxito:**
- [ ] CUSIP resolution success rate >= 98%
- [ ] API key no en source code
- [ ] Transient failures manejados gracefully
- [ ] Rate limiting previene API throttling

---

### FASE 4: CSV Support (8-12 días - CONDICIONAL) 🎯

**Estado:** ⏸️ PENDIENTE DECISIÓN
**Blocker:** Ejecutar SQL query primero

- [ ] **4.1 Decisión Gate: Ejecutar SQL Query**
  ```sql
  SELECT
      source_type,
      COUNT(*) as count,
      COUNT(DISTINCT user_id) as user_count,
      ROUND(100.0 * COUNT(*) / SUM(COUNT(*)) OVER (), 2) as percentage,
      MAX(created_at) as last_used
  FROM data_sources
  WHERE broker_id = 'charles_schwab'
    AND created_at > NOW() - INTERVAL '12 months'
  GROUP BY source_type
  ORDER BY count DESC;
  ```
  - [ ] Ejecutar query en producción
  - [ ] Analizar percentage de CSV
  - [ ] **SI CSV > 5%:** Proceder con 4.2-4.6
  - [ ] **SI CSV < 5%:** OMITIR Fase 4

- [ ] **4.2 CSV Parser 1: Standard Format**
  - Archivo: `brokers/charles_schwab/csv_parsers.py` (nuevo)
  - Días: 2
  - [ ] Implementar getcsv() equivalent
  - [ ] Columns: Date, Action, Symbol, etc.
  - [ ] Tests: test_csv_standard_format()

- [ ] **4.3 CSV Parser 2: Action Description**
  - Archivo: `brokers/charles_schwab/csv_parsers.py`
  - Días: 2
  - [ ] Implementar getcsv2() equivalent
  - [ ] Tests: test_csv_action_description()

- [ ] **4.4 CSV Parser 3: Qty Filled At**
  - Archivo: `brokers/charles_schwab/csv_parsers.py`
  - Días: 2
  - [ ] Implementar getcsv3() equivalent
  - [ ] Tests: test_csv_qty_filled_at()

- [ ] **4.5 CSV Parser 4: Quantity/Face Value**
  - Archivo: `brokers/charles_schwab/csv_parsers.py`
  - Días: 2
  - [ ] Implementar getcsv4() equivalent
  - [ ] Tests: test_csv_quantity_face_value()

- [ ] **4.6 CSV Parser 5: Exec Time/Spread**
  - Archivo: `brokers/charles_schwab/csv_parsers.py`
  - Días: 2
  - [ ] Implementar getcsv5() equivalent
  - [ ] Tests: test_csv_exec_time_spread()

- [ ] **4.7 SchwabStreet Format (CONDICIONAL)**
  - Archivo: `brokers/charles_schwab/schwabstreet_parser.py` (nuevo)
  - Días: 2-3
  - [ ] **DECISIÓN:** Solo si > 1% del total
  - [ ] Implementar parser
  - [ ] Tests: test_schwabstreet_format()

**Criterio de Decisión:**
- CSV percentage > 5%: IMPLEMENTAR parsers 1-5 (8-12 días)
- CSV percentage < 5%: OMITIR Fase 4
- SchwabStreet > 1%: IMPLEMENTAR (2-3 días adicionales)

---

## Validaciones Correctamente Excluidas (OUT OF SCOPE) ✅

Las siguientes validaciones fueron identificadas en legacy pero correctamente excluidas del normalizer:

- [x] **Account Reference Code Validation** (brokers_charlesschwab.py:62-103)
  - **Razón:** Portfolio management - pertenece a sync service
  - **Pipeline Stage:** Sync service

- [x] **Portfolio ID Lookup** (schwab_export.py:973-984)
  - **Razón:** Database FK lookup - pertenece a write stage
  - **Pipeline Stage:** p05_write

- [x] **Duplicate Detection via DB** (brokers_charlesschwab.py:1159-1243)
  - **Razón:** Queries original_file_row from DB
  - **Pipeline Stage:** p05_write

- [x] **Trade Regrouping / Spread Detection** (schwab_export.py:991,1113)
  - **Razón:** Multi-leg spread detection
  - **Pipeline Stage:** p03_group

- [x] **Credential Validation / OAuth** (schwab_export.py:62-86)
  - **Razón:** API auth - pertenece a sync service
  - **Pipeline Stage:** Sync service

---

## Validaciones Ya Implementadas ✅

Las siguientes validaciones ya están presentes en la nueva implementación:

- [x] **Column Detection** (detector.py:42)
  - Estado: ✅ COMPLETO
  - Tests: test_detector.py

- [x] **Order Type Filtering** (schwab.py:250)
  - Estado: ✅ COMPLETO
  - Filtra solo type == "TRADE"

- [x] **CUSIP Resolution** (schwab.py:152-209)
  - Estado: ✅ COMPLETO (requiere mejoras en Fase 3)
  - Tests: test_cusip_resolution()

- [x] **Symbol Transformation** (schwab.py:424)
  - Estado: ✅ COMPLETO
  - Uppercase + strip whitespace

- [x] **Asset Type Mapping** (schwab.py:91-101)
  - Estado: ✅ COMPLETO
  - 8 tipos → 5 categorías

- [x] **Timezone Conversion** (schwab.py:441-446)
  - Estado: ✅ COMPLETO
  - UTC → America/New_York

- [x] **Fee Extraction** (schwab.py:284-290)
  - Estado: ✅ COMPLETO
  - 4 tipos de fees (COMMISSION, SEC_FEE, TAF_FEE, OPT_REG_FEE)

- [x] **Fee Absolute Value** (schwab.py:286)
  - Estado: ✅ COMPLETO
  - `.abs()`

- [x] **Quantity Absolute Value** (schwab.py:433)
  - Estado: ✅ COMPLETO
  - `.abs()`

- [x] **Date Format Conversions** (schwab.py:441-446)
  - Estado: ✅ COMPLETO
  - ISO format → datetime

- [x] **Option Symbol Parsing** (schwab.py:368-381)
  - Estado: ✅ COMPLETO
  - 5 formatos soportados

---

## Métricas de Progreso

### Validaciones por Estado

| Estado | Cantidad | Porcentaje |
|--------|----------|------------|
| ❌ FALTANTE | 8 | 30% |
| ⏸️ CONDICIONAL | 2 | 7% |
| ✅ OUT OF SCOPE | 7 | 26% |
| ✅ YA IMPLEMENTADO | 10 | 37% |
| **TOTAL** | **27** | **100%** |

### Estimaciones de Esfuerzo

| Fase | Días Estimados | Estado |
|------|----------------|--------|
| Fase 1 (Hash Fix) | 1-2 | ❌ NO INICIADO |
| Fase 2 (Validations) | 1.5-2 | ❌ NO INICIADO |
| Fase 3 (Quality) | 1-1.5 | ❌ NO INICIADO |
| **Total Crítico (Fases 1-3)** | **3.5-5.5** | **0% completo** |
| Fase 4 (CSV) | 10-15 | ⏸️ CONDICIONAL |
| **Total Completo** | **13.5-20.5** | **Pendiente decisión** |

### Hash Match Rate Progress

| Milestone | Target | Actual | Estado |
|-----------|--------|--------|--------|
| Baseline (pre-fix) | - | 42% | ✅ MEDIDO |
| Post Fase 1 | 95-100% | - | ❌ PENDIENTE |

---

## Notas de Implementación

### Issue Crítico: closingPrice Volatility

**Descubierto:** 2026-01-14
**Severidad:** CRÍTICA (afecta 58% de ejecuciones)

**Evidencia Real:**
```json
Trade: SAVA, 2021-09-15, activityId 31607727843

// Mirror sync (2026-01-11)
{
  "transferItems": [{
    "instrument": {"closingPrice": 2.09},  // ← Mercado hoy
    "price": 43.93                          // ← Precio ejecución
  }]
}

// Legacy sync (2026-01-08)
{
  "transferItems": [{
    "instrument": {"closingPrice": 2.18},  // ← Mercado hace 3 días
    "price": 43.93                          // ← Mismo precio ejecución
  }]
}

→ Diferentes hashes, pero MISMOS datos de trading
```

**Root Cause:** Schwab API incluye `closingPrice` (precio de mercado ACTUAL en vivo), no precio de ejecución histórico. Este campo cambia con cada API call.

**Impacto:**
- Hash match rate: 42% (25,941/62,237 matches)
- No-matching: 36,296 ejecuciones (58%)
- Data integrity: 100% ✓ (datos de trading son perfectos)
- Solo afecta deduplicación (no hay pérdida de datos)

**Solución:** Zero out closingPrice + sort transferItems antes de computar hash (Fase 1)

---

## Testing Checklist

### Unit Tests Nuevos Requeridos

- [ ] test_file_row_stable_across_closing_price_changes()
- [ ] test_file_row_stable_across_transfer_items_order()
- [ ] test_required_fields_validation()
- [ ] test_status_filter()
- [ ] test_empty_symbol_validation()
- [ ] test_zero_price_validation()
- [ ] test_zero_quantity_validation()
- [ ] test_negative_price_validation()
- [ ] test_disabled_instrument_filter()
- [ ] test_cusip_retry_on_timeout()
- [ ] test_cusip_rate_limit_handling()
- [ ] test_cusip_exponential_backoff()
- [ ] test_cusip_api_key_from_env()
- [ ] test_cusip_api_key_missing()

### Integration Tests

- [ ] test_end_to_end_hash_match_rate() - Target: >= 95%
- [ ] test_legacy_mirror_hash_compatibility()
- [ ] test_rejection_rate() - Target: < 0.1%
- [ ] test_cusip_resolution_success_rate() - Target: >= 98%

### Regression Tests

- [ ] Verificar que todos los tests existentes (504 líneas) pasan
- [ ] Verificar coverage no disminuye
- [ ] Verificar que cambios no afectan original_file_row

---

## Deployment Checklist

### Pre-Deployment

- [ ] Code review completo (Fases 1-3)
- [ ] Todos los tests pasan
- [ ] Coverage >= 90%
- [ ] Documentación actualizada
- [ ] CUSIP_API_KEY configurado en environment

### Fase 1 Deployment (Hash Fix)

- [ ] Coordinar con legacy team
- [ ] Deploy legacy changes primero
- [ ] Deploy mirror changes
- [ ] Ejecutar SQL rebuild script (dry-run)
- [ ] Ejecutar SQL rebuild script (production)
- [ ] Validar hash match rate >= 95%
- [ ] Monitor logs por 24-48 horas

### Fase 2-3 Deployment (Validations + Quality)

- [ ] Deploy en staging
- [ ] Validar rejection rate < 0.1%
- [ ] Validar CUSIP success rate >= 98%
- [ ] Deploy en production
- [ ] Monitor logs por 24-48 horas

### Post-Deployment

- [ ] Verificar hash match rate mantenido >= 95%
- [ ] Verificar no hay errores de validación inesperados
- [ ] Verificar throughput no afectado
- [ ] Documentar lessons learned

---

## Decisiones Pendientes

### 🔴 Decisión 1: closingPrice Fix Strategy (BLOQUEANTE)

**Pregunta:** ¿Qué approach para fixing hash volatility?

**Opciones:**
- **A: Zero out closingPrice + sort transferItems (RECOMENDADO)**
  - Pros: Fix completo, 95-100% match rate expected
  - Cons: Requiere legacy update + SQL rebuild
- **B: Zero out closingPrice only**
  - Pros: Fix parcial, más simple
  - Cons: Puede quedar volatilidad de array order (80-90% match)
- **C: Aceptar 42% match rate (NO RECOMENDADO)**
  - Pros: No code changes
  - Cons: Deduplicación no funciona

**Recomendación:** **Opción A**

**Estado:** ⏸️ PENDIENTE APROBACIÓN

---

### 🟡 Decisión 2: CSV Support Necessity

**Pregunta:** ¿Implementar 5 CSV parsers (1,235 líneas legacy)?

**Data Requerida:** Ejecutar SQL query (ver Fase 4.1)

**Criterio:**
- Si CSV > 5%: **IMPLEMENTAR** (8-12 días)
- Si CSV < 5%: **OMITIR**

**Recomendación:** **Query data first**

**Estado:** ⏸️ PENDIENTE SQL QUERY

---

### 🟡 Decisión 3: SchwabStreet Support

**Pregunta:** ¿Soportar formato SchwabStreet CSV (306 líneas legacy)?

**Criterio:** Si > 1% del total: **IMPLEMENTAR** (2-3 días)

**Recomendación:** **Probablemente OMITIR** (formato legacy, likely unused)

**Estado:** ⏸️ PENDIENTE SQL QUERY

---

## Contactos y Referencias

**Documentación:**
- Plan completo: `PLAN_ANALISIS_VALIDACIONES_CHARLES_SCHWAB.md`
- Ejemplos de código: `EJEMPLOS_CAMBIOS_CODIGO.md`
- Guía de implementación: `brokers/charles_schwab/README.md`

**Archivos Críticos:**
- Main interpreter: `brokers/charles_schwab/schwab.py`
- Tests: `tests/test_charles_schwab.py`
- Legacy reference: `old_code_from_legacy/schwab_export.py`
- Legacy CSV parsers: `old_code_from_legacy/brokers_charlesschwab.py`

**Issues:**
- closingPrice volatility: 42% hash match rate (CRÍTICO)
- Missing validations: 8 validaciones (HIGH/MEDIUM priority)
- CUSIP robustness: No retry logic, hardcoded key

---

**Última Actualización:** 2026-01-14
**Próxima Revisión:** Post Fase 1 completion
