#import traceback
import time
#import sys
import json
import hashlib
import re
from datetime import datetime
import requests
from flask_restful import Resource, request
from app.models import UserEvents
from app.responses import ErrorResponses
from app.import_params import ImportParams
from app.trade.trades_regroups import TradeRegroups
from app.broker.brokers_export import BrokerExport
from app.event.events import UserEventList as EventUser
from app.server_info import ServerInfo
from app.security_service import verify_role
#from requests.exceptions import ConnectionError
#from flask_jwt_extended import jwt_required
#from ..user.users_params import *
#import itertools

class DeribitExport(BrokerExport, ServerInfo, Resource):

    @verify_role('broker export')
    def post(self):
        try:
            version = {}
            self.orders_execid = []
            self.data = request.json
            
            # Start synchronization and update progress
            self._update_progress('Saving Pre-Data', '1%')
            new_event_id=self.init_sync()
            if not isinstance(new_event_id,UserEvents) and not self.is_lambda():
                return new_event_id

            
            if len(self.credentials) == 0:
                self.credentials = [None]

            self.session = None
            # self.credentials = []
            for credential in self.credentials:
                self.credential = None
                self.credential = credential
                self._update_progress('Checking Credentials', '5%')

                self.not_error = self.validate()
                if self.not_error != True:
                    _end = self.end_sync()
                    if _end != True:
                        return _end

                self.symbols = []
                self.credential = None
                self.credential = credential

                self.not_error = self.login()

                if self.not_error != True:
                    _end = self.end_sync(code=1)
                    if _end != True:
                        return _end
                self._update_progress('Saving data', '10%')
                self.save_account(self.api_key_information['id'])
                # self.sessions.append(self.session)
                #if self.credential:
                    #self.symbols = self.symbols + self.credential.symbols_list

                #if self.data['symbols'] != [] and self.symbols == [] and (
                #        'add' in self.data or self.data['add'] == True):
                #    self.symbols = self.data['symbols']
                self.account_pusher = 'Account #' + str(self.api_key_information['id'])
                self.time_out_lambda=False
                if self.condition_lambda() and not self.aws_autosync:
                    try:
                        self.not_error = self.call_lambda()
                    except Exception as err:
                        #print(err)
                        #print(traceback.print_exc())
                        self.not_error = err
                        self.executed_lambda = False
                
                if not self.executed_lambda:
                    self._update_progress('Getting symbols', '15%')
                    self.not_error = self.get_symbols()

                    if self.not_error != True:
                        _end = self.end_sync(code=6)
                        if _end != True:
                            return _end
                    self._update_progress('Saving data', '16%')
                    self.save_configs()

                    self._update_progress('Getting orders', '18%')
                    self.not_error = self.get_orders()

                    if self.not_error != True:
                        _end = self.end_sync(code=7)
                        if _end != True:
                            return _end

                    self.all_orders = self.orders
                    if len(self.all_orders) > 0:
                        self.save_files(file_type='json')

                        self._update_progress('Reading orders', '19%')

                        self.interpret_orders()

                        #UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, True)
                        self._update_progress('Preparing all to save orders', '20%')
                        self.save_orders()

                    #if not self.is_lambda() or not self.can_call_lambda():
                    #    UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, True)
                    self.user.users_configs.tda_import = True
                    self.user.users_configs.save()

                    self._update_progress('Import completed', '100%')
                    self.send_pusher()
                    self.not_error  = self.save_params()
                    getattr(self.out, 'mgs', 'successfully')
                    self.sync_status(healthy=True, message=self.out['mgs'] if 'mgs' in self.out else 'Sync Success', status_code=200)
            # TERMINA LA ITERACION

            return self.end_sync(event_id=new_event_id)

        except Exception as err:
            #UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, True)
            self.unlock_portfolios()
            self.pusher_title = 'warning'
            self.pusher_message = 'Imported Fail'
            self.pusher_complete = True
            self.send_pusher()
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(time.time())-self.star_timestamp), 500, 'Fail') 
            return ErrorResponses.error_500(self.data, err, version)

    def validate(self):
        try:
            self.data = request.json
            self.user.users_configs.not_warning_import = self.data.get('not_warning_import', True)
            self.symbols = self.data.get('symbols', self.symbols)
            self.user.users_configs.save()
            self.auto_import = self.data['auto_import'] if 'auto_import' in self.data else False

            if self.credential and (not 'add' in self.data or self.data['add'] == False):
                #self.credential = BrokersConnections.find_by(**{'user_id':self.user.id, "broker_id":self.broker.broker_id, 'active': True})
                self.api_key = self.credential.api_key
                self.secret_key = self.credential.secret_key
                self.test_account = self.credential.test_account
                self.passphrase = self.credential.passphrase
                # self.content_type = 'application/x-www-form-urlencoded'
                self.new_sync =  self.credential.new_sync
            else:
                # self.symbols = self.data['symbols']
                self.api_key = self.data['api_key'].strip()
                self.secret_key = self.data['secret_key'].strip()
                self.passphrase = self.data['passphrase'].strip()
                self.test_account = self.data['test_account']  if 'test_account' in self.data and self.data['test_account'] != "" else False
                self.add = self.data.get('add', False)
                self.new_sync = True

            self.host = "https://www.deribit.com/api/v2/"


            return True

        except Exception as err:
            #print("Exception", err)
            #print(traceback.print_exc())
            if not self.credential:
                return "Wrong credentials"

            # self.symbols = self.credential.symbols
            self.api_key = self.credential.api_key
            self.secret_key = self.credential.secret_key
            self.passphrase = self.credential.passphrase
            self.test_account = self.credential.test_account
            self.host = "https://www.deribit.com/api/v2/"
            
            # self.content_type = 'application/x-www-form-urlencoded'
            self.user.users_configs.not_warning_import = True
            self.user.users_configs.save()
            self.data = None

    def login(self):
        try:
            
            endpoint_login = 'public/auth'
            data = {
                'id': 0,
                'jsonrpc': "2.0",
                'method': endpoint_login,
                'params': {
                    'grant_type': 'client_credentials',
                    'client_id': self.api_key,
                    'client_secret': self.secret_key,
                }
            }
            self.session =  {
                'Content-Type': 'application/x-www-form-urlencoded'
            }
            response = requests.request('post', self.host + endpoint_login, headers=self.session, json=data).json()
            
            if 'result' in response:
                self.session['Authorization'] = 'Bearer ' + response['result']['access_token']
                self.api_key_information = {'id':self.api_key}
                return True
            else:
                return json.dumps(response)
        except Exception as e:
            #print(e)
            #print(traceback.print_exc())
            #return 'Wrong login credentials'
            return str(e)

    def get_symbols(self):
        try: 
            endpoint = f"public/get_currencies"
            data = {
                'id': 0,
                'jsonrpc': "2.0",
                'method': "public/get_currencies",
                'params': {
                }
            }
            response = requests.request('post', self.host+endpoint, headers=self.session, json=data).json()
            self.symbols = response['result']
            return True
        except Exception as ex:
            return str(ex)

    def get_orders(self):
        try:
            last_date = self.get_last_date_a(user_account=self.api_key_information['id'])
            last_time = 0 if self.data['partial'] == False or (
                    not self.credential or not last_date or last_date == 0) else last_date
            startTime = int(last_time * 1000)
            timestampt = int(time.time()) * 1000
            orders = []
            endpoint = "private/get_transaction_log"
            attempts = 0
            for currency in self.symbols:
                page = None
                while True:
                    data = {
                        'id': 0,
                        'jsonrpc': "2.0",
                        'method': endpoint,
                        'params': {
                            'currency': currency['currency'],
                            'start_timestamp': startTime,
                            'end_timestamp': timestampt,
                            'count':100,
                            'query':'trade'
                        }
                    }
                    if page != None:
                        data['params']['continuation'] = page
                    response = requests.post(f"{self.host}{endpoint}", headers=self.session, json=data).json()
                    #print(response)
                    if 'error' in response:
                        if 'message' in response['error'] and response['error']['message'] == 'too_many_requests':
                            time.sleep(5)
                            attempts += 1
                            if attempts >= 10:
                                break
                            continue

                        return str(response['error'])
                    orders.extend(response['result']['logs'])
                    page = response['result']['continuation']
                    if page == None:
                        break

            self.orders = orders
            return True
        except Exception as ex:
            #print(ex)
            #print(traceback.print_exc())
            return ex


    def classify_instrument(self, ticker):
        """
            Clasifica un ticker financiero en 'Option', 'Perpetual Future', 'Spot' o 'Unknown'.
        """
        # Patrón para opciones: e.g., BTC-4JUL25-116000-C
        # Busca: [TEXTO]-[FECHA]-[NUMERO]-[C o P]
        option_pattern = re.compile(r'.+-\d{1,2}[A-Z]{3}\d{2}-\d+-[CP]$')

        if "PERPETUAL" in ticker:
            return "Future"
        elif option_pattern.match(ticker):
            return "Option"
        elif "_" in ticker:
            return "Spot"
        else:
            return "Unknown"
        
    def interpret_orders(self):
        try:
            interpreter_orders_event = EventUser.post_user_events(101, new_user=self.user_id)
        except:
            pass

        pip_value_order = dict()
        b = 0
        new_date_time = []
        verify_njson_len = 0
        i = 0

        for order in self.all_orders:
            i += 1
            if i % 100 == 0 or i == 1 or i == len(self.all_orders):
                self._update_progress("Reading orders: {}/{}".format(i, len( self.all_orders)), '19%')
            original_file_row = json.loads(json.dumps(order))
            njson = json.dumps(order)
            njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

            try:
                if order['type'] != 'trade':
                    continue
                
                #action = order['side'].upper()
                #action = 'BUY' if action == 'OPEN BUY' else 'SELL' if action ==  'CLOSE SELL' else ''
                action = order['side'].upper()
                if (("CLOSE" in action and "SHORT" in action) or ("OPEN" in action and "LONG" in action)) or (
                        "BUY" in action):
                    action = "BUY"
                elif (("CLOSE" in action and "LONG" in action) or ("OPEN" in action and "SHORT" in action)) or (
                        "SELL" in action):
                    action = "SELL"
                
                #order['price'] = float(order['price'])
                #quantity = float(order['amount'])/float(order['index_price'])
                quantity = float(order['amount'])
                order['side'] = action
                order_time = int(order['timestamp'])
                order['date'] = datetime.utcfromtimestamp(order_time / 1000).isoformat()

                order['quantity'] = quantity
                order['commission'] = float(order['price']*order['commission'] if 'commission' in order else 0 )
                order['symbol'] = order['instrument_name'].replace('_', '').replace('-', '').replace('PERPETUAL', order['price_currency'] )
                order['fees'] = 0
                
                if order['side'] == '':
                    continue
                #else:
                #    order['symbol'] = order['symbol'].split('.')[0]
            except Exception as err:
                #print(err)
                #print(traceback.print_exc())
                continue
            if not action:
                continue
            pip_value = 1
            date_time = order['date']
            original_file_row['date_tz'] = date_time
            self.any_error, date, time = ImportParams.get_param_datetime(date_time, b)
            new_date_time = ImportParams.convert_date(date, time, self.date_format, True, 'UTC')

            order['date'] = new_date_time[0]
            order['time'] = new_date_time[1]
            fp = str(order['price']).replace(',', '').replace('$', '')
            decimal = fp[::-1].find('.')
            decimal = decimal if decimal > 1 else 2
            price = round(float(fp), decimal)
            # price = round(float(order['price'].replace(',', '')),6)

            sm = len(order['symbol'])
            margen = 1
            value = 1
            type_trade = 'crypto'
            option_trade = 'CRYPTO'
            strike = ''
            expire = ''
            if 'balance' in order:
                margen = float(order['balance']) * price
                value = float(quantity) * price
            pip_value = margen / value    
            ci = self.classify_instrument(order['instrument_name'])
            
            if ci in ['Spot', 'Future', 'Unknown']:
                type_trade = 'crypto'
                option_trade = 'CRYPTO'
                strike = ''
                expire = ''
            elif ci == 'Option':
                ci_d = order['instrument_name'].split('-')
                type_trade = 'option'
                option_trade =  'CALL' if ci_d[3] == 'C' else 'PUT' if ci_d[3] == 'P' else 'OPTION'
                expire = datetime.strptime(ci_d[1], '%d%b%y').strftime('%d %b %y').upper()
                strike = ci_d[2]
                order['symbol'] = ci_d[0].replace('_', '')
                sm = len(order['symbol'])
                if order['symbol'].upper() in ['BTC']:
                    pip_value = float(ImportParams.pip_value_crypto_(date=order['date'], base='usdt',
                                                                                        currency=order['symbol']))
                    
            # order['size'] = 1

            #if order['category'] in self.params['user_portfolios']:
            #    user_portfolio = self.params['user_portfolios'][order['category']]
            #else:
            #    user_portfolio = self.params['user_portfolio']

            user_portfolio = self.params['user_portfolio']

            if 'pair' in order:
                order['size'] = 10
                pip_value = self.convert_usdt(order, pip_value_order, date)

            #################### VERIFY FILE ROW ######################
            if ImportParams.verify_njson(njson, self.params['get_session_userid'], user_portfolio):
                verify_njson_len = verify_njson_len + 1
                continue
            else:
                if 'id' in original_file_row and original_file_row['id']:
                    n2 = original_file_row['id']
                    njson2 = json.dumps(n2)
                    njson2 = hashlib.md5(njson2.encode('utf-8')).hexdigest()
                    if ImportParams.verify_njson(njson2, self.params['get_session_userid'], user_portfolio):
                        verify_njson_len = verify_njson_len + 1
                        continue
                    else:
                        if ImportParams.verify_date_file_row(self.params['get_session_userid'],
                                                             self.params['broker'],
                                                             original_file_row,
                                                             argv2='id' if 'id' in original_file_row
                                                             else '',
                                                             portfolio=user_portfolio
                                                             ):
                            verify_njson_len = verify_njson_len + 1
                            continue
                        else:
                            njson3 = {
                                'price': float(fp) if fp else 0.00,
                                'date': order['date'] + ' ' + order['time'],
                                'option_type': option_trade,
                                'action': 1 if action == 'BUY' else 2,
                                'shares': order['quantity'],
                                'strike': float(strike) if ImportParams.isfloat(strike) else '',
                                'expire': expire,

                            }
                            if ImportParams.verify_njson_webull(njson3, self.params['get_session_userid']):
                                verify_njson_len = verify_njson_len + 1
                                continue
                            else:
                                njson = njson2

            order['trade_notes'] = order['text'] if 'text' in order else ''
            order['type_stock'] = type_trade
            order['type_option'] = option_trade
            order['action'] = action
            order['price'] = price
            order['shares'] = str(order['quantity']).replace(',', '')
            order['comm'] = str(order['commission']).replace(',', '').replace('$','')
            order['njson'] = njson
            order['decimal'] = decimal
            order['expire'] = expire
            order['strike'] = strike
            order['pip_value'] = pip_value
            order['original_file_row'] = original_file_row
            order['broker'] = self.params['broker']
            order['userid'] = self.params['get_session_userid']
            order['portfolio'] = user_portfolio
            
            data_item = ImportParams.get_result_append(order)
            self.out_result.append(data_item)
            b = b + 1
        try:
            event_success = EventUser.update_user_events(interpreter_orders_event)
        except:
            pass

    def save_orders(self):
        try:
            get_orders_event = EventUser.post_user_events(102, new_user=self.user_id)
        except:
            pass

        self.pusher_title = "Regrouping orders"
        self.pusher_message = '19%'
        self.pusher_complete = False
        self.send_pusher()

        import_broker = 'Deribit'

        regroup_value = [group['code'] for group in self.user.users_configs.trade_grouping if group['active'] is True][
            0]
        error_mgs = "There was an error. Our support team will review the issue and get back to you"

        spread = False
        if regroup_value == 'split':
            output_group = TradeRegroups.regroup_trades_closed(self.out_result, import_broker, self.user.id)

        else:
            if regroup_value == 'spread':
                spread = True
            output_group = TradeRegroups.regroup_trades(self.out_result, import_broker, self.user.id, spread=spread, user=self.user)
        if 'error' in output_group:
            self.out['mgs'] = error_mgs
            return self.out
        any_error, rows, return_total, error_issue, executions, self.upload_id = TradeRegroups.save_to_database(
            output_group, import_broker, self.user.id, archive=self.filename_csv, upload_id=self.upload_id)
        """
            rows : total trades imported
            executions: total executions imported
        """
        # self.rows = self.rows+rows
        # self.executions = self.executions + executions
        self.rows = rows
        self.out_result = output_group
        self.out = {'any_error': any_error, 'rows': rows, 'ordens': executions,
                    'return_total': return_total, 'error_issue': error_issue,
                    'broker': import_broker, 'error_code': any_error}
        if any_error and any_error != 21:
            self.out['mgs'] = error_mgs
            return self.out
        else:
            if rows > 0:
                try:
                    self.user.fk_user_status_id = 1
                    self.user.save()
                except:
                    pass
                mgs = f'{str(rows)} Trades, {str(executions)} Executions'
            else:
                if self.last_date == 0 or self.last_date == None:
                    mgs = "No new trades found."
                else:
                    mgs = "No new trades to import"
        self.out['mgs'] = mgs
        self.save_file(tmp_route=self.tmp_route_csv, archive=self.filename_csv, to=self.to_csv,data = self.all_orders,
                       f_type='transactions_csv', content_type='text/csv', portfolio=self.portfolio,
                       executions=executions, trades=rows, fk_broker_id=self.broker.broker_id,
                       broker=self.broker.broker_key)

        # self.save_file(tmp_route = self.tmp_route_json, archive = self.filename_json , to = self.to_json, f_type= 'transactions_json', content_type = 'text/json',  portfolio =self.portfolio,  executions=executions , trades=rows, fk_broker_id = self.broker.broker_id, broker = self.broker.broker_key)
        #UserParams.append_param(self.user.id, 'IMPORT_UPLOAD', False, replace=True)
        try:
            event_success = EventUser.update_user_events(get_orders_event)
        except:
            pass
