import re
import hashlib
import json
import traceback

from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required
from dateutil.parser import parse

from datetime import datetime
from .. import_params import ImportParams
from .. security_service import *
from .. logs import create_log
from .. responses import ErrorResponses, SuccessResponses

class BrokerDeribit(Resource):

    def getcsv(params, content, date_format='mdy'):
        data = "BrokerDeribit"
        print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:
            if 'TRADE ID' in content.upper():
                return BrokerDeribit.getcsv2(params, content, date_format='mdy')
            content = content.replace(';', '')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False

            # for row in content_b:
            #     if len(row) == 0:
            #         continue
            #     rl = rl + 1
            #     result_b.append(row)
            #     if rl == 1:
            #         row = row.replace("\r", "")
            #         ns = row.split(',')
            #         nl = len(ns)
                    #print row

            for row in content_b:
                if 'DATE' in row.upper():
                    ath = True
                elif not row:
                    ath = False

                if ath:
                    if rl == 0:
                        row = row.replace("\r", "")
                        ns = row.split(',')
                        nl = len(ns)
                        result_b.append(row)
                    if rl > 0 and  'TRADE' in row.upper():
                        result_b.append(row)
                    rl = rl + 1
            result = ImportParams.custom_getcsv(result_b, nl,True,True)

            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                action = n['buy/sell'].upper() if 'buy/sell' in n else n['side'].upper() if 'side' in n else ''
                if 'action' in n:
                    action = 'BUY' if str(n['action'])=='1' else 'SELL' if str(n['action'])=='2' else ''
                action = 'BUY' if action.upper() == 'CLOSE BUY' \
                                  or action.upper() == 'OPEN BUY' \
                                  or action=='BUY' \
                                  else 'SELL' if action.upper() == 'OPEN SELL' \
                                  or action.upper() == 'CLOSE SELL' \
                                  or action == 'SELL' else ''
                if 'trade_datetime' in n:
                    date = str(n['trade_datetime']).split(' ')
                    n['date'] = date[0]
                    n['time'] = date[1]
                n['symbol'] =  n['instrument']  if 'instrument' in n else  n['symbol'] if 'symbol' in n else ''

                if not n['symbol'] or not n['date'] or not n['price'] or not action:
                    continue

                n['symbol'] = "BTC" if  n['instrument'] == "BTC-PERPETUAL" else n['instrument']
                pip_value = 0

                if ImportParams.isfloat(n['date'].strip()):
                    date_m = int(n['date']) / 1000
                    date_m = datetime.utcfromtimestamp(date_m).strftime('%Y-%m-%d %H:%M:%S')
                    date_split =date_m.strip()
                    d = date_split
                    t = n['time'] if 'time' in n else ''
                    date_time = (d+' '+t).strip()
                else:
                    date_time = n['date'].strip()
                original_file_row['date_tz'] = date_time
                any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                new_date_time = ImportParams.convert_date(date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                fp = n['price'].replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp),6)
                #price = round(float(n['price'].replace(',', '')),6)
                quantity = n['quantity'].replace(',', '') if 'quantity' in n else n['amount'].replace(',', '')
                if not 'type' in n:
                    n['type'] = 'SHARE'
                sm = len(n['symbol'])
                type = 'share'
                option = 'SHARE'
                strike = ''
                expire = ''
                smn = n['symbol'][-2:]
                if 'fee paid' in n:
                    type = 'crypto'
                    option = 'CRYPTO'
                    pip_value = 0.000001
                    smo = n['symbol'].split('-')
                    if len(smo) > 2:
                            base = smo[0]
                            date_c = n['date']
                            pip_value = ImportParams.value_pip_forex(date_c, base)
                            strike = smo[2]
                            expire = smo[1]
                    else:
                        crypto_value = float(quantity) / price
                        row_value = float(quantity) * price
                        pip_value = (crypto_value/row_value) * price
                        if len(smo) > 1 and not 'PERPETUAL' in smo[1]:
                            expire = smo[1]
                    if expire:
                        try:
                            expd = datetime.strptime(str(expire),'%d%b%y')
                            expire = expd.strftime("%d %b %y")
                        except:
                            expire = ''
                            pass


                n['trade_notes'] = n['trade_notes'] if 'trade_notes' in n else ''
                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = n['commission'].replace(',', '').replace('$','') if 'commission' in n else '0.00'
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['pip_value'] = pip_value
                n['original_file_row'] = original_file_row
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            print(err)
            print(traceback.format_exc())
            any_error = 9
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error

    def getcsv2(params, content, date_format='mdy'):
        data = "BrokerDeribit 2"
        print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        pip_value_order_btc = dict()
        pip_value_btc = 0
        b=0

        try:
            content = content.replace(';', '').replace('\nS', ' S').replace('\t',',')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False
            for row in content_b:
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            firstday = False
            if params['date_format']['id'] == 3 or params['date_format']['id'] == 4:
                firstday = True
            for a, n in enumerate(result):
                # {'side': 'sell', 'instrument': 'BTC-2DEC22-17000-C', 'size': '18', 'price usd': '352.84', 'price crypto': '0.0216', 'iv': '61.52', 'type': 'limit', 'order id': '51726453597', 'und. mark': '16335.39', 'trade id': '236633644', 'fees': '0.00000000', 'index': '16400.83', 'date': '23 Nov 2022 15:55:06'}
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                for k in list(n):
                    if 'price usd' in k:
                        n['price'] = n[k]
                amount = float(n['size']) if 'size' in n and ImportParams.isfloat(n['size']) else float(n['amount']) if 'amount' in n and  ImportParams.isfloat(n['amount']) else float(n['base amount']) if ImportParams.isfloat(n['base amount']) else ''
                n['size'] = 1

                action = 'BUY' if 'side' in n and 'BUY' in n['side'].upper() else \
                         'SELL' if 'side' in n and 'SELL' in n['side'].upper() else ''

                n['symbol'] = n['instrument'].strip().replace('PERPETUAL','PERP')
                n['action'] = action

                if n['action'] not in ['BUY', 'SELL'] or not n['symbol'] or not n['price'] or not amount:
                    continue
                date_format = '%m/%d/%Y %H:%M:%S'
                if firstday:
                    try:
                        date_split = ImportParams.parse_date(n['date'], firstday)
                    except:
                        pass
                else:
                    date_split = parse(n['date'])
                date_split = str(date_split.strftime(date_format))

                original_file_row['date_tz'] = date_split
                any_error, date, time = ImportParams.get_param_datetime(date_split,b,date_format)
                new_date_time = ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                fp = n['price'].replace(',', '').replace('$', '')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                vfp = ImportParams.isfloat(fp)
                price = round(float(fp),6) if vfp else 0.00


                type = 'crypto'
                option = 'CRYPTO'
                expire = ''
                strike = ''

                sm = len(n['symbol'])
                if sm >= 8 and '-' in n['symbol'] and ImportParams.isfloat(n['symbol'][-2:]):
                    sym_split = n['symbol'].split('-')
                    #BTC-2DEC22
                    type = 'crypto future'
                    option = 'CRYPTO'
                    # type = 'crypto future'
                    symbol = '#{}USDT'.format(sym_split[0])
                    expire = str(datetime.strptime(sym_split[1],'%d%b%y'))
                    n['symbol'] = symbol
                if sm >= 12 and '-' in n['symbol']:
                    sym_split = n['symbol'].split('-')
                    #BTC-2DEC22-17000-C
                    type = 'crypto option'
                    symbol = '#{}USDT'.format(sym_split[0])
                    expire = str(datetime.strptime(sym_split[1],'%d%b%y'))
                    strike = sym_split[2]
                    option = 'CALL' if 'C' in sym_split[3] else 'PUT' if 'P' in sym_split[3] else 'OPTION'
                    n['symbol'] = symbol

                quantity = abs(amount)
                commission = 0.00
                if 'cash flow' in n and 'instrument' in n and 'btc' in n['instrument'].lower():
                    row_btc = '{}{}'.format(date,'btc')
                    if not row_btc in pip_value_order_btc:
                        pip_value_btc = ImportParams.pip_value_crypto_(n['date'], base='btc', currency='usdt')
                        pip_value_order_btc[row_btc] = pip_value_btc
                    else:
                        pip_value_btc = pip_value_order_btc[row_btc]
                    n['pip_value'] = pip_value_btc

                fee = n['fees'] if 'fees' in n else n['fee charged']  if 'fee charged' in n else n['fee rate'].replace('-','')
                fee = round(float(fee),7) if fee else 0.00
                if pip_value_btc:
                    fee = fee * float(fp)
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = commission
                n['fees'] = fee
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['original_file_row'] = original_file_row

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            print(err)
            print(traceback.format_exc())
            any_error = 9

        if not any_error and not out_result:
            any_error=9

        return out_result, any_error
