from . brokers_export import BrokerExport
from flask_restful import Resource, request
from dateutil.parser import parse
from .. security_service import verify_role
from .. responses import ErrorResponses, SuccessResponses
from .. user.users_params import *
import itertools
from .. import_params import ImportParams
from .. trade.trades_regroups import *
from .. server_info import ServerInfo
from .. event.events import UserEventList as EventUser
import hmac
import hashlib
import requests
import time as tt
from json.decoder import JSONDecodeError

class BybitExport(BrokerExport,ServerInfo, Resource):

    @verify_role('broker export')
    def post(self):        
        try:
            version = {}
            self.data = {} 
            self.type_category=[]
            self.orders_execid = []
            self.data = request.json
            # Start synchronization and update progress
            self._update_progress('Saving Pre-Data', '1%')
            new_event_id=self.init_sync()
            if not isinstance(new_event_id,UserEvents) and not self.is_lambda():
                return new_event_id
            
            self._update_progress('Checking Credentials', '5%')
            rows = 0
            executions = 0
            return_total = 0
            ordens = 0
            
            for credential in self.credentials:
                self.credential = credential
                self.not_error = self.validate()
                #print('validate',self.not_error)
                if self.not_error != True:
                    _end = self.end_sync(code=4)
                    if _end != True:
                        return _end           
                self.symbols = []
                self.credential = None
                self.credential = credential
                if 'api_key_information' in self.data:
                    self.api_key_information = self.data['api_key_information']
                else:
                    self.not_error = self.login()
                    if self.not_error != True:
                        _end = self.end_sync(code=1)
                        if _end != True:
                            return _end 
                #print('api_key_information',self.api_key_information)
                if self.credential:
                    self.symbols =  self.symbols +self.credential.symbols_list
                
                self.symbols =[] 
                
                self.account_pusher = ''
                
                self.executed_lambda = False
                
                if self.condition_lambda() and not self.aws_autosync:
                    try:
                        self.not_error = self.call_lambda()
                    except Exception as err:
                        #print(err)
                        #print(traceback.print_exc())
                        self.not_error = err
                        self.executed_lambda = False
                
                if not self.executed_lambda:
                    self._update_progress('Saving data', '18%')
                    self.save_configs()
                    
                    self._update_progress('Retrieving orders', '19%')                 
                    self.not_error = self.loop_symbols()
                    if self.not_error != True:
                        _end = self.end_sync()
                        if _end != True:
                            return _end   
                                    
                    self.orders=list(itertools.chain.from_iterable(self.orders))  
                    self.orders = list(sorted(self.orders, key=lambda i: i['created_at'], reverse=False)) 
                    if  (self.user.id in (43830,48391,48397,282164,276437) or 'localhost' in self.backend_domain_name()):
                        pass
                    else:
                        if len(self.orders) < 50000:
                            self._update_progress('Verifying transactions', '18%')
                            self.orders=self.remove_duplicate(self.orders) 
                    
                    self.all_orders = self.orders
                    
                    self.used_symbols=list(set(self.used_symbols))                   

                    if self.type_category!=[]:
                        self.type_category = list(set(self.type_category))
                        for type in self.type_category:      
                            self.save_account(self.api_key_information,category=type)
                    else:
                        self.save_account(self.api_key_information,category='Future') 

                    if self.funding:
                        self.save_account(self.api_key_information,category='Funding')
                        
                    self._update_progress('Saving data', '19%')
                    self.save_files(file_type='json')
                    
                    self._update_progress('Reading orders', '19%')                    
                    self.not_error  =  self.interpret_save_orders()
                    if self.not_error != True:
                        self.not_error = str(self.not_error)
                        _end = self.end_sync(code=0)
                        if _end != True:
                            return _end
                   
                    self.user.users_configs.tda_import = True
                    self.user.users_configs.save()              
                    self.not_error  = self.save_params()
                    self.sync_status(healthy=True, message=self.out['mgs'] if 'mgs' in self.out else 'Sync Success',status_code=200)
                    
            
            #TERMINA LA ITERACION   
            return self.end_sync(event_id=new_event_id)

        except Exception as err:
            #print(err)
            #print(traceback.print_exc())
            UserParams.append_param(self.user.id,'IMPORT_UPLOAD',False,True)
            self.pusher_title =  'warning'
            self.pusher_message = 'Imported Fail'
            self.pusher_complete = True
            self.send_pusher()
            if self.is_lambda() and self.can_call_lambda():      
                self.save_params_lambda((int(tt.time())-self.star_timestamp), 500, 'Fail')
            return ErrorResponses.error_500(self.data, err, version)

    def validate(self):
        try:
            self.timestamp_now = (int(tt.time())+86400)*1000 
            self.data = request.json
            self.user.users_configs.not_warning_import = self.data.get('not_warning_import',True)
            self.user.users_configs.save()
            self.symbols = self.data.get('symbols',self.symbols)            
            self.auto_import = self.data['auto_import'] if 'auto_import' in self.data else False
            self.recv_window = 5000

            if self.credential and (not 'add' in self.data or self.data['add'] == False):
                self.api_key = self.credential.api_key
                self.secret_key = self.credential.secret_key
                self.test_account =  self.credential.test_account
                self.host  = "https://api-testnet.bybit.com" if  self.credential.test_account else "https://api.bybit.com"
                self.spot =  self.credential.spot
                self.future1 =  self.credential.future1
                self.future2 =  self.credential.future2
                self.option =  self.credential.option
                self.funding =  self.credential.funding
                self.unified =  self.credential.unified
                self.new_pairs =  self.credential.new_pairs
                self.new_sync = False
            else: 
                if self.data['api_key'] =='' or self.data['secret_key'] == '':
                    return "Wrong credentials"
                account_check = BrokersConnections.find_by(**{'user_id':self.user.id, "api_key":self.data['api_key'].strip(), "secret_key":self.data['secret_key'].strip(), 
                                                         "active": True})
                self.api_key = self.data['api_key'].strip()
                self.secret_key = self.data['secret_key'].strip()
                self.host  = "https://api-testnet.bybit.com" if  self.data['test_account']  else "https://api.bybit.com"
                self.test_account =  self.data['test_account']
                self.spot =  self.data['spot']
                self.future1 =  self.data['future1']
                self.future2 =  self.data['future2']
                self.option =  self.data['option']
                self.funding =  self.data['funding'] if 'funding' in self.data else False
                self.unified =  self.data['unified'] if 'unified' in self.data else False
                self.new_pairs =  self.data['new_pairs'] if 'new_pairs' in self.data else False
                self.add = self.data.get('add',False)
                self.new_sync = True
                if account_check:
                    return "account_is_already_connected"
                
            if not any([self.spot, self.future1,self.option,self.funding,self.unified]):
                return 'select_type'
            
            return True

        except Exception as err:
            if not self.credential:
                return "Wrong credentials"
            self.api_key = self.credential.api_key
            self.secret_key = self.credential.secret_key
            self.test_account =  self.credential.test_account
            self.future1 =  self.credential.future1
            self.future2 =  self.credential.future2
            self.option =  self.credential.option 
            self.funding =  self.credential.funding 
            self.unified =  self.credential.unified 
            self.new_pairs =  self.credential.new_pairs 
            self.recv_window = 5000
            self.host  = "https://api-testnet.bybit.com" if  self.credential.test_account else "https://api.bybit.com"
            self.user.users_configs.not_warning_import = True
            self.user.users_configs.save()
            self.data = None

    def genSignature(self,recv_window, timestamp, payload):
        param_str= str(timestamp) + self.api_key + str(recv_window) + payload
        hash = hmac.new(bytes(self.secret_key, "utf-8"), param_str.encode("utf-8"),hashlib.sha256)
        signature = hash.hexdigest()
        return signature
    
    def request_bybit(self, uri_path, payload):
        recv_window = self.recv_window
        while True:
            timestamp = int(tt.time() * 1000)
            headers = {
                        "Content-Type": "application/json",
                        'X-BAPI-API-KEY': self.api_key,
                        'X-BAPI-TIMESTAMP': str(timestamp),
                        'X-BAPI-RECV-WINDOW': str(recv_window) ,
                        'X-BAPI-SIGN': self.genSignature(recv_window,timestamp,payload) 
                        #"X-BAPI-SIGN-TYPE": "2"
                    }
            try: 
                response = self.session_v5.request("GET", uri_path+"?"+payload , headers=headers, timeout=10)
                #print(response.text)
            except (
                self.session_v5.request.exceptions.ReadTimeout,
                self.session_v5.request.exceptions.SSLError,
                self.session_v5.request.exceptions.ConnectionError,
            ) as e:
                 return e
            
            # Check HTTP status code before trying to decode JSON.
            if response.status_code != 200:
                if response.status_code == 403:
                    return  "You have breached the IP rate limit."
                else:
                    return  "HTTP status code is not 200."
            
            # Convert response to dictionary, or raise if requests error.
            try:
                s_json = response.json()

            # If we have trouble converting, handle the error and retry.
            except JSONDecodeError as e:
                    return "Conflict. Could not decode JSON."
             
            ret_code = "retCode"
            ret_msg = "retMsg"

            if s_json[ret_code] != 0:
                delay_time = 3
                # Retry non-fatal whitelisted error requests.
                if s_json[ret_code]:
                    if s_json[ret_code] == 10002:
                        recv_window += 2500
                        tt.sleep(delay_time)
                        continue
                    elif s_json[ret_code] == 10006:                        
                        # Calculate how long we need to wait in milliseconds.
                        try:
                            limit_reset_time = int(response.headers["X-Bapi-Limit-Reset-Timestamp"])                        
                            delay_time = (int(limit_reset_time) - int(tt.time() * 1000)) / 10**3 
                            if delay_time>0:
                                tt.sleep(delay_time)
                            else:
                                tt.sleep(4)
                        except:
                            tt.sleep(delay_time)
                        
                        continue
                    elif s_json[ret_code] == 10004:
                        s_json[ret_msg]='Error sign, please check your signature'
                        return s_json
                    else:
                        return s_json               
            else:
                return s_json 
                   
    def get_api_key_information(self):
        if 'localhost' in self.backend_domain_name():
            url=self.host + '/v5/user/query-api'
            payload=''
            response = self.request_bybit(url, payload)

            if response["result"]!= []:
                try:
                    return response["result"]["userID"]
                except:
                    return 'Error getting User ID'
            else:
                return 'Error getting User ID'
        
        else: # servidor lambda
            url = "https://l3jj7ycwh7qx35726guo5mkyzu0xzeut.lambda-url.eu-central-1.on.aws/"

            payload = json.dumps({
                    "api": self.api_key,
                    "key": self.secret_key,
                    "host": self.host
                    })
            response = requests.request("POST", url, headers=self.headers_json , data=payload)          
            if response.status_code == 200:            
                return response.json()['account']
            else:
                try: 
                    return  response.json()['message']
                except:
                    return 'Error getting User ID'
                
    def login(self):            
        if 'localhost' in self.backend_domain_name():
            self.session_v5=requests.Session() #requests V5
            
            try:
                url=self.host + '/v5/user/query-api'
                payload=''
                response = self.request_bybit(url, payload)
                if response['retCode'] == 0:
                    self.api_key_information=response["result"]["userID"]
                    self.data['api_key_information'] = self.api_key_information
                    return True  
                else:
                    return  response['retMsg'] 
                    
            except:
                    return 'Error when making the request.'
        else: # servidor lambda
            url = "https://l3jj7ycwh7qx35726guo5mkyzu0xzeut.lambda-url.eu-central-1.on.aws/"
          
            payload = json.dumps({
                    "api": self.api_key,
                    "key": self.secret_key,
                    "host": self.host
                    })
            response = requests.request("POST", url, headers=self.headers_json , data=payload)   
            if response.status_code == 200: 
                self.api_key_information  = response.json()['account']   
                self.data['api_key_information'] = self.api_key_information       
                return True
            else:
                try: 
                    return  response.json()['message']
                except:
                    return 'Error when making the request.'
         
    def get_symbols(self): 
        self.symbols = []
        if 'localhost' in self.backend_domain_name():
            url=self.host + '/v5/market/instruments-info'        
            types = ['linear','inverse'] #,'option','spot',
            for type in types:            
                payload=f"category={type}"
                response = self.request_bybit(url, payload)
                
                if  response["retMsg"] == "OK" and response["result"]["list"]!= []:
                    for symbol in response['result']['list']:
                        self.symbols.append(symbol['symbol'])
                    return True
        else:      
            url = "https://pg4xhfd5gfjiv2xcgbhtgklygm0kpwne.lambda-url.eu-central-1.on.aws/"
           

            payload = json.dumps({
                    "api": self.api_key,
                    "key": self.secret_key,
                    "host": self.host
                    })
            response = requests.request("POST", url, headers=self.headers_json , data=payload)          
            if response.status_code == 200:    
                self.symbols=response.json()['symbols']      
                return True
            else:
                try: 
                    return  response.json()['message']
                except:
                    return 'Error when making the request.'
        return True
                  
    def loop_symbols(self):
        try:
            get_orders_event = EventUser.post_user_events(100, new_user=self.user_id)
        except:
            pass

        self.orders = []
        self.all_orders = []
        order = None
        f = 2
        start_time = 0
        symbol_count = 0
        paginated = False
        self.symbols.sort()  
        try:
               
            if self.spot:
                if self.data['partial']== True:                
                    start_time = int((self.get_last_date_a(user_account=str(self.api_key_information),category='Spot'))*1000) if not 'add' in self.data or self.data['add'] == False else 0  #menos un dia
                    if start_time>0:
                        paginated = True
                    else:
                        paginated = False
                        start_time = 0 
                else:
                    paginated = False 
                    start_time = 0  
                
                self._update_progress('Retrieving orders - Spot', '19%')
                self.get_bybit_orders_spot_new(start_time = start_time, paginated = paginated)
                
            if self.future1 or self.unified or self.funding:
                if self.data['partial']== True:                
                    start_time = int((self.get_last_date_a(user_account=str(self.api_key_information),category='Future')-172800)*1000) #menos un dos dia
                    if start_time>0:
                        paginated = True
                    else:
                        paginated = False
                        start_time = 0 
                else:
                    paginated = False 
                    start_time = 0  
                types = ['linear','inverse'] #,'option','spot',
                for type in types:  
                   
                    if self.unified:
                        prefx='Unified'
                    else:
                        prefx=''
                    self._update_progress('Retrieving orders - {} Future {}'.format(prefx,type), '19%')                         
                    self.get_bybit_orders_new(category = type, starTime = start_time, paginated = paginated,index=f)                          
                    f = f +1
                    symbol_count = symbol_count+1
            if self.option or self.unified:
                if self.data['partial']== True:                
                    start_time = int((self.get_last_date_a(user_account=str(self.api_key_information),category='Future')-172800)*1000) if not 'add' in self.data or self.data['add'] == False else 0  #menos un dos dia
                    if start_time>0:
                        paginated = True
                    else:
                        paginated = False
                        start_time = 0 
                else:
                    paginated = False 
                    start_time = 0  
                types = ['option'] #,'option','spot',
                for type in types:  
                    if self.unified:
                        prefx='Unified'
                    else:
                        prefx=''  
                    self._update_progress('Retrieving orders - {} option {}'.format(prefx,type), '19%')                     
                    self.get_bybit_orders_new(category = type, starTime = start_time, paginated = paginated,index=f)                          
                    f = f +1
                    symbol_count = symbol_count+1
           
        except Exception as e:
            #print(e)
            return e
            
        try:
            event_success = EventUser.update_user_events(get_orders_event)
        except:
            pass
        return True

    def get_bybit_orders_spot_new(self, start_time, paginated):
        url=self.host + '/v5/execution/list' 
        msg_order_len = 0
        j = 0
        symbols=self.symbols
        endTime = int(tt.time()*1000)
        margin = 604800 *1000  
        start_time, endTime = self.validate_date_range(start_time, endTime)
        stop=False
        self.pusher_title =  'Extracting orders - Spot'
        self.pusher_message = '21%'
        self.pusher_complete = False
        self.send_pusher() 
        if self.user.id in (43830,48391,48397) or 'localhost' in self.backend_domain_name():
            url_lambda=  self.url_microservice()
            account = {
                        "broker": "bybit",
                        "credentials": {
                            "user": self.api_key,
                            "password": self.secret_key,
                        },
                        "categories": [
                            "spot",
                        ]
                    }
            if start_time > 0:
                account["date_range"] = {
                    "start": start_time,
                    "end": endTime
                }

            payload = json.dumps({
                                "users": [
                                    {
                                        "id": self.user.uuid,
                                        "accounts": [account]
                                    }
                                ]
                            })
            #print('payload',payload) 
            response = requests.request("POST", url_lambda, headers=self.headers_json , data=payload)        
            #print(response.json())
            if response.status_code == 200:
                if 'body' in response.json()['result']:
                    body = response.json()['result']['body']
                    #print('body',body)
                    if body['final_path']!=None and body['final_path']!='':
                        file_path = body['final_path']
                        order = self.s3_to_json_microservice(s3_url=file_path)
                        #print('order',order['orders'])
                        for row_order in order['orders']:
                            #print('entro')
                            row_order['category']='Spot'
                            endTime=int(row_order['execTime'])-1
                            j = 0
                            if  row_order['symbol'] in symbols or symbols==[]:                     
                                self.used_symbols.append(row_order['symbol'])
                                row_order['created_at'] = row_order['trade_time_ms']/1000 if 'trade_time_ms' in row_order else int(row_order['createdAt'])/1000 if 'createdAt' in row_order else  int(row_order['execTime'])/1000
                                row_order['created_at_formated'] = datetime.utcfromtimestamp(row_order['trade_time_ms']/1000).strftime('%Y-%m-%d %H:%M:%S') if 'trade_time_ms' in row_order else  datetime.utcfromtimestamp(int(row_order['createdAt'])/1000).strftime('%Y-%m-%d %H:%M:%S') if 'createdAt' in row_order else datetime.utcfromtimestamp(int(row_order['execTime'])/1000).strftime('%Y-%m-%d %H:%M:%S')
                                if row_order['created_at']>=(start_time/1000):
                                    self.orders.append([row_order]) 
            else:
                try: 
                    return  response.json()['message']
                except:
                    return 'Error getting orders'
            #print('orders',self.orders)
            if len(self.orders)>0:                
                self.type_category.append('Spot') 
                print('entro 2')

        else:                            
            url_lambda="https://mxmlost2rda7nyjgkzv6xplvvy0qsryv.lambda-url.eu-central-1.on.aws/"
          
            while  endTime>=start_time and not stop:
                query_string= f"category=spot&endTime={endTime}&limit=100"
                nextPageCursor='0'
                order_len = 100
                i = 1
                text_date=datetime.utcfromtimestamp(endTime/1000).strftime('%Y-%m-%d')           
                        
                while order_len == 100 and nextPageCursor!='' and endTime>=start_time:
                    tt.sleep(0.3) 
                    self._update_progress('Retrieving orders - Spot ({}) - Page {}'.format(text_date,i), '19%')
                    if i==1:
                        payload=query_string            
                    else:
                        payload=query_string+f"&cursor={nextPageCursor}"                 
                    try:
                        if 'localhost' in self.backend_domain_name():
                            order = self.request_bybit(url, payload)
                        else: #servidor lambda 
                            payload_lambda = json.dumps({
                            "api": self.api_key,
                            "key": self.secret_key,
                            "host": self.host,
                            "payload": payload
                            })
                        
                            response = requests.request("POST", url_lambda, headers=self.headers_json , data=payload_lambda)          
                            order = response.json()['orders']
                                
                        #print(order)
                        if  order['retMsg'] == 'OK'  and \
                            ('list' in order['result'] and order['result']['list'] != [] and order['result']['list']):
                            nextPageCursor=order["result"]["nextPageCursor"]                                         
                            order_len = len(order['result']['list'])
                            for row_order in order['result']['list']:
                                row_order['category']='Spot'                                                   
                                endTime=int(row_order['execTime'])-1
                                j = 0
                                if  row_order['symbol'] in symbols or symbols==[]:                           
                                    self.used_symbols.append(row_order['symbol'])
                                    row_order['created_at'] = row_order['trade_time_ms']/1000 if 'trade_time_ms' in row_order else int(row_order['createdAt'])/1000 if 'createdAt' in row_order else  int(row_order['execTime'])/1000
                                    row_order['created_at_formated'] = datetime.utcfromtimestamp(row_order['trade_time_ms']/1000).strftime('%Y-%m-%d %H:%M:%S') if 'trade_time_ms' in row_order else  datetime.utcfromtimestamp(int(row_order['createdAt'])/1000).strftime('%Y-%m-%d %H:%M:%S') if 'createdAt' in row_order else datetime.utcfromtimestamp(int(row_order['execTime'])/1000).strftime('%Y-%m-%d %H:%M:%S')
                                    self.type_category.append('Spot')                   
                                    self.orders.append([row_order])
                        else:
                            order_len = 0
                            nextPageCursor = ''
                    except Exception as e:
                        nextPageCursor = ''
                        order_len = 0
                        #print(e)  
                        return e  
                    i = i+1
                    msg_order_len = order_len + msg_order_len
                    
                j+=1
                if j>1:
                    endTime = (endTime - margin)             
                if j==30 or endTime<=start_time:
                    stop=True
         
    def get_bybit_orders_new(self, category,  starTime, paginated, index):
        url=self.host + '/v5/execution/list'
        msg_order_len = 0  
        order_len = 100
        j = 0
        futures_orders = None 
        endTime = int(tt.time()*1000)
        margin = 604800 *1000
        symbols=self.symbols
        starTime, endTime = self.validate_date_range(starTime, endTime)           
        stop=False
        if self.unified:
            prefx='Unified'
        else:
            prefx=''
            
        if self.user.id in (43830,48391,48397,282164,276437) or 'localhost' in self.backend_domain_name():
            url_lambda=self.url_microservice()
            account = {
                        "broker": "bybit",
                        "credentials": {
                            "user": self.api_key,
                            "password": self.secret_key,
                        },
                        "categories": [
                            category,
                        ]
                    }
            if starTime > 0:
                account["date_range"] = {
                    "start": starTime,
                    "end": endTime
                }

            payload = json.dumps({
                                "users": [
                                    {
                                        "id": self.user.uuid,
                                        "accounts": [account]
                                    }
                                ]
                            })
            #print('payload',payload) 
            response = requests.request("POST", url_lambda, headers=self.headers_json , data=payload)        
            #print(response.json())
            if response.status_code == 200:
                if 'body' in response.json()['result']:
                    body = response.json()['result']['body']
                    #print('body',body)
                    if body['final_path']!=None and body['final_path']!='':
                        file_path = body['final_path']
                        order = self.s3_to_json_microservice(s3_url=file_path)
                        #print('order',order)
                        for row_order in order['orders']:
                            row_order['category']='Future'
                            endTime=int(row_order['execTime'])-1
                            j = 0
                            if  row_order['symbol'] in symbols or symbols==[] or category=='option' :                     
                                self.used_symbols.append(row_order['symbol'])
                                row_order['created_at'] = row_order['trade_time_ms']/1000 if 'trade_time_ms' in row_order else int(row_order['createdAt'])/1000 if 'createdAt' in row_order else  int(row_order['execTime'])/1000
                                row_order['created_at_formated'] = datetime.utcfromtimestamp(row_order['trade_time_ms']/1000).strftime('%Y-%m-%d %H:%M:%S') if 'trade_time_ms' in row_order else  datetime.utcfromtimestamp(int(row_order['createdAt'])/1000).strftime('%Y-%m-%d %H:%M:%S') if 'createdAt' in row_order else datetime.utcfromtimestamp(int(row_order['execTime'])/1000).strftime('%Y-%m-%d %H:%M:%S')
                                if row_order['created_at']>=(starTime/1000):
                                    self.orders.append([row_order]) 
            else:
                try: 
                    return  response.json()['message']
                except:
                    return 'Error getting orders'
                          
            if len(self.orders)>0:
                self.type_category.append('Future') 
        else:  
            url_lambda="https://mxmlost2rda7nyjgkzv6xplvvy0qsryv.lambda-url.eu-central-1.on.aws/"
        ## end data lambda
            
            while  endTime>=starTime and not stop: 
                query_string= f"category={category}&endTime={endTime}&limit=100"
                nextPageCursor='0'
                order_len = 100
                i = 1
                text_date=datetime.utcfromtimestamp(endTime/1000).strftime('%Y-%m-%d') 
                anterio_nextPageCursor=''       
                while order_len==100 and nextPageCursor!='' and endTime>=starTime:
                    tt.sleep(0.3)
                    self._update_progress('Retrieving orders - {} {} ({}) - Page {}'.format(prefx,category,text_date,i), '19%')
                    if i==1:
                        payload=query_string            
                    else:
                        if anterio_nextPageCursor==nextPageCursor:
                            order_len=0
                            continue
                        else:
                            payload=query_string+f"&cursor={nextPageCursor}"
                            anterio_nextPageCursor=nextPageCursor
                    try:
                        if 'localhost' in self.backend_domain_name():
                            order = self.request_bybit(url, payload)
                        else: #servidor lambda 
                            payload_lambda = json.dumps({
                            "api": self.api_key,
                            "key": self.secret_key,
                            "host": self.host,
                            "payload": payload
                            }) 
                            response = requests.request("POST", url_lambda, headers=self.headers_json , data=payload_lambda)          
                            order = response.json()['orders']
                        
                        if  order['retMsg'] == 'OK'  and \
                            ('list' in order['result'] and order['result']['list'] != [] and order['result']['list']):
                            nextPageCursor=order["result"]["nextPageCursor"]
                            order_len = len(order['result']['list'])
                            for row_order in order['result']['list']:
                                row_order['category']='Future'
                                endTime=int(row_order['execTime'])-1
                                j = 0
                                if  row_order['symbol'] in symbols or symbols==[] or category=='option' :                     
                                    self.used_symbols.append(row_order['symbol'])
                                    row_order['created_at'] = row_order['trade_time_ms']/1000 if 'trade_time_ms' in row_order else int(row_order['createdAt'])/1000 if 'createdAt' in row_order else  int(row_order['execTime'])/1000
                                    row_order['created_at_formated'] = datetime.utcfromtimestamp(row_order['trade_time_ms']/1000).strftime('%Y-%m-%d %H:%M:%S') if 'trade_time_ms' in row_order else  datetime.utcfromtimestamp(int(row_order['createdAt'])/1000).strftime('%Y-%m-%d %H:%M:%S') if 'createdAt' in row_order else datetime.utcfromtimestamp(int(row_order['execTime'])/1000).strftime('%Y-%m-%d %H:%M:%S')
                                    if row_order['created_at']>=(starTime/1000):
                                        self.orders.append([row_order]) 
                                        self.type_category.append('Future') 
                                        
                        else:
                            order_len = 0
                            nextPageCursor = ''
                    except Exception as e:
                        nextPageCursor=''
                        order_len = 0
                        #print(e)
                        return e               
                    i = i+1
                    msg_order_len = order_len + msg_order_len
                j+=1
                if j>1:
                    endTime = (endTime - margin)             
                if j==30  or endTime<=starTime:
                    stop=True
                            
    def interpret_orders(self):        
        result_b = []
        self.out_result = []
        #b=len(self.orders)
        b=0
        new_date_time = []
        pip_value_order = dict()
        pip_value_order_btc = dict()
        verify_njson_len = 0
        orders_filerow = []
        
        i = 0                            
        if self.orders:
            orders_filerow = ImportParams.filerow_orders(self.params['get_session_userid'],
                                                         var_sync='execId', 
                                                         var_file='orderid',
                                                         broker=self.params['broker']
                                                        )
        self.orders = list(sorted(self.orders, key=lambda i: i['created_at'], reverse=False))
        self.orders=self.remove_duplicate(self.orders)
        for order in self.orders:             
            if 'execType' in order:
                if order['execType'].lower() == 'funding' and not self.funding:
                    continue
                                        
            i = i +1
            original_file_row = json.loads(json.dumps(order))
            njson = json.dumps(order)
            njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
            # issue 23360
            if 'execId' in order:
                if not order['execId'] in self.orders_execid:
                    self.orders_execid.append(order['execId'])
                else:
                    continue
            ##################
            
            if 'side'in order:
                action = order['buy/sell'].upper() if 'buy/sell' in order else order['side'].upper() if 'side' in order else order['transaction category'].upper() if 'transaction category' in order else ''
            else:
                action = 'BUY' if order['isBuyer']== True else 'SELL'
            action = 'BUY' if action == 'BUY' or action=='COVER' else 'SELL' if action == 'SELL' or action == 'SHORT' else ''
            order['symbol']  = order['contracts'] if 'contracts' in order else order['contract'] if 'contract' in order else order['symbol'] if 'symbol' in order else ''
            order['date'] = order['updated_time'] if 'updated_time' in order else order['trade_time_ms'] if 'trade_time_ms' in order else  int(order['createdAt']) if 'createdAt' in order else int(order['execTime'] )
            order['date'] = datetime.utcfromtimestamp(order['date']/1000).strftime('%Y-%m-%d %H:%M:%S')
            order['type'] = order['filled type'].upper() if 'filled type' in order else order['types'].upper() if 'types' in order else 'TRADE'
            # continue 
            
            order['price'] = order['execPrice']                
            if float(order['execPrice']) != 0:
                order['quantity'] = float(order['execQty']) /  float(order['execPrice'])
            else:
                continue 
            if not order['symbol'] or not order['date'] or not order['price'] or not action or order['type'] != "TRADE":
                continue

            pip_value = 1
            date_time = order['date']
            original_file_row['date_tz'] = date_time
            self.any_error, date, time = ImportParams.get_param_datetime(date_time,b)
            new_date_time = ImportParams.convert_date(date, time, self.date_format,True,'UTC')

            order['date'] = new_date_time[0]
            order['time'] = new_date_time[1]
            fp = str(order['price']).replace(',', '').replace('$','')
            decimal = fp[::-1].find('.')
            decimal = decimal if decimal > 1 else 2
            price = round(float(fp),decimal)
            #price = round(float(order['price'].replace(',', '')),6)
            sm = len(order['symbol'])
            type = 'crypto'
            option = 'CRYPTO'
            strike = ''
            expire = ''

            if order['category'] in self.params['user_portfolios']:
                if order['execType'].lower() == 'funding' and self.funding:
                    user_portfolio = self.params['user_portfolios']['Funding']
                else:
                    user_portfolio = self.params['user_portfolios'][order['category']]
            else:
                user_portfolio = self.params['user_portfolio']           

            #################### VERIFY FILE ROW ######################
            if njson in orders_filerow:
                verify_njson_len = verify_njson_len + 1
                continue
            if 'execId' in original_file_row and original_file_row['execId']:
                order_id = '{}'.format(original_file_row['execId'])
                if order_id in orders_filerow:
                    verify_njson_len = verify_njson_len + 1
                    continue
            try:
                var_date = original_file_row['date_tz']
                var_date = ImportParams.parse_date(var_date).strftime('%Y-%m-%d %H:%M:%S')
                njson3 = '{}{}{}{}{}{}{}'.format(float(fp) if fp else 0.00,
                                                 var_date,
                                                 option,
                                                 1 if action == 'BUY' else 2,
                                                 float(str(order['execQty']).replace(',', '')) if 'execQty' in order \
                                                      else '',
                                                 float(strike) if ImportParams.isfloat(strike) else 0.0,
                                                 expire
                                                )
                if njson3 in orders_filerow:
                    verify_njson_len = verify_njson_len + 1
                    continue
            except:
                pass
            ###########################################################
            if len(order['symbol']) > 8 and len(order['symbol'].split('-')) == 4:
                split_symbol = order['symbol'].split('-')
                type = 'crypto option'
                option = 'CALL' if split_symbol[3].upper() == 'C' else 'PUT' if split_symbol[3].upper() == 'P' else 'OPTION'
                strike = split_symbol[2]
                expire = str(parse(split_symbol[1]).strftime("%d %b %y")).upper()
                order['symbol'] = '#{}{}'.format(split_symbol[0],'USDT')
                
            sym = order['symbol'][-3:]
            if not 'execValue' in order:
                pip_value = self.convert_usdt(order, pip_value_order, date )
            elif sym in ['USD']:
                value_order = float(order['execQty']) * float(order['execPrice'])
                exec_value = float(order['execValue']) if ImportParams.isfloat(order['execValue']) else ''
                pip_value_exec = (exec_value / value_order)
                pip_value = pip_value_exec * price
            elif 'USDT' in order['symbol'] or 'PERP' in order['symbol']  or 'USDC' in order['symbol'] or 'USDE' in order['symbol']:
                pip_value = 1
            else:
                value_order = float(order['execQty']) * float(order['execPrice'])
                exec_value = float(order['execValue']) if ImportParams.isfloat(order['execValue']) else ''
                if exec_value and order['symbol']:                    
                    if value_order != 0:
                        pip_value = (exec_value / value_order)
                    else:
                        pip_value = exec_value
                        
                    pip_value = pip_value * float(order['price'])
                     
                    #pip_value_btc = ImportParams.pip_value_crypto_(order['date'], base='usdt', currency='btc')"""
            
            pip_value_btc = 1
            if order['symbol'] == 'BTCUSD':
                row_btc = '{}{}'.format(date,sym)
                if not row_btc in pip_value_order_btc:
                    pip_value_btc = ImportParams.pip_value_crypto_(order['date'], base='usdt', currency='btc')
                    pip_value_order_btc[row_btc] = pip_value_btc
                else:
                    pip_value_btc = pip_value_order_btc[row_btc]

            order['orderby'] = b
            order['trade_notes'] = order['trade_notes'] if 'trade_notes' in order else ''
            order['type_stock'] = type
            order['type_option'] = option
            order['action'] = action
            order['price'] = price
            order['shares'] = str(order['execQty']).replace(',', '') if 'execQty' in order else str(order['qty']).replace(',', '')
            # if not 'app' in self.domain_name():
            #order['swap'] = order['execFee'] if 'execFee' in order else '0.00'
            if 'execFee' in order:
                order['fees'] = (float(order['execFee']) * float(pip_value_btc)) if 'execFee' in order else '0.00'
            elif 'cumExecFee' in order:
                order['fees'] = order['cumExecFee'] if 'cumExecFee' in order else '0.00'
            else:
                order['fees'] = (float(order['feeAmount']) * float(pip_value_btc)) if 'feeAmount' in order else '0.00'
            
            
            convertFees = True
            
            
            if ImportParams.isfloat(order['fees']) and 'USD' in order['symbol'] \
                  and not 'USDT' in order['symbol'] and not 'BTCUSD' in order['symbol']:
                order['fees'] = float(order['fees']) * float(price)
                convertFees = False
                
            try:
                if ImportParams.isfloat(order['fees']) and 'feeCurrency' in order \
                      and order['feeCurrency'] and not order['feeCurrency'] in ['USDT'] \
                      and  'USDT' in order['symbol'] and order['feeCurrency'] in order['symbol'] and convertFees:
                    order['fees'] = float(order['fees']) * float(price)
            except:
                pass
            order['njson'] = njson
            order['decimal'] = decimal
            order['expire'] = expire
            order['strike'] = strike
            order['pip_value'] = pip_value
            order['original_file_row'] = original_file_row
            order['broker'] = self.params['broker']
            order['userid'] = self.params['get_session_userid']
            order['portfolio'] = user_portfolio
            order['app_broker'] = 1
            order['size'] = 1
            data_item = ImportParams.get_result_append(order)
            self.out_result.append(data_item)
            b = b + 1
        
          