import re
import hashlib
import json
import traceback

from flask import request, current_app
from flask_jwt_extended import jwt_required
from flask_restful import Resource, Api, reqparse
from flask_login import current_user, login_required
from datetime import datetime, date, timedelta, tzinfo, time
from dateutil.parser import parse
from copy import deepcopy

from .. import_params import ImportParams
from .. security_service import *
from .. logs import create_log
from .. responses import ErrorResponses, SuccessResponses

class BrokerByBit(Resource):
    ORDERS_FILEROW = []
    def getcsv(params, content, date_format='mdy'):
        data = "BrokerByBit 1"
        # print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0
        return_is_base_currency = False
        currency_trade = 'USD'
        try:
            return_is_base_currency = current_user.users_configs.return_is_base_currency
            currency_trade = current_user.users_configs.fk_currency.code
        except:
            pass

        try:

            content = content.replace(';', '')
            if 'Filled Type' in content or 'Time In Force' in content:
                return BrokerByBit.getcsv2(params, content, date_format='mdy')
            if 'Entry Price' in content and ('Exit Price' in content or 'Close Price' in content):
                return BrokerByBit.getcsv3(params, content, date_format='mdy')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False

            for row in content_b:
                if len(row) == 0 or len(row)<15:
                    continue
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            pip_value_list = dict()
            verify_njson_len = 0
            orders_filerow = []
            try:
                orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                             broker=params['broker'])
                BrokerTastyworks.ORDERS_FILEROW = orders_filerow

            except:
                pass

            for a, n in enumerate(result):
                keys = list(n.keys())
                for k in keys:
                    if 'filled/settlement time' in k:
                        n['date'] = n[k]

                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                action = n['buy/sell'].upper() if 'buy/sell' in n else \
                         n['side'].upper() if 'side' in n else \
                         n['transaction category'].upper() if 'transaction category' in n else \
                         n['direction'] if 'direction' in n else  n['trade type'] if 'trade type' in n else ''
                action = 'BUY' if action == 'BUY' or action=='COVER' else 'SELL' if action == 'SELL' or action == 'SHORT' else ''
                n['symbol']  = n['contracts'] if 'contracts' in n else \
                               n['contract'] if 'contract' in n else \
                               n['symbol'] if 'symbol' in n else \
                               n['spot pairs'] if 'spot pairs' in n else ''

                n['date'] = n['date'] if 'date' in n else \
                            n['transaction time'] if 'transaction time' in n else \
                            n['filled time local time'] if 'filled time local time' in n else ''


                n['type'] = n['filled type'].upper() if 'filled type' in n else \
                            n['types'].upper() if 'types' in n else 'TRADE'
                n['quantity'] = n['filled qty'] if 'filled qty' in n else \
                                n['transaction qty'] if 'transaction qty' in n else \
                                n['quantity'] if 'quantity' in n else \
                                n['filled quantity'] if 'filled quantity' in n else n['qty'] if 'qty' in n else ''
                n['price'] = n['exec price'] if 'exec price' in n else \
                             n['executed price'] if 'executed price' in n else \
                             n['price'] if 'price' in n else \
                             n['filled price'] if 'filled price' in n else ''

                if not n['symbol'] or not n['date'] or not n['price'] or not action or n['type'] != "TRADE":
                    continue
                pip_value = 1
                if 'time' in n:
                    date_split = n['date'].strip()
                    d = date_split
                    t = n['time'].replace('.',':') if 'time' in n else ''
                    date_time = (d+' '+t).strip()
                else:
                    date_time = n['date']
                original_file_row['date_tz'] = date_time
                any_error, date, time = ImportParams.get_param_datetime(date_time,b)
                new_date_time = ImportParams.convert_date(date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                if ' ' in n['price']:
                    pp = n['price'].split(' ')
                    n['price'] = pp[0]

                fp = n['price'].replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp),decimal)
                #price = round(float(n['price'].replace(',', '')),6)

                sm = len(n['symbol'])
                type = 'crypto'
                option = 'CRYPTO'
                strike = ''
                expire = ''
                ########################################
                try:
                    if not ImportParams.isfloat(n['quantity']):
                        n['quantity'] = ImportParams.Extract_Numbers(n['quantity'])
                    if 'filled value' in n and 'USDT' in n['filled value']:
                        pq = price * float(n['quantity'])
                        value = float(ImportParams.Extract_Numbers(n['filled value']))
                        pip_value = value / pq
                    if return_is_base_currency:
                        sym = currency_trade.upper()
                        pip_row = "{}{}".format(sym,n['date'])
                        if not pip_row in pip_value_list:
                            pip_value_params = float(ImportParams.value_pip_forex(n['date'],sym))
                            pip_value_list[pip_row] = pip_value_params
                        else:
                            pip_value_params = pip_value_list[pip_row]
                        pip_value = pip_value * pip_value_params
                except:
                    pass
                #################### VERIFY FILE ROW ######################
                try:
                    order_id = ''
                    portfolio_ = params['user_portfolio']
                    valid_file_row = ImportParams.validate_filerow(orders_filerow,
                                                                   njson=njson,
                                                                   order_id=order_id,
                                                                   date_tz=original_file_row['date_tz'],
                                                                   price=fp,
                                                                   option=option,
                                                                   action=action,
                                                                   quantity=n['quantity'].replace(',', ''),
                                                                   strike=strike,
                                                                   expire=expire,
                                                                   portfolio=portfolio_
                                                                  )
                    if valid_file_row:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################

                n['trade_notes'] = n['trade_notes'] if 'trade_notes' in n else ''
                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = price
                n['shares'] = n['quantity'].replace(',', '')
                n['comm'] = n['commission'].replace(',', '').replace('$','') if 'commission' in n else '0.00'
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['pip_value'] = pip_value

                n['original_file_row'] = original_file_row
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b + 1

                # out_result.append(n)
        except Exception as err:
            any_error = 9
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error

    def getcsv2(params, content, date_format='mdy'):
        data = "BrokerByBit 2"
        # print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:

            content = content.replace(';', '')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False

            for row in content_b:
                if len(row) == 0:
                    continue
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            b = len(result)
            verify_njson_len = 0
            orders_filerow = []
            try:
                orders_filerow = ImportParams.filerow_orders(params['get_session_userid'],
                                                             broker=params['broker'])
            except:
                pass

            firtday = False

            if params['date_format']['id'] == 3 or params['date_format']['id'] == 4:
                firtday = True

            pip_value_order = dict()

            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()
                keys = list(n.keys())

                for k in keys:
                    if 'transaction time' in k or 'order time' in k:
                        n['transaction time'] = n[k]
                    if 'status' in k:
                       n['filled type'] = n[k]

                if 'filled qty' in n and float(n['filled qty']) > 0:
                    action = 'BUY'
                elif 'filled qty' in n and float(n['filled qty']) < 0:
                    action = 'SELL'
                else:
                    action = ''
                if 'type' in n or 'contract type' in n or 'direction' in n:
                    action = n['type'].upper() if 'type' in n else \
                             n['contract type'].upper() if 'contract type' in n else \
                             n['direction'] if 'direction' in n else ''
                    if action.upper() in ['OPEN LONG', 'CLOSE SHORT' ]:
                        action = 'BUY'
                    if action.upper() in ['CLOSE LONG', 'OPEN SHORT' ]:
                        action = 'SELL'
                n['quantity'] = n['filled qty'] if 'filled qty' in n else n['filled/total'] if 'filled/total' in n  \
                                and ImportParams.isfloat(n['filled/total']) \
                                and float(n['filled/total']) > 0 else n['quantity'] if 'quantity' in n else ''
                n['price'] = n['exec price'] if 'exec price' in n else \
                             n['filled price'] if 'filled price' in n else ''
                n['symbol']  = n['contracts']
                original_file_row['date_tz'] = n['transaction time']
                n['date'] = n['transaction time'].replace('UTC','').strip()
                if not n['symbol'] \
                    or not n['date'] \
                    or not n['price'] \
                    or action not in ["BUY","SELL"] \
                    or n['filled type'].upper() not in ['TRADE','LIQUIDATION','FILLED'] \
                    or not n['quantity']:
                    continue
                n['orderby'] = b
                pip_value = 1

                if firtday:
                    dp = ImportParams.parse_date(n['date'], firtday)
                    date_split = dp.strftime('%m/%d/%Y %H:%M:%S')
                    dateformat = '%m/%d/%Y %H:%M:%S'
                    any_error, date, time = ImportParams.get_param_datetime(date_split,b,dateformat=dateformat)
                else:
                    dp = ImportParams.parse_date(n['date'], False)
                    date_split = dp.strftime('%m/%d/%Y %H:%M:%S')
                    dateformat = '%m/%d/%Y %H:%M:%S'
                    any_error, date, time = ImportParams.get_param_datetime(date_split,b,dateformat=dateformat)
                new_date_time = ImportParams.convert_date(date, time, date_format)

                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]
                fp = n['price'].replace(',', '').replace('$','')
                decimal = fp[::-1].find('.')
                decimal = decimal if decimal > 1 else 2
                price = round(float(fp),decimal)
                #price = round(float(n['price'].replace(',', '')),6)
                quantity = n['quantity'].replace(',', '')
                """if not 'value' in n:
                    price_inv = 1/price
                    value_inv = price_inv * float(quantity)
                    pq = price * float(quantity)
                    pip_value = (value_inv / pq)"""

                try:
                    # Tomamos los 4 ultimos caracteres del simbolo
                    sym_last_1 = n['symbol'][-4:]
                    # Validamos si los ultimos 4 caracteres del simbolo es diferente USDT
                    if sym_last_1.upper() != 'USDT':
                        # Tomamos los 3 ultimos caracteres del simbolo
                        sym_last_2 = n['symbol'][-3:]
                        # Validamos si los ultimos 3 caracteres del simbolo es igual USD
                        if sym_last_2.upper() == 'USD':
                            # Borramos USD del simbolo para que nos quede solo el codigo del que vamos a
                            # sacar el rate USDT
                            smn = n['symbol'].replace(sym_last_2,'')
                            # Convertimos la fecha de la orden en el formato que requiere el api para sacar el rate
                            date_sym = str(parse(date)).split(' ')[0]
                            # Para evitar que se este llamando el api constantemente para un codico y fecha repetida se valida esto
                            # si el key_date_sym se encuentra en pip_value_order no se hace el llamado al api sino que se toma de la
                            # variable pip_value_order
                            key_date_sym = '{}{}'.format(smn, date_sym)
                            if not key_date_sym in pip_value_order:
                                # date_sym = la fecha de la orden formateada a como lo requiere el api
                                # smn = code base que vamos a sacar el valor RATE de USDT
                                pip_value = ImportParams.pip_value_crypto_(date_sym, smn)
                                pip_value_order[key_date_sym] = pip_value
                            else:
                                pip_value = pip_value_order[key_date_sym]
                except:
                    pass


                sm = len(n['symbol'])
                type = 'crypto'
                option = 'CRYPTO'
                strike = ''
                expire = ''
                fees = '0.00'
                if 'fees paid' in n and ImportParams.isfloat(n['fees paid']):
                    fees = str(float(n['fees paid']))
                    if 'BTCUSD' in n['symbol'].upper() and not 'USDT' in n['symbol'].upper():
                        fees = str(float(n['fees paid']) * float(price)).replace('-','')

                #################### VERIFY FILE ROW ######################
                if njson in orders_filerow:
                    verify_njson_len = verify_njson_len + 1
                    continue
                try:
                    var_date = original_file_row['date_tz']
                    var_date = ImportParams.parse_date(var_date).strftime('%Y-%m-%d %H:%M:%S')
                    njson3 = '{}{}{}{}{}{}{}'.format(float(fp) if fp else 0.00,
                                                     var_date,
                                                     option,
                                                     1 if action == 'BUY' else 2,
                                                     quantity,
                                                     float(strike) if ImportParams.isfloat(strike) else 0.0,
                                                     expire
                                                    )
                    if njson3 in orders_filerow:
                        verify_njson_len = verify_njson_len + 1
                        continue
                except:
                    pass
                ##########################################################

                n['trade_notes'] = n['trade_notes'] if 'trade_notes' in n else ''
                n['type_stock'] = type
                n['type_option'] = option
                n['action'] = action
                n['price'] = price
                n['shares'] = quantity
                n['comm'] = n['commission'].replace(',', '').replace('$','') if 'commission' in n else '0.00'
                n['fees'] = fees
                n['njson'] = njson
                n['decimal'] = decimal
                n['expire'] = expire
                n['strike'] = strike
                n['pip_value'] = pip_value
                n['original_file_row'] = original_file_row

                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']

                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)
                b = b - 1

                # out_result.append(n)
        except Exception as err:
            any_error = 9
        if not any_error and not out_result and not verify_njson_len:
            any_error=9

        return out_result, any_error

    def getcsv3(params, content, date_format='mdy'):
        data = "BrokerByBit 3"
        print(data)
        version = {}
        any_error = 0
        out_result = []
        result_b = []
        new_date_time = []
        result = []
        b=0

        try:

            content = content.replace(';', '')
            if 'Filled Type' in content:
                return BrokerByBit.getcsv2(params, content, date_format='mdy')
            content_b = content.splitlines()
            content = "\n".join(content_b)
            content_b = ''.join([i if ord(i) < 128 else ' ' for i in content])
            content_b = re.sub(r'[^\x00-\x7F]+', ' ', content_b)
            content_b = content_b.split("\n") if "\n" in content_b else content_b.split("\r") if "\r" in content_b else ""
            nl = 0
            rl = 0
            ath = False

            for row in content_b:
                if len(row) == 0:
                    continue
                rl = rl + 1
                result_b.append(row)
                if rl == 1:
                    row = row.replace("\r", "")
                    ns = row.split(',')
                    nl = len(ns)
            result = ImportParams.custom_getcsv(result_b, nl,True,True)
            pip_value_order_btc = dict()
            for a, n in enumerate(result):
                original_file_row = json.loads(json.dumps(n))
                njson = json.dumps(n)
                njson = hashlib.md5(njson.encode('utf-8')).hexdigest()

                keys = list(n.keys())
                for k in keys:
                    if 'trade time' in k:
                        n['trade time'] = n[k]
                action_open = ''
                action_close = n['closed direction'].strip().upper() if 'closed direction' in n else \
                               n['closing direction'].strip().upper() if 'closing direction' in n else ''

                if action_close:
                    action_open = 'BUY' if action_close in ['SELL', 'CLOSE LONG'] else \
                                  'SELL' if action_close in ['BUY', 'CLOSE SHORT'] else ''
                    if action_open == 'BUY':
                        action_close = 'SELL'
                    elif action_open == 'SELL':
                        action_close = 'BUY'
                else:
                    if 'contract' in n:
                        action_open = 'BUY' if 'LONG' in n['contract'].upper() else \
                                      'SELL' if 'SHORT' in n['contract'].upper() else ''
                        action_close = 'SELL' if action_open == 'BUY' else 'BUY'
                action = action_open

                n['open time']  = n['open time'] if 'open time' in n else ''
                n['close time']  = n['close time'] if 'close time' in n else ''

                try:
                    if 'time of exit order' in n or 'trade time' in n:
                        time_exit = n['time of exit order'].split(' ') if 'time of exit order' in n else \
                                    n['trade time'].split(' ') if 'trade time' in n else ''
                        if len(time_exit) > 1:
                            date_time = '{0} {1}'.format(time_exit[0], time_exit[1])
                            close_time = parse(date_time)
                            n['close time'] = '{:%m/%d/%Y %H:%M:%S}'.format(close_time)
                            open_time = close_time - timedelta(minutes=1)
                            n['open time'] = '{:%m/%d/%Y %H:%M:%S}'.format(open_time)
                except:
                    continue

                n['symbol'] = n['contracts'].replace('$', '').replace(' ', '').replace('/','') if 'contracts' in n else \
                              n['contract'].replace('$', '').replace(' ', '').replace('/','').replace('Short','Long').split('Long')[0] if 'contract' in n else \
                              n['symbol'] if 'symbol' in n else ''

                n['action'] = 'BUY' if action == 'L' or action.upper() == 'BUY' or  'LONG' in n['symbol'] else \
                              'SELL' if action == 'S' or  'SHORT' in n['symbol'] or action.upper() == 'SELL' else action

                n['entry price'] = n['entry price'] if 'entry price' in n else n['open price'] if 'open price' in n else ''
                n['exit price'] = n['exit price'] if 'exit price' in n else n['close price'] if 'close price' in n else ''
                n['profit'] = n['closed profit and loss'] if 'closed profit and loss' in n else \
                              n['closed p&l'] if 'closed p&l' in n else \
                              n['profit'] if 'profit' in n else '0'
                n['volume'] = n['contracts volume'] if 'contracts volume' in n else \
                              n['qty'].replace('ATOM','') if 'qty' in n else \
                              n['volume'] if 'volume' in n else ''

                if ImportParams.isfloat(n['symbol']) \
                              or ImportParams.isfloat(n['symbol'][:4]) \
                              or not n['symbol'] \
                              or not n['close time'] \
                              or n['action'] not in ['BUY', 'SELL'] \
                              or not 'entry price' in n \
                              or not 'exit price' in n:
                    continue
                #: Get format date and TIMEZONE for date file.
                original_file_row['date_tz'] = n['open time']
                any_error, date, time = ImportParams.get_param_datetime(n['open time'], b)
                new_date_time = ImportParams.convert_date(date, time, date_format)
                n['date'] = new_date_time[0]
                n['time'] = new_date_time[1]

                fp = n['entry price'].replace(',', '').replace('$', '').replace(' ', '')
                decimal_1 = fp[::-1].find('.')
                decimal_open = decimal_1 if decimal_1 > 1 else 2

                vfp = ImportParams.isfloat(fp)
                price = round(float(fp), 6) if vfp else 0.00
                sm = len(n['symbol'])

                fp2 = n['exit price'].replace(',', '').replace('$', '').replace(' ', '')
                decimal = fp2[::-1].find('.')
                decimal_closed = decimal if decimal > 1 else 2

                decimal = max([decimal_open, decimal_closed])
                type = 'crypto'
                option = 'CRYPTO'
                try:
                    quantity = float(n['volume'].replace('-', '').replace(',', '').replace(' ', '').replace('Lots','').replace('BTC',''))
                except:
                    continue
                ##################################
                profit_diff = 0
                profit = n['profit'].replace(',','.')
                if ImportParams.isfloat(profit):
                    profit_file = float(profit)
                    pips = float(fp2) - float(fp) if action == 'BUY' else \
                           float(fp) - float(fp2)
                    profit_ts = (pips * quantity)
                    profit_diff = abs(profit_file - profit_ts)
                ##################################
                pip_value_btc = 1
                pip_value = 1
                sym = n['symbol'][-3:]
                if n['symbol'] == 'BTCUSD':
                    row_btc = '{}{}'.format(date,sym)
                    if not row_btc in pip_value_order_btc:
                        pip_value_btc = ImportParams.pip_value_crypto_(n['date'], base='usdt', currency='btc')
                        pip_value_order_btc[row_btc] = pip_value_btc
                    else:
                        pip_value_btc = pip_value_order_btc[row_btc]
                    profit_btc = profit_file * pip_value_btc
                    pip_value = profit_btc / profit_ts
                    profit_diff = abs(profit_btc - (profit_ts / pip_value_btc))

                fees = float(n['fees'].replace(',', '').replace('$', '').replace('-','').replace(' ','')) if 'fees' in n else \
                       float(n['open fees'].split(' ')[0].replace(',', '').replace('$', '').replace('-','').replace(' ','')) if 'open fees' in n else \
                       profit_diff

                n['symbol'] = "{}|{}".format(n['symbol'], str(a))
                n['type_stock'] = type
                n['type_option'] = option
                n['price'] = fp
                n['shares'] = quantity
                n['comm'] = 0
                n['fees'] = fees
                n['swap'] = 0
                n['njson'] = njson
                n['decimal'] = decimal
                n['pip_value'] = pip_value
                n['expire'] = ''
                n['strike'] = ''
                n['original_file_row'] = original_file_row
                n['broker'] = params['broker']
                n['userid'] = params['get_session_userid']
                n['portfolio'] = params['user_portfolio']
                data_item = ImportParams.get_result_append(n)
                out_result.append(data_item)

                #: Get closed item in the row
                if n['close time']:
                    original_file_row2 = deepcopy(original_file_row)
                    n['action'] = action_close
                    d = n['close time'].strip().split(' ')
                    b = b + 1
                    original_file_row2['date_tz'] = n['close time']
                    any_error, date, time = ImportParams.get_param_datetime(n['close time'], b)
                    new_date_time = ImportParams.convert_date(date, time, date_format)

                    n['date'] = new_date_time[0]
                    n['time'] = new_date_time[1]
                    fees = float(n['close fees'].split(' ')[0].replace(',', '').replace('$', '').replace('-','').replace(' ','')) if 'close fees' in n else ''
                    commission = 0.00
                    n['type_stock'] = type
                    n['type_option'] = option
                    n['price'] = fp2
                    n['shares'] = quantity
                    n['comm'] = commission
                    n['fees'] = fees
                    n['swap'] = 0.00
                    n['njson'] = njson + 'Closed'
                    n['decimal'] = decimal
                    n['expire'] = ''
                    n['strike'] = ''
                    n['original_file_row'] = original_file_row2
                    n['broker'] = params['broker']
                    n['userid'] = params['get_session_userid']
                    n['portfolio'] = params['user_portfolio']

                    data_item = ImportParams.get_result_append(n)
                    out_result.append(data_item)

                b = b + 1

        except Exception as err:
            any_error = 9
        if not any_error and not out_result:
            any_error=9
        return out_result, any_error
